(* Copyright (C) 1989, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Mon Nov 18 21:32:21 PST 1991 by gnelson    *)
(*      modified on Thu Nov  2 18:28:31 1989 by muller         *)
(*      modified on Mon Oct  2 09:13:50 1989 by kalsow         *)
(*      modified on Fri Jun  3 16:12:45 PDT 1988 by glassman   *)
(*      modified on Tue Mar  3 18:14:23 PST 1987 by luca       *)

INTERFACE Axis;

(* "Axis.T.Hor" and "Axis.T.Ver" are Trestle's names for the horizontal
   and vertical axes.  "Axis.Other" exchanges "Hor" and "Ver".

   Index: screen, coordinate system *)

TYPE T = {Hor, Ver};

CONST Other = ARRAY T OF T {T.Ver, T.Hor};
      other = Other; (* Maps Hor to Ver and Ver to Hor *)

PROCEDURE New (value: T): REF T;
(* Allocates and initializes a new heap value *)

PROCEDURE NewArray (size: CARDINAL;  value: T := T.Hor): REF ARRAY OF T;
(* Allocates a new array from the heap
  and initializes all its elements with the given value *)

PROCEDURE UntracedNew (value: T): UNTRACED REF T;
(* Allocates and initializes a new untraced value *)

PROCEDURE UntracedNewArray (size: CARDINAL;  value: T := T.Hor):
                                                       UNTRACED REF ARRAY OF T;
(* Allocates a new untraced array from the heap
  and initializes all its elements with the given value *)

PROCEDURE Compare (a, b: T): INTEGER;
(* == RETURN (a - b) *)

PROCEDURE Lt (a, b: T): BOOLEAN;
(* == RETURN (a < b) *)

PROCEDURE Eq (a, b: T): BOOLEAN;
(* == RETURN (a = b) *)

PROCEDURE Hash (a: T): INTEGER;
(* == RETURN ORD (a) *)

END Axis.
