 /*
  * Khoros: $Id: vdefines.h,v 1.2 1991/07/15 05:48:28 khoros Exp $
  */

 /*
  * $Log: vdefines.h,v $
 * Revision 1.2  1991/07/15  05:48:28  khoros
 * HellPatch1
 *
  */ 

/*
 *----------------------------------------------------------------------
 *
 * Copyright 1990, University of New Mexico.  All rights reserved.
 * 
 * Permission to copy and modify this software and its documen-
 * tation only for internal use in your organization is hereby
 * granted, provided that this notice is retained thereon and
 * on all copies.  UNM makes no representations as too the sui-
 * tability and operability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 * 
 * UNM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FIT-
 * NESS.  IN NO EVENT SHALL UNM BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY OTHER DAMAGES WHAT-
 * SOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
 * IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PER-
 * FORMANCE OF THIS SOFTWARE.
 * 
 * No other rights, including for example, the right to redis-
 * tribute this software and its documentation or the right to
 * prepare derivative works, are granted unless specifically
 * provided in a separate license agreement.
 *----------------------------------------------------------------------
 */

#include "unmcopyright.h"	 /* Copyright 1990 by UNM */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                          <<<<
   >>>>      file: vdefines.h                                    <<<<
   >>>>                                                          <<<<
   >>>>      contains:  common definitions needed by             <<<<
   >>>>			Khoros programs				 <<<<
   >>>>                                                          <<<<
   >>>>      written by: John Rasure, Scott Wilson, Danielle     <<<<
   >>>>			 Argiro, Mark Young, Ron E. Neher        <<<<
   >>>>                                                          <<<<
   >>>>      date:                                               <<<<
   >>>>                                                          <<<<
   >>>>	     modifications:  Added Ron's VStrlen & VStrcpy       <<<<
   >>>>			     defines. Tom & Mark 12/21/88        <<<<
   >>>>                      Rasure for Khoros, 2/6/89           <<<<
   >>>>                      Tom & Mark - added VStrcat, 2/27/89 <<<<
   >>>>                      Scott Wilson - Added readimage, etc <<<<
   >>>>                      definitions, and added PIXEL and    <<<<
   >>>>                      BPIXEL definitions. 18-Jan-91       <<<<
   >>>>                                                          <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _vdefines_h_
#define _vdefines_h_

#define	XV_FILE_MAGIC_NUM	0xab	/* Khoros file identifier */
#define	XV_FILE_TYPE_XVIFF	1	/* indicates an image file */

#undef  TRUE
#define TRUE 1

#undef  FALSE
#define FALSE 0

#undef LENGTH
#define LENGTH 512

#undef  COMMENTLEN
#define COMMENTLEN 512


/*
 *  Need to see if we are on a system V machine.  If so then we need to define
 *  bcopy(), bzero(), bcmp() to use memcpy(), memset(), memcmp(), LOCK_EX,
 *  LOCK_UN, lockf
 */
#ifdef SYSV

#ifndef bcopy
#define bcopy(s1, s2, n)	memcpy(s2, s1, n)
#endif

#ifndef bzero
#define bzero(s1, n)		memset(s1, 0, n)
#endif

#ifndef bcmp
#define bcmp(s1, s2, n)		memcmp(s2, s1, n)
#endif

#if !defined(_IBMR2) && !defined(sgi)
#ifndef LOCK_EX
#define LOCK_EX F_LOCK
#endif


#ifndef LOCK_UN
#define LOCK_UN F_ULOCK
#endif

#ifndef flock
#define flock(fids, function) lockf(fids, function, 0) 
#endif
#endif

#endif

#ifdef BSDTYPES

#ifndef u_char
typedef unsigned char u_char;
#endif
#ifndef u_short
typedef unsigned short u_short;
#endif
#ifndef u_int
typedef unsigned int u_int;
#endif
#ifndef u_long
typedef unsigned long u_long;
#endif

#endif

/*
 *  Defines used for vlistdir for it's list mode
 */
#define XV_PATH	 (1 << 0)
#define XV_FILE	 (1 << 1)
#define XV_DIR	 (1 << 2)
#define XV_DOT	 (1 << 3)
#define XV_LINK	 (1 << 4)
#define XV_SOCK	 (1 << 5)
#define XV_READ	 (1 << 6)
#define XV_WRITE (1 << 7)
#define XV_EXEC	 (1 << 8)


/*
 *  Need to make sure that S_IFSOCK & S_IFLNK are defined.  Normally these
 *  defines are defined in <sys/stat.h>, but on certain POSIX machines these
 *  are not defined.  If they are not defined, we then define them to something
 *  meaningless (ie. -1, -2).  Also, make sure that MAXPATHLEN is defined.
 */
#ifndef S_IFSOCK
#define S_IFSOCK -1
#endif

#ifndef S_IFLNK
#define S_IFLNK -2
#endif

#ifdef UNICOS
#define MAXPATHLEN    PATHSIZE
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN    1024
#endif


/*
 *  Defines for the dsp routines
 */
#undef  DSP_VECTOR 
#define DSP_VECTOR  0

#undef  DSP_BAND 
#define DSP_BAND 1


/*
 *  Declare some of the basic basic string manipulation routines
 */
#ifndef malloc
char 	*malloc();
#endif

#ifndef calloc
char 	*calloc();
#endif

#ifndef strchr
char	*strchr();
#endif

#ifndef strrchr
char	*strrchr();
#endif

#define MAXBUFF 	20      /* max # of command line string args */

/**************************************************************
*
* MODULE NAME: VStrlen
*
*     PURPOSE: a better strlen (will check for null pointers)
*
*       INPUT: 1. a character pointer
*
*      OUTPUT: the length of the string
*
* CALLED FROM: EVERY place that uses strlen
*
**************************************************************/

#define	   VStrlen(strng)	((strng == NULL) ? 0 : strlen(strng))

/**************************************************************
*
* MODULE NAME: VStrcat
*
*     PURPOSE: a memory allocation  strcat (will malloc for me)
*
*       INPUT: 1. s1 - a character pointer to the first string
*       	  s2 - a character pointer to the second string
*
*      OUTPUT: a pointer to the concatenated string
*
* CALLED FROM: EVERY place that needs to malloc inside of strcpy
*
**************************************************************/

#define VStrcat(s1, s2) (strcat(strcpy(malloc(VStrlen(s1) + VStrlen(s2) +1), \
				(s1)), (s2)))

/**************************************************************
*
* MODULE NAME: VStrcpy
*
*     PURPOSE: a memory allocation  strcpy (will calloc for me)
*
*       INPUT: 1. a character pointer
*
*      OUTPUT: a pointer to a calloc'ed string
*
*
**************************************************************/

#define	VStrcpy(strng) (strcpy(calloc((unsigned)1, (unsigned)(VStrlen(strng)+1)),strng))

/*
 * library routine declarations
 */
char *vbasename();
char *vfullpath();
char *vtempnam();
struct xvimage *readimage();
struct xvimage *createimage();
struct xvimage *copyimage();
struct xvimage **create_image_list();
float *read_raw();
float *read_ascii();
char **load_vector();
char **dload_vector();
char *unload_vector();

/*
 * Handy defines for getting around in image data arrays
 */

/* PIXEL - For indexing into SINGLE BAND 2D arrays, incurs less computation
           then BPIXEL. */
#define PIXEL(x,y,rows,cols) (y)*(cols)+(x) 

/* BPIXEL - For indexing into MULTI-BAND 2D arrays. */
#define BPIXEL(b,x,y,rows,cols) (b)*(rows)*(cols)+(y)*(cols)+(x)

#endif /* _vdefines_h_ */
/* Don't add after this point. */
