/* SCCS @(#)contours4.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                      contours4.c                                     */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   contours4.c                                         */
/*                                                                      */
/* DESCRIPTION  :   Edge Detection oprations                            */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <stdio.h>
#include <math.h>

#include "define.h"
#include "type.h"


#define	LAPLACE	0
#define	ROBERTS	1
#define	SOBEL	2

int	find_zero();
int	draw();
int	limit();
int	permut_buf();



/*****************************************************************************/
/*  Mero_Vassy								     */
/*****************************************************************************/

int edg_mero_vassy(bp1, bf, colonne, ligne)
    float *bp1;
    float **bf;
    int colonne, ligne;
{
  float *bp2;
  int i, j;
  
  /* Allocation of memory space for the resultant image */
  *bf=(float*) malloc(ligne*colonne*sizeof(float));

  if (*bf == NULL)      /* not enough memory space */
         return(-1);

  bp2 = *bf;

  for (i = 0; i < ligne - 1; i++) {
     for (j = 0; j < colonne - 1; j++) {
       *bp2 = abs((int)(*(bp1+1) + *(bp1+colonne+1) - *bp1 - *(bp1+colonne) + 0.5)) +
              abs((int)(*bp1 + *(bp1+1) - *(bp1 + colonne) - *(bp1 + colonne + 1) + 0.5));
       bp2++; bp1++;
     }
     *bp2 = *bp1;
     bp2++; bp1++;
   }
  for (j = 0; j < colonne; j++) {
    *bp2 = *bp1;
    bp2++; bp1++;
  }
  return(0); 
}


/*****************************************************************************/

int find_zero (fa, fb, fc, s)
float fa, fb, *fc, s;
{
    int t;

    if (((fa > s) && (fb < s)) || ((fa < s) && (fb > s))) {
	t = (int)(abs((int)fa) + abs((int)fb));
	*fc = (t > *fc) ? t : *fc;
    }
}

/*****************************************************************************/
/*  Zero_Crossing							     */
/*****************************************************************************/

int edg_zero_cross(bp1, bnf, colonne, ligne, valzero)
    float *bp1;
    float **bnf;
    int colonne, ligne;
    float valzero;
{
    float *bp2, *datum;
    int i, j;

    datum = (float *)calloc(1, sizeof(float));

    /* Allocation of memory space for the resultant image */
    *bnf=(float*) malloc(ligne*colonne*sizeof(float));

    if (*bnf == NULL)      /* not enough memory space */
         return(-1);

    bp2 = *bnf;

    for (i = 0; i < ligne - 1; i++) {
      for (j = 0; j < colonne - 1; j++) {
	*datum = 0;
	find_zero(*bp1, *(bp1+1), datum, valzero);	      /*east*/
	find_zero(*bp1, *(bp1+colonne), datum, valzero);      /*south*/
	find_zero(*bp1, *(bp1+colonne+1), datum, valzero);    /*south_east*/
	*bp2 = *datum;
	bp2++; bp1++;
      }
      *bp2 = 0;
      bp2++; bp1++;
    }
    for (j = 0; j < colonne; j++) {
      *bp2 = 0;
      bp2++; bp1++;
    }
    return(0);
}


/*****************************************************************************/

#define S(x, y) s[x * col + y]
#define RES(x, y) res[x * col + y]
#define RUB(x, y) rub[x * col + y]

draw(i, j, l, lt, bfpxl, s, res, rub, min_thr, first, lin, col)

    int i, j, *l, lt, first, lin, col;
    struct prcd *bfpxl;
    float min_thr;
    float *s, *rub; /*, *res; */
    unsigned char *res;
{
    int bpi, bpj, k, n;
    int F1;
    int FAIL;
    int iinf, isup, jinf, jsup;		    /* coordinates */
    int Pt1Hlf2;			    /* flags 1st pnt of 2nd half */
    float locmax;			    /* value of local maximum */
    int repl;				    /* replace *l */

    repl = *l;
    F1 = TRUE;
    FAIL = FALSE;
    bpi = i; bpj = j;			    /* bpi/bpj savd bef while loop!!*/
    locmax = S(bpi, bpj);		    /* value for first point   */
    if (first == 1) S(bpi, bpj) = 0;	    /* 1st pnt taken only once */

    /* Pt1Hlf2: prevents beg pnt taken twice */
    Pt1Hlf2 = 0;			    /* normally FALSE, but */
    if (first == 0) Pt1Hlf2 = 1;	    /* TRUE when entering 2nd half */

    while (!FAIL) {
	if (repl < lt) {	
	    if (Pt1Hlf2 != 1)	{
		bfpxl[repl].x = i;	
		bfpxl[repl].y = j;
		bfpxl[repl].val = locmax;	 
		repl++;
	    }
	    else Pt1Hlf2 = 0;		    /* only once at 1 */
	    if (repl == lt) {		    /* writes buf     */
		for (k=0; k<repl; k++)
		    RES(bfpxl[k].x, bfpxl[k].y) = 255 ; /* 1.0; */
	    }
	}
	else {				    /*repl>lt: writes all pnts fnd  */
	    if (first==1) {		    /* 1st half contour		    */
		RES(i, j) = 255 ; /* 1.0; */
		repl++;
	    }
	    else {			    /* 2nd half contour, needs test */
		if (Pt1Hlf2 != 1) {	    /* dont write 1st pnt, 2nd half */
		    RES(i, j)= 255 ; /* 1.0; */
		    repl++;
		} else Pt1Hlf2 = 0;
	    }				    
	 }
	locmax = peaks(s, rub, &i, &j, lin, col); /* next extremum along chain*/
	if (locmax < min_thr)		     /*restores into 'source' neighb */
	    if (F1) {			     /*of beg point (w/o 1st and 2nd)*/
		F1 = FALSE;
		limit (i, j, lin, col, &iinf, &isup, &jinf, &jsup);
		for (k=iinf; k<=isup; k++)
		    for (n=jinf; n<=jsup; n++)
			if (RUB(k, n) != 0)  S(k, n) = RUB(k, n);
		limit (bpi, bpj, lin, col, &iinf, &isup, &jinf, &jsup);
		for (k=iinf; k<=isup; k++)
		    for (n=jinf; n<=jsup; n++)
			if (RUB(k, n) != 0)  S(k, n) = RUB(k, n);
		if((locmax==0) || (locmax < min_thr))
		    FAIL = TRUE;
	    }
	    else FAIL = TRUE;
	else F1 = TRUE;			    /* then locmax >= minthr */
    }					    /* while (!FAIL)	     */
    *l = repl;
}

/************************************************************************/

#define IS(x, y) I1[x * column + y]
#define RUBISH(x, y) rubish[x * column + y]

peaks(I1, rubish, i, j, line, column)
    float *I1, *rubish;
    int *i, *j, line, column;

{
    int k, l;
    float m;			/* will contains max in neighborhood*/
    float vt;
    int x,y;
    int icnt;
    static int k_inc[8] = {-1, -1,  1, 1, -1,  0, 1, 0};
    static int l_inc[8] = { 1, -1, -1, 1,  0, -1, 0, 1};

    m = 0.0;
    for (icnt=0; icnt<8; icnt++) {	/* loop over 8-neighborhood     */
	k = *i + k_inc[icnt];
	l = *j + l_inc[icnt];
	if (k < 0) k = 0;
	if (l < 0) l = 0;
	if (k >= line) k = line - 1;
	if (l >= column) l = column - 1;
	vt = IS(k, l);
	if (vt > m) {
	    m = vt;			/*contains largest of 3x3 nghb, not*/
	    x = k; y = l;		/*center point since was put to 0  */
	}
					/* writes into rubish only data != 0*/
	if (vt != 0) RUBISH(k, l) = vt;
	IS(k, l) = 0.0;			/* zeroes I1 progressively	    */
    }

    if (m!=0) {				/*then zeroes rubish at max position*/
	*i = x; *j = y;			/* (thus each max only once)	    */
	RUBISH(x, y) = 0.0;
    }
    return m;
}

/****************************************************************************/

limit(l, c, line, column, linf, lsup,  cinf, csup)
    int l, c, line, column, *linf, *lsup, *cinf, *csup;
{

    *linf = (l <= 0) ? 0 : l-1;
    *cinf = (c <= 0) ? 0 : c-1;
    *lsup = (l < line-1) ? l+1 : line-1;
    *csup = (c < column-1) ? c+1 : column-1;
}

/**************************************************************************/

permut_buf(bfpxl, l, lt)
    struct prcd *bfpxl;
    int l, lt;

{
    struct prcd bufdum;		    /* for permutation		*/
    int ndatperm;			    /* nr data to permutate	*/
    int llt, kk, lkk1;

    if (l <= 0) return;			    /*permutation even if l > lt*/

    if (l > lt) {
	ndatperm = lt/2;
	llt = lt;
    } else {
	ndatperm = l/2;
	llt = l;
    }
    for (kk=0; kk < ndatperm; kk++) {
	lkk1 = llt - kk - 1;
	bufdum.x = bfpxl[kk].x;
	bufdum.y = bfpxl[kk].y;
	bufdum.val = bfpxl[kk].val;
	bfpxl[kk].x = bfpxl[lkk1].x;
	bfpxl[kk].y = bfpxl[lkk1].y;
	bfpxl[kk].val = bfpxl[lkk1].val;
	bfpxl[lkk1].x = bufdum.x;
	bfpxl[lkk1].y = bufdum.y;
	bfpxl[lkk1].val = bufdum.val;
    }
}


/*****************************************************************************/
/*  Date   :                                                                 */
/*  Subject: Edge detecting subroutines for image analysis.                  */
/*  Ref    : SubRoutines edg_frei_chen, edg_laplace, edg_sobel1,             */
/*           edg_roberts of the Spider Manual   	       		     */
/*                                                                           */
/* Subroutine edg_frei_chen : uses the Frei-Chen Masks,returns a 1-D array.  */
/* ---------------------------------------------------------------------     */
/* performs edge detection using the Frei-Chen Masks and returns a 1-D       */
/* array containing the edge detected image .                                */
/*                                                                           */
/*   **Parameters**                                                          */
/*   InArray: 1-D Array containing the image.                                */
/*   DimX, DimY : Dimensions of the image.( DimY is the no. of rows    )     */
/*                                        ( DimX is the no. of columns )     */
/*                                                                           */
/*   **Returns**                                                             */
/*   - NULL if there was not enough memory space for the output array.       */
/*   - a 1-D array of reals containing the resultant image                   */
/*     if there was enough space for the array.                              */
/*****************************************************************************/


int edg_frei_chen (InArray, OutArray, DimX, DimY)
   float *InArray;
   float **OutArray;            /* will contain edge detected image */
   int DimX, DimY;
{
  int i,j,il,jl,ik,jk,buf1,buf2;
  int ValIm;
  float SSValIm,Res1Mas,Res2Mas;
  float MaskW1[3][3],MaskW2[3][3]; /* The Frei-Chen Masks  */
	
  /* Initialisation of the Frei-Chen Masks */
  MaskW1[0][0]= 1;
  MaskW1[0][1]= 1.41421356;
  MaskW1[0][2]= 1;
  MaskW1[1][0]= 0;
  MaskW1[1][1]= 0;
  MaskW1[1][2]= 0;
  MaskW1[2][0]= -1;
  MaskW1[2][1]= -1.41421356;
  MaskW1[2][2]= -1;


  MaskW2[0][0]= 1;
  MaskW2[0][1]= 0;
  MaskW2[0][2]= -1;
  MaskW2[1][0]= 1.41421356;
  MaskW2[1][1]= 0;
  MaskW2[1][2]= -1.41421356;
  MaskW2[2][0]= 1;
  MaskW2[2][1]= 0;
  MaskW2[2][2]= -1;
 
  /* Allocation of memory space for the resultant image */

  *OutArray=(float*) malloc(DimX*DimY*sizeof(float));
  if (*OutArray == NULL)      /* not enough memory space */
         return(-1);
 

  /* A point on the 2-D image Image[x,y] is OutArray[DimX*y+ x].  
     Outermost pixels of the resultant image are at zero. */

  buf1=DimX*(DimY-1);
  buf2=DimX;       
  for (i=0; i < buf2; ++i){
    *(*OutArray+i)=0;
    *(*OutArray+i+buf1)=0;
  }
  buf1=DimX-1;
  buf2=DimY-1;
  for (j=1; j < buf2; ++j){
    *(*OutArray+DimX*j)=0;
    *(*OutArray+(DimX*j+buf1))=0;
  }

  /* The application of Frei-Chen masks given by:                         */
  /*              sum over i,k of ( Image[x-i,y-k]* W[i,k] )              */  
  /*              i=1,N-1;j=1,N-1                                         */

  for (j=1; j < buf2; ++j)
     for (i=1; i < buf1; ++i){
       SSValIm=0;
       Res1Mas=0;
       Res2Mas=0;
       for (jl=0; jl < 3; ++jl){
	 jk = j-1+jl;
	 for (il=0; il < 3; ++il){
	   ValIm = InArray[DimX*jk+(i-1+il)];
	   SSValIm = SSValIm + ValIm * ValIm ;
	   Res1Mas = Res1Mas + ValIm * MaskW1[il][jl];
	   Res2Mas = Res2Mas + ValIm * MaskW2[il][jl];
	 }
       }
       /* Attribution of the resultant value to the array containing 
	  the output image.*/

       *(*OutArray+DimX*j+i)=(Res1Mas*Res1Mas+Res2Mas*Res2Mas)/
							    SSValIm;
     }
  return(0);
}                      





/*****************************************************************************/
/*  Subroutine edg_roberts : uses the  Roberts Operator, returns a 1-D array.*/
/*  ------------------------------------------------------------------------ */
/*  performs edge detection using the Roberts Operator and returns a 1-D     */
/*  array containing the edge detected image .                               */
/*                                                                           */
/*    **Parameters**                                                         */
/*    InArray    : 1-D Array containing the image.                           */
/*    DimX, DimY : Dimensions of the image.( DimY is the no. of rows    )    */
/*                                         ( DimX is the no. of columns )    */
/*    TypEdgMag  : To determine the type of edge magnitude computation,      */
/*                 if < 0 then add the absolute difference of diagonally     */
/*                        opposite pixel values.                             */
/*                 if not ,take the sqrt of sum of squares of the            */
/*                         difference of diagonally opposite pixel values.   */
/*                                                                           */
/*    **Returns**                                                            */
/*    - NULL if there was not enough memory space for the output array.      */
/*    - A 1-D array of integers containing the resultant image               */
/*      if there was enough space.                                           */
/*****************************************************************************/

int edg_roberts (InArray, OutArray, DimX, DimY, TypEdgMag)
   float *InArray;
   float **OutArray;                /* to contain edge detected image */  
   int DimX, DimY, TypEdgMag;
{
  int i,j,buf1,buf2;
  int DiffDiag, DiagDiff, ValRes, ValBuf;

  /* Allocation of memory space for the resultant image */

  *OutArray=(float*) malloc(DimX*DimY*sizeof(float));
  if (*OutArray == NULL)         /* not enough memory space */
          return(-1);  

  /* A point on the 2-D image Image[x,y] is InArray[Dim*y+x].
     The outermost pixels of the resultant image are at zero. */

  buf1=DimX*(DimY-1);
  buf2=DimX;   
  for (i=0; i < buf2; ++i)
  {
    *(*OutArray+i)=0.0;
    *(*OutArray+i+buf1)=0.0;
  }
  buf1=DimX-1;
  buf2=DimY-1;
  for (j=1; j < buf2; ++j)
  {
    *(*OutArray+DimX*j)=0.0;
    *(*OutArray+(DimX*j+buf1))=0.0;
  }

  /* The application of the Roberts operator is given by: */

  for (j=1; j < buf2; ++j)
    for (i=1; i < buf1; ++i)
    {
      DiffDiag=InArray[DimX*j+i] - InArray[DimX*(j+1)+(i+1)];
      DiagDiff=InArray[DimX*j+i+1] - InArray[DimX*(j+1)+i]; 
      ValRes = (TypEdgMag == 2) ? (abs(DiffDiag) + abs(DiagDiff)) : ((int)(sqrt((double)DiffDiag*DiffDiag + DiagDiff*DiagDiff))); 
      *(*OutArray+DimX*j+i)=ValRes;
    }      

  return(0);       
}
   





/*****************************************************************************/
/* Subroutine edg_sobel : by  Sobel Operator                                 */
/* -----------------------------------------                                 */
/* performs edge detection using the Roberts Operator and returns a 1-D      */
/* array containing the edge detected image .                                */
/*                                                                           */
/*    **Parameters**                                                         */
/*    InArray    : 1-D Array containing the image.                           */
/*    DimX, DimY : Dimensions of the image.( DimY is the no. of rows    )    */
/*                                         ( DimX is the no. of columns )    */
/*    TypEdgMag  : To determine the type of edge magnitude computation,      */
/*                 if < 0 then add the absolute difference of diagonally     */
/*                        opposite pixel values.                             */
/*                 if not ,take the sqrt of sum of squares of the            */
/*                         difference of diagonally opposite pixel values.   */
/*                                                                           */
/*    **Returns**                                                            */
/*    - NULL if there was not enough memory space for the output array.      */
/*    - a 1-D Array of integers,containing the resultant image               */
/*      if there was enough space.                                           */
/*****************************************************************************/

int edg_sobel (InArray, OutArray, DimX, DimY, TypEdgMag)
   float *InArray;
   float **OutArray;           /* to contain the edge detected image */ 
   int DimX, DimY, TypEdgMag;
{
  int i,j,buf1,buf2;
  int XDiff, YDiff, ValRes, ValBuf;

  /* Allocation of memory space for the resultant image */

  *OutArray=(float*) malloc(DimX*DimY*sizeof(float));
  if (*OutArray == NULL)         /* not enough memory space */
          return(-1);

  /* A point on the 2-D image Image[x,y] is OutArray[DimX*y+x].
     Outermost pixels of the resultant image are at zero */

  buf1=DimX*(DimY-1);
  buf2=DimX;         
  for (i=0; i < buf2; ++i)
  {
    *(*OutArray+i)=0.0;
    *(*OutArray+i+buf1)=0.0;
  }
  buf1=DimX-1;
  buf2=DimY-1;
  for (j=1; j < buf2; ++j)
  {
    *(*OutArray+DimX*j)=0.0;
    *(*OutArray+(DimX*j+buf1))=0.0;
  }

  /* The application of the Sobel's operator is given by:*/
  for (j=1; j < buf2; ++j)
    for (i=1; i < buf1; ++i)
    {	
      XDiff=(InArray[DimX*(j-1)+i+1] + (2 * InArray[DimX*j+i+1]) + InArray[DimX*(j+1)+(i+1)]) - (InArray[DimX*(j-1)+i-1] + (2 * InArray[DimX*j+i-1]) + InArray[DimX*(j+1)+i-1]);
      YDiff=(InArray[DimX*(j+1)+i-1] + (2 * InArray[DimX*(j+1)+i]) + InArray[DimX*(j+1)+(i+1)]) - (InArray[DimX*(j-1)+i-1] + (2 * InArray[DimX*(j-1)+i]) + InArray[DimX*(j-1)+(i+1)]);
      ValRes = (TypEdgMag == 2) ? (abs(XDiff) + abs(YDiff)) : ( (int)(sqrt((double)(XDiff*XDiff + YDiff*YDiff))));
    
      /* Attribution of the resultant value to the array containing the output
	 image.*/
      *(*OutArray+(DimX*j+i))=ValRes;  /*i*10+j;*/
    }
  return(0);          
}
   





/*****************************************************************************/
/* Subroutine edg_laplace : Edge extraction by  Laplacian Operator           */
/* ---------------------------------------------------------------	     */
/* performs edge detection using the Roberts Operator and returns a 1-D      */
/* array containing the edge detected image .                                */
/*                                                                           */
/*    **Parameters**                                                         */
/*   InArray    : 1-D Array containing the image.                            */
/*   DimX, DimY : Dimensions of the image.( DimY is the no. of rows    )     */
/*                                        ( DimX is the no. of columns )     */
/*   TypEdgMag  : To determine the type of edge magnitude computation,       */
/*                the third dimension of the Maskl determines which 3X3      */
/*                mask is to be used.                                        */
/*                                                                           */
/*    **Returns**                                                            */
/*    - NULL if there was not enough memory space for the output array.      */
/*    - a 1-D Array of integers,containing the resultant image               */
/*      if there was enough space.                                           */
/*****************************************************************************/

int edg_laplace (InArray, OutArray, DimX, DimY, TypEdgMag)
   float *InArray;
   float **OutArray;           /* to contain the edge detected image */ 
   int DimX, DimY, TypEdgMag;
{
  void PrintImage();
  int i,j,mi,mj,ii,jj,buf1,buf2;
  int DiffDiag, DiagDiff, ValSum;
  int Maskl[3][3][3];
  

  /* Initialisation of the Laplacian Maskls                             */
  Maskl[0][0][0]= 0;
  Maskl[0][1][0]= -1;
  Maskl[0][2][0]= 0;
  Maskl[1][0][0]= -1;
  Maskl[1][1][0]= 4;
  Maskl[1][2][0]= -1;
  Maskl[2][0][0]= 0;
  Maskl[2][1][0]= -1;
  Maskl[2][2][0]= 0;
  Maskl[0][0][1]= -1;
  Maskl[0][1][1]= -1;
  Maskl[0][2][1]= -1;
  Maskl[1][0][1]= -1;
  Maskl[1][1][1]= 8;
  Maskl[1][2][1]= -1;
  Maskl[2][0][1]= -1;
  Maskl[2][1][1]= -1;
  Maskl[2][2][1]= -1;
  Maskl[0][0][2]= 1;
  Maskl[1][0][2]= -2;
  Maskl[2][0][2]= 1;
  Maskl[0][1][2]= -2;
  Maskl[1][1][2]= 4;
  Maskl[2][1][2]= -2;
  Maskl[0][2][2]= 1;
  Maskl[1][2][2]= -2;
  Maskl[2][2][2]= 1;
 
  /* Allocation of memory space for the resultant image */

  *OutArray=(float*) malloc(DimX*DimY*sizeof(float));
  if (*OutArray == NULL)
     return(-1);
  
  /* A point on the 2-D image Image[x,y] is OutArray[DimX*y+x].
     Outermost pixels of the resultant image are at zero */

  buf1=DimX*(DimY-1);
  buf2=DimX;         
  for (i=0; i < buf2; ++i)
  {
    *(*OutArray+i)=0.0;
    *(*OutArray+i+buf1)=0.0;
  }
  buf1=DimX-1;
  buf2=DimY-1;

  /* The application of the Laplacian operator is given by: */

  for (j=1; j < buf2; ++j)
  {
    *(*OutArray+DimX*j)=0.0;
    *(*OutArray+(DimX*j+buf1))=0.0;
  }

  for (j=1; j < buf2; ++j)
    for (i=1; i < buf1; ++i) 
    {
      ValSum=0;
      for (mj= 0; mj < 3; ++mj)
      {
	jj=j-1+mj;
	for (mi= 0; mi < 3; ++mi)
	{
	  ValSum=ValSum + InArray[DimX*jj+(i-1+mi)] *  Maskl[mi][mj][TypEdgMag];
	}
      }  
      /* Attribution of the resultant value to the array containing the output
	 image. */
      *(*OutArray+DimX*j+i)=ValSum;
    }
  return(0);  
}




