/* SCCS @(#)reg_growingTOOL.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                   reg_growingTOOL.callback.c                         */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   reg_growingTOOL.callback.c                          */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Region Growing Tool)                     */
/*                                                                      */
/* AUTHORS      :   Rene Lutz, Marianne Logean                          */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

/*******************************************************************/
/*                                                                 */
/*	      Methode de segmentation par region growing	   */
/*		 (version 1.0 destinee au LaboImage)        	   */
/*								   */
/*******************************************************************/

#include "libwidgets/widgetstructure.h"
#include "reg_growingTOOL.layout.h"
#include "pre_pro.layout.h"
#include <Xm/Text.h>
#include <stdio.h>
#include <math.h>
#include <X11/cursorfont.h>

extern Display          *gDisplay;
extern Visual           *gVisual;
extern GC               default_gc;
extern Cursor  	        gWatchcursor;
extern Widget  		gLabowidget;

extern Colormap init_color_lin();  /*pour medinfo */
/* plus tard, peut-etre faire des tables de couleurs globals*/

/********************************************************

		     macros et constantes

********************************************************/


#define DIFF(a,b) fabs ((double) a - (double) b )

#define GLOBAL 0
#define LOCAL 1
#define MOYENNE 2
#define SIGMA 3
#define OFF 0
#define ON 1
#define CON4 0
#define CON8 1
#define OFF 0
#define RI 0
#define IC 1
#define RC 2

/*
	variables de calcul
*/

int *I, *R, *C ;		/* plans I-mage, R-egion (% 256), C-ontour */
int *Reg ;		        /* plan Reg-ion (regions etiquettees) */

int taille_image ;
int width, height ;
int swidth,bwidth, lastline ;   /* s(b)-width = width -(+) 1 ; pour le
				   calcul des bords ainsi que lastline */

int seuil ;			/* seuil de tolerance */
int init_val ;			/* valeur du pixel initial (seg. moyenne) */
int color;			/* colour d'affichage (% 256) */
int Reg_color ;			/* etiquette de region [1,2,...etc] */

int nombre_tot ;		/* calculs de moyennes et d'ecart-types */
int nombre ;
int mmin, mmax ;		/* pour les segmentation min_max */

static struct description_memoire desc_mem;
static xs_struc_reg_growing *widgets_growing;

static Pixmap pixmap_drawing[2];

/* variable d'etat des toggles */
/* =========================== */

static int segmentation_selected = GLOBAL;
static int trace_selected = OFF;       /* anciennement trace_val */
static int display_selected = RI;      /* anciennement d_mode */
static int connexity_selected = CON4;


/*******************************************************************/
/*								   */
/*			Procedures de segmentation		   */
/*								   */
/*******************************************************************/

/*******************************************************************/
/*								   */
/* nom      : get_tolerance					   */
/*								   */
/* fonction : determine la valeur de tolerance choisie	       	   */
/*                                                                 */
/*******************************************************************/


static int
get_tolerance(tab_widgets)
    xs_struc_reg_growing *tab_widgets;
{
    return(atoi(XmTextGetString(tab_widgets->tolerance)));
}



/*******************************************************************/
/*								   */
/* nom      : fix_parameters				           */
/*								   */
/* fonction : effectue les initialisations		           */
/*                                                                 */
/* entrees  : ---	                                           */
/*                                                                 */
/* globales : int seuil, width, swidth, bwidth, height, lastline   */
/*                taille_image 			                   */
/*                *R, *C                                           */
/*                                                                 */
/* return   : ---						   */
/*								   */
/* routines : get_tolerance()				           */
/*								   */
/*******************************************************************/

static void
fix_parameters(tab_widgets)
xs_struc_reg_growing *tab_widgets;
{
	int i, *tmp_R, *tmp_C ;

	seuil = get_tolerance(tab_widgets) + 1 ;
	swidth = width - 1 ;
	bwidth = width + 1 ;
	lastline = taille_image - width ;

	if (R != NULL) 
	{
	  free(R);
	  R = NULL ;
	}
	
	if (C != NULL) 
	{
	  free(C);
	  C = NULL ;
	}

	R = (int *) calloc (taille_image, sizeof(int));
	C = (int *) calloc (taille_image, sizeof(int));

	tmp_R = R ;
	tmp_C = C ;

	for(i=0 ; i < taille_image ; i++)
	{
		*tmp_R = *tmp_C = 0 ;
		tmp_R++ ; tmp_C++ ;
	}
}


/*******************************************************************/


static void
show_image(tab_widgets, no, image) 
    xs_struc_reg_growing *tab_widgets;
    int no, *image;         
{
  int type;
  float mmin, mmax;
  XImage *ximage;
  unsigned char *data;
  Arg args[MAX_ARGS];
  int n = 0;

  if (!image || !pixmap_drawing[no]) return;
  
  type = 2;
  mmin = dir_desc[index_image[0]].mmin;
  mmax = dir_desc[index_image[0]].mmax;

  affiche_image_color (&data, (unsigned char *)image,
		       type, height, width, mmin, mmax);

  ximage = XCreateImage(gDisplay, gVisual,
			8, ZPixmap, 0, (char *)data,
			width, height, 8, 0);

  XPutImage(gDisplay, pixmap_drawing[no], default_gc, ximage, 
	    0, 0, 0, 0, width, height);

  XCopyArea (gDisplay, pixmap_drawing[no], 
	     XtWindow(tab_widgets->drawing_widget[no]), 
	     default_gc, 0, 0, 
	     width, height, 0, 0);

  XDestroyImage(ximage);
  free(data);
}



static void
clear_screen(tab_widgets, no) 
    xs_struc_reg_growing *tab_widgets;
    int no; 
{
  XImage *ximage;
  unsigned char *data;
  int i;

  if (!pixmap_drawing[no]) return;
  
  data = (unsigned char *)malloc(taille_image); 

  ximage = XCreateImage(gDisplay, gVisual,
			8, ZPixmap, 0, (char *)data,
			width, height, 8, 0);

  for (i = 0; i<taille_image; i++) 
  {
    *data = 0;
    data++;
  }

  XPutImage(gDisplay, pixmap_drawing[no], default_gc, ximage, 0, 0, 0, 0, 
	    width, height);
	
  XCopyArea (gDisplay, pixmap_drawing[no], 
	     XtWindow(tab_widgets->drawing_widget[no]), 
	     default_gc, 0, 0, 
	     width, height, 0, 0);

  XDestroyImage(ximage);
  free(data);
}



/*******************************************************************/
/*								   */
/* nom      : load_proc_growing		       		           */
/*								   */
/* fonction : charge un plan image			           */
/*                                                                 */
/* entrees  : ---	                                           */
/*                                                                 */
/* globales : int *I, *R, *Reg					   */
/*	      dir_image[], dir_desc[], index_image[]		   */
/*	      int height, width, taille_image			   */
/*	      Canvas left_canvas, right_canvas			   */
/*	      Pixwin *lpw, *rpw					   */
/*								   */
/* return   : ---			 			   */
/*								   */
/* routines : statis(),	clear_screen()	  		       	   */
/*	      show_image()			                   */
/*								   */
/*******************************************************************/

void
load_proc_growing()
{
    int type, ligne, colonne;
    unsigned char *imageIn;
    float mmin, mmax, mmin2, mmax2;
    struct convert *conv;
    int i, *tmp_R, *tmp_C, *tmp_Reg ;
    Arg args[MAX_ARGS];
    int n;

    if (I != NULL)
      {
	free(I) ;
	I = NULL;
      }

    sprintf (buf,"%d --> \n", index_image[0]);
    write_master (buf);

    desc_mem = dir_desc[index_image[0]];
    type = dir_desc[index_image[0]].type;
    ligne =  dir_desc[index_image[0]].nligne;
    colonne = dir_desc[index_image[0]].ncolonne;
    imageIn = dir_image[index_image[0]].image;
    mmin = dir_desc[index_image[0]].mmin;
    mmax = dir_desc[index_image[0]].mmax;

    /* L'image doit etre de type entier =>
       conversion automatique de l'image dans ce type */

    conv = (struct convert *) malloc (sizeof (struct convert));
    conv->flag_mind = TRUE;
    conv->flag_maxd = TRUE;
    conv->flag_mina = TRUE;
    conv->flag_maxa = TRUE;

    sprintf (buf, mastertabs[28]);
    write_master (buf);

    sprintf(buf,"%d", index_image[0]);
    write_master (buf);

    if (dir_image[index_image[0]].image == NULL){
      write_erreur(1);
      return;
    }

    convert_integer(imageIn, type, colonne, ligne, mmin, mmax, 
		    &I, &mmin2, &mmax2, conv);

    sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n", 
	     conv->mind, conv->maxd, conv->mina, conv->maxa);
    write_master (buf);

    desc_mem.mmin = mmin2;
    desc_mem.mmax = mmax2;
    desc_mem.type = 2;

    height = desc_mem.nligne;
    width = desc_mem.ncolonne;
    taille_image = width*height ;

    if (R != NULL) 
      {
	free(R);
	R = NULL ;
      }
	
    if (C != NULL) 
      {
	free(C);
	C = NULL ;
      }

    if (Reg != NULL) 
      {
	free(Reg);
	Reg = NULL ;
      }

    R = (int *) calloc (taille_image, sizeof(int)) ;
    Reg = (int *) calloc (taille_image, sizeof(int)) ;
    C = (int *) calloc (taille_image, sizeof(int)) ;

    tmp_R = R ;
    tmp_C = C ;
    tmp_Reg = Reg ;

    for(i=0 ; i < taille_image ; i++)
    {
      *tmp_R = *tmp_C = *tmp_Reg = 0 ;
      tmp_R++ ; tmp_C++ ; tmp_Reg++ ;
    }

    /* creation des 2 pixmaps */

    if (pixmap_drawing[0]) {
      XFreePixmap(gDisplay, pixmap_drawing[0]);
      pixmap_drawing[0] = NULL;
    }
    if (pixmap_drawing[1]) {
      XFreePixmap(gDisplay, pixmap_drawing[1]);
      pixmap_drawing[1] = NULL;
    }

    pixmap_drawing[0] = XCreatePixmap(gDisplay,
				      XDefaultRootWindow(gDisplay),
				      width, height, 8);
    n = 0;
    XtSetArg(args[n],XmNbackgroundPixmap, pixmap_drawing[0]); n++;
    XtSetArg(args[n],XmNwidth, (Dimension)width); n++;
    XtSetArg(args[n],XmNheight, (Dimension)height); n++;
    XtSetValues(widgets_growing->drawing_widget[0], args, n);


    pixmap_drawing[1] = XCreatePixmap(gDisplay,
				      XDefaultRootWindow(gDisplay),
				      width, height, 8);
    n = 0;
    XtSetArg(args[n],XmNbackgroundPixmap, pixmap_drawing[1]); n++;
    XtSetArg(args[n],XmNwidth, (Dimension)width); n++;
    XtSetArg(args[n],XmNheight, (Dimension)height); n++;
    XtSetValues(widgets_growing->drawing_widget[1], args, n);

    switch(display_selected)
    {

	case RI :
		clear_screen(widgets_growing, 0) ;
		show_image(widgets_growing, 1, I) ;
		break ;

	case IC :
		clear_screen(widgets_growing, 1) ;
		show_image(widgets_growing, 0,I) ;
		break ;

	default : 
		clear_screen(widgets_growing, 0) ;
		clear_screen(widgets_growing, 1) ;
		break ; 
    }	
}


/*******************************************************************/
/*								   */
/* nom      : store_c_proc				           */
/*								   */
/* fonction : sauve le plan des contours dans un plan image        */
/*                                                                 */
/* entrees  : ---                                                  */
/*                                                                 */
/* globales : *C				                   */
/*	      dir_image[], dir_desc[], index_image[]		   */
/*								   */
/*******************************************************************/
 
void
store_c_proc()
{
	if (dir_image[index_image[1]].image != NULL) 
		free (dir_image[index_image[1]]);

	dir_image[index_image[1]].image =  (unsigned char *) C ;
	dir_desc[index_image[1]] = desc_mem;
	dir_desc[index_image[1]].type = 2;

	statis (dir_image[index_image[1]].image,
			dir_desc[index_image[1]].type, 
			dir_desc[index_image[1]].nligne,
			dir_desc[index_image[1]].ncolonne,
			&(dir_desc[index_image[1]].mmin),
			&(dir_desc[index_image[1]].mmax), 
			&(dir_desc[index_image[1]].mu),
			&(dir_desc[index_image[1]].ecart));

}


/*******************************************************************/
/*								   */
/* nom      : store_r_proc				           */
/*								   */
/* fonction : sauve le plan des regions dans un plan image         */
/*                                                                 */
/* entrees  : ---                                                  */
/*                                                                 */
/* globales : *Reg				                   */
/*	      dir_image[], dir_desc[], index_image[]		   */
/*								   */
/*******************************************************************/

void
store_r_proc()
{
	if (dir_image[index_image[1]].image != NULL) 
		free (dir_image[index_image[1]]);

	dir_image[index_image[1]].image = (unsigned char *) Reg ;
	dir_desc[index_image[1]] = desc_mem;
	dir_desc[index_image[1]].type = 2;

	statis (dir_image[index_image[1]].image,
			dir_desc[index_image[1]].type, 
			dir_desc[index_image[1]].nligne,
			dir_desc[index_image[1]].ncolonne,
			&(dir_desc[index_image[1]].mmin),
			&(dir_desc[index_image[1]].mmax), 
			&(dir_desc[index_image[1]].mu),
			&(dir_desc[index_image[1]].ecart));

}


/*******************************************************************/
/*								   */
/* nom      : marquer					           */
/*								   */
/* fonction : marque le nouveau point accepte dans la region       */
/*                                                                 */
/* entrees  : int pos (position dans l'image)	                   */
/*                                                                 */
/* globales : int *R, *Reg					   */
/*		  Reg_color, color, trace_val, d_mode, width	   */
/*								   */
/*								   */
/*******************************************************************/

static void
marquer(pos, tab_widgets)
int pos ;
xs_struc_reg_growing *tab_widgets;
{
  Arg args[MAX_ARGS];
  int n = 0;

  if (!pixmap_drawing[0]) return;

  R[pos] = color;
  Reg[pos] = Reg_color;

  if(trace_selected && 
     ((display_selected == RC) || (display_selected == RI)))
  {
    XSetForeground(gDisplay, default_gc, color);
    XDrawPoint(gDisplay, pixmap_drawing[0],
	       default_gc, pos % width, (int) pos/width);
    XDrawPoint(gDisplay, XtWindow(tab_widgets->drawing_widget[0]),
	       default_gc, pos % width, (int) pos/width);
  }
}


/*******************************************************************/
/*								   */
/* nom      : contour					           */
/*								   */
/* fonction : marque le point dont aucun voisin n'est "merge-able" */
/*                                                                 */
/* entrees  : int pos (position dans l'image)	                   */
/*                                                                 */
/* globales : int *R, *C					   */
/*		  trace_val, d_mode, width			   */
/*								   */
/*******************************************************************/

static void
contour(pos, tab_widgets)
int pos ;
xs_struc_reg_growing *tab_widgets;
{
  Arg args[MAX_ARGS];
  int n = 0;

  if (!pixmap_drawing[1]) return;

  if(!R[pos])
  {
    C[pos] = 255;
    if (trace_selected && 
	((display_selected == IC) || (display_selected == RC)))
    {
      XSetForeground(gDisplay, default_gc, 255);
      XDrawPoint(gDisplay, pixmap_drawing[1],
		 default_gc, pos % width, (int) pos/width);
      XDrawPoint(gDisplay, XtWindow(tab_widgets->drawing_widget[1]),
		 default_gc, pos % width, (int) pos/width);
    }
  }
}



/*******************************************************************/
/*								   */
/* nom      : segmente_global_8					   */
/*								   */
/* fonction : segmentation par croissance de regions avec une	   */
/*	      connexite 8 et un seuil de tolerance fixe par	   */
/*	      rapport au point initial				   */
/*                                                                 */
/* entrees  : int pos (position du point de depart)	           */
/*                                                                 */
/* globales : int *R, *I					   */
/*	          init_val, swidth, bwidth, seuil 		   */
/*								   */
/* return   : ---						   */
/*								   */
/* routines : contour(), marquer()				   */
/*******************************************************************/

static void
segmente_global_8(pos, tab_widgets)
int pos ;
xs_struc_reg_growing *tab_widgets;
{
	int i,j,
	    nofirst, nolast,
	    p[50000],r ;

	p[0] = pos ;
	r = 0 ;
        i = 0 ;
	
    while(r>-1)
    {
	if (pos > swidth)
	{
	    j = pos - bwidth ;
	
	    if((nolast = ((j % width) != swidth)) &&
	          (!R[j]) &&
	          (DIFF(init_val,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	    
	    j++ ;
	    if( (!R[j]) &&
		(DIFF(init_val,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	    j++ ;

	    if( (nofirst = ((j % width) != 0)) &&
	        (!R[j]) &&	
	        (DIFF(init_val,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	}
	    
	j = pos - 1 ;

	if( (nolast) &&
	    (!R[j]) &&	
	    (DIFF(init_val,I[j]) < seuil))
	{
	   p[r++] = j ;
	   marquer(j, tab_widgets) ;
	}

	j+=2 ;

	if( (nofirst) &&
	    (!R[j]) &&	
	    (DIFF(init_val,I[j]) < seuil))
	{
	    p[r++] = j ;
	    marquer(j, tab_widgets) ;
	}

	if(pos < lastline)
	{
	    j = pos + swidth ;

	    if( (nolast) &&
	        (!R[j]) &&
	        (DIFF(I[pos],I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	    
	    j++ ;
	    if(	(!R[j]) &&
	        (DIFF(init_val,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	    j++ ;

	    if( (nofirst) &&
	        (!R[j]) &&	
	        (DIFF(init_val,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }	    	    
	}
    
        if (i==r)
	{
	    contour(pos, tab_widgets);
	    marquer(pos, tab_widgets) ;
	}
	r-- ;
	i = r ;
	pos = p[r] ;
    } /* while */
}


/*******************************************************************/
/*								   */
/* nom      : segmente_global_4					   */
/*								   */
/* fonction : segmentation par croissance de regions avec une	   */
/*	      connexite 4 et un seuil de tolerance fixe par	   */
/*	      rapport au point initial				   */
/*                                                                 */
/* entrees  : int pos (position du point de depart)	           */
/*                                                                 */
/* globales : int *R, *I					   */
/*	          init_val, swidth, bwidth, seuil 		   */
/*								   */
/* return   : ---						   */
/*								   */
/* routines : contour(), marquer()				   */
/*								   */
/* Made by Rene W. LUTZ 19.09.1990				   */
/*******************************************************************/

static void
segmente_global_4(pos, tab_widgets)
int pos ;
xs_struc_reg_growing *tab_widgets;
{
	int i,j,
	    p[50000],r ;

	p[0] = pos ;
	r = 0 ;
        i = 0 ;
	
    while(r>-1)
    {
	if (pos > swidth)
	{
	    j = pos - width ;

	    if( (!R[j]) &&
		(DIFF(init_val,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	}

	j = pos - 1  ;

	if( ((j % width) != swidth) &&
	    (!R[j]) &&
	    (DIFF(init_val,I[j]) < seuil))
	{
	    p[r++] = j ;
	    marquer(j, tab_widgets) ;
	}

	j+= 2 ;
	    
	if( ((j % width) != 0) &&
	     (!R[j]) &&	
	     (DIFF(init_val,I[j]) < seuil))
	{
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	}
	    
	if(pos < lastline)
	{
	    j = pos + width ;

	    if(	(!R[j]) &&
	        (DIFF(init_val,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	}
    
        if (i==r)
	{
	    contour(pos, tab_widgets);
	    marquer(pos, tab_widgets) ;
	}
	r-- ;
	i = r ;
	pos = p[r] ;
    } /* while */
}


/*******************************************************************/
/*								   */
/* nom      : segmente_local_8					   */
/*								   */
/* fonction : segmentation par croissance de regions avec une	   */
/*	      connexite 8 et un seuil local (gradient)		   */
/*                                                                 */
/* entrees  : int pos (position du point de depart)	           */
/*                                                                 */
/* globales : int *R, *I					   */
/*	          swidth, bwidth, seuil				   */
/*								   */
/* return   : ---						   */
/*								   */
/* routines : contour(), marquer()				   */
/*								   */
/* Made by Rene W. LUTZ 19.09.1990				   */
/*******************************************************************/

static void
segmente_local_8(pos, tab_widgets)
int pos ;
xs_struc_reg_growing *tab_widgets;
{
	int i,j,
	    nofirst, nolast,
	    p[50000],r ;

	p[0] = pos ;
	r = 0 ;
        i = 0 ;
	
    while(r>-1)
    {	
	if (pos > swidth)
	{
	    j = pos - bwidth ;
	
	    if( (nolast = ((j % width) != swidth)) &&
	        (!R[j]) &&
	        (DIFF(I[pos],I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	    
	    j++ ;
	    if(	(!R[j]) &&
	        (DIFF(I[pos],I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	    j++ ;

	    if( (nofirst = ((j % width) != 0)) &&
	        (!R[j]) &&	
	        (DIFF(I[pos],I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	}
	    
	j = pos - 1 ;

	if( (nolast) &&
	    (!R[j]) &&
	    (DIFF(I[pos],I[j]) < seuil))
	{
	   p[r++] = j ;
	   marquer(j, tab_widgets) ;
	}

	j+=2 ;

	if( (nofirst) &&
	    (!R[j]) &&	
	    (DIFF(I[pos],I[j]) < seuil))
	{
	    p[r++] = j ;
	    marquer(j, tab_widgets) ;
	}

	if(pos < lastline)
	{
	    j = pos + swidth ;

	    if( (nolast) &&
	        (!R[j]) &&
	        (DIFF(I[pos],I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	    
	    j++ ;
	    if( (!R[j]) &&
		(DIFF(I[pos],I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	    j++ ;

	    if( (nofirst) &&
	        (!R[j]) &&	
	        (DIFF(I[pos],I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }	    	    
	}

        if (i==r)
	{
	    contour(pos, tab_widgets);
	    marquer(pos, tab_widgets) ;
	}
        r-- ;
	i = r ;
        pos = p[r] ;
    } /* while */
}




/*******************************************************************/
/*								   */
/* nom      : segmente_local_4					   */
/*								   */
/* fonction : segmentation par croissance de regions avec une	   */
/*	      connexite 4 et un seuil local (gradient)		   */
/*                                                                 */
/* entrees  : int pos (position du point de depart)	           */
/*                                                                 */
/* globales : int *R, *I					   */
/*	          swidth, bwidth, seuil				   */
/*								   */
/* return   : ---						   */
/*								   */
/* routines : contour(), marquer()				   */
/*								   */
/* Made by Rene W. LUTZ 19.09.1990				   */
/*******************************************************************/

static void
segmente_local_4(pos, tab_widgets)
int pos ;
xs_struc_reg_growing *tab_widgets;
{
	int i,j,
	    p[50000],r ;

	p[0] = pos ;
	r = 0 ;
        i = 0 ;
	
    while(r>-1)
    {
	if (pos > swidth)
	{
	    j = pos - width ;

	    if( (!R[j]) &&
		(DIFF(I[pos],I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	}

	j = pos - 1  ;

	if( ((j % width) != swidth) &&
	    (!R[j]) &&
	    (DIFF(I[pos],I[j]) < seuil))
	{
	    p[r++] = j ;
	    marquer(j, tab_widgets) ;
	}

	j+= 2 ;
	    
	if( ((j % width) != 0) &&
	     (!R[j]) &&	
	     (DIFF(I[pos],I[j]) < seuil))
	{
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	}
	    
	if(pos < lastline)
	{
	    j = pos + width ;

	    if(	(!R[j]) &&
	        (DIFF(I[pos],I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
	    }
	}
    
        if (i==r)
	{
	    contour(pos, tab_widgets);
	    marquer(pos, tab_widgets) ;
	}
	r-- ;
	i = r ;
	pos = p[r] ;
    } /* while */
}


/*******************************************************************/
/*								   */
/* nom      : segmente_moyenne_8				   */
/*								   */
/* fonction : segmentation par croissance de regions avec une	   */
/*	      connexite 8 et un seuil de tolerance fixe sur	   */
/*	      la moyenne (mise a jour a chaque ajout de point)	   */
/*                                                                 */
/* entrees  : int pos (position du point de depart)	           */
/*                                                                 */
/* globales : int *R, *I					   */
/*	          nombre_tot, nombre, swidth, bwidth, seuil 	   */
/*								   */
/* return   : ---						   */
/*								   */
/* routines : contour(), marquer()				   */
/*								   */
/* Made by Rene W. LUTZ 19.09.1990				   */
/*******************************************************************/


static void
segmente_moyenne_8(pos, tab_widgets)
int pos ;
xs_struc_reg_growing *tab_widgets;
{
	int i,j,
	    nofirst, nolast,
	    p[50000],r ;

	p[0] = pos ;
	r = 0 ;
        i = 0 ;
	
    while(r>-1)
    {	
	if (pos > swidth)
	{
	    j = pos - bwidth ;
	
	    if( (nolast = ((j % width) != swidth)) &&
	        (!R[j]) &&
	        (DIFF(nombre_tot/nombre , I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
		nombre++ ;
		nombre_tot+=I[j] ;
	    }
	    
	    j++ ;
	    if( (!R[j]) &&
		(DIFF( nombre_tot/nombre,I[j]) < seuil))
	    {
		p[r] = j ;
		marquer(j, tab_widgets) ;
	        r++ ;
		nombre++ ;
		nombre_tot+=I[j] ;
	    }
	    j++ ;

	    if( (nofirst = ((j % width) != 0)) &&
	        (!R[j]) &&	
	        (DIFF( nombre_tot/nombre,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
		nombre++ ;
		nombre_tot+=I[j] ;
	    }
	}
	    
	j = pos - 1 ;

	if( (nolast) &&
	    (!R[j]) &&
	    (DIFF( nombre_tot/nombre,I[j]) < seuil))
	{
	   p[r++] = j ;
	   marquer(j, tab_widgets) ;
		nombre++ ;
		nombre_tot+=I[j] ;
	}

	j+=2 ;

	if( (nofirst) &&
	    (!R[j]) &&	
	    (DIFF( nombre_tot/nombre,I[j]) < seuil))
	{
	    p[r++] = j ;
	    marquer(j, tab_widgets) ;
	    nombre++ ;
	    nombre_tot+=I[j] ;
	}

	if(pos < lastline)
	{
	    j = pos + swidth ;

	    if( (nolast) &&
	        (!R[j]) &&
	        (DIFF( nombre_tot/nombre,I[j]) < seuil))
	    {
		p[r] = j ;
		marquer(j, tab_widgets) ;
	        r++ ;
		nombre++ ;
		nombre_tot+=I[j] ;
	    }
	    
	    j++ ;
	    if( (!R[j]) &&
		(DIFF( nombre_tot/nombre,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
		nombre++ ;
		nombre_tot+=I[j] ;
	    }
	    j++ ;

	    if( (nofirst) &&
	        (!R[j]) &&	
	        (DIFF( nombre_tot/nombre,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
		nombre++ ;
		nombre_tot+=I[j] ;
	    }	    	    
	}

        if (i==r)
	{
	    contour(pos, tab_widgets);
	    marquer(pos, tab_widgets) ;
	}
	r-- ;
	i = r ;
	pos = p[r] ;
    } /* while */
}



/*******************************************************************/
/*								   */
/* nom      : segmente_moyenne_4				   */
/*								   */
/* fonction : segmentation par croissance de regions avec une	   */
/*	      connexite 4 et un seuil de tolerance fixe sur	   */
/*	      la moyenne (mise a jour a chaque ajout de point)	   */
/*                                                                 */
/* entrees  : int pos (position du point de depart)	           */
/*                                                                 */
/* globales : int *R, *I					   */
/*	          nombre_tot, nombre, swidth, bwidth, seuil 	   */
/*								   */
/* return   : ---						   */
/*								   */
/* routines : contour(), marquer()				   */
/*								   */
/* Made by Rene W. LUTZ 19.09.1990				   */
/*******************************************************************/

static void
segmente_moyenne_4(pos, tab_widgets)
int pos ;
xs_struc_reg_growing *tab_widgets;
{
	int i,j,
	    p[50000],r ;

	p[0] = pos ;
	r = 0 ;
        i = 0 ;
	
    while(r>-1)
    {
	if (pos > swidth)
	{
	    j = pos - width ;

	    if( (!R[j]) &&
	        (DIFF( nombre_tot/nombre,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
		nombre++ ;
		nombre_tot+=I[j] ;
	    }
	}

	j = pos - 1  ;

	if( ((j % width) != swidth) &&
	    (!R[j]) &&
	    (DIFF( nombre_tot/nombre,I[j]) < seuil))
	{
	    p[r++] = j ;
	    marquer(j, tab_widgets) ;
	    nombre++ ;
	    nombre_tot+=I[j] ;
	}

	j+= 2 ;
	    
	if( ((j % width) != 0) &&
	     (!R[j]) &&	
	     (DIFF( nombre_tot/nombre,I[j]) < seuil))
	{
		p[r++] = j ;
		marquer(j, tab_widgets) ;
		nombre++ ;
		nombre_tot+=I[j] ;
	}
	    
	if(pos < lastline)
	{
	    j = pos + width ;

	    if(	(!R[j]) &&
	        (DIFF( nombre_tot/nombre,I[j]) < seuil))
	    {
		p[r++] = j ;
		marquer(j, tab_widgets) ;
		nombre++ ;
		nombre_tot+=I[j] ;
	    }
	}
    
        if (i==r)
	{
	    contour(pos, tab_widgets);
	    marquer(pos, tab_widgets) ;
	}
	r-- ;
	i = r ;
	pos = p[r] ;
    } /* while */
}


/*******************************************************************/
/*								   */
/* nom      : segmente_min_max_8				   */
/*								   */
/* fonction : segmentation par croissance de regions avec une	   */
/*	      connexite 8 et un seuil de tolerance fixe sur	   */
/*	      la difference maximum entre le min et le max de	   */
/*            la region                                            */
/*                                                                 */
/* entrees  : int pos (position du point de depart)	           */
/*                                                                 */
/* globales : int *R, *I					   */
/*	          mmin, mmax, swidth, bwidth, seuil 		   */
/*								   */
/* return   : ---						   */
/*								   */
/* routines : contour(), marquer()				   */
/*								   */
/* Made by Rene W. LUTZ 19.09.1990				   */
/*******************************************************************/

static void
segmente_min_max_8(pos, tab_widgets)
int pos ;
xs_struc_reg_growing *tab_widgets;
{
	int i,j,
	    nofirst, nolast,
	    p[50000],k, nb ;

    p[0] = pos ;
    k = 0 ;
    i = 0 ;
	
    while(k>-1)
    {	
	if (pos > swidth)
	{
	    j = pos - bwidth ;
	
	    if( (nolast = ((j % width) != swidth)) &&
	        (!R[j]) &&
	        ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <= seuil)))
	    {
		p[k++] = j ;
		marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	    }
	    
	    j++ ;
	    if( (!R[j]) &&
	        ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <= seuil)))
	    {
		p[k++] = j ;
		marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	    }
	    j++ ;

	    if( (nofirst = ((j % width) != 0)) &&
	        (!R[j]) &&	
	        ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <= seuil)))
	    {
		p[k++] = j ;
		marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	    }
	}
	    
	j = pos - 1 ;

	if( (nolast) &&
	    (!R[j]) &&
	    ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <= seuil)))
	{
	   p[k++] = j ;
	   marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	}

	j+=2 ;

	if( (nofirst) &&
	    (!R[j]) &&	
	    ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <= seuil)))
	{
	    p[k++] = j ;
	    marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	}

	if(pos < lastline)
	{
	    j = pos + swidth ;

	    if( (nolast) &&
	        (!R[j]) &&
	        ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <= seuil)))
	    {
		p[k++] = j ;
		marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	    }
	    
	    j++ ;
	    if( (!R[j]) &&
	        ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <= seuil)))
	    {
		p[k++] = j ;
		marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	    }
	    j++ ;

	    if( (nofirst) &&
	        (!R[j]) &&	
	        ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <= seuil)))
	    {
		p[k++] = j ;
		marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	    }	    	    
	}

        if (i==k)
	{
	    contour(pos, tab_widgets);
	    marquer(pos, tab_widgets) ;
	}
	k-- ;
	i = k ;
	pos = p[k] ;
    }
}


/*******************************************************************/
/*								   */
/* nom      : segmente_min_max_4				   */
/*								   */
/* fonction : segmentation par croissance de regions avec une	   */
/*	      connexite 4 et un seuil de tolerance fixe sur	   */
/*	      la difference maximum entre le min et le max de	   */
/*            la region                                            */
/*                                                                 */
/* entrees  : int pos (position du point de depart)	           */
/*                                                                 */
/* globales : int *R, *I					   */
/*	          mmin, mmax, swidth, bwidth, seuil 		   */
/*								   */
/* return   : ---						   */
/*								   */
/* routines : contour(), marquer()				   */
/*								   */
/* Made by Rene W. LUTZ 19.09.1990				   */
/*******************************************************************/

static void
segmente_min_max_4(pos, tab_widgets)
int pos ;
xs_struc_reg_growing *tab_widgets;
{
	int i,j,
	    p[50000],k ;

	p[0] = pos ;
	k = 0 ;
        i = 0 ;
	
    while(k>-1)
    {
	if (pos > swidth)
	{
	    j = pos - width ;

	    if( (!R[j]) &&
	        ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <=
		seuil)))
	    {
		p[k++] = j ;
		marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	    }
	}

	j = pos - 1  ;

	if( ((j % width) != swidth) &&
	    (!R[j]) &&
	    ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <= seuil)))
	{
		p[k++] = j ;
		marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	}

	j+= 2 ;
	    
	if( ((j % width) != 0) &&
	     (!R[j]) &&	
	     ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <= seuil)))
	{
		p[k++] = j ;
		marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	}
	    
	if(pos < lastline)
	{
	    j = pos + width ;

	    if(	(!R[j]) &&
	        ( (DIFF(mmin , I[j]) <= seuil) && (DIFF(mmax, I[j]) <= seuil)))
	    {
		p[k++] = j ;
		marquer(j, tab_widgets) ;

		if (I[j] < mmin)
			mmin = I[j] ;
		else if (I[j] > mmax)
			mmax = I[j] ;
	    }
	}
    
        if (i==k)
	{
	    contour(pos, tab_widgets);
	    marquer(pos, tab_widgets);
	}
	k-- ;
	i = k ;
	pos = p[k] ;
    } /* while */
}



/*******************************************************************/
/*								   */
/* nom      : display_proc				           */
/*								   */
/* fonction : affiche les plans image selon le mode d'affichage    */
/*                                                                 */
/*******************************************************************/
 
static void
display_proc(tab_widgets)
xs_struc_reg_growing *tab_widgets;
{
  switch(display_selected)
  {
	case RC :
		show_image(tab_widgets, 0, R) ;
		show_image(tab_widgets, 1, C) ;
		break ;

	case RI :
		show_image(tab_widgets, 0, R) ;
		show_image(tab_widgets, 1, I) ;
		break ;

	case IC :
		show_image(tab_widgets, 0, I) ;
		show_image(tab_widgets, 1, C) ;
		break ;

	default : 
		clear_screen(tab_widgets, 0) ;
		clear_screen(tab_widgets, 1) ;
		break ; 
   }			
}



/*******************************************************************/
/*								   */
/* nom      : start_segmentation			           */
/*								   */
/* fonction : appelle les routines de segmentation	           */
/*                                                                 */
/* globales : int Reg_color, taille_image, init_val, mmin, mmax	   */
/*		  color, trace_selected 		       	   */
/* routines : display_proc()          				   */
/*	      segmente_global_4/8(), segmente_local_4/8()	   */
/*	      segmente_moyenne_4/8(), segmente_min_max_4/8()	   */
/*								   */
/*******************************************************************/

static void
start_segmentation(tab_widgets)
xs_struc_reg_growing *tab_widgets;
{
	int i = 0 ,
	    mode, connex8,
	    old ;

	mode = segmentation_selected;
	connex8 = connexity_selected;
	Reg_color = 0 ;

        if (mode == GLOBAL)
	{
	     while(i<taille_image)
	     {
	        old = TRUE ;
		while((i < taille_image) && (old))
		    old = R[i++] ;
 
	        init_val = I[i - 1] ;
		Reg_color += 1 ;
		color = 100 + (rand() % 156) ;
		if (connex8)
			segmente_global_8(i - 1, tab_widgets) ;
		else
			segmente_global_4(i - 1, tab_widgets) ;
	    }
	}
	else if(mode == LOCAL)
	{
	     while(i<taille_image)
	     {
	        old = TRUE ;
		while((i < taille_image) && (old))
		    old = R[i++] ;

		Reg_color += 1 ;
		color = 100 + rand() % 156 ;
		if (connex8)    
			segmente_local_8(i - 1, tab_widgets) ;
		else
			segmente_local_4(i - 1, tab_widgets) ;

	     }		
	}
	else if (mode == MOYENNE)
	{
	
	     while(i<taille_image)
	     {
	        old = TRUE ;
		while((i < taille_image) && (old))	
		    old = R[i++] ;
		Reg_color += 1 ;
		color = 100 + rand() % 156 ;    
		nombre_tot = I[i-1] ;
		nombre = 1 ;
		if (connex8)
			segmente_moyenne_8(i-1, tab_widgets) ;
		else
			segmente_moyenne_4(i-1, tab_widgets) ;
	     }
	}
	else
        {
	     while(i<taille_image)
	     {
	        old = TRUE ;
		while((i < taille_image) && (old))	
		    old = R[i++] ;
		mmin = mmax = I[i-1] ;

		color = 100 + rand() % 156 ;    
		if (connex8)				
			segmente_min_max_8(i-1, tab_widgets) ;		
		else	
			segmente_min_max_4(i-1, tab_widgets) ;
	     }
	}

	if (!trace_selected)
		display_proc(tab_widgets);
}




/*******************************************************************/

/******************************************************
/   activateCallback for Widget Segmentation
/*****************************************************/
/* fonction : determine si le lissage du masque doit etre fait */
/*****************************************************/

void
Choose_Segmentation(typewidget, tab_widgets, callData)
	Widget typewidget;
        xs_struc_reg_growing *tab_widgets;
	caddr_t callData;
{
  int k;
  for (k=0;k < 4 ; k++)
    if (typewidget == tab_widgets->tabsegmentation[k]) 
        segmentation_selected = k;
}



/******************************************************
/   activateCallback for Widget Connexity
/*****************************************************/

void
Choose_Connexity(typewidget, tab_widgets, callData)
	Widget typewidget;
        xs_struc_reg_growing *tab_widgets;
	caddr_t callData;
{
  int k;
  for (k=0;k < 2 ; k++)
    if (typewidget == tab_widgets->tabconnexity[k]) 
         connexity_selected = k;
  /* switch (typewidget)
     {
       case tab_widgets->tabconnexity[0]: connexity_selected = CON4; break;
       case tab_widgets->tabconnexity[1]: connexity_selected = CON8; break;
       }
  */
}


/******************************************************
/   activateCallback for Widget Trace
/*****************************************************/
/* fonction : determine si le masque est affiche     */
/* return   : TRUE si "OFF", "FALSE" si "ON"	     */
/*****************************************************/

void
Choose_Trace(typewidget, tab_widgets, callData)
	Widget typewidget;
        xs_struc_reg_growing *tab_widgets;
	caddr_t callData;
{
  int k;
  for (k=0;k < 2 ; k++)
    if (typewidget == tab_widgets->tabtrace[k]) 
         trace_selected = k;
}



/******************************************************
/   activateCallback for Widget Display
/*****************************************************/

void
Choose_Display(typewidget, tab_widgets, callData)
	Widget typewidget;
        xs_struc_reg_growing *tab_widgets;
	caddr_t callData;
{
  int k; 

  for (k=0;k < 3 ; k++)
  if (typewidget == tab_widgets->tabdisplay[k]) 
         display_selected = k;
  
  display_proc(tab_widgets);
}

/******************************************************
/   activateCallback for Widget  LOAD
/*****************************************************/

void
reg_growing_LOAD_callb(LOAD, tab_widgets, callData)
	Widget LOAD;
        xs_struc_reg_growing *tab_widgets;
	caddr_t callData;
{ 
     Widget growing_LOAD_widget;
  
     widgets_growing = tab_widgets;
     
     growing_LOAD_widget = 
	build_PRE_PRO_options_widget(LOAD, 400, mastertabs[264]);

     XtManageChild(growing_LOAD_widget);
}




/******************************************************
/   activateCallback for Widget  CONTOUR 
/*****************************************************/
/*******************************************************************/
/*								   */
/* fonction : sauve le plan des contours dans un plan image        */
/*                                                                 */
/*******************************************************************/

void
reg_growing_CONTOUR_callb(OK, tab_widgets, callData)
	Widget OK;
        xs_struc_reg_growing *tab_widgets;
	caddr_t callData;
{
     Widget growing_SAVE_widget;
  
     growing_SAVE_widget = 
	build_PRE_PRO_options_widget(OK, 401, mastertabs[264]);

     XtManageChild(growing_SAVE_widget);
}


/******************************************************
/   activateCallback for Widget  REGION
/*****************************************************/

void
reg_growing_REGION_callb(OK, tab_widgets, callData)
	Widget OK;
        xs_struc_reg_growing *tab_widgets;
	caddr_t callData;
{
     Widget growing_SAVE_widget;
  
     growing_SAVE_widget = 
	build_PRE_PRO_options_widget(OK, 402, mastertabs[264]);

     XtManageChild(growing_SAVE_widget);
}


/******************************************************
/   activateCallback for Widget  desctool_CANCEL
/*****************************************************/

void
reg_growing_QUIT_callb(QUIT, reg_growing_mainwidget, callData)
	Widget QUIT;
        Widget reg_growing_mainwidget;
	caddr_t callData;
{
  if (pixmap_drawing[0]) {
    XFreePixmap(gDisplay, pixmap_drawing[0]);
    pixmap_drawing[0] = NULL;
  }
  if (pixmap_drawing[1]) {
    XFreePixmap(gDisplay, pixmap_drawing[1]);
    pixmap_drawing[1] = NULL;
  }

  XtUnmanageChild (reg_growing_mainwidget);
}


/******************************************************
/   activateCallback for Widget  APPLY
/*****************************************************/

void
reg_growing_APPLY_callb(APPLY, tab_widgets, callData)
	Widget APPLY;
        xs_struc_reg_growing *tab_widgets;
	caddr_t callData;
{
  Colormap my_colormap;

  my_colormap = init_color_lin();  /* pour medinfo cf .layout.c*/

  XInstallColormap(gDisplay, my_colormap);
  XDefineCursor(gDisplay, XtWindow(gLabowidget), gWatchcursor);
  XDefineCursor(gDisplay, 
      XtWindow(XtParent(XtParent(XtParent(tab_widgets->drawing_widget[0])))), 
      gWatchcursor);

  fix_parameters(tab_widgets);
  start_segmentation(tab_widgets);

  XUndefineCursor(gDisplay, XtWindow(gLabowidget));
  XUndefineCursor(gDisplay, 
		  XtWindow(XtParent(XtParent(XtParent(tab_widgets->drawing_widget[0])))));
  XUninstallColormap(gDisplay, my_colormap);
}


/*******************************************************************/
