/* SCCS @(#)image_generation.callback.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                   image_generation.callback.c                        */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   image_generation.callback.c                         */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Image Generation Tool)                   */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include "libwidgets/widgetstructure.h"
#include "image_generation.layout.h"
#include "IOplans.layout.h"
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h> 
#include <X11/cursorfont.h>
#include <Xm/Text.h>

#include <stdio.h>
#include <strings.h>
#include <math.h>

extern Display          *gDisplay;
extern Visual           *gVisual;
extern int    		screen_number;
extern Window           root_window;
extern GC               default_gc, gc_xor;
extern Cursor  	        gWatchcursor;
extern Widget 		gLabowidget;
extern Colormap 	gDefaultcolormap;

extern void free_liste_pts();  /* win4.c*/

#define MONO 1
#define COULEUR 255

static void     recherche ();
static void     reaffichage();
static void	remplit_seg(), segment_contour(), dessine_contour();
static void	extract_seg(), segment_plein();
/*static void	efface(), efface_tout(), efface_segment()*/
static void     efface_seg();
static void	expose_segment(), expose_seg();
static void	ferme_et_insere_segment();

void sauve_im_ds_plan();


/* used for saving operation */
static Pixmap pixmap_temp = NULL;

/* Structure d'un segment : le nombre de points qui le compose, un pointeur */
/* sur la liste de ces points, un flag pour dire s'il est rempli ou non     */
/* ainsi que sa couleur	*/

typedef struct el_seg	*ptr_seg;	 /* Type de la liste des segments */

struct	    el_seg  {		   /* Un element de la liste des segments */	
		     int	    nbr_pts;
		     int	    flag_plein; /* 1 si le segment est plein, 0 sinon	*/
		     short	    couleur;	/* Si masque (overlay) = 1 (monochrome)	*/
		     ptr_point	    pts;
		     ptr_seg	    suivant;
		    };


/* Structure d'une image : le nombre de segments qui la compose et un      */
/* pointeur sur la liste de ces segments                                   */

struct	    el_image {
			int	    nbr_seg;    
			ptr_seg	    seg;
		     };

/* Tableau donnant pour chaque image le nombre de segments quelle contient  */
/* ainsi que le pointeur vers la liste des segments			    */

struct el_image	liste_image[MAX_IMAGE];	


ptr_point   pt_debut, pt_courant;	/* Pointeur sur le debut de la liste */
					/* et sur le point courant	     */
ptr_seg	    seg_debut, seg_courant;
short	    xdim = 0, ydim = 0;		/* Dimensions de l'image a creer     */

int	    nbr_pts = 0;
int	    nbr_seg = 0;
short	    controle_x, controle_y;	/* Point selectionnant le segment a  */
                                        /* effacer	                     */
short	    pos_x, pos_y;		/* Point donne par le clavier ou     */
                                        /* dernier point clique par la souris*/
short	    couleur_fond = 0;		/* Fond noir par defaut		     */
short	    couleur_courante = 255;	/* Ecrit en blanc par defaut	     */

int	    type;			/* Type de l'image en cours:         */
                                        /* mono ou couleur	             */
int	    fonction = 0;		/* Genre de la fonction executee au  */
                                        /* moment du test:                   */
					/*  efface, change_couleur, expose.  */
int	    contrainte = 0;		/* Si 1 on force les droites a etre  */
                                        /* horizontales ou verticales	     */
int 	    entree_flag=0;
int	    flag_chablon;

int 	    type_segment = 1;           /* 1 = Fill; 0 = Borders             */
int 	    type_clear = 0;		/* 0 = All;  1 = Segment             */

static      begintrack = FALSE;

/******************************************************
/   activateCallback for Widget HELP
/*****************************************************/

void
image_gen_HELP_callb(image_gen_HELP, image_gen_mainwidget, callData)
	Widget image_gen_HELP;
	Widget image_gen_mainwidget;
	caddr_t callData;
{
}



/******************************************************
/   activateCallback for Widget QUIT
/*****************************************************/

void
image_gen_QUIT_callb(image_gen_QUIT, tab_widgets, callData)
	Widget image_gen_QUIT;
	xs_struc_ima_gener *tab_widgets;
	caddr_t callData;
{
  if (tab_widgets->pixmap_drawing) 
  {
    XFreePixmap(gDisplay, tab_widgets->pixmap_drawing);
    tab_widgets->pixmap_drawing = NULL;
  } 

  XtUnmanageChild(tab_widgets->Drawing_area);
  XtUnmanageChild(tab_widgets->Draw_dialog);
  XtUnmanageChild(XtParent (XtParent (image_gen_QUIT)));
}


/******************************************************
/   activateCallback for Widget CREATE
/*****************************************************/


/*****************************************************************************/
/*  nom	    :	init_liste_pts          				     */
/*									     */
/*  fonction:	initialise les pointeurs de la liste des points ainsi que le */
/*              nombre de points courants.				     */
/*									     */
/*  entrees :	aucune                                                       */
/*									     */
/*  globales:   ptr_point   pt_debut                                         */
/*              ptr_point   pt_courant                                       */
/*	        int	    nbr_pts                                          */
/*                                                                           */
/*  return  :	aucun							     */
/*									     */
/*  routines:	aucune		 					     */
/*									     */
/*****************************************************************************/

static void init_liste_pts()
{
    pt_debut = NULL;
    pt_courant = NULL;
    nbr_pts = 0;

    return;
}

/*****************************************************************************/
/*  nom	    :	init_liste_seg           				     */
/*									     */
/*  fonction:	initialise le pointeur de debut de la liste des segments,    *
/*              le pointeur du segment courant ainsi que le nombre de        */
/*	        segments.			                             */
/*		De plus, la place memoire des segments est liberee ainsi     */
/*              que celle de leur liste de points.			     */
/*									     */
/*  entrees :	aucune                                                       */
/*									     */
/*  globales:   ptr_seg	seg_debut                                            */
/*              ptr_seg seg_courant                                          */
/*              int	nbr_seg                                              */
/*                                                                           */
/*  return  :	aucun							     */
/*									     */
/*  routines:	free_liste_pts		  				     */
/*									     */
/*****************************************************************************/


static void  init_liste_seg()
{
    ptr_seg	    p;

    while (seg_debut != NULL) 
    {
				    	/* On extrait */
	p = seg_debut;		
	seg_debut = seg_debut -> suivant;		    
	
					/* On libere */
	free_liste_pts(&(p -> pts));
	p -> suivant = NULL;
	cfree(p);
    }
    seg_courant = NULL;
    nbr_seg = 0;

    return;
}



/****************************************************************************/
/*  nom	    :	gen_pts_controle_mono					    */
/*									    */
/*  fonction:	initialisation pour la generation d'une image monochrome.   */
/*	       								    */
/*									    */
/*  entrees :	aucune							    */
/*									    */
/*  globales:	int	type						    */
/*		int	flag_chalon					    */
/*		int	contrainte					    */
/*									    */
/*  return  :	aucun							    */
/*									    */
/*  routines:	init_liste_pts						    */
/*		init_liste_seg						    */
/*									    */
/****************************************************************************/

void gen_pts_controle_mono()
{
    entree_flag = 1;
    flag_chablon = 0;
    type = MONO;
    contrainte = 0;
    init_liste_pts();
    init_liste_seg();
}



/****************************************************************************/
/*  nom	    :	gen_pts_controle_couleur				    */
/*									    */
/*  fonction:	initialisation pour la generation d'une image 	            */
/*		a niveau de gris.					    */
/*									    */
/*  entrees :	aucune							    */
/*									    */
/*  globales:	int	type						    */
/*		int	flag_chablon					    */
/*		int	contrainte					    */
/*		unsigned char nivgrislin[3][256]			    */
/*									    */
/*  return  :	aucun							    */
/*									    */
/*  routines:	init_liste_pts						    */
/*		init_liste_seg						    */
/*		init_color_lin						    */
/*									    */
/****************************************************************************/

void gen_pts_controle_couleur()
{
    entree_flag = 2;
    flag_chablon = 0;
    type = COULEUR;
    contrainte = 0;
    init_liste_pts();
    init_liste_seg();
}

/*

*/


void
saisie_pts(Drawing_Area, tab_widgets, event)
	Widget Drawing_Area;
        xs_struc_ima_gener *tab_widgets;
        XEvent    *event;
{
  short   c;
  int X, Y;
  Arg args[MAX_ARGS];
  int n;

  switch (event->type){
    case ButtonPress:
    {
      switch (event->xbutton.button){
        case Button1:
        case Button3:
	  X = event->xmotion.x;
	  Y = event->xmotion.y;
	  if (pt_debut == NULL)
	  {
	    pt_debut = (ptr_point) calloc (1,sizeof (struct coords));
	    pt_courant = pt_debut ;

	    pt_courant -> next = NULL;
	    pt_courant -> x = X;
	    pt_courant -> y = Y;
	  }
	  else
	  switch (contrainte) 
	  {
	    case 0 : 
	      pt_courant -> next = 
	                (ptr_point) calloc (1,sizeof (struct coords));
	      pt_courant = pt_courant -> next;

	      pt_courant -> next = NULL;
	      pt_courant -> x = X;
	      pt_courant -> y = Y;
	      break;

	    case 1 : 
	      if (abs((pt_courant -> x) - X) < abs((pt_courant -> y) - Y))
	      {
		X = pt_courant -> x;
		Y = Y;
	      }
	      else
	      {
		X = X;
		Y = pt_courant -> y;
	      }
	      pt_courant -> next = 
	           (ptr_point) calloc (1,sizeof (struct coords));
	      pt_courant = pt_courant -> next;
	      pt_courant -> next = NULL;
	
	      pt_courant -> x = X;
	      pt_courant -> y = Y;
	      break;
	  }
	  if (type == MONO)	c=1;
	  else  if (couleur_fond >127) c=0;
		else c=255;

          XSetForeground(gDisplay, 
			 gc_xor, c);  /* 128 */
	  XDrawLine (gDisplay, tab_widgets->pixmap_drawing, 
		     gc_xor, pt_courant -> x,pt_courant -> y,
		     pt_courant -> x,pt_courant -> y+1);
	  XDrawLine (gDisplay, tab_widgets->pixmap_drawing, 
		     gc_xor, pt_courant -> x+1,pt_courant -> y,
		     pt_courant -> x+1,pt_courant -> y+1);
	  XDrawLine (gDisplay, XtWindow(Drawing_Area), 
		     gc_xor, pt_courant -> x,pt_courant -> y,
		     pt_courant -> x,pt_courant -> y+1);
	  XDrawLine (gDisplay, XtWindow(Drawing_Area), 
		     gc_xor, pt_courant -> x+1,pt_courant -> y,
		     pt_courant -> x+1,pt_courant -> y+1);
	  nbr_pts++;
	  break;

	case Button2:
	  if (pt_debut)  /* FERME POLYGONE */
	  {
	    if (type_segment == 0) 
	         segment_contour(tab_widgets->pixmap_drawing);
  
	    else segment_plein(tab_widgets->pixmap_drawing);

	    XCopyArea (gDisplay, tab_widgets->pixmap_drawing, 
		       XtWindow(tab_widgets->Drawing_area), 
		       default_gc, 0, 0, xdim, ydim, 0, 0);
	    begintrack = FALSE;
	  }
	  
	  else                   /* EXPOSE */
	  {
	    controle_x = event->xmotion.x;
	    controle_y = event->xmotion.y;
	    expose_seg(tab_widgets->pixmap_drawing);
	  	
	    XCopyArea (gDisplay, tab_widgets->pixmap_drawing, 
		       XtWindow(tab_widgets->Drawing_area), 
		       default_gc, 0, 0, xdim, ydim, 0, 0);
	  }
	  break;
	}
    }/* case ButtonPress */
    
  }/* switch */
}



void
image_gen_CREATE_callb(image_gen_CREATE, tab_widgets, callData)
	Widget image_gen_CREATE;
	xs_struc_ima_gener *tab_widgets;
	caddr_t callData;
{
        Cursor pencil;
        Widget reg_growing_mainwidget, ScrolledWindow_1, drawing_1;
        XImage *ximage;
        unsigned char *data;
 	Arg args[MAX_ARGS];
	int i, n;
 
        xdim = atoi(XmTextGetString(tab_widgets->Width_text));
        if (xdim <= 0)
	{
	  XmTextSetString(tab_widgets->Width_text, "");
	  return;
	}
	
        ydim = atoi(XmTextGetString(tab_widgets->Height_text));
        if (ydim <= 0)
	{
	  XmTextSetString(tab_widgets->Height_text, "");
	  return;
	}

	if (tab_widgets->pixmap_drawing) {
	   XFreePixmap(gDisplay, tab_widgets->pixmap_drawing);
	   tab_widgets->pixmap_drawing = NULL;
	}
	data = (unsigned char *)malloc(xdim*ydim); 

        ximage = XCreateImage(gDisplay, gVisual,
			      8, ZPixmap, 0, (char *)data,
			      xdim, ydim, 8, 0);

	for (i = 0; i<xdim * ydim; i++) 
	{
	  *data = 255;
	  data++;
	}

	tab_widgets->pixmap_drawing = XCreatePixmap(gDisplay,
						    root_window,
						    xdim, ydim, 8);
	n = 0;
	XtUnmanageChild(tab_widgets->Drawing_area);
	XtUnmanageChild(tab_widgets->Draw_dialog);
        XtSetArg(args[n],XmNwidth, (Dimension)xdim); n++;
        XtSetArg(args[n],XmNheight, (Dimension)ydim); n++;
	XtSetValues(tab_widgets->Draw_dialog, args, n);
	if (type == MONO)
          if  (couleur_fond == 0)
               XtSetArg(args[n],XmNbackground, BlackPixel(gDisplay, screen_number));
          else XtSetArg(args[n],XmNbackground, WhitePixel(gDisplay, screen_number));
	else XtSetArg(args[n],XmNbackground, couleur_fond); 
	n++;

        XtSetArg(args[n],XmNforeground, couleur_courante); n++;
	XtSetArg(args[n],XmNbackgroundPixmap, tab_widgets->pixmap_drawing); n++;
	XtSetValues(tab_widgets->Drawing_area, args, n);

	XtManageChild(tab_widgets->Drawing_area);
	XtManageChild(tab_widgets->Draw_dialog);

	init_liste_pts();
	init_liste_seg();

	XPutImage(gDisplay, tab_widgets->pixmap_drawing, 
		  default_gc, ximage, 0, 0, 0, 0, xdim, ydim);

	XCopyArea (gDisplay, tab_widgets->pixmap_drawing, 
		   XtWindow(tab_widgets->Drawing_area), 
		   default_gc, 0, 0, xdim, ydim, 0, 0);

	pencil = XCreateFontCursor(gDisplay, XC_pencil);

	XDefineCursor(gDisplay, XtWindow(tab_widgets->Drawing_area), pencil);

	XtAddEventHandler(tab_widgets->Drawing_area, ButtonPressMask, FALSE,
			  saisie_pts, tab_widgets);

	XDestroyImage(ximage);
	free(data);
}


void
change_color_back(scale, tab_widgets, callData)
	Widget scale;
        xs_struc_ima_gener *tab_widgets;
	XmScaleCallbackStruct * callData;
{
  int value;

  value = callData->value;
  sprintf(buf,"%d", value) ;
  XmTextSetString (tab_widgets->Back_color, buf);
  couleur_fond = value;

  if (tab_widgets->pixmap_drawing)
  {
    reaffichage(tab_widgets->pixmap_drawing);

    XCopyArea (gDisplay, tab_widgets->pixmap_drawing, 
	       XtWindow(tab_widgets->Drawing_area), 
	       default_gc, 0, 0, xdim, ydim, 0, 0);

    strcpy(buf, mastertabs[381]);
    write_master(buf);
  }
}


void
uninstall_colormap(scale, graytone_colormap, callData)
	Widget scale;
        Colormap graytone_colormap;
	XmScaleCallbackStruct * callData;
{
  XUninstallColormap(gDisplay, graytone_colormap);
  XInstallColormap(gDisplay, gDefaultcolormap);
}


void
install_colormap(scale, graytone_colormap, callData)
	Widget scale;
        Colormap graytone_colormap;
	XmScaleCallbackStruct * callData;
{
  XInstallColormap(gDisplay, graytone_colormap);
}


void
change_color_seg(scale, tab_widgets, callData)
	Widget scale;
        xs_struc_ima_gener *tab_widgets;
	XmScaleCallbackStruct * callData;
{
int value;

  value = callData->value;
  sprintf(buf,"%d", value) ;
  XmTextSetString (tab_widgets->Seg_color, buf);
  couleur_courante = value;

  if (seg_courant != NULL)
  {	
    seg_courant -> couleur = couleur_courante;

    if (type_segment == 0) 
      dessine_contour (tab_widgets->pixmap_drawing, seg_courant);
  
    else remplit_seg (tab_widgets->pixmap_drawing, seg_courant);

    XCopyArea (gDisplay, tab_widgets->pixmap_drawing, 
	       XtWindow(tab_widgets->Drawing_area), 
	       default_gc, 0, 0, xdim, ydim, 0, 0);
  }

}




/******************************************************
/   activateCallback for Widget SEGMENT
/*****************************************************/

void set_type_segment(Segment_RadioButton, value, callData)
	Widget Segment_RadioButton;
        int value;
	caddr_t callData;
{
  type_segment = value;     /* 1 = Fill; 0 = Borders */
}


void
create_segment(SegmentPB, tab_widgets, callData)
	Widget SegmentPB;
	xs_struc_ima_gener *tab_widgets;
	caddr_t callData;
{
    if (!tab_widgets->pixmap_drawing) return;
  
    if (pt_debut == NULL)
    {
      if (seg_courant != NULL)
      {	
	seg_courant -> flag_plein = type_segment;
	
	reaffichage(tab_widgets->pixmap_drawing);

	XCopyArea (gDisplay, tab_widgets->pixmap_drawing, 
		   XtWindow(tab_widgets->Drawing_area), 
		   default_gc, 0, 0, xdim, ydim, 0, 0);
      }    
    }

    else 
    {
      if (type_segment == 0) segment_contour(tab_widgets->pixmap_drawing);
  
      else segment_plein(tab_widgets->pixmap_drawing);

      XCopyArea (gDisplay, tab_widgets->pixmap_drawing, 
		 XtWindow(tab_widgets->Drawing_area), 
		 default_gc, 0, 0, xdim, ydim, 0, 0);
    }  
}




/******************************************************
/   activateCallback for Widget CLEAR
/*****************************************************/



/****************************************************************************/
/*  nom	    :	ferme_et_insere_segment       				    */
/*									    */
/*  fonction:	Rajoute le point necessaire pour fermer le polygone et      */
/*	        insere ce segment dans la liste des segments                */
/*									    */
/*  entrees :	aucune                                                      */
/*									    */
/*  globales:   int	nbr_seg                                             */
/*              int	nbr_pts                                             */
/*              int	contrainte                                          */
/*              ptr_point   pt_debut                                        */
/*              ptr_point   pt_courant                                      */
/*              ptr_seg	    seg_debut	                                    */
/*              ptr_seg	    seg_courant	                                    */
/*              short	    couleur_courante                                */
/*                                                                          */
/*  return  :	aucun							    */
/*									    */
/*  routines:	write_master  						    */
/*                                                                          */
/****************************************************************************/

static void ferme_et_insere_segment()
{
    int	    x, y;

    if (pt_debut != NULL)
    {
    /* On ferme le polygone */
	switch (contrainte)
	{
	    case 0 :pt_courant -> next = (ptr_point) calloc (1,sizeof (struct coords));
		    pt_courant =  pt_courant -> next;
		    pt_courant -> next = NULL;
		    pt_courant -> x = pt_debut -> x;
		    pt_courant -> y = pt_debut -> y;
		    nbr_pts++;
		    break;

    /* Si on a la contrainte hv il faut rajouter un point (en plus de celui pour fermer	*/ 
    /* la figure) afin que le dernier segment soit bien vertical ou horizontal	        */

	    case 1 :if ((pt_courant -> x) - (pt_debut -> x) < 0)
		    {
			pt_courant -> next = (ptr_point) calloc (1,sizeof (struct coords));
			x = pt_courant -> x;
			y = pt_debut -> y;
			pt_courant =  pt_courant -> next;
			pt_courant -> next = NULL;
			pt_courant -> x = x;
			pt_courant -> y = y;
			nbr_pts++;
		    }
		    else
		      if ((pt_courant -> x) - (pt_debut -> x) > 0)
		      {
			pt_courant -> next = (ptr_point) calloc (1,sizeof (struct coords));
			x = pt_debut -> x;
			y = pt_courant -> y;
			pt_courant =  pt_courant -> next;
			pt_courant -> next = NULL;
			pt_courant -> x = x;
			pt_courant -> y = y;
			nbr_pts++;
		      }	
		    pt_courant -> next = (ptr_point) calloc (1,sizeof (struct coords));
		    pt_courant =  pt_courant -> next;
		    pt_courant -> next = NULL;
		    pt_courant -> x = pt_debut -> x;
		    pt_courant -> y = pt_debut -> y;
		    nbr_pts++;
		    break;
	}

	/* On ajoute ce segment (liste de points) a la liste des segments */
	if (seg_debut == NULL)
	{
	    seg_debut = (ptr_seg) calloc (1, sizeof (struct el_seg));
	    seg_courant = seg_debut;
	}
	else
	{
	    seg_courant -> suivant = (ptr_seg) calloc (1, sizeof (struct el_seg));
	    seg_courant = seg_courant -> suivant;
	}
	seg_courant -> nbr_pts = nbr_pts;
	seg_courant -> pts = pt_debut;	    /* on pointe le debut de la chaine de points*/
	seg_courant -> couleur = couleur_courante;
	seg_courant -> suivant = NULL;
	nbr_seg++;
    }
}


/****************************************************************************/
/*  nom	    :	segment_plein       					    */
/*									    */
/*  fonction:	relie successivement les points stockes dans la liste des   */
/*	        points par des segments de droite et rempli le polygone     */
/*              ainsi forme                                                 */
/*									    */
/*  entrees :	aucune                                                      */
/*									    */
/*  globales:   ptr_seg	    seg_courant	                                    */
/*                                                                          */
/*  return  :	aucun							    */
/*									    */
/*  routines:	write_master 						    */
/*              init_liste_pts                                              */
/*		ferme_et_insere_segment					    */
/*		remplit_seg						    */
/*									    */
/****************************************************************************/

static void segment_plein(drawing)
    Pixmap drawing;
{
    char    *num;
    if (pt_debut != NULL)
    {
        ferme_et_insere_segment();
	remplit_seg (drawing, seg_courant);
	seg_courant -> flag_plein = 1;
	init_liste_pts();
    }
    num = (char *) calloc (10, sizeof(char));
    sprintf(num," %d ",nbr_seg);
    strcpy(buf, mastertabs[377]); 
    strcat(buf, num);
    cfree(num);
    strcat(buf, mastertabs[378]);
    write_master(buf);
}


/****************************************************************************/
/*  nom	    :	recherche	          				    */
/*									    */
/*  fonction:	cherche le segment auquel appartient le point x,y           */
/*									    */
/*  entrees :	short	xx,yy	                                            */
/*		ptr_seg	*stemp						    */
/*									    */
/*  globales:   ptr_seg	seg_debut                                           */
/*                                                                          */
/*  return  :	aucun					    		    */
/*									    */
/*  routines:	aucune		 					    */
/*									    */
/****************************************************************************/

static void recherche (old_seg_det, seg_det)
    ptr_seg	*seg_det;
    ptr_seg	*old_seg_det;
{
    ptr_point	ptemp;
    ptr_seg	seg_temp, old_seg_temp;
    float	norme, n;
    int		px, py;

    px = controle_x;
    py = controle_y;

    old_seg_temp = NULL;
			     /* Si reste nil => pt trouve dans premier      */
			     /* segment sinon, pointe le segment precedent  */
			     /* precedent celui contenant le point cherche. */
    seg_temp = seg_debut;
    norme = (float) sqrt ((float)((xdim*xdim) + (ydim*ydim))); 
    while ((seg_temp) != NULL) 
    {
	ptemp = (seg_temp) -> pts;
	while (ptemp != NULL)
	{
	    n = sqrt ((float)((ptemp -> x - px)*(ptemp -> x - px) + 
			(ptemp -> y - py)*(ptemp -> y - py))); 
	    if ( n < norme)
	    {
		norme = n;
		*seg_det = seg_temp;
		*old_seg_det = old_seg_temp;
	    }
	    ptemp = ptemp -> next;
	}
	old_seg_temp = seg_temp;
	seg_temp = (seg_temp) -> suivant;
    }
    return ;
}



/****************************************************************************/
/*  nom	    :	expose_seg						    */
/*									    */
/*  fonction:	expose un segment choisi par l'utilisateur en mettant a jour*/
/*		la liste des segments .					    */
/*									    */
/*  entrees :	aucune	         		                            */
/*			    						    */
/*  globales:   Canvas	canvas                                              */
/*              short	controle_x                                          */
/*	        short   controle_y                                          */
/*		ptr_seg	    seg_courant	                                    */
/*              ptr_seg	    seg_debut                                       */
/*                                                                          */
/*  return  :	aucun							    */
/*									    */
/*  routines:	free_liste_pts		 				    */
/*		reaffichage						    */
/*		recherche						    */
/*		saisie_pts						    */
/*									    */
/****************************************************************************/

static void expose_seg(drawing)
    Pixmap drawing;
{
   ptr_seg stemp, oldstemp;

    if (seg_debut != NULL)
    {
     if ((controle_x >= 0) && (controle_y >= 0)) 
     {
	recherche (&oldstemp,&stemp); 

        /* Extraction du segment et positionnement en fin de liste =>  */
        /* dernier a etre affiche, donc vient par dessus tout     	   */

	if (stemp != seg_courant)
	{
	    if (oldstemp == NULL)	/* Premier segment de la liste */
		seg_debut = stemp -> suivant;
	    else
		oldstemp -> suivant = stemp -> suivant;
	    stemp -> suivant = NULL;
	    seg_courant -> suivant = stemp;
	    seg_courant = seg_courant -> suivant;

	    reaffichage(drawing);
	}
     }
   } 
}


/****************************************************************************/
/*  nom	    :	extract_seg						    */
/*									    */
/*  fonction:	extrait un element pointe par sptr de la liste des segment  */
/*		et libere l'espace memoire rattache a ce segment, oldsptr   */
/*              etant l'element le precedant.				    */
/*									    */
/*  entrees :	ptr_seg	    *sptr                                           */
/*		ptr_seg	    *oldsptr                                        */
/*			    						    */
/*  globales:   ptr_seg	    seg_courant	                                    */
/*              ptr_seg	    seg_debut                                       */
/*              int	    nbr_seg                                         */
/*                                                                          */
/*  return  :	aucun							    */
/*								      	    */
/*  routines:	free_liste_pts		 				    */
/*									    */
/****************************************************************************/

static void extract_seg(oldsptr,sptr)
    ptr_seg	*oldsptr;
    ptr_seg	*sptr;
{

    if ((*oldsptr) == NULL)              /* On extrait le premier element */
    {
	if ((*sptr) -> suivant == NULL)	 /* Si on extrait le dernier element => */
	    seg_courant = *oldsptr;	 /* mise a jour du pointeur courant */

	seg_debut = (*sptr) -> suivant;
    }
    else
    {
	
	if ((*sptr) -> suivant == NULL)	 /* Si on extrait le dernier element => */
	    seg_courant = *oldsptr;	 /* mise a jour du pointeur courant */
	    
	(*oldsptr) -> suivant = (*sptr) -> suivant;
	
    }
    		/* On libere */
    free_liste_pts(&((*sptr) -> pts));
    (*sptr) -> suivant = NULL;
    cfree(*sptr);
    *sptr = NULL;
    nbr_seg--;

    return;
    
}


/****************************************************************************/
/*  nom	    :	dessine_contour       					    */
/*									    */
/*  fonction:	relie successivement les points stockes dans la liste par   */
/*	        des segments de droite avec la couleur definie pour ce      */
/*              segment.                                                    */
/*									    */
/*  entrees :	ptr_seg	sptr                                                */
/*									    */
/*  globales:   aucune		                                            */
/*									    */
/*  return  :	aucun							    */
/*									    */
/*  routines:	aucune							    */
/*                                                                          */
/****************************************************************************/

static void dessine_contour(drawing, sptr)
    Pixmap drawing;
    ptr_seg sptr;
{
    ptr_point	temp, oldtemp;

 	oldtemp = sptr -> pts;
	temp = oldtemp -> next;
	while (temp != NULL)
	{        
	  if (type == MONO)
	   if (couleur_courante == 0)
	     XSetForeground(gDisplay, default_gc, 
			    BlackPixel(gDisplay, screen_number));
	   else
	     XSetForeground(gDisplay, default_gc, 
			    WhitePixel(gDisplay, screen_number));
	  else XSetForeground(gDisplay, default_gc, sptr -> couleur);

	  XDrawLine (gDisplay, drawing, default_gc, oldtemp -> x,oldtemp -> y, 
		     temp -> x, temp -> y);
	  oldtemp = temp;
	  temp = temp -> next;
	}
}



/****************************************************************************/
/*  nom	    :	segment_contour       					    */
/*									    */
/*  fonction:	relie successivement les points stockes dans la liste par   */
/*	        des segments de droite                                      */
/*									    */
/*  entrees :	aucune                                                      */
/*									    */
/*  globales:   ptr_seg	    seg_courant	                                    */
/*                                                                          */
/*  return  :	aucun							    */
/*									    */
/*  routines:	write_master  						    */
/*              init_liste_pts                                              */
/*              dessine_contour                                             */
/*              ferme_et_insere_segment                                     */
/*                                                                          */
/****************************************************************************/

static void segment_contour(drawing)
    Pixmap drawing;
{
    ptr_point	temp, oldtemp;
    char    *num;

    if ( pt_debut != NULL)
    {	
	ferme_et_insere_segment();
	seg_courant -> flag_plein = 0;
	dessine_contour (drawing, seg_courant);
	init_liste_pts();

	num = (char *) calloc (10, sizeof(char));
	sprintf(num," %d ",nbr_seg);
	strcpy(buf, mastertabs[377]);
	strcat(buf, num);
	cfree(num);
	strcat(buf, mastertabs[378]);
	write_master(buf);
    }
}



/****************************************************************************/
/*  nom	    :	remplit_seg       					    */
/*									    */
/*  fonction:	relie successivement les points stockes dans la liste par   */
/*	        des segments de droite et remplit le polygone avec la       */
/*              couleur definie pour ce segment                             */
/*									    */
/*  entrees :	ptr_seg	sptr                                                */
/*									    */
/*  globales:	aucune		                                            */
/*                                                                          */
/*  return  :	aucun							    */
/*									    */
/*  routines:	write_master  						    */
/*              init_liste_pts                                              */
/*              dessine_contour                                             */
/*                                                                          */
/****************************************************************************/

static void remplit_seg(drawing, sptr)
    Pixmap drawing;
    ptr_seg sptr;
{
    XPoint          *tab;
    ptr_point	    pos;
    int		    n, i, nbds = 1, npts[1];	/* nbds est le nombre de frontieres */
    
    n = sptr -> nbr_pts; 
    dessine_contour(drawing, sptr);
    if (n > 3) 
    {
	pos = sptr -> pts;

        /* n-1 car on ne prend pas le dernier point (qui sert a fermer le   */
        /* polygone) pw_polygon_2 le fait tout seul			    */
        /* structure XPoint contain points for defining the polygonal mask  */
   
        tab = (XPoint *) malloc ((n-1) * sizeof(* tab));

        /* On initialise le tableau */

	for (i = 0; i < (n-1); i++) /* n-1 car on part de 0 avec un tableau */
	{
	    tab[i].x = pos -> x;
	    tab[i].y = pos -> y;
	    pos = pos -> next;
	}
	
	npts[0] = n-1;

	if (type == MONO)
	  if (couleur_courante == 0)
	     XSetForeground(gDisplay, default_gc, 
			    BlackPixel(gDisplay, screen_number));
	  else
	     XSetForeground(gDisplay, default_gc, 
			    WhitePixel(gDisplay, screen_number));
	else XSetForeground(gDisplay, default_gc, sptr -> couleur);

        XFillPolygon(gDisplay, drawing, default_gc, tab, 
		     n - 1, Convex, CoordModeOrigin);

/*	cfree(tab);*/
	
    }
}



/****************************************************************************/
/*  nom	    :	reaffichage     					    */
/*									    */
/*  fonction:	reaffiche l'image en lisant la liste des segments et en les */
/*	        affichant successivement selon leur caracteristiques	    */
/*									    */
/*  entrees :	aucune	                                                    */
/*									    */
/*  globales:                                                               */
/*                                                                          */
/*  return  :	aucun							    */
/*									    */
/*  routines:	write_master  						    */
/*              init_liste_pts                                              */
/*              dessine_contour                                             */
/*		remplit_seg                                                 */
/*                                                                          */
/****************************************************************************/

static void reaffichage(drawing)
    Pixmap drawing;
{
   ptr_seg	    temp;

   /* Affichage du fond */
   if (type == MONO)
     if (couleur_fond == 0)
      XSetForeground(gDisplay, default_gc, BlackPixel(gDisplay, screen_number));
     else
      XSetForeground(gDisplay, default_gc, WhitePixel(gDisplay, screen_number));
   else XSetForeground(gDisplay, default_gc, couleur_fond);

   XFillRectangle(gDisplay, drawing, default_gc, 0, 0, xdim, ydim);

   /* Affichage de la liste des segments */ 
    temp = seg_debut;
    while (temp != NULL)
    {
	if (temp -> flag_plein)	remplit_seg (drawing, temp);
	else dessine_contour (drawing, temp);
	temp = temp -> suivant;
    }
    return;
}


/****************************************************************************/
/*  nom	    :	efface_seg          					    */
/*									    */
/*  fonction:	efface un segment choisi par l'utilisateur et met a jour la */
/*		liste des segments ainsi que celles des points.		    */
/*									    */
/*  entrees :	aucune                                                      */
/*									    */
/*  globales:   Canvas	canvas                                              */
/*              short	controle_x                                          */
/*	        short   controle_y                                          */
/*              ptr_seg	seg_debut                                           */
/*                                                                          */
/*  return  :	aucun							    */
/*									    */
/*  routines:	recherche	  					    */
/*		reaffichage						    */
/*		saisie_pts						    */
/*		extract_seg						    */
/*		write_master						    */
/*									    */
/****************************************************************************/

static void efface_seg(drawing)
    Pixmap drawing;
{
    ptr_seg stemp, oldstemp;
    
    if (seg_debut != NULL)
    {
	if ((controle_x >= 0) && (controle_y >= 0)) 
	{
	    recherche (&oldstemp,&stemp); 
			  
	    extract_seg (&oldstemp,&stemp);
	    reaffichage(drawing);
	    strcpy (buf, mastertabs[382]);
	    write_master (buf);
	}
    }
}


void set_type_clear(Clear_RadioButton, value, callData)
	Widget Clear_RadioButton;
        int value;
	caddr_t callData;
{
  type_clear = value;      /* 0 = All;  1 = Segment */
}



void
clear(ClearPB, tab_widgets, callData)
	Widget ClearPB;
	xs_struc_ima_gener *tab_widgets;
	caddr_t callData;
{
  if (!tab_widgets->pixmap_drawing) return;
  
  if (type_clear == 0)
  {
    init_liste_pts();
    init_liste_seg();

    if (type == MONO)
      if (couleur_fond == 0)
        XSetForeground(gDisplay, default_gc, 
		       BlackPixel(gDisplay, screen_number));
      else
        XSetForeground(gDisplay, default_gc, 
		       WhitePixel(gDisplay, screen_number));
    else XSetForeground(gDisplay, default_gc, couleur_fond);

    XFillRectangle(gDisplay, tab_widgets->pixmap_drawing,
		   default_gc, 0, 0, xdim, ydim);
  }
  else efface_seg(tab_widgets->pixmap_drawing);

  XCopyArea (gDisplay, tab_widgets->pixmap_drawing, 
	     XtWindow(tab_widgets->Drawing_area), 
	     default_gc, 0, 0, xdim, ydim, 0, 0);
}


void set_constraint(HV_RadioButton, value, callData)
	Widget HV_RadioButton;
        int value;
	caddr_t callData;
{
  contrainte = value;
}



void set_color_wb(Color_RadioButton, tab_widgets, callData)
	Widget Color_RadioButton;
        xs_struc_ima_gener *tab_widgets;
	caddr_t callData;
{
  Arg args[MAX_ARGS];
  int n;

  couleur_fond = 0;	
  couleur_courante = 255;	

  if (tab_widgets->pixmap_drawing)
  {
    reaffichage(tab_widgets->pixmap_drawing);
  
    XCopyArea (gDisplay, tab_widgets->pixmap_drawing, 
	       XtWindow(tab_widgets->Drawing_area), 
	       default_gc, 0, 0, xdim, ydim, 0, 0);
  }
}



void set_color_bw(Color_RadioButton, tab_widgets, callData)
	Widget Color_RadioButton;
        xs_struc_ima_gener *tab_widgets;
	caddr_t callData;
{
  Arg args[MAX_ARGS];
  int n;

  couleur_fond = 255;	
  couleur_courante = 0;	

  if (tab_widgets->pixmap_drawing)
  {
    reaffichage(tab_widgets->pixmap_drawing);

    XCopyArea (gDisplay, tab_widgets->pixmap_drawing, 
	       XtWindow(tab_widgets->Drawing_area), 
	       default_gc, 0, 0, xdim, ydim, 0, 0);
  }
}



void 
track_mouse_image_generation(w, tab_widgets, event)
    Widget          w;
    xs_struc_ima_gener *tab_widgets;
    XEvent         *event;
{
  static int Xold;
  static int Yold;
  char message[25];
  Arg args[MAX_ARGS];
  int X, Y, n;
  int Affichage;

  XSetForeground(gDisplay, gc_xor, 128);
  if (begintrack && pt_courant)
     XDrawLine(gDisplay, 
	       XtWindow(tab_widgets->Drawing_area), 
	       gc_xor, pt_courant->x, pt_courant->y, Xold, Yold);

  /*
   * Extract the position of the sprite from the event
   * and display it in the widgets. 
   */

  X = event->xmotion.x;    /* positions de la souris sur le display! */
  Y = event->xmotion.y;
  
  sprintf (message, "X: %4d   Y: %4d", X, Y);
  n = 0;
  XtSetArg(args[n],XmNlabelString,
	   XmStringLtoRCreate(message,XmSTRING_DEFAULT_CHARSET)); n++;
  XtSetValues(tab_widgets->XY_label, args, n);

  if (pt_courant)
  {
    if (contrainte)
    {
      if (abs((pt_courant -> x) - X) < abs((pt_courant -> y) - Y))
      {	
	X = pt_courant -> x;
	Y = Y;
      }
      else
      {
	X = X;
	Y = pt_courant -> y;
      }
    }

    XDrawLine(gDisplay, 
	      XtWindow(tab_widgets->Drawing_area), 
	      gc_xor, pt_courant->x, pt_courant->y, X, Y);

    Xold = X;
    Yold = Y;
    begintrack = TRUE;
   }
}


/******************************************************
/   activateCallback for Widget SAVE
/*****************************************************/

/****************************************************************************/
/*  nom	    :	sauve_im_ds_plan       					    */
/*									    */
/*  fonction:	sauve l'image contenue par le canvas dans un plan d'image   */
/*									    */
/*  entrees :	aucune                                                      */
/*									    */
/*  globale :	int	    type                                            */
/*		int	    index_image[]				    */
/*		short	    xdim					    */
/*		short	    ydim					    */
/*		struct description_memoire  dir_desc[]			    */
/*		struct directoire_image	    dir_image[]			    */
/*									    */
/*  return  :	aucun							    */
/*									    */
/*  routines:	         						    */
/*									    */
/****************************************************************************/

void sauve_im_ds_plan()
{
    unsigned char   *image_temp;
    unsigned char   val;
    char	    *num;
    short	    x, y;
    XImage 	    *xi;

    strcpy (buf, mastertabs[376]);
    num = (char *) calloc (10, sizeof(char));
    sprintf(num," %d ", index_image[1]);
    strcat(buf, num);
    strcat(buf, "\n");
    cfree(num);
    write_master (buf);

    /* Index_image[1] contient le numero du plan dans lequel 	 */
    /* on veut sauver l'image.					 */
  
    liste_image[index_image[1]].nbr_seg = nbr_seg; /* mise a jour du nombre de*/
						   /* segments appartenant a  */
    liste_image[index_image[1]].seg = seg_debut;   /* une image; pointeur sur */
                                                   /* le debut de la liste    */
						   /* des points              */
    dir_desc[index_image[1]].nligne = ydim;
    dir_desc[index_image[1]].ncolonne = xdim;
    if (dir_image[index_image[1]].image != NULL)
	free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *) malloc (ydim*xdim);

    if (type == MONO)
	dir_desc[index_image[1]].type = -1;
    else
	dir_desc[index_image[1]].type = 0;

    image_temp = dir_image[index_image[1]].image;

   /*lecture de l'image*/
    xi = XGetImage(gDisplay, pixmap_temp, 0, 0, xdim, ydim, AllPlanes, ZPixmap);

    for (y =0 ; y < ydim ; y++)
	for (x = 0 ; x < xdim ; x++)
	{
	    val = (unsigned char) XGetPixel(xi, x, y) ; 
	    
	    if ((type == MONO) && (val == 0))
		*image_temp = 255;
	    else
		*image_temp = val;
	    image_temp++;
	}
    
    statis (dir_image[index_image[1]].image,
                dir_desc[index_image[1]].type, 
	        dir_desc[index_image[1]].nligne,
	        dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin),
		&(dir_desc[index_image[1]].mmax), 
	        &(dir_desc[index_image[1]].mu),
		&(dir_desc[index_image[1]].ecart));
}


void
image_gen_SAVE_callb(SAVE, tab_widgets, callData)
	Widget SAVE;
        xs_struc_ima_gener *tab_widgets;
	caddr_t callData;
{
  Widget planSortie;

  if (!tab_widgets->pixmap_drawing)
  {
    sprintf(buf, paneltabs[317]);
    write_master(buf);
    return;
  }
	
  reaffichage(tab_widgets->pixmap_drawing);

  XCopyArea (gDisplay, tab_widgets->pixmap_drawing, 
	     XtWindow(tab_widgets->Drawing_area), 
	     default_gc, 0, 0, xdim, ydim, 0, 0);

  pixmap_temp = tab_widgets->pixmap_drawing;

  planSortie = build_IOplans_widget(SAVE, 83, paneltabs[539], NULL);
  XtManageChild(planSortie);
}


