/* SCCS @(#)displayplane.c	1.1  12/2/92 */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/*                       displayplane.c                                 */
/*                                                                      */
/************************************************************************/
/************************************************************************/
/*                                                                      */
/* FILENAME     :   displayplane.c                                      */
/*                                                                      */
/* DESCRIPTION  :   LaboImage (Display Image)                           */
/*                                                                      */
/* AUTHORS      :   Marianne Logean                                     */
/*                                                                      */
/* VERSION      :   1.0                                                 */
/*                                                                      */
/* HISTORY      :   1.12.92                                             */
/*                  MAL         Created    version: 1.0                 */
/*                                                                      */
/* Copyright  1992 by CUI/UIN/HCUG, All rights reserved.                */
/*                                                                      */
/************************************************************************/
/************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/Shell.h>
#include "../libwidgets/widgetstructure.h"
#include "displayplane.h"
#include "displayplane.callback.h"
#include "../win4.h"
#include "affiche4.h"


#define	MIN(A,B)    ((A)<(B)?(A):(B))

#define global

extern XmFontList gFontlist, gSmall_fontlist;
extern void track_mouse_position();

extern Display          *gDisplay;
extern Visual           *gVisual;
extern Window           root_window;
extern Widget		gLabowidget;

extern GC               default_gc, gc_xor;

global Widget   outer,             /* general widgets */
  		viewport,
                menubar,menubar2,
  		image_frame,
                stack_widget;

static void get_IMAGE();



/***** fct donne le nom du fichier sans son chemin d'acces! ******/

char *find_name (filename)
    char *filename;
{
  char *name;
  int length = strlen(filename);
  int j, i = length;
  while (filename[i] != '/') i--;
  i++;
  name = (char *) malloc (length-i+1);
  for (j = 0; j <= length-i; j++)
      name[j] = filename[j+i];
  return name;
}


/********************************************************************************/
/* affichage d'un histogramme							*/
/********************************************************************************/


xs_struc_histo
* display_histogram(width, height, dv)
    int width;
    int height;
    struct description_vecteur *dv;
{
    Widget shell_display, show_histo;
    Widget histo_viewport, histo_info, histo_QUIT, DrawingArea_widget;
    Widget level, level_text, percent, percent_text, percent_tot, percent_tot_text;
    xs_struc_histo * histoparam;
    char titlewindow[50];
    Arg  arg[15];
    int i;

    histoparam = (xs_struc_histo *) malloc (sizeof (xs_struc_histo));


    sprintf(titlewindow, "%s[%d]", panel_titres[122], index_vect[0]);
    i = 0;
    XtSetArg(arg[i], XmNwidth, MIN (width, 512) + 134);i++;
    XtSetArg(arg[i], XmNheight, MIN (height, 512) + 4);i++;
    XtSetArg(arg[i],XmNtitle, titlewindow); i++;
    shell_display = XtCreateApplicationShell("shell_display",
					     topLevelShellWidgetClass, arg, i);

    i = 0;
    XtSetArg(arg[i],XmNwidth, MIN (width, 512) + 134);i++;
    XtSetArg(arg[i],XmNheight, MIN (height, 512) + 4);i++;

    show_histo = XmCreateForm(shell_display, "show_histo", arg, i);


    /* Creating histo_info Widget */ 

    i = 0;
    XtSetArg(arg[i],XmNwidth, 130);i++;
    XtSetArg(arg[i],XmNheight, MIN (height, 512) + 4);i++;
    XtSetArg(arg[i],XmNbottomAttachment,XmATTACH_FORM); i++;
    XtSetArg(arg[i],XmNleftAttachment, XmATTACH_NONE); i++;
    XtSetArg(arg[i],XmNresizePolicy,XmRESIZE_NONE); i++;
    XtSetArg(arg[i],XmNrightAttachment, XmATTACH_FORM); i++;
    XtSetArg(arg[i],XmNtopAttachment,XmATTACH_FORM); i++;
    histo_info = XmCreateForm(show_histo,"histo_info",arg,i);
    XtManageChild(histo_info);


    /* Creating level Widget */ 

    i = 0;
    XtSetArg(arg[i],XmNalignment,XmALIGNMENT_BEGINNING); i++;
    XtSetArg(arg[i],XmNfontList, gFontlist); i++;
    XtSetArg(arg[i],XmNlabelString,
	XmStringLtoRCreate(paneltabs[223],
		XmSTRING_DEFAULT_CHARSET)); i++;
    XtSetArg(arg[i],XmNleftAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNleftPosition, 5); i++;
    XtSetArg(arg[i],XmNrightAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNrightPosition,40); i++;
    XtSetArg(arg[i],XmNtopAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNtopPosition,20); i++;

    level = XmCreateLabel(histo_info,"level",arg,i);
    XtManageChild(level);


    /* Creating level_text Widget */ 

    i = 0;
    XtSetArg(arg[i],XmNalignment,XmALIGNMENT_BEGINNING); i++;
    XtSetArg(arg[i],XmNfontList, gSmall_fontlist); i++;
    XtSetArg(arg[i],XmNlabelString,
	XmStringLtoRCreate("",
		XmSTRING_DEFAULT_CHARSET)); i++;
    XtSetArg(arg[i],XmNleftAttachment,XmATTACH_WIDGET); i++;
    XtSetArg(arg[i],XmNleftWidget, level); i++;
    XtSetArg(arg[i],XmNrightAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNrightPosition,95); i++;
    XtSetArg(arg[i],XmNtopAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNtopPosition,20); i++;

    level_text = XmCreateLabel(histo_info,"level",arg,i);
    XtManageChild(level_text);

    histoparam->level = level_text;

    /* Creating percent Widget */ 

    i = 0;
    XtSetArg(arg[i],XmNalignment,XmALIGNMENT_BEGINNING); i++;
    XtSetArg(arg[i],XmNfontList, gFontlist); i++;
    XtSetArg(arg[i],XmNlabelString,
	XmStringLtoRCreate("% :",
		XmSTRING_DEFAULT_CHARSET)); i++;
    XtSetArg(arg[i],XmNleftAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNleftPosition, 5); i++;
    XtSetArg(arg[i],XmNrightAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNrightPosition,40); i++;
    XtSetArg(arg[i],XmNtopAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNtopPosition,40); i++;

    percent = XmCreateLabel(histo_info,"percent",arg,i);
    XtManageChild(percent);


    /* Creating percent_text Widget */ 

    i = 0;
    XtSetArg(arg[i],XmNalignment,XmALIGNMENT_BEGINNING); i++;
    XtSetArg(arg[i],XmNfontList, gSmall_fontlist); i++;
    XtSetArg(arg[i],XmNlabelString,
	XmStringLtoRCreate("",
		XmSTRING_DEFAULT_CHARSET)); i++;
    XtSetArg(arg[i],XmNleftAttachment,XmATTACH_WIDGET); i++;
    XtSetArg(arg[i],XmNleftWidget, percent); i++;
    XtSetArg(arg[i],XmNrightAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNrightPosition,95); i++;
    XtSetArg(arg[i],XmNtopAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNtopPosition,40); i++;

    percent_text = XmCreateLabel(histo_info,"percent",arg,i);
    XtManageChild(percent_text);

    histoparam->percent = percent_text;

    /* Creating percent_tot Widget */ 

    i = 0;
    XtSetArg(arg[i],XmNalignment,XmALIGNMENT_BEGINNING); i++;
    XtSetArg(arg[i],XmNfontList, gFontlist); i++;
    XtSetArg(arg[i],XmNlabelString,
	XmStringLtoRCreate("% tot.:",
		XmSTRING_DEFAULT_CHARSET)); i++;
    XtSetArg(arg[i],XmNleftAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNleftPosition, 5); i++;
    XtSetArg(arg[i],XmNrightAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNrightPosition,40); i++;
    XtSetArg(arg[i],XmNtopAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNtopPosition,60); i++;

    percent_tot = XmCreateLabel(histo_info,"percent_tot",arg,i);
    XtManageChild(percent_tot);


    /* Creating percent_tot_text Widget */ 

    i = 0;
    XtSetArg(arg[i],XmNalignment,XmALIGNMENT_BEGINNING); i++;
    XtSetArg(arg[i],XmNfontList, gSmall_fontlist); i++;
    XtSetArg(arg[i],XmNlabelString,
	XmStringLtoRCreate("",
		XmSTRING_DEFAULT_CHARSET)); i++;
    XtSetArg(arg[i],XmNleftAttachment,XmATTACH_WIDGET); i++;
    XtSetArg(arg[i],XmNleftWidget, percent_tot); i++;
    XtSetArg(arg[i],XmNrightAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNrightPosition,95); i++;
    XtSetArg(arg[i],XmNtopAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNtopPosition,60); i++;

    percent_tot_text = XmCreateLabel(histo_info,"percent_tot",arg,i);
    XtManageChild(percent_tot_text);

    histoparam->percent_tot = percent_tot_text;

    /* Creating histo_QUIT Widget */ 

    i = 0;
    XtSetArg(arg[i],XmNfontList, gFontlist); i++;
    XtSetArg(arg[i],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); i++;
    XtSetArg(arg[i],XmNleftAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNleftPosition,15); i++;
    XtSetArg(arg[i],XmNrightAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNrightPosition,85); i++;
    XtSetArg(arg[i],XmNtopAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNtopPosition, 75); i++;

    histo_QUIT = XmCreatePushButton(histo_info,"histo_QUIT",arg,i);
    XtManageChild(histo_QUIT);

    /* Adding Callbacks for histo_QUIT */ 

    XtAddCallback(histo_QUIT,XmNactivateCallback,QUIT_callb,shell_display);


    /* Creating histo_viewport Widget */ 

    i = 0;
    XtSetArg(arg[i], XmNwidth, 257);i++;
    XtSetArg(arg[i], XmNheight, 257);i++;
    XtSetArg(arg[i], XmNtopAttachment, XmATTACH_FORM); i++;
    XtSetArg(arg[i], XmNrightAttachment, XmATTACH_WIDGET); i++;
    XtSetArg(arg[i], XmNrightWidget, histo_info); i++;
    XtSetArg(arg[i], XmNleftAttachment, XmATTACH_FORM);i++;
    XtSetArg(arg[i], XmNbottomAttachment, XmATTACH_FORM);i++;
    XtSetArg(arg[i], XmNscrollingPolicy, XmAUTOMATIC);i++;
    histo_viewport = XtCreateManagedWidget("histo_viewport", 
				xmScrolledWindowWidgetClass, show_histo, arg, i);


    /* Creating DrawingArea Widget */ 

    i = 0;
    XtSetArg(arg[i], XmNwidth, (Dimension)width);i++;
    XtSetArg(arg[i], XmNheight, (Dimension)height);i++;
    DrawingArea_widget = 
	XtCreateWidget("image", xmDrawingAreaWidgetClass, histo_viewport, arg, i);

    XtManageChild(DrawingArea_widget);

    histoparam->canvas = DrawingArea_widget;
    histoparam->dv = dv;

    XtAddCallback (DrawingArea_widget, XmNinputCallback, dans_histo, histoparam);

    i = 0;
    XtSetArg(arg[i], XmNworkWindow, DrawingArea_widget); i++;
    XtSetValues(histo_viewport, arg, i);

    XtManageChild(show_histo);

    XtRealizeWidget(shell_display);


    return (histoparam);
}





/********************************************************************************/
/* affichage d'une image							*/
/********************************************************************************/



void
install_win_colormap(win, colormap, event)
    Widget      win;
    Colormap	colormap;
    XEvent      *event;
    
{
    switch (event->type)
    {
    case EnterNotify:
      XInstallColormap(gDisplay, colormap);
      break;
    case LeaveNotify:
      XUninstallColormap(gDisplay, colormap);
      break;
    default:
      break;
    }
}


void displayplane(typeColormap, nbr_plan)
    int typeColormap;
    int nbr_plan;
{
    int                   seuil;
    Colormap              my_colormap;
    int                   i, j;
    Widget                shell_display;
    Widget                menu_QUIT, menu_MENU;
    struct image_ecran    *im_desc;
    xs_struc_display_menu * data_display;
    IMAGE                 *image;
    char                  titlewindow[50];
    Arg                   arg[15];


    get_IMAGE(&image, typeColormap);

    if (!image)
    {
      write_erreur(1);
      return;
    }

    /*statistiques de l'image-ecran sont stockees dans im_desc:*/

    im_desc = (struct image_ecran *) malloc (sizeof (struct image_ecran));
    im_desc->nligne = dir_desc[index_image[0]].nligne;
    im_desc->ncolonne = dir_desc[index_image[0]].ncolonne;
    
    im_desc->pt_zone = NULL;  /* initialisation de la structure contenant */
                              /* les points formant la region d'interet   */
    
    strcpy (im_desc->filename, find_name (dir_desc[index_image[0]].filename));
    strcpy (im_desc->comment, dir_desc[index_image[0]].comment);

    switch (dir_desc[index_image[0]].type) {
        case -1: strcpy (im_desc->type, " byte 'binaire'"); break;
	case 0 : strcpy (im_desc->type, " byte"); break;
	case 1 : strcpy (im_desc->type, " short"); break;
	case 2 : strcpy (im_desc->type, " integer"); break;
	case 3 : strcpy (im_desc->type, " float"); break;
    }

    im_desc->nbr_plan = (short) nbr_plan;
    im_desc->n_plan = index_image[0];
    for (i=0; i<nbr_plan; i++) {
	im_desc->maxi[i] = dir_desc[index_image[2*i]].mmax;    
	im_desc->mini[i] = dir_desc[index_image[2*i]].mmin;    
	im_desc->mu[i] = dir_desc[index_image[2*i]].mu;
	im_desc->ecart[i] = dir_desc[index_image[2*i]].ecart;    
    }

    /*Stockage de toutes les donnees necessaires a l'execution des 
      options du menu de display. */

    data_display = (xs_struc_display_menu *) malloc (sizeof (xs_struc_display_menu));

    data_display->ret = image;
    data_display->im_desc = im_desc;
    data_display->colormap = typeColormap;

    switch (typeColormap) {
	case 1: my_colormap = init_color_lin (); break;
	case 2: my_colormap = init_color_log (); break;
	case 3:                                           /*seuil*/
	case 4: seuil = (int)dir_desc[index_image[0]].mu; /*report d'erreur*/
		my_colormap = init_seuil (seuil); break;
	case 5:                                           /*rgb direct*/
	case 6: my_colormap = init_color(); break;        /*rgb report*/
	case 7: seuil = 100;     			  /*morphologie binaire*/
		my_colormap = init_seuil (seuil); break;  /* cf smorpho.c*/
    }

    if (nbr_plan == 1) sprintf(titlewindow, "[%d] %s", index_image[0], 
			    find_name (dir_desc[index_image[0]].filename));
    else sprintf(titlewindow, "[%d-%d-%d] %s", index_image[0],index_image[2],
		 index_image[4], find_name (dir_desc[index_image[0]].filename));
    i = 0;
    XtSetArg(arg[i],XmNwidth, MIN ((Dimension)image->width+15, 527));i++;
    XtSetArg(arg[i],XmNheight, MIN ((Dimension)image->height+46, 552));i++;
/*
    XtSetArg(arg[i],XmNmaxWidth,MIN ((Dimension)image->width+15, 527)); i++;
    XtSetArg(arg[i],XmNmaxHeight,MIN ((Dimension)image->height+46, 552)); i++;
*/
    XtSetArg(arg[i],XmNmaxWidth,(Dimension)image->width+15); i++;
    XtSetArg(arg[i],XmNmaxHeight,(Dimension)image->height+46); i++;
    XtSetArg(arg[i],XmNtitle, titlewindow); i++;
    shell_display = XtCreateApplicationShell("shell_display",
					     topLevelShellWidgetClass, arg, i);

    i = 0;
    XtSetArg(arg[i],XmNwidth, MIN ((Dimension)image->width+15, 527));i++;
    XtSetArg(arg[i],XmNheight, MIN ((Dimension)image->height+46, 552));i++;

    outer = XmCreateForm(shell_display, "outer", arg, i);


    /* Creating Menu_command Widget */ 

    i = 0;
    XtSetArg(arg[i],XmNbottomAttachment,XmATTACH_FORM); i++;
    XtSetArg(arg[i],XmNleftAttachment, XmATTACH_FORM);i++;
    XtSetArg(arg[i],XmNresizePolicy,XmRESIZE_NONE); i++;
    XtSetArg(arg[i],XmNrightAttachment, XmATTACH_FORM); i++;
    XtSetArg(arg[i],XmNtopAttachment,XmATTACH_NONE); i++;
    menubar = XmCreateForm(outer,"menu_command",arg,i);
    XtManageChild(menubar);


    /* Creating menubar2 Widget */ 

    i = 0;
    XtSetArg(arg[i],XmNleftAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNleftPosition,5); i++;
    XtSetArg(arg[i],XmNrightAttachment,XmATTACH_NONE); i++;
    XtSetArg(arg[i],XmNtopAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNtopPosition,6); i++;
    XtSetArg(arg[i],XmNbottomAttachment,XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNbottomPosition,94); i++;

    menubar2 = XmCreateMenuBar(menubar,"menubar2",arg,i);
    XtManageChild(menubar2);

    /* Creating menu_MENU Widget */ 

    i = 0;
    XtSetArg(arg[i],XmNfontList, gFontlist); i++;
    XtSetArg(arg[i],XmNlabelString,
		XmStringLtoRCreate("MENU",
			XmSTRING_DEFAULT_CHARSET)); i++;

    menu_MENU = XmCreateCascadeButton(menubar2,"menu_MENU",arg,i);
    build_Display_Menu (menu_MENU, data_display);
    XtManageChild(menu_MENU);

    /* Creating menu_QUIT Widget */ 

    i = 1;
    XtSetArg(arg[i],XmNlabelString,
		XmStringLtoRCreate(paneltabs[313],
			XmSTRING_DEFAULT_CHARSET)); i++;
    XtSetArg(arg[i],XmNbottomAttachment,XmATTACH_FORM); i++;
    XtSetArg(arg[i],XmNtopAttachment,XmATTACH_FORM); i++;
    XtSetArg(arg[i],XmNleftAttachment, XmATTACH_NONE);i++;
    XtSetArg(arg[i],XmNrightAttachment, XmATTACH_POSITION); i++;
    XtSetArg(arg[i],XmNrightPosition,95); i++;
    menu_QUIT = XmCreatePushButton(menubar,"menu_QUIT",arg,i);
    XtManageChild(menu_QUIT);

    /* Adding Callbacks for menu_QUIT */ 

    XtAddCallback(menu_QUIT,XmNactivateCallback,freeColormap,my_colormap);
    XtAddCallback(menu_QUIT,XmNactivateCallback,QUIT_callb,shell_display);


    /* Creating ScrolledWindow Widget */ 

    i = 0;
    XtSetArg(arg[i], XmNtopAttachment, XmATTACH_FORM); i++;
    XtSetArg(arg[i], XmNrightAttachment, XmATTACH_FORM); i++;
    XtSetArg(arg[i], XmNleftAttachment, XmATTACH_FORM);i++;
    XtSetArg(arg[i], XmNbottomAttachment, XmATTACH_WIDGET);i++;
    XtSetArg(arg[i], XmNbottomWidget,menubar); i++;
    XtSetArg(arg[i], XmNscrollingPolicy, XmAUTOMATIC);i++;
    viewport = XtCreateManagedWidget("viewport", xmScrolledWindowWidgetClass,
			outer, arg, i);


/***** Create Stack Widget ****/
    i = 0;
    XtSetArg( arg[i], XmNbackgroundPixmap, image->pixmap);i++;
    XtSetArg( arg[i], XmNwidth, (Dimension)image->width);i++;
    XtSetArg( arg[i], XmNheight, (Dimension)image->height);i++;
    stack_widget = XtCreateWidget("image", xmDrawingAreaWidgetClass,
			    		viewport, arg, i);
    XtManageChild(stack_widget);
    data_display->Drawing_Area = stack_widget;


    XtAddEventHandler((Widget) stack_widget, 
			EnterWindowMask | LeaveWindowMask,False,
 			(XtEventHandler)install_win_colormap, my_colormap);

    /*Dimensionnement de la fenetre de display selon les dimensions de l'image:*/

    i = 0;
    XtSetArg(arg[i], XmNworkWindow, stack_widget); i++;
    XtSetValues(viewport, arg, i);
    XtManageChild(viewport);

    XtManageChild(outer);

    XtRealizeWidget(shell_display);

    /*  colormap install with one event handler: */
/*    XSetWindowColormap (XtDisplay(shell_display), 
                         XtWindow (shell_display), my_colormap);*/
    
    sprintf (data_display->repfloat, "X:%04d Y:%04d Pix:%04d", 0,0,0); 
 	        
    data_display->calliperON = 0;     /* Le calliper est OFF */
    data_display->MaskPix = NULL;
    data_display->masque = NULL;
    data_display->pixmap_profile = NULL;
    
    XtAddEventHandler(data_display->Drawing_Area, PointerMotionMask, FALSE,
                      track_mouse_position, data_display);
}


static void get_IMAGE(image, methode)
    IMAGE	       **image;
    int                methode;
{
  int		err, i, j, k, size;
  unsigned long nb_val;
  IMAGE		*ret;
  float		m,  b, flo, fhi;

  *image = (IMAGE *)calloc(1, sizeof(IMAGE));

  if(*image == NULL)
  {
    fprintf(stderr, "Error in allocation\n");
    return;
  }

  ret = *image;

  ret->image = (unsigned char *)dir_image[index_image[0]].image;
  ret->type = (unsigned int)dir_desc[index_image[0]].type;
  ret->height = (unsigned int)dir_desc[index_image[0]].nligne;
  ret->width = (unsigned int)dir_desc[index_image[0]].ncolonne;
  size = (int)dir_desc[index_image[0]].nligne*(int)dir_desc[index_image[0]].ncolonne;

  if ((ret->height != 0) && (ret->width != 0))
    ret->pixmap = XCreatePixmap(gDisplay, root_window,
				ret->width, ret->height, 8);
  else 
  {
    free(*image);
    *image = NULL;
  }
  if (ret->pixmap == 0) 
  {
    free(*image);
    *image = NULL;
    return;
  }

  switch (methode) {
    case 1: 
      affiche_image_color (&(ret->imagedisplay), 
			   dir_image[index_image[0]].image,
			   dir_desc[index_image[0]].type, 
			   dir_desc[index_image[0]].nligne, 
			   dir_desc[index_image[0]].ncolonne, 
			   dir_desc[index_image[0]].mmin, 
			   dir_desc[index_image[0]].mmax);
      break;
    case 2: 
      affiche_image_color (&(ret->imagedisplay), 
			   dir_image[index_image[0]].image, 
			   dir_desc[index_image[0]].type, 
			   dir_desc[index_image[0]].nligne, 
			   dir_desc[index_image[0]].ncolonne, 
			   dir_desc[index_image[0]].mmin, 
			   dir_desc[index_image[0]].mmax); 
      break;
    case 3: 
    case 7: 
      affiche_image (&(ret->imagedisplay),  
		     dir_image[index_image[0]].image,
		     dir_desc[index_image[0]].type, 
		     dir_desc[index_image[0]].nligne, 
		     dir_desc[index_image[0]].ncolonne, 
		     dir_desc[index_image[0]].mmin, 
		     dir_desc[index_image[0]].mmax, 
		     dir_desc[index_image[0]].mu, 1);
      break;
    case 4: 
      affiche_image (&(ret->imagedisplay),  
		     dir_image[index_image[0]].image,
		     dir_desc[index_image[0]].type, 
		     dir_desc[index_image[0]].nligne, 
		     dir_desc[index_image[0]].ncolonne, 
		     dir_desc[index_image[0]].mmin, 
		     dir_desc[index_image[0]].mmax, 
		     dir_desc[index_image[0]].mu, 2);
      break;
    case 5: affiche_image_couleur (&(ret->imagedisplay), 
				   dir_image[index_image[0]].image,
				   dir_image[index_image[2]].image,
				   dir_image[index_image[4]].image,
				   dir_desc[index_image[0]].type,
				   dir_desc[index_image[2]].type,
				   dir_desc[index_image[4]].type,
				   dir_desc[index_image[0]].mmin,
				   dir_desc[index_image[2]].mmin,
				   dir_desc[index_image[4]].mmin,
				   dir_desc[index_image[0]].mmax,
				   dir_desc[index_image[2]].mmax,
				   dir_desc[index_image[4]].mmax,
				   dir_desc[index_image[0]].nligne,
				   dir_desc[index_image[0]].ncolonne); 
      break;
    case 6: affiche_couleur_floyd (&(ret->imagedisplay), 
				   dir_image[index_image[0]].image,
				   dir_image[index_image[2]].image,
				   dir_image[index_image[4]].image,
				   dir_desc[index_image[0]].type,
				   dir_desc[index_image[2]].type,
				   dir_desc[index_image[4]].type,
				   dir_desc[index_image[0]].mmin,
				   dir_desc[index_image[2]].mmin,
				   dir_desc[index_image[4]].mmin,
				   dir_desc[index_image[0]].mmax,
				   dir_desc[index_image[2]].mmax,
				   dir_desc[index_image[4]].mmax,
				   dir_desc[index_image[0]].nligne,
				   dir_desc[index_image[0]].ncolonne); 
      break;
  }

  ret->ximage = XCreateImage(gDisplay, gVisual,
			     8, ZPixmap, 0, (char *)(ret->imagedisplay),
			     ret->width, ret->height, 8, 0);
  if (ret->ximage == NULL)
  {
    free(*image);
    *image = NULL;
    return;
  }

  XPutImage(gDisplay, ret->pixmap, default_gc,
	    ret->ximage, 0, 0, 0, 0, ret->width, ret->height);

}


