;**************************************************************************
;** justif.lisp                                                          **
;**                                                                      **
;**  Ce programme a les definitions et fonctions qui aident au mecanisme **
;** de justification du systeme.                                         **
;**                                                                      **
;** Claudia Coiteux-Rosu  juillet 1989                                   **
;**************************************************************************
;** Fonctions et methodes:                                               **
;** Justification:                                                       **
;**  trouve-justif               why                  why+               **
;**  saut-ligne                  explain-exec         cs-in-exec         **
;**  explain-num-exec            imprime              descrip            **
;**  affiche                                                             **
;**                                                                      **
;** Stocage de la justification:                                         **
;**  agrega                      elimina                                 **
;**************************************************************************

(eval-when (compile) (load "varenv")
                     (load "ps-util"))

;**************************************************************************
;** Definitions de elements pour la justification                        **
;**************************************************************************
(defflavor just ((rule nil) ; pointeur vers la regle utilisee
                 (util nil) ; liste de pointeurs vers les faits utilises
                 (remov nil); liste de pointeurs vers les  faits effaces
                 (adit nil) ; liste de pointeurs vers les  faits ajoutes
                ) nil
                  :initable-instance-variables)
 

;**************************************************************************
;** Fonctions de justification.                                          **
;**************************************************************************
;** Cherche la justification du fait `fait' de la base `base' (ou de la  **
;** base courante) a partir du fait lui meme ou de son numero de cycle.  **
;** La valeur retourne est "d" si le fait est une donne initiale, un nom **
;** de base s'il a ete herite d'une base ou une instance du flavor just  **
;** s'il a ete ajoute par une regle.                                     **
(defun trouve-justif (fait &optional base)
 (let ((psy-db (cond (base (get '*psy-kb* base)) (t *psy-db*))))
  (cond ((numberp fait)
             (cadr (nth (- (symeval-in-instance psy-db 'cycle) fait)
                        (symeval-in-instance psy-db 'just))))
        (t   (for i in (symeval-in-instance  psy-db 'just)
                  until (equal (symeval-in-instance (car i) 'value) fait)
                  finally (cadr i))))))


;** Fonction de justification d'un fait. Justifie la presence du fait    **
;** `fait' dans la base `base'. L'identificateur du fait peut etre une   **
;** liste qui le represente ou son numero de cycle                       **
(defun why (fait &optional base)
 (let ((ok-just (trouve-justif fait base)))
    (cond ((null ok-just)(msg #\T "Fait inexistente " #\N))
          ((equal ok-just "d")(msg #\T "Fait introduit comme donne" #\N))
          ((typep ok-just 'just)(funcall ok-just 'imprime))
          ( t  (msg #\T "Fait herite de la base " ok-just #\N)))))


;** Idem why mais si le fait a ete ajoute par une regle affiche aussi la **
;** partie description de la regle                                       **
(defun why+ (fait &optional base)
 (let ((ok-just (trouve-justif fait base)))
   (cond ((null ok-just)(msg #\T "Fait inexistente " #\N))
         ((eq ok-just "d")(msg #\T "Fait introduit comme donne" #\N))
         ((typep ok-just 'just)(funcall ok-just 'imprime)
                               (funcall ok-just 'descrip))
         ( t (msg #\T "Fait herite de la base " ok-just #\N)))))


;*** Fonction auxiliere qui fait un arret d'affichage chaque 30 lignes   **
(defun saut-ligne(i tab sl)
   (if (and sl (eq 0 (rem i 30)))
                       (progn ()
                           (msg "Tapez un caracter pour continuer" )
                           (read)))
   (if (> tab 0) (for j from 1 to tab
                         do (msg #\T)))
    t)


;** Retourne la trace d'execution des regles de la base `base' ou de tou-**
;** tes les bases si `base' est vide. Si `sl' n'est pas vide fait une    **
;** pause d'affichage toutes les 30 lignes                               **
(defun explain-exec (&optional base (sl nil))
  (let ((db (and base (get '*psy-kb* base)))
        (lignes 2)
        (tabs 0))
   (declare (special lignes))
   (declare (special tabs))
   (cond (db (msg #\N "L'execution des regles dans la base " base 
                      " a eu l'ordre suivant:" #\N)
              (funcall db 'explain-exec-base 0 t sl))
         (t  (msg #\N "Ordre d'execution des regles" #\N)
             (for bind (bases (symbol-plist '*psy-kb*) (cddr bases))
                        base
                        nom-base 
                  until (null bases)
                  do (setq nom-base (car bases))
                     (setq base (cadr bases))
                     (setq lignes (+ 2 lignes))  
                     (saut-ligne lignes tabs sl)
                     (msg #\N " Base : " nom-base #\N)
                     (funcall base 'explain-exec-base 0 t sl))))))


;** Affiche le "conflict-set" pendant une execution de regle de la base  **
;** `base'. Si retour n'est pas vide retourne une liste avec les noms des**
;** regles qui le composaient.                                           **
(defun cs-in-exec (exec base &optional (retour nil))
  (let* ((db  (get '*psy-kb* base))
         (node (and db (assoc exec (symeval-in-instance db 'reg-exec))))
         (cs (car (cdaddr node)))
         (nn 1)
          val-retour
         (r-cycles (cadddr node)))
    (and db
         (cond ((> exec (symeval-in-instance db 'nombre-exec))
                  (msg "Il n'y a pas " exec "executions" #\N))
               ((symeval-in-instance db 'permet-reexec)
                  (msg "0. " 
                       (take-rule-name (symeval-in-instance (cadr node) 
                                                            'name))
                       #\N) 
                  (and r-cycles
                       (progn ()
                         (msg "Regles recyclantes :" #\N)
                         (for r in r-cycles
                              bind (n nn (1+ n))
                              do (msg n ". " (take-rule-name 
                                    (symeval-in-instance r 'name)) #\N)
                              finally (setq nn (1+ n)))
                         (msg #\N "Autres regles" #\N)))
                  (for r in cs
                       bind (n nn (1+ n)) nom-regle
                       do  (setq nom-regle 
                                (take-rule-name  
                                    (symeval-in-instance r 'name)))
                           (push nom-regle val-retour)
                           (msg n ". " nom-regle #\N))
                  (msg #\N)
                  (and retour val-retour))
               (t (msg "Pour avoir cet information le systeme devait"
                       " tourner en mode reexecutable" #\N))))))


;** Retourne les appariements de l'execution `num-exec' de la base `base'**
(defun explain-num-exec (num-exec base)
  (let* ((db  (get '*psy-kb* base))
         (node (and db (assoc num-exec(symeval-in-instance db 'reg-exec))))
         (just (caaddr node)))
      (funcall just 'imprime)))


;** Methode qui affiche la justification d'un fait ajoute par une regle  **
(defmethod (just imprime)()
   (msg "La regle : " (take-rule-name (symeval-in-instance rule 'name))
        " de la base :" *psy-name-db* #\N 
        "a eu le comportement suivant :" #\N)
   (msg #\N #\T "Faits utilises :" #\N)
   (affiche util)
   (and remov
       (not (msg #\T "Faits effaces  :" #\N))
       (affiche (reverse remov)))
   (and adit
        (not (msg #\T "Faits ajoutes  :" #\N))
        (affiche (reverse adit))))


;** Methode qui affiche la description d'une regle justifiant un fait    **
(defmethod (just descrip) ()
 (msg #\N #\T "Description de la regle : " #\N)
 (for de in (symeval-in-instance rule 'desc)
      bind ligne
      do (setq ligne de)
         (msg #\T)
         (for i in ligne 
              do (msg i " "))
         (msg #\N)))


;** Affiche la liste des faits `l' avec son numero de cycle              **
(defun affiche(l)
       (for f in l 
            do (msg #\T #\T #\T #\T (symeval-in-instance f 'cycle) "." #\T 
                            (symeval-in-instance f 'value) #\N)))


;**************************************************************************
;** Fonctions qui aident la justification plus tard                      **
;**************************************************************************
;** Fonction qui memorise qu'un fait a ete ajoute par une regle,s'il est **
;** une donnee de depart, ou s'il a ete herite d'une base                **
(defun agrega (fait just base)
  (cond ((equal just "r") 
            ; le fait a ete ajoute par une regle
            (set-in-instance base 'just
                 (cons  (list fait *psy-just-point*)
                        (symeval-in-instance base 'just)))
            (set-in-instance *psy-just-point* 'adit
                (cons fait (symeval-in-instance *psy-just-point* 'adit))))
        ((null just) 
            ; le fait est une donne initiale
            (set-in-instance base 'just
                 (cons  (list fait "d") 
                        (symeval-in-instance base 'just))))
        (t  ; le fait a ete herite de la base just
            (set-in-instance base 'just
                 (cons  (list fait just)
                        (symeval-in-instance base 'just))))))


;** Fonction qui memorise qu'un fait a ete efface par une regle          **
(defun elimina (fait)
   (set-in-instance *psy-just-point* 'remov 
        (cons fait (symeval-in-instance *psy-just-point* 'remov))))
