/*****************************************************************************/
/* module autoconvert.c							     */
/*									     */
/* Author: Alain Jacot-Descombes					     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   January 1989							     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <math.h>

#include "define.h"
#include "structure.h"
#include "global.h"
#include "type.h"

#define MAXFLOAT       ((float)1.7014118219281863150e+38)
#define MINFLOAT (-MAXFLOAT)

struct directoire_image buffer_image[2];
struct description_memoire buffer_desc[2];

Panel_item autoconvpaneltitre;
Panel_item  minarr, maxarr, mindep, maxdep, actval;
Panel	    acpanel_convert, acpanel_seuil;
Frame	    acframe_convert, acframe_seuil;
Panel_item  acbarre_seuil, acbouton_ok, acbouton_cancel;
int	autoconvval_seuil, flag_ccompl = FALSE;
char	rep[80];


extern char *paneltabs[];
extern char *mastertabs[];
extern char *labeltabs[];
/*****************************************************************************/

static Panel_setting lire_paramconvert (item, event)
    Panel_item item;
    Event *event;

{
    static struct convert conv;
    int no_dep_plan;

    if (event_id(event) == CTRLC) {
    /* demande d'interruption de l'interaction par l'utilisateur */
	no_dep_plan = (int) panel_get(autoconvpaneltitre, PANEL_CLIENT_DATA);
	conv.mind = (int) dir_desc[no_dep_plan].mu;
	conv.maxd = 0;
	conv.mina = 0;
	conv.maxa = 0;
        if (item != actval){ 
	    conv.maxd = dir_desc[no_dep_plan].mmax;
	    conv.mina = dir_desc[no_dep_plan].mmin;
	    conv.maxa = dir_desc[no_dep_plan].mmax;
	}
    }
    else { 
        if (event_id(event) == '\t') 
	    return(PANEL_NEXT);
	else {
	  if (item == actval){
	    strcpy (rep, (char *)panel_get(actval,PANEL_VALUE));
	    conv.mind = atof((char *)panel_get(actval, PANEL_VALUE));
	    conv.maxd = 0;
	    conv.mina = 0;
	    conv.maxa = 0;
	  }
	  else{
	    strcpy (rep, (char *)panel_get(mindep,PANEL_VALUE));
	    conv.mind = atof((char *)panel_get(mindep, PANEL_VALUE));
/*	    conv.flag_mind = FALSE; */	
	    strcpy (rep, (char *)panel_get(maxdep,PANEL_VALUE));
	    conv.maxd = atof((char *)panel_get(maxdep, PANEL_VALUE));
	  /*  conv.flag_maxd = FALSE; */	
	    strcpy (rep, (char *)panel_get(minarr,PANEL_VALUE));
	    conv.mina = atof((char *)panel_get(minarr, PANEL_VALUE));
	/*    conv.flag_mina = FALSE; */	
	    strcpy (rep, (char *)panel_get(maxarr,PANEL_VALUE));
	    conv.maxa = atof((char *)panel_get(maxarr, PANEL_VALUE));
	 /*   conv.flag_maxa = FALSE; */
	  }	
	}
    }
    window_return(&conv);
    window_destroy (acframe_convert);
    return;

}

/*****************************************************************************/

complete (stitre, select)

    char stitre[40];
    int select;
    
{
    switch (select) {
        case -1:strcat (stitre, "'BINARY'"); break;
	case 0: strcat (stitre, "'BYTE'"); break;
	case 1: strcat (stitre, "'SHORT'"); break;
	case 2: strcat (stitre, "'INT'"); break;
	case 3: strcat (stitre, "'FLOAT'"); break;
    }
    return;
}

/*****************************************************************************/

struct convert *autoconvert_panel (nodep, type_arr)
    short type_arr, nodep;
{

    char *repfloat, repint[10];
    char stitre[40];
    struct convert *conv;

    repfloat = (char *)malloc(20);
    acframe_convert = window_create (frame, FRAME, WIN_X, 500, WIN_Y, 500,
                         FRAME_NO_CONFIRM, TRUE, 0);
    acpanel_convert = window_create (acframe_convert, PANEL, PANEL_LABEL_BOLD,
			 TRUE, 0);

    strcpy (stitre, paneltabs[21]);
    complete (stitre, dir_desc[nodep].type);
    strcat (stitre, paneltabs[22]);
    complete (stitre, type_arr);
    strcat (stitre, "\n");
    autoconvpaneltitre = panel_create_item (acpanel_convert, PANEL_MESSAGE,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_LABEL_STRING, stitre,
		       PANEL_CLIENT_DATA, (caddr_t) nodep,
                       0);
    sprintf (repfloat, "%f\0", dir_desc[nodep].mmin); 
    if (type_arr > -1){ 
	mindep = panel_create_item (acpanel_convert, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[23],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_paramconvert,
                       0);
	sprintf (repfloat, "%f\0", dir_desc[nodep].mmax);  
	maxdep = panel_create_item (acpanel_convert, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[24],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_paramconvert,
                       0);
	if (dir_desc[nodep].type < type_arr)
	sprintf (repfloat, "%f\0", dir_desc[nodep].mmin);
	else sprintf (repfloat, "0\0");  
	minarr = panel_create_item (acpanel_convert, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[25],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_paramconvert,
                       0);
	if (dir_desc[nodep].type < type_arr)
	    sprintf (repfloat, "%f", dir_desc[nodep].mmax);
	else sprintf (repfloat, "255");  
	maxarr = panel_create_item (acpanel_convert, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[26],
                       PANEL_VALUE, repfloat,
                       PANEL_NOTIFY_STRING, "\r\n\t\03",
                       PANEL_NOTIFY_PROC, lire_paramconvert,
                       0);
    }
    else {
	sprintf (repint, "%d", (int)dir_desc[nodep].mu);  
	actval = panel_create_item (acpanel_convert, PANEL_TEXT,
                       PANEL_SHOW_ITEM, TRUE,
                       PANEL_VALUE_DISPLAY_LENGTH, 20,
                       PANEL_VALUE_STORED_LENGTH, 20,
                       PANEL_LABEL_STRING, paneltabs[26],
                       PANEL_VALUE, repint,
                       PANEL_NOTIFY_STRING, "\r\03",
                       PANEL_NOTIFY_PROC, lire_paramconvert,
                       0);
    }
    window_fit (acpanel_convert);
    window_fit (acframe_convert);
    if (type_arr == -1) window_set (acpanel_convert, PANEL_CARET_ITEM, actval, 0);
    else window_set (acpanel_convert, PANEL_CARET_ITEM, mindep, 0);
    conv = (struct convert *)window_loop(acframe_convert);
    free(repfloat);
    return(conv);
}

/*****************************************************************************/
/*									     */
/* nom      : autoconvert_byte						     */
/*									     */
/* fonction : convertit l'image dir_image[no_dep].image en byte et la	     */
/*	      stocke dans buffer_image[0].image.			     */
/*                                                                           */
/* entrees  : int no_dep	        : no du plan-image de depart         */
/*            int no_arr	        : no du plan-image d'arrivee         */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/

int  autoconvert_byte (no_dep)
int no_dep;
{
    unsigned char *im, *debut;
    register int j;
    int taille;
    register float delta, minim;
    register int minarr;
    struct convert *conv, *copyconv;


    sprintf (buf, mastertabs[350]);
    write_master (buf);

	conv = autoconvert_panel (no_dep, 0);
/*	if (flag_break) interruption();
	else{ */
	    sprintf(buf, "byte img %d", no_dep);
	    write_master (buf);
	    taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
	    debut = im = (unsigned char *) malloc (taille);
/*	    if (conv->flag_mind) conv->mind = dir_desc[no_dep].mmin;
	    if (conv->flag_maxd) conv->maxd = dir_desc[no_dep].mmax;
	    if (conv->flag_mina) conv->mina = dir_desc[no_dep].mmin;
	    if (conv->flag_maxa) conv->maxa = dir_desc[no_dep].mmax;
*/
	    sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n\0", 
		     conv->mind, conv->maxd, conv->mina, conv->maxa);
	    write_master (buf);
	    if (dir_desc[no_dep].mmin >= MINBYTE && 
		dir_desc[no_dep].mmax <= MAXBYTE &&
		dir_desc[no_dep].mmin == conv->mind &&
			   conv->mind == conv->mina &&
		dir_desc[no_dep].mmax == conv->maxd &&
			   conv->maxd == conv->maxa)
            {
		    /* image depart comprise dans l'intervalle des byte */
		    /* +pas changement dynamique = convertir avec les "cast" */
		 switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {  
			    /* image de depart de type unsigned char(recopie)*/
			    unsigned char *b;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (unsigned char)*b;
				im++;  b++;
			    }
			    break;
			}        
			case 1 : {   /* image de depart de type short */
			    short *s;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (unsigned char)*s;
				im++;  s++;
			    }
			    break; 
			}       
			case 2 : {   /* image de depart de type int */
			    int *i;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (unsigned char)*i;
				im++;  i++;
			    }
			    break;
			}        
			case 3 : {   /* image de depart de type float */
			    float *f;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (unsigned char)*f;
				im++;  f++;
			    }
			    break;
			}
		    }
		    /* les statistiques de l'image d'arrivee sont inchangees */
		    if (buffer_image[0].image != NULL)
			free(buffer_image[0].image);
		    buffer_image[0].image = (unsigned char *)debut;
		    buffer_desc[0]  = dir_desc[no_dep];
		    buffer_desc[0].type = 0;
		}
		else { /* else with if dir_desc..... */
		    /* on fait une regle de trois en etalant la dynamique de */
		    /* l'intervalle de depart sur la dynamique choisie	*/
		    delta=(conv->maxa - conv->mina)/(conv->maxd - conv->mind);
		    minim = conv->mind;
		    minarr = (int)conv->mina;
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {   /* l'image de depart est de type byte */
			    unsigned char *b, bb;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*b > conv->maxd) bb = conv->maxd;
				else if (*b < conv->mind) bb = conv->mind;
			    	else bb = *b;
				*im = (unsigned char)
				    (((bb - minim) * delta + minarr) + 0.5);
				im++;  b++;
			    }
			    break;
			}
			case 1 : {   /* image de depart de type short */
			    short *s, ss;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*s > conv->maxd) ss = conv->maxd;
				else if (*s < conv->mind) ss = conv->mind;
				else ss = *s;
				*im = (unsigned char)
				    (((ss - minim) * delta + minarr) + 0.5);
				im++;  s++;
			    }
			    break;
			}
			case 2 : {   /* image de depart de type int */
			    int *i, ii;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*i > conv->maxd) ii = conv->maxd;
				else if (*i < conv->mind) ii = conv->mind;
				else ii = *i;
				*im = (unsigned char)
				    (((ii - minim) * delta + minarr) + 0.5);
				im++;  i++;
			    }
			    break;
			}
			case 3 : {   /* image de depart de type float */
			    float *f, ff;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*f > conv->maxd) ff = conv->maxd;
				else if (*f < conv->mind) ff = conv->mind;
				else ff = *f;
				*im = (unsigned char)
				    (((ff - minim) * delta + minarr) + 0.5);
				im++;  f++;
			    }
			    break;
			}
		    }
		    /* on doit recalculer les statistiques de l'image */    
		    if (buffer_image[0].image != NULL)
			free(buffer_image[0].image);
		    buffer_image[0].image = (unsigned char *)debut;
		    buffer_desc[0] = dir_desc[no_dep];
		    buffer_desc[0].mmin = conv->mina;
		    buffer_desc[0].mmax = conv->maxa;
		    buffer_desc[0].type = 0;
		    statis (buffer_image[0].image, buffer_desc[0].type, 
			buffer_desc[0].nligne, buffer_desc[0].ncolonne,
			&(buffer_desc[0].mmin), &(buffer_desc[0].mmax), 
			&(buffer_desc[0].mu), &(buffer_desc[0].ecart));

		}
/*	} */
}



/*****************************************************************************/
/*									     */
/* nom      : autoconvert_short						     */
/*									     */
/* fonction : convertit l'image dir_image[no_dep].image en short et la	     */
/*	      stocke dans buffer_image[0].image.			     */
/*                                                                           */
/* entrees  : int no_dep	        : no du plan-image de depart         */
/*            int no_arr	        : no du plan-image d'arrivee         */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/

int autoconvert_short (no_dep)
int no_dep;

{
    short *im, *debut;
    register int j;
    int taille;
    register float delta, minim;
    register int minarr;
    struct convert *conv, *copyconv;

    sprintf (buf, mastertabs[350]);
    write_master (buf);

	conv = autoconvert_panel (no_dep, 1);
/*	if (flag_break) interruption();
	else{ */
	    sprintf(buf, "short img %d", no_dep);
	    write_master (buf);
	    taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
	    debut = im = (short *) malloc (taille * 2);
							/* 2 bytes par short */
/*	    if (conv->flag_mind) conv->mind = dir_desc[no_dep].mmin;
	    if (conv->flag_maxd) conv->maxd = dir_desc[no_dep].mmax;
	    if (conv->flag_mina) conv->mina = dir_desc[no_dep].mmin;
	    if (conv->flag_maxa) conv->maxa = dir_desc[no_dep].mmax;
*/
	    sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n\0", 
		     conv->mind, conv->maxd, conv->mina, conv->maxa);
	    write_master (buf);
	    if (dir_desc[no_dep].mmin >= MINSHORT &&
	        dir_desc[no_dep].mmax <= MAXSHORT &&
		dir_desc[no_dep].mmin == conv->mind &&
			  conv->mind  == conv->mina &&
		dir_desc[no_dep].mmax == conv->maxd &&
		conv->maxd==conv->maxa){
		    /* image depart comprise dans l'intervalle des short    */
		    /* +pas changement dynamique = convertir avec les "cast" */
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {  /* image de depart de type unsigned char */
			    unsigned char *b;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (short)*b;
				im++;  b++;
			    }
			    break;
			}        
			case 1 : { /* image de depart de type short (recopie)*/
			    short *s;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (short)*s;
				im++;  s++;
			    }
			    break; 
			}       
			case 2 : {   /* image de depart de type int */
			    int *i;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (short)*i;
				im++;  i++;
			    }
			    break;
			}        
			case 3 : {   /* image de depart de type float */
			    float *f;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (short)*f;
				im++;  f++;
			    }
			    break;
			}        
		    }
		    /* les statistiques de l'image d'arrivee sont inchangees */
		    if (buffer_image[0].image != NULL) 
			free(buffer_image[0].image);
		    buffer_image[0].image = (unsigned char *)debut;
		    buffer_desc[0] = dir_desc[no_dep];
		    buffer_desc[0].type = 1;
		}
		else { 
		    /* on fait une regle de trois en etalant la dynamique de */
		    /* l'intervalle de depart sur la dynamique choisie	*/
		    delta=(conv->maxa - conv->mina)/(conv->maxd - conv->mind);
		    minim = conv->mind;
		    minarr = (int)conv->mina;
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {   /* l'image de depart est de type byte */
			    unsigned char *b, bb;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*b > conv->maxd) bb = conv->maxd;
				else if (*b < conv->mind) bb = conv->mind;
				else bb = *b;
				*im = (short)
				    (((bb - minim) * delta + minarr) + 0.5);
				im++;  b++;
			    }
			    break;
			}
			case 1 : {   /* l'image de depart est de type short */
			    short *s, ss;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*s > conv->maxd) ss = conv->maxd;
				else if (*s < conv->mind) ss = conv->mind;
				else ss = *s;
				*im = (short)
				    (((ss - minim) * delta + minarr) + 0.5);
				im++;  s++;
			    }
			    break;
			}
			case 2 : {   /* l'image de depart est de type int */
			    int *i, ii;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*i > conv->maxd) ii = conv->maxd;
				else if (*i < conv->mind) ii = conv->mind;
				else ii = *i;
				*im = (short)
				    (((ii - minim) * delta + minarr) + 0.5);
				im++;  i++;
			    }
			    break;
			}
			case 3 : {   /* l'image de depart est de type float */
			    float *f, ff;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*f > conv->maxd) ff = conv->maxd;
				else if (*f < conv->mind) ff = conv->mind;
				else ff = *f;
				*im = (short)
				    (((ff - minim) * delta + minarr) + 0.5);
				im++;  f++;
			    }
			    break;
			}
		    }
		    /* on doit recalculer les statistiques de l'image */
		    if (buffer_image[0].image != NULL) 
			free(buffer_image[0].image);
		    buffer_image[0].image = (unsigned char *)debut;
		    buffer_desc[0] = dir_desc[no_dep];
		    buffer_desc[0].mmin = conv->mina;
		    buffer_desc[0].mmax = conv->maxa;
		    buffer_desc[0].type = 1;
		    statis (buffer_image[0].image, buffer_desc[0].type, 
			buffer_desc[0].nligne, buffer_desc[0].ncolonne,
			&(buffer_desc[0].mmin), &(buffer_desc[0].mmax), 
			&(buffer_desc[0].mu), &(buffer_desc[0].ecart));
		}
/*	} */
}


/*****************************************************************************/
/*									     */
/* nom      : autoconvert_integer						     */
/*									     */
/* fonction : convertit l'image dir_image[no_dep].image en entier et la	     */
/*	      stocke dans buffer_image[0].image.			     */
/*                                                                           */
/* entrees  : int no_dep	        : no du plan-image de depart         */
/*            int no_arr	        : no du plan-image d'arrivee         */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/

int autoconvert_integer (no_dep)
int no_dep;
{
    int *im, *debut;
    register int j;
    int taille;
    register float delta, minim;
    register int minarr;
    struct convert *conv, *copyconv;

    sprintf (buf, mastertabs[350]);
    write_master (buf);
	conv = autoconvert_panel (no_dep, 2);

/*	if (flag_break) interruption();
	else{ */
	    sprintf(buf, "integer img %d", no_dep);
	    write_master (buf);
	    taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
	    debut = im = (int *) malloc (taille * 4);
							/* 4 bytes part int */
/*	    if (conv->flag_mind) conv->mind = dir_desc[no_dep].mmin;
	    if (conv->flag_maxd) conv->maxd = dir_desc[no_dep].mmax;
	    if (conv->flag_mina) conv->mina = dir_desc[no_dep].mmin;
	    if (conv->flag_maxa) conv->maxa = dir_desc[no_dep].mmax;
*/
	    sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n\0", 
		    conv->mind, conv->maxd, conv->mina, conv->maxa);
	    write_master (buf);
	    if (dir_desc[no_dep].mmin >= MININT &&
		dir_desc[no_dep].mmax <= MAXINT &&
		dir_desc[no_dep].mmin == conv->mind && 
		           conv->mind == conv->mina &&
		dir_desc[no_dep].mmax == conv->maxd &&
			   conv->maxd == conv->maxa){
		    /* image depart comprise dans l'intervalle des int      */
		    /* +pas changement dynamique = convertir avec les "cast" */
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {   /* image de depart en unsigned char */
			    unsigned char *b;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (int)*b;
				im++;  b++;
			    }
			    break;
			}        
			case 1 : {   /* image de depart en short */
			    short *s;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (int)*s;
				im++;  s++;
			    }
			    break; 
			}       
			case 2 : {   /* image de depart en int (recopie) */
			    int *i;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (int)*i;
				im++;  i++;
			    }
			    break;
			}        
			case 3 : {   /* image de depart en float */
			    float *f;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (int)*f;
				im++;  f++;
			    }
			    break;
			}        
		    }
		    /* les statistiques de l'image d'arrivee sont inchangees */
		    if (buffer_image[0].image != NULL) 
			free(buffer_image[0].image);
		    buffer_image[0].image = (unsigned char *)debut;
		    buffer_desc[0] = dir_desc[no_dep];
		    buffer_desc[0].type = 2;    
		}
		else {  
		    /* on fait une regle de trois en etalant la dynamique de */
		    /* l'intervalle de depart sur toute la dynamique des int */
		    delta = (conv->maxa - conv->mina) / 
			    (dir_desc[no_dep].mmax - dir_desc[no_dep].mmin);
		    minim = dir_desc[no_dep].mmin;
		    minarr = (int)conv->mina;
		    buffer_desc[0].mmin = conv->mina;
		    buffer_desc[0].mmax = conv->maxa;
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {   /* l'image de depart est de type byte */
			    unsigned char *b, bb;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*b > conv->maxd) bb = conv->maxd;
				else if (*b < conv->mind) bb = conv->mind;
				else bb = *b;
				*im = (int)
				    (((bb - minim) * delta + minarr) + 0.5);
				im++;  b++;
			    }
			    break;
			}
			case 1 : {   /* l'image de depart est de type short */
			    short *s, ss;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*s > conv->maxd) ss = conv->maxd;
				else if (*s < conv->mind) ss = conv->mind;
				else ss = *s;
				*im = (int)
				    (((ss - minim) * delta + minarr) + 0.5);
				im++;  s++;
			    }
			    break;
			}
			case 2 : {   /* l'image de depart est de type int */
			    int *i, ii;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*i > conv->maxd) ii = conv->maxd;
				else if (*i < conv->mind) ii = conv->mind;
				else ii = *i;
				*im = (int)
				    (((ii - minim) * delta + minarr) + 0.5);
				im++;  i++;
			    }
			    break;
			}
			case 3 : {   /* l'image de depart est de type float */
			    float *f, ff;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*f > conv->maxd) ff = conv->maxd;
				else if (*f < conv->mind) ff = conv->mind;
				else ff = *f;
				*im = (int)
				    (((ff - minim) * delta + minarr) + 0.5);
				im++;  f++;
			    }
			break;
			}
		    }
/* ### 18 septembre 1989 */
		    /* on doit recalculer les statistiques de l'image */
		    if (buffer_image[0].image != NULL) 
			free(buffer_image[0].image);
		    buffer_image[0].image = (unsigned char *)debut;
		    buffer_desc[0] = dir_desc[no_dep];
		    buffer_desc[0].mmin = conv->mina;
		    buffer_desc[0].mmax = conv->maxa;
		    buffer_desc[0].type = 2;
/* ### */
		    statis (buffer_image[0].image, buffer_desc[0].type, 
			buffer_desc[0].nligne, buffer_desc[0].ncolonne,
			&(buffer_desc[0].mmin), &(buffer_desc[0].mmax), 
			&(buffer_desc[0].mu), &(buffer_desc[0].ecart));
		}
/*	} */
}


/*****************************************************************************/
/*									     */
/* nom      : autoconvert_float						     */
/*									     */
/* fonction : convertit l'image dir_image[no_dep].image en float et la	     */
/*	      stocke dans buffer_image[0].image.			     */
/*                                                                           */
/* entrees  : int no_dep	        : no du plan-image de depart         */
/*            int no_arrs	        : no du plan-image d'arrivee         */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/

int autoconvert_float (no_dep)
int no_dep;
{
    float *im, *debut;
    register int j;
    int taille;
    register float delta, minim;
    register int minarr;
    struct convert *conv, *copyconv;

    if (flag_ccompl) sprintf (buf,mastertabs[29]);
    else sprintf (buf, mastertabs[30]);
    write_master (buf);
/*    if (flag_ccompl) {

    }
    else 
    if (flag_break) interruption();
    else{ */
	conv = autoconvert_panel (no_dep, 3);
/*	if (flag_break) interruption();
	else{ */
	    sprintf(buf, "float img %d", no_dep);
	    write_master (buf);
		taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
		debut = im = (float *) malloc (taille * 4);  
							/* 4 bytes par float */
/*		if (conv->flag_mind) conv->mind = dir_desc[no_dep].mmin;
		if (conv->flag_maxd) conv->maxd = dir_desc[no_dep].mmax;
		if (conv->flag_mina) conv->mina = dir_desc[no_dep].mmin;
		if (conv->flag_maxa) conv->maxa = dir_desc[no_dep].mmax;
*/
		sprintf (buf, "(%.2f,%.2f -> %.2f,%.2f)\n\0", 
			conv->mind, conv->maxd, conv->mina, conv->maxa);
		write_master (buf);
		if (dir_desc[no_dep].mmin>=MINFLOAT &&
		    dir_desc[no_dep].mmax<=MAXFLOAT &&
		    dir_desc[no_dep].mmin==conv->mind&&conv->mind==conv->mina&&
		    dir_desc[no_dep].mmax==conv->maxd&&conv->maxd==conv->maxa){
		    /* image depart comprise dans l'intervalle des float    */
		    /* +changement dynamique = convertir avec les "cast" */
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {  /* image de depart de type unsigned char */
			    unsigned char *b;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (float)*b;
				im++;  b++;
			    }
			    break;
			 }        
			case 1 : {   /* image de depart de type short */
			    short *s;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (float)*s;
				im++;  s++;
			    }
			    break; 
			}       
			case 2 : {   /* image de depart de type int */
			    int *i;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (float)*i;
				im++;  i++;
			    }
			    break;
			}        
			case 3 : {   /* image de depart de type float */
			    float *f;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				*im = (float)*f;
				im++;  f++;
			    }
			    break;
			} 
		    }       
		    /* les statistiques de l'image d'arrivee sont inchangees */
		    if (buffer_image[0].image != NULL) 
			free(buffer_image[0].image);
		    buffer_image[0].image = (unsigned char *)debut;
		    buffer_desc[0] = dir_desc[no_dep];
		    buffer_desc[0].type = 3;
		}
		else {
		    /* on fait une regle de trois en etalant la dynamique de */
		    /* l'intervalle de depart sur toute la dynamique des int */
		    delta = (conv->maxa - conv->mina) / 
			    (dir_desc[no_dep].mmax - dir_desc[no_dep].mmin);
		    minim = dir_desc[no_dep].mmin;
		    minarr = (int)conv->mina;
		    switch (dir_desc[no_dep].type) {
			case -1:
			case 0 : {   /* l'image de depart est de type byte */
			    unsigned char *b, bb;
			    b = (unsigned char *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*b > conv->maxd) bb = conv->maxd;
				else if (*b < conv->mind) bb = conv->mind;
				else bb = *b;
				*im = (float)
				    (((bb - minim) * delta + minarr) + 0.5);
				im++;  b++;
			    }
			    break;
			}
			case 1 : {   /* l'image de depart est de type short */
			    short *s, ss;
			    s = (short *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*s > conv->maxd) ss = conv->maxd;
				else if (*s < conv->mind) ss = conv->mind;
				else ss = *s;
				*im = (float)
				    (((ss - minim) * delta + minarr) + 0.5);
				im++;  s++;
			    }
			    break;
			}
			case 2 : {   /* l'image de depart est de type int */
			    int *i, ii;
			    i = (int *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*i > conv->maxd) ii = conv->maxd;
				else if (*i < conv->mind) ii = conv->mind;
				else ii = *i;
				*im = (float)
				    (((ii - minim) * delta + minarr) + 0.5);
				im++;  i++;
			    }
			    break;
			}
			case 3 : {   /* l'image de depart est de type float */
			    float *f, ff;
			    f = (float *)dir_image[no_dep].image;
			    for (j=0; j < taille; j++) {
				if (*f > conv->maxd) ff = conv->maxd;
				else if (*f < conv->mind) ff = conv->mind;
				else ff = *f;
				*im = (float)
				    (((ff - minim) * delta + minarr) + 0.5);
				im++;  f++;
			    }
			break;
			}
		    }
		    if (buffer_image[0].image != NULL) 
			free(buffer_image[0].image);
/* 18 septembre 1989 */
/* im --> debut	     */
		    buffer_image[0].image = (unsigned char *)debut;
/* */
		    buffer_desc[0] = dir_desc[no_dep];
		    buffer_desc[0].type = 3;
		    buffer_desc[0].mmin = conv->mina;
		    buffer_desc[0].mmax = conv->maxa;
		    statis (buffer_image[0].image, buffer_desc[0].type, 
			buffer_desc[0].nligne, buffer_desc[0].ncolonne,
			&(buffer_desc[0].mmin), &(buffer_desc[0].mmax), 
			&(buffer_desc[0].mu), &(buffer_desc[0].ecart));
		}
/*	}  */
	    if (flag_ccompl){
		taille = dir_desc[no_dep].ncolonne * dir_desc[no_dep].nligne;
		im = (float *) calloc (taille, sizeof(float));
		if (buffer_image[1].image != NULL)
		    free (buffer_image[1].image);
		buffer_image[1].image = (unsigned char *) im;
		/* mise a 0 du plan imaginaire (ou argument) */
		for (j = 0; j < taille; j++){
		    *im = 0.0;
		    *im++;	
		}
		/* mise a jour des statistiques du plan imaginaire */
		buffer_desc[1] = dir_desc[no_dep];
		buffer_desc[1].type = 3;
		buffer_desc[1].mmin = 0;
		buffer_desc[1].mmax = 0;
		buffer_desc[1].mu = 0;
		buffer_desc[1].ecart = 0;
	    }
/*    } */
}

/*****************************************************************************/
/*									     */
/* nom      : autoconvert_complex						     */
/*									     */
/* fonction : convertit l'image dir_image[no_dep].image en complexes et la   */
/*	      stocke dans buffer_image[0].image.			     */
/*                                                                           */
/* entrees  : int no_dep	        : no du plan-image de depart         */
/*            int no_arr	        : no du plan-image d'arrivee         */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/

int autoconvert_complex ()

{
    float *im;
    int taille, j;

    flag_ccompl = TRUE;
    autoconvert_float ();
    flag_ccompl = FALSE;
}

/*****************************************************************************/
/*									     */
/* nom      : pplans_complexes						     */
/*									     */
/* fonction : verifie si les deux plans-images forment une image complexe    */
/*            (si les 2 plans existent et ont la meme taille)                */
/*                                                                           */
/* entrees  : int n1		        : no du 1er plan	             */
/*            int n2			: no du 2eme plan		     */
/*                                                                           */
/* globales : dir_desc							     */
/*									     */
/* return   : TRUE			: les 2 plans forment une im. compl. */
/*            FALSE			: sinon				     */
/*									     */
/* routines : write_erreur						     */
/*									     */
/*****************************************************************************/

int pplans_complexes (n1, n2)

    int n1, n2;

{
    if (dir_desc[n1].nligne != dir_desc[n2].nligne ||
        dir_desc[n1].ncolonne!=dir_desc[n2].ncolonne) {
            /* taille differente */
	    write_erreur(2);
            return(FALSE);
    }
    if (dir_image[n1].image == NULL) {
        /* plan reel (ou norme) vide */
	write_erreur(9);
        return(FALSE);
    }
    if (dir_image[n2].image == NULL) {
        /* plan imaginaire (ou argument) vide */
	write_erreur(10);
        return(FALSE);
    }
    return (TRUE);
}

/*****************************************************************************/
/*									     */
/* nom      : autoconvert_cart_en_pol					     */
/*									     */
/* fonction : convertit l'image complexe cartesienne			     */
/*	      dir_image[no_dep1 et no_dep2].image en une image complexe	     */
/*	      polaire dir_image[no_arr1 et no_arr2].image		     */
/*                                                                           */
/* entrees  : int no_dep1	        : no du plan de depart reel          */
/*            int no_dep2		: no du plan de depart imaginaire    */
/*            int no_arr1	        : no du plan d'arrivee norme         */
/*            int no_arr2		: no du plan d'arrivee argument	     */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/
 
int autoconvert_cart_en_pol (no_dep1, no_dep2)
 int no_dep1, no_dep2;
{
    float *x, *y, *module, *arg, *deb_m, *deb_a;
    register int taille, n;

    sprintf (buf, mastertabs[350]);
    write_master (buf);
/*    if (flag_break) interruption();
    else{ */
	    sprintf(buf,"(%d,%d)\n", no_dep1, no_dep2);
	    write_master (buf);
	    if (pplans_complexes(no_dep1,no_dep2)==TRUE){
		taille = dir_desc[no_dep1].nligne * dir_desc[no_dep1].ncolonne;
		x = (float *) dir_image[no_dep1].image;
		y = (float *) dir_image[no_dep2].image;
		deb_m = module = (float *)malloc(taille*4);
		deb_a = arg = (float *)malloc(taille*4);

		for ( n = 0 ; n < taille ; n++){
		    *module = (float) hypot((double) *x , (double) *y);
		    if (*x==0)
			if (*y>0) *arg = M_PI_2;
			else if (*y<0) *arg = - M_PI_2;
			else *arg = 0;
		    else
			*arg = (float) atan ( (double) *y / (double) *x);
		    module++;  arg++;
		    x++;  y++;
		}

		if (buffer_image[0].image != NULL)
		    free (buffer_image[0].image);
		if (buffer_image[1].image != NULL)
		    free (buffer_image[1].image);
		buffer_image[0].image = (unsigned char *)deb_m;
		buffer_image[1].image = (unsigned char *)deb_a;

		/* recopie globale des descripteurs */
		buffer_desc[0] = dir_desc[no_dep1];
		buffer_desc[1] = dir_desc[no_dep2];

		/* calcul des statistiques pour le plan-norme */
		statis (buffer_image[0].image, buffer_desc[0].type,
			buffer_desc[0].nligne, buffer_desc[0].ncolonne,
			&(buffer_desc[0].mmin),&(buffer_desc[0].mmax), 
			&(buffer_desc[0].mu), &(buffer_desc[0].ecart)); 
		/* calcul des statistiques pour le plan-argument */
		statis (buffer_image[1].image, buffer_desc[1].type, 
			buffer_desc[1].nligne, buffer_desc[1].ncolonne,
			&(buffer_desc[1].mmin),&(buffer_desc[1].mmax), 
			&(buffer_desc[1].mu), &(buffer_desc[1].ecart)); 
	    }
/*    }  */
}

/*****************************************************************************/
/*									     */
/* nom      : autoconvert_pol_en_cart					     */
/*									     */
/* fonction : convertit l'image complexe polaire			     */
/*	      dir_image[no_dep1 et no_dep2].image en une image complexe	     */
/*	      cartesienne dir_image[no_arr1 et no_arr2].image		     */
/*                                                                           */
/* entrees  : int no_dep1	        : no du plan de depart norme         */
/*            int no_dep2		: no du plan de depart argument      */
/*            int no_arr1	        : no du plan d'arrivee reel          */
/*            int no_arr2		: no du plan d'arrivee imaginaire    */
/*                                                                           */
/* globales : dir_desc							     */
/*	      dir_image							     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : statis							     */
/*									     */
/*****************************************************************************/
 
int autoconvert_pol_en_cart (no_dep1, no_dep2)
    int no_dep1, no_dep2;
{
    float *x, *y, *module, *arg, *deb_x, *deb_y;
    register int taille, n;

    sprintf (buf, mastertabs[350]);
    write_master (buf);
/*    if (flag_break) interruption();
    else{ */
	    sprintf(buf, "(%d,%d)\n", no_dep1, no_dep2);
	    write_master (buf);
	    if (pplans_complexes(no_dep1,no_dep2)==TRUE){
		taille = dir_desc[no_dep1].nligne * dir_desc[no_dep1].ncolonne;
		module = (float *) dir_image[no_dep1].image;
		arg = (float *) dir_image[no_dep2].image;
		deb_x = x = (float *)malloc(taille*4);
		deb_y = y = (float *)malloc(taille*4);

		for ( n = 0 ; n < taille ; n++){
		    *x = *module * cos (*arg);
		    *y = *module * sin (*arg);
		    x++;  y++;
		    module++;  arg++;
		}
		if (buffer_image[0].image != NULL)
		    free (buffer_image[0].image);
		if (buffer_image[1].image != NULL)
		    free (buffer_image[1].image);
		buffer_image[0].image = (unsigned char *)deb_x;
		buffer_image[1].image = (unsigned char *)deb_y;

		/* recopie globale des descripteurs */
		buffer_desc[0] = dir_desc[no_dep1];
		buffer_desc[1] = dir_desc[no_dep2];

		/* calcul des statistiques pour le plan-reel */
		statis (buffer_image[0].image, buffer_desc[0].type, 
			buffer_desc[0].nligne, buffer_desc[0].ncolonne,
			&(buffer_desc[0].mmin),&(buffer_desc[0].mmax), 
			&(buffer_desc[0].mu), &(buffer_desc[0].ecart)); 
		/*calcul des statistiques pour le plan-imaginaire */
		statis (buffer_image[1].image, buffer_desc[1].type, 
			buffer_desc[1].nligne, buffer_desc[1].ncolonne,
			&(buffer_desc[1].mmin),&(buffer_desc[1].mmax), 
			&(buffer_desc[1].mu), &(buffer_desc[1].ecart));
	    }
/*    }  */
}

/*****************************************************************************/


/*****************************************************************************/

/*int valid_conversion (ff)

    float ff[4];

{
    if (ff[0]>ff[1]) {
    }
    if (ff[2]>ff[3]) {
    }
    else {
	   
    }   
}
*/
/*****************************************************************************/
/*                							     */
/* nom      : creer_plan_bin 						     */
/*									     */
/* fonction : rend "binaire" (0 et 255) l'image pointee par                  */
/*	      dir_image[no_dep1].image en appliquant un seuil	     */
/*									     */
/* entrees  : int valeur                : valeur du seuil                    */
/*									     */
/* globales : dir_image					                     */
/*            dir_desc                                                       */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : statis							     */
/*								             */
/*****************************************************************************/

void autoconvcreer_plan_bin (no_dep1, no_arr)

int no_dep1, no_arr;
  
{
    int taille, valeur;
    unsigned char *image, *debut;
    register unsigned char *b;
    register short *s;
    register int *i, x, y;
    register float *f;
    struct convert *conv;

    sprintf (buf, mastertabs[350]);
    write_master (buf);
    sprintf(buf, "bin img %d,", no_dep1);
    write_master (buf);
    conv = autoconvert_panel (no_dep1, -1);
    valeur = conv->mind;
    sprintf(buf, "threshold %d\n", valeur);
    write_master (buf);
    taille = dir_desc[no_dep1].nligne * 
             dir_desc[no_dep1].ncolonne; 
    debut = image = (unsigned char *)malloc (taille);    
    switch (dir_desc[no_dep1].type) {
        case -1:
	case 0: b = (unsigned char *) dir_image[no_dep1].image; break;
        case 1: s = (short *) dir_image[no_dep1].image; break;
        case 2: i = (int *) dir_image[no_dep1].image; break;
        case 3: f = (float *) dir_image[no_dep1].image; break;
    }
    switch (dir_desc[no_dep1].type) {
	case -1:
	case 0:
	    for ( y = 0 ; y < dir_desc[no_dep1].nligne ; y++) 
		for ( x = 0 ; x < dir_desc[no_dep1].ncolonne; x++) {
	            if ( *b > valeur ) *image = 255;
		    else *image = 0;
		    b++;
	            image++;
		}
	    break;
	case 1:
	    for ( y = 0 ; y < dir_desc[no_dep1].nligne ; y++) 
		for ( x = 0 ; x < dir_desc[no_dep1].ncolonne; x++) {
	            if ( *s > valeur ) *image = 255;
		    else *image = 0;
		    s++;
	            image++;
		}
	    break;
	case 2:
	    for ( y = 0 ; y < dir_desc[no_dep1].nligne ; y++) 
		for ( x = 0 ; x < dir_desc[no_dep1].ncolonne; x++) {
	            if ( *i > valeur ) *image = 255;
		    else *image = 0;
		    i++;
	            image++;
		}
	    break;
	case 3:
	    for ( y = 0 ; y < dir_desc[no_dep1].nligne ; y++) 
		for ( x = 0 ; x < dir_desc[no_dep1].ncolonne; x++) {
	            if ( *f > valeur ) *image = 255;
		    else *image = 0;
		    f++;
	            image++;
		}
	    break;
    }
    if (buffer_image[no_arr].image != NULL)
        free(buffer_image[no_arr].image);
    buffer_image[no_arr].image = (unsigned char *)debut;
    buffer_desc[no_arr] = dir_desc[no_dep1];
    buffer_desc[no_arr].type = -1;
    buffer_desc[no_arr].mmax = valeur;
    buffer_desc[no_arr].mmin = 0;
    statis (buffer_image[no_arr].image, buffer_desc[no_arr].type, 
	    buffer_desc[no_arr].nligne, buffer_desc[no_arr].ncolonne,
	    &(buffer_desc[no_arr].mmin), &(buffer_desc[no_arr].mmax),
	    &(buffer_desc[no_arr].mu), &(buffer_desc[no_arr].ecart));
}

/*****************************************************************************/
/*									     */
/* nom      : autoconvdef_seuil						     */
/*									     */
/* fonction : declanche la creation d'une image "binaire" avec un seuil	     */
/*	      contenu dans value.				             */
/*                                                                           */
/* entrees  : panel_item item		: item d'interaction	             */
/*            Evant event	        : evenements		             */
/*                                                                           */
/* globales : Frame frameseuil		: frame du slider		     */
/*	      Textsw  master		: fenetre de commandes		     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/* routines : autoconvcreer_plan_bin						     */
/*									     */
/*****************************************************************************/
/*
static Panel_setting autoconvdef_seuil (item, value, event)
    Panel_item item;
    int value;
    Event *event;

{
    autoconvval_seuil = value;
}
*/
/*****************************************************************************/
/*
static Panel_setting autoconvset_seuil (item, event)
    Panel_item	item;
    Event	*event;
{
  int no_dep1;
    window_return ();
    window_destroy (acframe_seuil);
    if (item == acbouton_ok){
	    sprintf (buf, mastertabs[33], autoconvval_seuil);
            no_dep1 = (int) panel_get(acbouton_ok, PANEL_CLIENT_DATA);
	    write_master (buf);  
    }
    autoconvcreer_plan_bin (autoconvval_seuil, no_dep1);
}
*/
/*****************************************************************************/
/*                							     */
/* nom      : autoconvinit_seuil_slider						     */
/*									     */
/* fonction : initialisation d'un panneau contenant un "slider" pour         */
/*	      l'operation de seuillage.					     */
/*									     */
/* entrees  : int vmin			: valeur minimum du slider           */
/*	      int vmax                  : valeur maximum du slider	     */
/*	      int vmoy			: valeur initiale du slider          */
/*									     */
/* globales : neant						             */
/*									     */
/* return   : neant                                                          */
/*								             */
/* routines : neant							     */
/*								             */
/*****************************************************************************/
/*
int autoconvinit_seuil_slider (no_dep1)
int no_dep1;
{
    float vmin, vmax, vmoy;
    
    if (flag_creer){
	vmin = -1;
	vmax = 255;
	vmoy = -1;
    }
    else {
	vmin = dir_desc[no_dep1].mmin;
	vmax = dir_desc[no_dep1].mmax;
	vmoy = dir_desc[no_dep1].mu;
    }
    autoconvval_seuil = vmoy;
    acframe_seuil = window_create(frame, FRAME, WIN_X, 500, WIN_Y, 500,
		       FRAME_NO_CONFIRM, TRUE, 0);
   acpanel_seuil = window_create(acframe_seuil, PANEL,
		       PANEL_ACCEPT_KEYSTROKE, TRUE,
                       PANEL_LABEL_BOLD, TRUE, 0);
    acbarre_seuil = panel_create_item (acpanel_seuil, PANEL_SLIDER,
                       PANEL_LABEL_STRING, paneltabs[27],
                       PANEL_SHOW_ITEM, TRUE,
		       PANEL_MIN_VALUE, (unsigned int)rint(vmin),
		       PANEL_MAX_VALUE, (unsigned int)rint(vmax),
		       PANEL_VALUE, (unsigned int)rint(vmoy),
                       PANEL_SLIDER_WIDTH, 300,
                       PANEL_NOTIFY_PROC, autoconvdef_seuil,
                       0);
    acbouton_ok = panel_create_item (acpanel_seuil, PANEL_BUTTON,
	    PANEL_NOTIFY_PROC, autoconvset_seuil,
	    PANEL_LABEL_IMAGE, panel_button_image (acpanel_seuil, "OK",7,0),
	    PANEL_ITEM_X, 125, PANEL_ITEM_Y, 30,
	    PANEL_CLIENT_DATA, (caddr_t) no_dep1,
	    0);
    acbouton_cancel = panel_create_item (acpanel_seuil, PANEL_BUTTON,
	    PANEL_NOTIFY_PROC, autoconvset_seuil,
	    PANEL_LABEL_IMAGE, panel_button_image (acpanel_seuil, "Cancel",7,0),
	    PANEL_ITEM_X, 225, PANEL_ITEM_Y, 30,
	    0);
    window_fit (acbouton_ok);
    window_fit (acbouton_cancel);
    window_fit (acpanel_seuil);
    window_fit (acframe_seuil);
    window_set (acframe_seuil, WIN_MOUSE_XY,
       (int)window_get (acframe_seuil, WIN_X, 0) + 10,
       (int)window_get (acframe_seuil, WIN_Y, 0) + 10,
       0);
    window_loop (acframe_seuil);
}
*/
/*****************************************************************************/
/*									     */
/* nom      : proc_seuillage						     */
/*									     */
/* fonction : initialise le panel-slider pour le seuillage.		     */
/*                                                                           */
/* entrees  : Menu   m		        : menu courant                       */
/*            Menu_item mi	        : item dans le menu                  */
/*                                                                           */
/* globales : Frame acframe_seuil						     */
/*	      Panel acpanel_seuil						     */
/*	      description_memoire dir_desc				     */
/*	      int index_image[6]					     */
/*									     */
/* return   : neant                                     		     */
/*									     */
/*	      autoconvinit_seuil_slider						     */
/*	      fromto							     */
/*									     */
/*****************************************************************************/
/*
int autoconvert_bin (no_dep1)
int no_dep1;
{
    int val;

    sprintf (buf, mastertabs[350]);
    write_master (buf);

	  sprintf (buf,"bin %d\n", no_dep1);
	  write_master (buf);
	  autoconvinit_seuil_slider (no_dep1);
}


*/
