/*****************************************************************************/
/* module gen.c								     */
/*									     */
/* Author: Anne Bobillier						     */
/*	   Labo Image							     */
/*	   Computing Science Center					     */
/*	   University of Geneva, Switzerland				     */
/* Date:   February 1988						     */
/* Modifications:   April 2, 1989: some cleaning.			     */
/* Copyright (c) A. Jacot-Descombes, T. Pun, C. Pellegrini, Uni. of Geneva   */
/* (This copyright notice should appear).				     */
/*									     */
/*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <math.h>
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/textsw.h>
#include <suntool/scrollbar.h>
#include <suntool/panel.h>
#include <pixrect/pixrect_hs.h>

#include "../define.h"
#include "../structure.h"
#include "../global.h"

#define LARGEUR_ECRAN 1152
#define HAUTEUR_ECRAN 900
#define MAX_PTS 100
#define MAX_SEG 10
#define PAN_X 0
#define PAN_Y 400

#define MONO 1
#define COULEUR 255

#define EFFACE	10
#define CHANGE_COULEUR	20
#define EXPOSE	30	

#define	AND    20
#define	OR     21
#define	XOR    22
#define	NOT    23
#define	AND_BOUNDED    24

static void	gen_pts_controle_mono();
static void	gen_pts_controle_couleur();

static void	annule_contrainte_hv();
static void	contrainte_hv();
static void	change_fond();
static void	change_couleur_seg(), change_couleur_segment();
static void	create_mainpanel_items_1(), create_mainpanel_items_2();
static void	create_mainpanel_color_items();
static void	create_panel_point_items();
static void	cree_fenetre_couleur();
static void	dessine_contour();
static void	detruit_fen_graph();
static void	efface(), efface_tout(), efface_segment(), efface_seg();
static void	expose_segment(), expose_seg();
static void	extract_masque();
static void	extract_seg();
static void	ferme_et_insere_segment();
static void	free_liste_pts();
static void	handle_panel_event();
static void	init_liste_pts();
static void	init_liste_seg();
static void	raster_op();
static void	reaffichage();
static void	recherche();
static void     remplit_seg();
static void	saisie_controle();
static void	saisie_souris();
static void	saisie_clavier();
static void	sauve_im_ds_plan();
static void	segments(), segment_plein(), segment_contour();

extern void	cree_fenetre_mono(); 
extern void	entree_gen();
extern void	saisie_pts();

extern void hproc_oplogic_AND();
extern void hproc_oplogic_AND_BOUNDED();
extern void hproc_oplogic_OR();
extern void hproc_oplogic_XOR();
extern void hproc_oplogic_NOT();
extern void hproc_extract_masque();
extern void hproc_gen_pts_controle_couleur();
extern void hproc_gen_pts_controle_mono();

static Panel_setting lire();
static Panel_setting lire_point();

caddr_t		quit_frame_base();
caddr_t		quit_frame_image();

extern int Confirm();

/**/int		element ();
/**/int		init_color_lin();
/**/int		statis();
/**/int		write_master();
/**/int		write_erreur();	    
/**/caddr_t	proc_seuil();
/**/caddr_t	proc_report_erreur();
/**/caddr_t	proc_gris_lin();
/**/caddr_t	proc_gris_log();
/**/caddr_t	proc_couleur_rgb();

Canvas	    canvas, last_can;
Frame       frame;		    /* Cadre principal de win.c */
Frame       frame_base, frame_image, last_fr;  
Panel	    mainpanel, panel_point;
struct	    commande    *com;

int entree_flag=0;

Panel_item  affiche_item;
Panel_item  aff_mess1_item;
Panel_item  aff_mess2_item;
Panel_item  contrainte_item;
Panel_item  annule_contrainte_item;
Panel_item  creation_item, creation_couleur_item; 
Panel_item  sortie_item; 
Panel_item  change_couleur_fond_item, fond_item;
Panel_item  change_couleur_seg_item, couleur_seg_item;
Panel_item  dimx_item, dimy_item;
Panel_item  eff_tout, eff_seg;
Panel_item  expose_segment_item;
Panel_item  mess1, mess2, mess2change, mess2expose, mess3; 
Panel_item  pos_x_item, pos_y_item;
Panel_item  clavier_item, souris_item;
Panel_item  segments_item, plein_item, contour_item;
Panel_item  sauve_item, efface_item, comment1_item, comment2_item;

extern char *paneltabs[];
extern char *mastertabs[];


Menu	    framemenu;
extern	    Menu maff;

Pixwin	    *pw;

/* */ Textsw master;


typedef	struct coords	*ptr_point;             /* Type de la liste des points */

struct	    coords {
		    short	x,y;
	            ptr_point	 next;
                   };


/* Structure d'un segment : le nombre de points qui le compose, un pointeur sur la	*/
/* liste de ces points, un flag pour dire s'il est rempli ou non ainsi que sa couleur	*/

typedef struct el_seg	*ptr_seg;		   /* Type de la liste des segments */

struct	    el_seg  {			     /* Un element de la liste des segments */	
		     int	    nbr_pts;
		     int	    flag_plein; /* 1 si le segment est plein, 0 sinon	*/
		     short	    couleur;	/* Si masque (overlay) = 1 (monochrome)	*/
		     ptr_point	    pts;
		     ptr_seg	    suivant;
		    };


/* Structure d'une image : le nombre de segments qui la compose et un pointeur sur la */
/* liste de ces segments                                                              */

struct	    el_image {
			int	    nbr_seg;    
			ptr_seg	    seg;
		     };

/* Tableau donnant pour chaque image le nombre de segments quelle contient ainsi que 
   le pointeur vers la liste des segments					      */

struct el_image	liste_image[MAX_IMAGE];	


ptr_point   pt_debut, pt_courant;	/* Poiteur sur le debut de la liste et sur le */
					/* point courant			      */
ptr_seg	    seg_debut, seg_courant;
short	    xdim = 0, ydim = 0;		/* Dimensions de l'image a creer	      */

int	    nbr_pts = 0;
int	    nbr_seg = 0;
short	    controle_x, controle_y;	/* Point selectionnant le segment a effacer	 */
short	    pos_x, pos_y;		/* Point donne par le clavier ou dernier point	 */
					/* clique par la souris				 */
short	    couleur_fond = 0;		/* Fond noir par defaut				 */
short	    couleur_courante = 255;	/* Ecrit en blanc par defaut			 */

int	    type;			/* Type de l'image en cours: mono ou couleur	 */
int	    fonction = 0;		/* Genre de la fonction executee au moment du	 */
					/* test: efface, change_couleur, expose.	 */
int	    contrainte = 0;		/* Si 1 on force les droites a etre horizontales */
					/* ou verticales				 */
/**/int	    flag_chablon;


/****************************************************************************************/
/*  nom	    :	entree_gen								*/
/*											*/
/*  fonction:	appelee depuis win.c, elle selectionne la fonction de gen a executer	*/
/*		en fonction de nombre passe en parametre				*/
/*											*/
/*  entrees :	int	sel								*/
/*											*/
/*  globales:	aucune									*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	gen_pts_controle_mono							*/
/*		gen_pts_controle_couleur						*/
/*		extract_masque								*/
/*		raster_op								*/
/*											*/
/****************************************************************************************/
extern void entree_gen(sel)

int sel;
{


    switch (sel)
    {
	case 1 :   if (flag_bother){
			hproc_gen_pts_controle_mono();
			return;
		  }
		  if (flag_help) hproc_gen_pts_controle_mono();
		  break;
	case 2 :  if (flag_bother){
			hproc_gen_pts_controle_couleur();
			return;
		  }
		  if (flag_help) hproc_gen_pts_controle_couleur();
		  break;
	case 3 :   if (flag_bother){
			hproc_extract_masque();
			return;
		  }
		  if (flag_help) hproc_extract_masque();
		  break;	
	case 40:    if (flag_bother){
			hproc_oplogic_AND();
			return;
		  }
		  if (flag_help) hproc_oplogic_AND();
		  break;
	case 41:    if (flag_bother){
			hproc_oplogic_AND_BOUNDED();
			return;
		  }
		  if (flag_help) hproc_oplogic_AND_BOUNDED();
		  break;
	case 5 :    if (flag_bother){
			hproc_oplogic_OR();
			return;
		  }
		  if (flag_help) hproc_oplogic_OR();
		  break;
	case 6 :    if (flag_bother){
			hproc_oplogic_XOR();
			return;
		  }
		  if (flag_help) hproc_oplogic_XOR();
		  break;
	case 7 :    if (flag_bother){
			hproc_oplogic_NOT(); 
			return;
		  }
		  if (flag_help) hproc_oplogic_NOT(); 
		  break;
    }
 

 if (entree_flag == 0){

    switch (sel)
    {
	case 1 :  gen_pts_controle_mono();
		  break;
	case 2 :  gen_pts_controle_couleur();
		  break;
	case 3 :  extract_masque();
		  break;	
	case 40:  raster_op(AND);
		  break;
	case 41:  raster_op(AND_BOUNDED);    /* AND restreint a la bounding box du masque*/
		  break;
	case 5 :  raster_op(OR);
		  break;
	case 6 :  raster_op(XOR);
		  break;
	case 7 :  raster_op(NOT);
		  break;
    }
 }
 else{
     switch (entree_flag){
	 case 1: write_erreur(100);
		 break;
	 case 2: write_erreur(101); 
		 break;
	 case 3: write_erreur(102); 
		 break;
     }
   
     
 }
    return;
}


/****************************************************************************************/
/*  nom	    :	gen_pts_controle_mono							*/
/*											*/
/*  fonction:	Creation et initialisation d'un panel pour la generation d' une image 	*/
/*		monochrome.								*/
/*											*/
/*  entrees :	aucune									*/
/*											*/
/*  globales:	int	type								*/
/*		int	flag_chalon							*/
/*		int	type								*/
/*		int	contrainte							*/
/*		Frame	frame								*/
/*		Frame	frame_base							*/
/*		Menu	framemenu							*/
/*		Panel	mainpanel							*/
/*		Panel	panel_point							*/
/*		Panel_item  creation_item  						*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	init_liste_pts								*/
/*		init_liste_seg								*/
/*		create_mainpanel_items_1						*/
/*		create_mainpanel_items_2						*/  
/*	        create_panel_point_items  						*/
/*		quit_frame_base								*/
/*		write_master								*/
/*											*/
/****************************************************************************************/

static void gen_pts_controle_mono()
{
    entree_flag = 1;
    flag_chablon = 0;
    type = MONO;
    contrainte = 0;
    init_liste_pts();
    init_liste_seg();


    frame_base = window_create(frame, FRAME, 
		    WIN_SHOW, TRUE,
		    FRAME_NO_CONFIRM, TRUE,
		    FRAME_EMBOLDEN_LABEL, TRUE,
		    FRAME_LABEL, paneltabs[557],
		    FRAME_SHOW_LABEL, TRUE,
		    WIN_X, 0,
		    WIN_Y, 400,
		    0);	

    strcpy(buf,mastertabs[379]);
    write_master(buf);

/* Remplacement du "done" standard d'un subframe par la procedure quit_frame_base */
   
    framemenu = (Menu) window_get(frame_base, WIN_MENU, 0);
    menu_set(framemenu, MENU_REMOVE, 1,
		MENU_ACTION_ITEM, "Quit*", quit_frame_base,
		0);
    window_set(frame_base, WIN_MENU, framemenu, 0);

    mainpanel = window_create(frame_base, PANEL, 0);
    create_mainpanel_items_1();
    create_mainpanel_items_2();
    window_fit_height (mainpanel);

/* Creation du panel interactif pour la saisie des points */

    panel_point = window_create(frame_base, PANEL,
		    WIN_BELOW, mainpanel,
		    0);
    create_panel_point_items();
    
    window_fit (panel_point);
    window_fit (frame_base);

/* Positionnement du curseur dans le panneau d'interaction */

    window_set (frame_base,WIN_MOUSE_XY, 
		(int)panel_get (creation_item, PANEL_ITEM_X, 0) + 20 ,
		(int)panel_get (creation_item, PANEL_ITEM_Y, 0) + 30 ,
		0);
    return;

}

/****************************************************************************************/
/*  nom	    :	gen_pts_controle_couleur						*/
/*											*/
/*  fonction:	Creation et initialisation d'un panel pour la generation d' une image 	*/
/*		a niveau de gris.							*/
/*											*/
/*  entrees :	aucune									*/
/*											*/
/*  globales:	int	type								*/
/*		int	flag_chablon							*/
/*		int	contrainte							*/
/*		Frame	frame								*/
/*		Frame	frame_base							*/
/*		Menu	framemenu							*/
/*		Panel	mainpanel							*/
/*		Panel	panel_point							*/
/*		Panel_item  creation_item  						*/
/*		unsigned char nivgrislin[3][256]					*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	init_liste_pts								*/
/*		init_liste_seg								*/
/*		init_color_lin								*/
/*		create_mainpanel_items_1						*/
/*		create_mainpanel_items_2						*/   
/*		create_mainpanel_color_items						*/
/*	        create_panel_point_items  						*/
/*		quit_frame_base								*/
/*		write_master								*/
/*											*/
/****************************************************************************************/
static void gen_pts_controle_couleur()
{
    entree_flag = 2;
    flag_chablon = 0;
    type = COULEUR;
    contrainte = 0;

    init_color_lin (nivgrislin);    
    init_liste_pts();
    init_liste_seg();

    frame_base = window_create(frame, FRAME,
		    FRAME_NO_CONFIRM, TRUE,
		    WIN_SHOW, TRUE,
		    FRAME_EMBOLDEN_LABEL, TRUE,
		    FRAME_LABEL, paneltabs[556],
		    FRAME_SHOW_LABEL, TRUE,
		    WIN_X, 0,
		    WIN_Y, 400,
		    0);	

    strcpy(buf, mastertabs[380]);
    write_master(buf);

/* Remplacement du "done" standard d'un subframe par la procedure quit_frame_base */
   
    framemenu = (Menu) window_get(frame_base, WIN_MENU, 0);
    menu_set(framemenu, MENU_REMOVE, 1,
		MENU_ACTION_ITEM, "Quit*", quit_frame_base,
		0);
    window_set(frame_base, WIN_MENU, framemenu, 0);

    mainpanel = window_create(frame_base, PANEL, 0);
    create_mainpanel_items_1();
    create_mainpanel_items_2();
    create_mainpanel_color_items();
    window_fit_height (mainpanel);

/* Creation du panel interactif pour la saisie des points */

    panel_point = window_create(frame_base, PANEL, 
			WIN_BELOW, mainpanel,
			0);
    create_panel_point_items();
    window_fit (panel_point);

    window_fit (frame_base);

/* Positionnement du curseur dans le panneau d'interaction */

    window_set (frame_base,WIN_MOUSE_XY, 
		(int)panel_get (creation_item, PANEL_ITEM_X, 0) + 20 ,
		(int)panel_get (creation_item, PANEL_ITEM_Y, 0) + 30 ,
		0);
    return;


}

/****************************************************************************************/
/*  nom	    :	extract_masque								*/
/*											*/
/*  fonction:	Creation et initialisation d'un panel pour l'extraction d'un masque 	*/
/*		a partir d'une image existante.						*/
/*											*/
/*  entrees :	aucune									*/
/*											*/
/*  globales:	Frame	frame								*/
/*		Frame	frame_base							*/
/*		Menu	framemenu							*/
/*		Panel	mainpanel							*/
/*		Panel	panel_point							*/
/*		int	flag_chablon							*/
/*		int	type								*/
/*		int	contrainte							*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	create_mainpanel_items_2						*/ 
/*		create_panel_point_items						*/
/*		handle_panel_event    							*/
/*		quit_frame_base								*/
/*		write_master								*/
/*											*/
/****************************************************************************************/

static void extract_masque()
{
    entree_flag = 3;
    flag_chablon = 1;
    type = MONO;
    contrainte = 0;

    
    frame_base = window_create(frame, FRAME, 
		    WIN_SHOW, TRUE,
		    FRAME_NO_CONFIRM, TRUE,
		    FRAME_EMBOLDEN_LABEL, TRUE,
		    FRAME_LABEL,paneltabs[530], 
		    FRAME_SHOW_LABEL, TRUE,
		    WIN_X, 0,
		    WIN_Y, 400,
		    0);	

    framemenu = (Menu) window_get(frame_base, WIN_MENU, 0);
    menu_set(framemenu, MENU_REMOVE, 1,
		MENU_ACTION_ITEM, "Quit*", quit_frame_base,
		0);
    window_set(frame_base, WIN_MENU, framemenu, 0);

    mainpanel = window_create(frame_base, PANEL, 0);


    aff_mess1_item = panel_create_item (mainpanel, PANEL_MESSAGE,
		    PANEL_SHOW_ITEM, TRUE,
		    PANEL_LABEL_Y, ATTR_ROW(1),
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_STRING, paneltabs[531],
		    0);

    aff_mess2_item = panel_create_item (mainpanel, PANEL_MESSAGE,
		    PANEL_SHOW_ITEM, TRUE,
		    PANEL_LABEL_Y, ATTR_ROW(2),
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_STRING, paneltabs[532],
		    0);

    affiche_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, TRUE,
		    PANEL_LABEL_Y, ATTR_ROW(4),
		    PANEL_LABEL_X, ATTR_COL(9),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		     paneltabs[533], 0, 0),
		    PANEL_EVENT_PROC, handle_panel_event,    
		    0);

    create_mainpanel_items_2();
    window_fit_height (mainpanel);

    panel_point = window_create(frame_base, PANEL, 
			WIN_BELOW, mainpanel,
			0);
    create_panel_point_items();
    window_fit (panel_point);

    window_fit (frame_base);

    strcpy(buf,mastertabs[371]);
    write_master(buf);


    return;
}


/****************************************************************************************/
/*  nom	    :	raster_op								*/
/*											*/
/*  fonction:	Applique un operateur (passe en parametre a la fonction) entre deux   	*/
/*		plans dont le deuxieme est de type binaire (masque).			*/
/*											*/
/*  entrees :	int	sel								*/
/*											*/
/*  globales:	dir_desc								*/
/*		dir_image								*/
/*		index_image								*/
/*											*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	write_master								*/   
/*		write_erreur								*/
/*		statis									*/
/*		element									*/
/*		fromto									*/
/*											*/
/*											*/
/****************************************************************************************/
static void raster_op(sel)
    
    int	    sel;
{
    unsigned char *resultat_inter, *resultat_u, *source_u, *cu, *ptr_u;
    short *source_s, *resultat_s, *ptr_s;
    int *source_i, *resultat_i, *ptr_i;
    float *source_f, *resultat_f, *ptr_f;
    int	    plan_source, plan_masque;
    int	    plan_arr;
    int	    taille_im, taille_im_arr, taille_el;
    int	    xmin, xmax, ymin, ymax;		/* bounding box */
    int	    k, x, y;

    if (flag_creer) {
	com = (struct commande *)malloc(sizeof(*com));
	com = (struct commande *)new_commande (&macro_cour);
    }
    switch (sel)
    {
	case AND: 
		  if (!flag_creer) sprintf(buf, "AND ");
		  else {
		      strcpy (com->nom, "AUXLOPAND");
		      com->code = 550;
		  }
		  break;
	case AND_BOUNDED:
		  if (!flag_creer) sprintf(buf, "AND within mask ");
		  else {
		      strcpy (com->nom, "AUXLOPAWM");
		      com->code = 551;
		  }
		  break;
	case OR :
		  if (!flag_creer) sprintf(buf, "OR ");
		  else {
		      strcpy (com->nom, "AUXLOPOR");
		      com->code = 552;
		  }
		  break;
	case XOR: 
		  if (!flag_creer) sprintf(buf, "XOR ");
		  else {
		      strcpy (com->nom, "AUXLOPXOR");
		      com->code = 553;
		  }
		  break;
	case NOT:
		  if (!flag_creer) sprintf(buf, "NOT ");
		  else {
		      strcpy (com->nom, "AUXLOPNOT");
		      com->code = 554;
		  }
		  break;
    }
    if (!flag_creer) write_master (buf);
    
    if (flag_exec == FROMTO_AUTO || flag_exec == AUTO){
	plan_source = index_image[0] = macro_cour->from[0];
	plan_arr = index_image[1] = macro_cour->to[0];
	if (sel != NOT)
	    plan_masque = index_image[2] = macro_cour->from[1];
    }
    else
	switch (sel){
	    case AND: case AND_BOUNDED: case OR: case XOR:
		fromto (FROMTO, DEF21);
		if (flag_break){
		    interruption();
		    return;
		}
		plan_source = index_image[0];
		plan_masque = index_image[2];
		plan_arr = index_image[1];
		break;
	    case NOT:
		fromto (FROMTO, DEFAUT);
		if (flag_break){
		    interruption();
		    return;
		}
		plan_source = index_image[0];
		plan_arr = index_image[1];
		break;
	}

    if (!flag_creer){
	switch (sel) {
	case AND: case AND_BOUNDED: 
	    if (!flag_creer)
		sprintf(buf,"(%d, Mas %d) --> %d\n",
		    plan_source, plan_masque, plan_arr);
	    break;
	case OR: case XOR:
	    if (!flag_creer)
		sprintf(buf,"(Mas %d,Mas %d) --> %d\n",
		    plan_source, plan_masque, plan_arr);
	    break;
	case NOT:
	    if (!flag_creer)
		sprintf(buf,"%d --> %d\n",
		    plan_source, plan_arr);
	    break;
	}
	write_master (buf);
    }
    else{
	com->param = NULL;
	if (sel == NOT){
	    com->from[0] = index_image[0];    
	    com->to[0] = index_image[1];    
	    sprintf (buf, "%s FROM %d TO %d\n", com->nom, 
		    index_image[0], index_image[1]);
	}
	else {
	    com->from[0] = index_image[0];    
	    com->from[1] = index_image[2];    
	    com->to[0] = index_image[1];    
	    sprintf (buf, "%s FROM %d %d TO %d\n", com->nom, 
		    index_image[0], index_image[2], index_image[1]);
	}
	write_macro (buf);
    }

    if (!flag_creer){
	switch (sel){

/* Operation AND entre une image source de n'importe quel type et une image masque  */
/* de type -1 c'est a dire binarisee ( 0-255). Elles doivent etre de la meme taille */

	case AND:
	    if (dir_desc[plan_masque].type != -1)
	    {
		write_erreur(17);
		return;
	    }
	    if ((dir_desc[plan_source].nligne != dir_desc[plan_masque].nligne)
		|| (dir_desc[plan_source].ncolonne != dir_desc[plan_masque].ncolonne))
	    {
		write_erreur(2);
		return;
	    }

	    taille_im = dir_desc[plan_source].nligne * dir_desc[plan_source].ncolonne;
	    taille_el = element(dir_desc[plan_source].type); 
 
	    if (dir_image[plan_arr].image != NULL)
		free(dir_image[plan_arr].image); 
	    dir_image[plan_arr].image = (unsigned char*) malloc (taille_im * taille_el);
	    
    
	    dir_desc[plan_arr].nligne = dir_desc[plan_source].nligne;
	    dir_desc[plan_arr].ncolonne = dir_desc[plan_source].ncolonne;
	    dir_desc[plan_arr].type = dir_desc[plan_source].type;
	    switch (dir_desc[plan_source].type)
	    {
		case -1:
		case  0:   
		    resultat_u = dir_image[plan_arr].image; 
		    source_u = dir_image[plan_source].image; 
		    cu = dir_image[plan_masque].image;   
	    
			for (k = 0; k < taille_im ; k++)
				{
				    if (*source_u && *cu)
					*resultat_u = *source_u;
				    else 
					*resultat_u = 0;
				    source_u++;
				    cu++;
				    resultat_u++;
				}
		    break;

		case 1: 
		    resultat_s = (short *) (dir_image[plan_arr].image); 
		    source_s = (short *) (dir_image[plan_source].image); 
		    cu = dir_image[plan_masque].image;   
		    
			for (k = 0; k < taille_im ; k++)
				{
				    if (*source_s && *cu)
					*resultat_s = *source_s;
				    else 
					*resultat_s = 0;
				    source_s++;
				    cu++;
				    resultat_s++;
				}
		    break;
	
		case 2: 
		    resultat_i = (int *) (dir_image[plan_arr].image);
		    source_i = (int *) (dir_image[plan_source].image);
		    cu = dir_image[plan_masque].image;   
		    
			for (k = 0; k < taille_im ; k++)
				{
				    if (*source_i && *cu)
					*resultat_i = *source_i;
				    else 
					*resultat_i = 0;
				    source_i++;
				    cu++;
				    resultat_i++;
				}
		    break;

		case 3: 
		    resultat_f = (float *) (dir_image[plan_arr].image);
		    source_f = (float *) (dir_image[plan_source].image);
		    cu = dir_image[plan_masque].image;   
		    
			for (k = 0; k < taille_im ; k++)
				{
				    if (*source_f && *cu)
					*resultat_f = *source_f;
				    else 
					*resultat_f = 0;
				    source_f++;
				    cu++;
				    resultat_f++;
				}
		    break;
	    }
	    break;

/* Operation AND restreinte a la bounding box du masque sur une image source de	    */
/* n'importe quel type et une image masque de type -1 c'est a dire binarisee (0-255)*/
/* Elles doivent etre de la meme taille						    */

	case AND_BOUNDED :
	    if (dir_desc[plan_masque].type != -1)
	    {
		write_erreur(17);
		return;
	    }
	    if ((dir_desc[plan_source].nligne != dir_desc[plan_masque].nligne)
		|| (dir_desc[plan_source].ncolonne != dir_desc[plan_masque].ncolonne))
	    {
		write_erreur(2);
		return;
	    }
	    xmin = dir_desc[plan_source].ncolonne - 1;	  /* Initialisation de la */  
	    xmax = 0;					  /* bounding box	  */  
	    ymin = dir_desc[plan_source].nligne - 1;
	    ymax = 0; 


	    taille_im = dir_desc[plan_source].nligne * dir_desc[plan_source].ncolonne;
	    taille_el = element(dir_desc[plan_source].type);  
	    resultat_inter = (unsigned char*) malloc (taille_im * taille_el);

	    dir_desc[plan_arr].type = dir_desc[plan_source].type;

	    switch (dir_desc[plan_source].type)
	    {
		case -1:
		case  0:   
		    resultat_u = resultat_inter; 
		    source_u = dir_image[plan_source].image; 
		    cu = dir_image[plan_masque].image;   
	    
			for (y = 0; y < dir_desc[plan_source].nligne ; y++)
			    for (x = 0; x < dir_desc[plan_source].ncolonne ; x++)
				{
				    if (*cu == 255)		
				    {
					if (x < xmin)  xmin = x;    /* Mise a jour de la */
					if (x > xmax)  xmax = x;    /* bounding box	 */
					if (y < ymin)  ymin = y;
					if (y > ymax)  ymax = y;
				    }

				    if (*source_u && *cu)
					*resultat_u = *source_u;
				    else 
					*resultat_u = 0;
				    source_u++;
				    cu++;
				    resultat_u++;
				}
		    /* Creation d'une image de la grandeur de la bouding box du masque	*/

		    dir_desc[plan_arr].nligne = ymax - ymin + 1;
		    dir_desc[plan_arr].ncolonne = xmax - xmin + 1;
	
		    taille_im_arr = dir_desc[plan_arr].nligne * dir_desc[plan_arr].ncolonne;
		    if (dir_image[plan_arr].image != NULL)
			    free(dir_image[plan_arr].image); 
		    dir_image[plan_arr].image = (unsigned char*)
						 malloc (taille_im_arr * taille_el);
		    resultat_u = resultat_inter; 
		    ptr_u = dir_image[plan_arr].image;
		    for (y = 0; y < dir_desc[plan_source].nligne ; y++)
			for (x = 0; x < dir_desc[plan_source].ncolonne ; x++)
			{		    
			    if ((x >= xmin) && (x <= xmax) && (y >= ymin) && (y <= ymax))
			    {	/* Appartient a la bounding box */
			    
				*ptr_u = *resultat_u;
				ptr_u++;
			    }
		    
			    resultat_u++;
			}

		    break;

		case 1: 
		    resultat_s = (short *) resultat_inter;  
		    source_s = (short *) (dir_image[plan_source].image); 
		    cu = dir_image[plan_masque].image;  
 
			for (y = 0; y < dir_desc[plan_source].nligne ; y++)
			    for (x = 0; x < dir_desc[plan_source].ncolonne ; x++)
				{
				    if (*cu)		
				    {
					if (x < xmin)  xmin = x;
					if (x > xmax)  xmax = x;
					if (y < ymin)  ymin = y;
					if (y > ymax)  ymax = y;
					
 
				    }
				    if (*source_s && *cu)
					*resultat_s = *source_s;
				    else 
					*resultat_s = 0;
				    source_s++;
				    cu++;
				    resultat_s++;
				}
		    /* Creation d'une image de la grandeur de la bouding box du masque	*/

		    dir_desc[plan_arr].nligne = ymax - ymin + 1;
		    dir_desc[plan_arr].ncolonne = xmax - xmin + 1;
	
		    taille_im_arr = dir_desc[plan_arr].nligne * dir_desc[plan_arr].ncolonne;
		    if (dir_image[plan_arr].image != NULL)
			    free(dir_image[plan_arr].image); 
		    dir_image[plan_arr].image = (unsigned char*)
						 malloc (taille_im_arr * taille_el);
		    resultat_s = (short *) resultat_inter; 
		    ptr_s = (short *) dir_image[plan_arr].image;
		    for (y = 0; y < dir_desc[plan_source].nligne ; y++)
			for (x = 0; x < dir_desc[plan_source].ncolonne ; x++)
			{		    
			    if ((x >= xmin) && (x <= xmax) && (y >= ymin) && (y <= ymax))
			    {	/* Appartient a la bounding box */
			    
				*ptr_s = *resultat_s;
				ptr_s++;
			    }
		    
			    resultat_s++;
			}

		    break;
	
		case 2: 
		    resultat_i = (int *) resultat_inter; 
		    source_i = (int *) (dir_image[plan_source].image);
		    cu = dir_image[plan_masque].image;   
		    
			for (y = 0; y < dir_desc[plan_source].nligne ; y++)
			    for (x = 0; x < dir_desc[plan_source].ncolonne ; x++)
				{
				    if (*cu)		
				    {
					if (x < xmin)  xmin = x;
					if (x > xmax)  xmax = x;
					if (y < ymin)  ymin = y;
					if (y > ymax)  ymax = y;
					
 
				    }	    
				    if (*source_i && *cu)
					*resultat_i = *source_i;
				    else 
					*resultat_i = 0;

				    source_i++;
				    cu++;
				    resultat_i++;
				}
		    /* Creation d'une image de la grandeur de la bouding box du masque	*/

		    dir_desc[plan_arr].nligne = ymax - ymin + 1;
		    dir_desc[plan_arr].ncolonne = xmax - xmin + 1;
	
		    taille_im_arr = dir_desc[plan_arr].nligne * dir_desc[plan_arr].ncolonne;
		    if (dir_image[plan_arr].image != NULL)
			    free(dir_image[plan_arr].image); 
		    dir_image[plan_arr].image = (unsigned char*)
						 malloc (taille_im_arr * taille_el);
		    resultat_i = (int *) resultat_inter; 
		    ptr_i = (int *) dir_image[plan_arr].image;
		    for (y = 0; y < dir_desc[plan_source].nligne ; y++)
			for (x = 0; x < dir_desc[plan_source].ncolonne ; x++)
			{		    
			    if ((x >= xmin) && (x <= xmax) && (y >= ymin) && (y <= ymax))
			    {	/* Appartient a la bounding box */
			    
				*ptr_i = *resultat_i;
				ptr_i++;
			    }
		    
			    resultat_i++;
			}
		    break;

		case 3: 
		    resultat_f = (float *) resultat_inter; 
		    source_f = (float *) (dir_image[plan_source].image);
		    cu = dir_image[plan_masque].image; 
  
			for (y = 0; y < dir_desc[plan_source].nligne ; y++)
			    for (x = 0; x < dir_desc[plan_source].ncolonne ; x++)
				{
				    if (*cu)		
				    {
					if (x < xmin)  xmin = x;
					if (x > xmax)  xmax = x;
					if (y < ymin)  ymin = y;
					if (y > ymax)  ymax = y;
 
				    }
				    if (*source_f && *cu)
					*resultat_f = *source_f;
				    else 
					*resultat_f = 0;

				    source_f++;
				    cu++;
				    resultat_f++;
				}
		    /* Creation d'une image de la grandeur de la bouding box du masque	*/

		    dir_desc[plan_arr].nligne = ymax - ymin + 1;
		    dir_desc[plan_arr].ncolonne = xmax - xmin + 1;
	
		    taille_im_arr = dir_desc[plan_arr].nligne * dir_desc[plan_arr].ncolonne;
		    if (dir_image[plan_arr].image != NULL)
			    free(dir_image[plan_arr].image); 
		    dir_image[plan_arr].image = (unsigned char*)
						 malloc (taille_im_arr * taille_el);
		    resultat_f = (float *) resultat_inter; 
		    ptr_f = (float *) dir_image[plan_arr].image;
		    for (y = 0; y < dir_desc[plan_source].nligne ; y++)
			for (x = 0; x < dir_desc[plan_source].ncolonne ; x++)
			{		    
			    if ((x >= xmin) && (x <= xmax) && (y >= ymin) && (y <= ymax))
			    {	/* Appartient a la bounding box */
			    
				*ptr_f = *resultat_f;
				ptr_f++;
			    }
		    
			    resultat_f++;
			}
		    break;
	    }
	    break;


/* Operation OR entre deux images de type masque. Elles doivent etre de la meme taille*/
	
	case OR : 
	    if (dir_desc[plan_source].type != -1)		/*=> pas de type byte*/
	    {
		write_erreur(17);	
		return;
	    }
	    if (dir_desc[plan_masque].type != -1)
	    {
		write_erreur(17);
		return;
	    }
	    if ((dir_desc[plan_source].nligne != dir_desc[plan_masque].nligne)
		|| (dir_desc[plan_source].ncolonne != dir_desc[plan_masque].ncolonne))
	    {
		write_erreur(2);
		return;
	    }

	    taille_im = dir_desc[plan_source].nligne * dir_desc[plan_source].ncolonne;
	    if (dir_image[plan_arr].image != NULL)
		free(dir_image[plan_arr].image); 
	    dir_image[plan_arr].image = (unsigned char*) malloc (taille_im);
    
	    dir_desc[plan_arr].nligne = dir_desc[plan_source].nligne;
	    dir_desc[plan_arr].ncolonne = dir_desc[plan_source].ncolonne;
	    dir_desc[plan_arr].type = dir_desc[plan_source].type;
	    
	    resultat_u = dir_image[plan_arr].image; 
	    source_u = dir_image[plan_source].image; 
	    cu = dir_image[plan_masque].image;   
	    
	    for (k = 0; k < taille_im ; k++)
	    {
		if (!*source_u && !*cu )	/* Les deux sont a 0 */
		    *resultat_u = 0 ;
		else
		  {
		    if (*source_u)
			*resultat_u = *source_u ;
		    if (*cu)
		    *resultat_u = *cu ;
		  }
		source_u++;
		cu++;
		resultat_u++; 
	    }
	    break;

/* Operation XOR entre deux images de type masque. Elles doivent etre de la meme taille*/
	
	case XOR:
	    if (dir_desc[plan_source].type != -1)	/*=> pas de type byte "binaire"*/
	    {
		write_erreur(17);	
		return;
	    }
	    if (dir_desc[plan_masque].type != -1)
	    {
		write_erreur(17);
		return;
	    }
	    if ((dir_desc[plan_source].nligne != dir_desc[plan_masque].nligne)
		|| (dir_desc[plan_source].ncolonne != dir_desc[plan_masque].ncolonne))
	    {
		write_erreur(2);
		return;
	    }

	    taille_im = dir_desc[plan_source].nligne * dir_desc[plan_source].ncolonne;
	    if (dir_image[plan_arr].image != NULL)
		free(dir_image[plan_arr].image); 
	    dir_image[plan_arr].image = (unsigned char*) malloc (taille_im);
    
	    dir_desc[plan_arr].nligne = dir_desc[plan_source].nligne;
	    dir_desc[plan_arr].ncolonne = dir_desc[plan_source].ncolonne;
	    dir_desc[plan_arr].type = dir_desc[plan_source].type;
	    
	    resultat_u = dir_image[plan_arr].image; 
	    source_u = dir_image[plan_source].image; 
	    cu = dir_image[plan_masque].image;   
	    
	    for (k = 0; k < taille_im ; k++)
	    {
		if ((*source_u) && (*cu))
		    *resultat_u = 0 ;
		else
		  {
		    if (*cu)
			*resultat_u = *cu ;
		    else
			if (*source_u)
			    *resultat_u = *source_u;
			else
			    *resultat_u = 0;
		  }  
		source_u++;
		cu++;
		resultat_u++; 
	    }
	    break;

/* Operation XOR entre deux images de type masque. Elles doivent etre de la meme taille*/

	case NOT:
	    if (dir_desc[plan_source].type != 0 && 
		dir_desc[plan_source].type != -1)   /*=> pas de type byte*/
	    {
		write_erreur(16);
		return;
	    }

	    taille_im = dir_desc[plan_source].nligne * dir_desc[plan_source].ncolonne;
	    if (dir_image[plan_arr].image != NULL)
		free(dir_image[plan_arr].image); 
	    dir_image[plan_arr].image = (unsigned char*) malloc (taille_im);
	    resultat_u = dir_image[plan_arr].image;
    
	    dir_desc[plan_arr].nligne = dir_desc[plan_source].nligne;
	    dir_desc[plan_arr].ncolonne = dir_desc[plan_source].ncolonne;
	    dir_desc[plan_arr].type = dir_desc[plan_source].type;

	    source_u = dir_image[plan_source].image; 
	    
	    for (k = 0; k < taille_im ; k++)
	    {
		*resultat_u = abs(*source_u - 255);
		source_u++;
		resultat_u++; 
	    }
	    break;
	}
	statis (dir_image[plan_arr].image,
                dir_desc[plan_arr].type, 
	        dir_desc[plan_arr].nligne,
	        dir_desc[plan_arr].ncolonne,
		&(dir_desc[plan_arr].mmin),
		&(dir_desc[plan_arr].mmax), 
	        &(dir_desc[plan_arr].mu),
		&(dir_desc[plan_arr].ecart));
    }
    return;
}

/****************************************************************************************/
/*  nom	    :	handle_panel_event							*/
/*											*/
/*  fonction:	associe le menu d'affichage d'image de win.c (maff) au bouton		*/
/*		"Affichage".								*/
/*											*/
/*  entrees :	Panel_item  item							*/
/*		Event	    *event							*/
/*											*/
/*  globales:	Panel	    mainpanel							*/
/*		Menu	    maff							*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	aucune									*/
/*											*/
/****************************************************************************************/

static void handle_panel_event(item, event)
    Panel_item	item;
    Event	*event;
{

    if (event_id(event) == MS_RIGHT && event_is_down(event))
	menu_show(maff, mainpanel, event, 0);
    else
	panel_default_handle_event(item, event);
    return;
}



/****************************************************************************************/
/*  nom	    :	quit_frame_base								*/
/*											*/
/*  fonction:	detruit le frame de base et detruit l'eventuelle image cree par des	*/
/*		actions dans ce frame.							*/
/*											*/
/*  entrees :	Menu_item	mi							*/
/*		Menu_generate   op							*/
/*											*/
/*  globales:	Frame	frame_image							*/
/*		Frame	frame_base							*/
/*											*/
/*  routines:	aucune									*/
/*											*/
/****************************************************************************************/

caddr_t	    quit_frame_base(mi, op)
    Menu_item	    mi;
    Menu_generate   op;
{
 if (Confirm("quit tool?") == 1){
    if (window_destroy(frame_base) == 1){
	window_set(frame_image, FRAME_NO_CONFIRM, TRUE, 0);
	window_destroy(frame_image);
	if (flag_chablon >= 1){
	    window_set(last_fr, FRAME_NO_CONFIRM, TRUE, 0);
	    window_destroy(last_fr);
	    flag_chablon = 0;
	}
	strcpy(buf,mastertabs[372]);
	write_master(buf);
    }
    entree_flag = 0;
 }
    return;
}


/****************************************************************************************/
/*  nom	    :	quit_frame_image							*/
/*											*/
/*  fonction:	detruit l'image et reinitialise le panneau d'interaction	 	*/
/*											*/
/*  entrees :	Menu_item	mi							*/
/*		Menu_generate   op							*/
/*											*/
/*  globales:	aucune									*/
/*											*/
/*  routines:	detruit_fen_graph							*/
/*											*/
/****************************************************************************************/

caddr_t	    quit_frame_image(mi, op)
    Menu_item	    mi;
    Menu_generate   op;
{
    if (flag_chablon >= 1)
	    quit_frame_base();
    else
	    detruit_fen_graph();
    return;
}


/****************************************************************************************/
/*  nom	    :	create_panel_point_items						*/
/*											*/
/*  fonction:	cree les items du panneau de controle de la saisie des points.		*/
/*											*/
/*  entrees :	aucune									*/
/*											*/
/*  globales:	aucune									*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	lire_point						        	*/
/*		saisie_clavier							        */
/*		saisie_souris								*/
/*											*/
/****************************************************************************************/

static void create_panel_point_items()
{
    pos_x_item = panel_create_item(panel_point, PANEL_TEXT,
		    PANEL_LABEL_Y, ATTR_ROW(1),
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_STRING, " X: ",
		    PANEL_VALUE_DISPLAY_LENGTH, 5, 
		    PANEL_NOTIFY_PROC, lire_point,
		    0); 

   pos_y_item = panel_create_item(panel_point, PANEL_TEXT,
		    PANEL_LABEL_Y, ATTR_ROW(1),
		    PANEL_LABEL_X, ATTR_COL(22),
		    PANEL_LABEL_STRING, " Y: ",
		    PANEL_VALUE_DISPLAY_LENGTH, 5,
		    PANEL_NOTIFY_PROC, lire_point,
		    0);	
	
    clavier_item = panel_create_item(panel_point, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, TRUE,
		    PANEL_LABEL_Y, ATTR_ROW(3),
		    PANEL_LABEL_X, ATTR_COL(7),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		    paneltabs[534], 0, 0),
		    PANEL_NOTIFY_PROC, saisie_clavier,     
		    0);

    souris_item = panel_create_item(panel_point, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(3),
		    PANEL_LABEL_X, ATTR_COL(7),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		    paneltabs[535], 0, 0),
		    PANEL_NOTIFY_PROC, saisie_souris,     
		    0);

    
    

}

/****************************************************************************************/
/*  nom	    :	create_mainpanel_items_1						*/
/*											*/
/*  fonction:	cree les items du panneau d'interaction.				*/
/*											*/
/*  entrees :	aucune									*/
/*											*/
/*  globales:	aucune									*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	lire							        	*/
/*		affichage								*/
/*		cree_fenetre_mono							*/
/*											*/
/****************************************************************************************/


static void create_mainpanel_items_1()
{

    dimx_item = panel_create_item(mainpanel, PANEL_TEXT,
		    PANEL_LABEL_Y, ATTR_ROW(2),
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_STRING, "Dimension (X): ",
		    PANEL_VALUE_DISPLAY_LENGTH, 5, 
            /*defaut pour NOTIFY_STRING = line-feed,<CR> and tab*/                 
		    PANEL_NOTIFY_PROC, lire,
		    0); 

   dimy_item = panel_create_item(mainpanel, PANEL_TEXT,
		    PANEL_LABEL_Y, ATTR_ROW(3),
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_STRING, "Dimension (Y): ",
		    PANEL_VALUE_DISPLAY_LENGTH, 5,
		    PANEL_NOTIFY_PROC, lire,
		    0);	

    creation_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(5),
		    PANEL_LABEL_X, ATTR_COL(10),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, "Creation", 0, 0),
		    PANEL_NOTIFY_PROC, cree_fenetre_mono,     
		    0);

    
    
    return;


}
/****************************************************************************************/
/*  nom	    :	create_mainpanel_items_2						*/
/*											*/
/*  fonction:	cree les items du panneau d'interaction.				*/
/*											*/
/*  entrees :	aucune									*/
/*											*/
/*  globales:	aucune									*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	contrainte_hv						                */
/*		annule_contrainte_hv					                */
/*		efface									*/
/*		efface_tout								*/
/*		efface_segment								*/
/*		quit_frame_base								*/
/*		segments								*/
/*		segment_plein								*/
/*		segment_contour								*/
/*		sauve_im_ds_plan							*/
/*											*/
/****************************************************************************************/


static void create_mainpanel_items_2()
{
    
		
   
    contrainte_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(3),
		    PANEL_LABEL_X, ATTR_COL(7),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		    paneltabs[536], 0, 0),
		    PANEL_NOTIFY_PROC, contrainte_hv,     
		    0);

    annule_contrainte_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(3),
		    PANEL_LABEL_X, ATTR_COL(3),	
		    PANEL_LABEL_IMAGE, panel_button_image (mainpanel,
		    paneltabs[537], 0, 0),
		    PANEL_NOTIFY_PROC, annule_contrainte_hv,     
		    0);

    
    efface_item =   panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(6),
		    PANEL_LABEL_X, ATTR_COL(20),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		    paneltabs[538], 0, 0),
                    PANEL_NOTIFY_PROC, efface,     
		    0);

    sauve_item =    panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(6),
		    PANEL_LABEL_X, ATTR_COL(0),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		    paneltabs[539], 0, 0),
		    PANEL_NOTIFY_PROC, sauve_im_ds_plan,
		    0);

    sortie_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(7),
		    PANEL_LABEL_X, ATTR_COL(9),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel,
		    paneltabs[540], 0, 0),
		    PANEL_NOTIFY_PROC, quit_frame_base,     
		    0);

    mess1 = panel_create_item (mainpanel, PANEL_MESSAGE,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(5),
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_STRING,paneltabs[541], 
		    0);

    mess2 = panel_create_item (mainpanel, PANEL_MESSAGE,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(6),
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_STRING,paneltabs[542], 
		    0);

    mess3 = panel_create_item (mainpanel, PANEL_MESSAGE,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(7),
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_STRING, paneltabs[543],
		    0);

    eff_tout = panel_create_item (mainpanel, PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(6),
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		    paneltabs[544], 0,0),
		    PANEL_NOTIFY_PROC, efface_tout,
		    0);

    eff_seg = panel_create_item (mainpanel, PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(6),
		    PANEL_LABEL_X, ATTR_COL(20),
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, "Segment",0,0),
		    PANEL_NOTIFY_PROC, efface_segment,
		    0);

    comment1_item = panel_create_item(mainpanel, PANEL_MESSAGE,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(10),
		    PANEL_LABEL_X, ATTR_COL(0),	
                    PANEL_LABEL_STRING, paneltabs[545],
		    0);

    comment2_item = panel_create_item(mainpanel, PANEL_MESSAGE,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(11),
		    PANEL_LABEL_X, ATTR_COL(0),	
                    PANEL_LABEL_STRING, paneltabs[546], 
		    0);

    segments_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(13),
		    PANEL_LABEL_X, ATTR_COL(9),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, "Segment", 0, 0),
		    PANEL_NOTIFY_PROC, segments,     
		    0);
    
    plein_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(13),
		    PANEL_LABEL_X, ATTR_COL(0),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		    paneltabs[547], 0, 0),
		    PANEL_NOTIFY_PROC, segment_plein,     
		    0);

    contour_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(13),
		    PANEL_LABEL_X, ATTR_COL(18),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		    paneltabs[548], 0, 0),
		    PANEL_NOTIFY_PROC, segment_contour,     
		    0);
    
    
    return;
	
}

/****************************************************************************************/
/*  nom	    :	create_mainpanel_color_items						*/
/*											*/
/*  fonction:	cree les items supplementaires necessaire a une image couleur		*/
/*											*/
/*  entrees :	aucune									*/
/*											*/
/*  globales:	aucune									*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	lire							        	*/
/*		cree_fenetre_couleur							*/
/*		change_fond								*/
/*		change_couleur_segment							*/
/*		expose_segment								*/
/*											*/
/****************************************************************************************/


static void create_mainpanel_color_items()
{
    creation_couleur_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(5),
		    PANEL_LABEL_X, ATTR_COL(10),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, "Creation", 0, 0),
		    PANEL_NOTIFY_PROC, cree_fenetre_couleur,     
		    0);

    change_couleur_fond_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(15),
		    PANEL_LABEL_X, ATTR_COL(0),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		    paneltabs[549], 0, 0),
		    PANEL_NOTIFY_PROC, change_fond,     
		    0);

    mess2change = panel_create_item (mainpanel, PANEL_MESSAGE,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(6),
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_STRING, paneltabs[550], 
		    0);

    mess2expose = panel_create_item (mainpanel, PANEL_MESSAGE,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(6),
		    PANEL_LABEL_X, ATTR_COL(0),
		    PANEL_LABEL_STRING, paneltabs[551],
		    0);

    change_couleur_seg_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(15),
		    PANEL_LABEL_X, ATTR_COL(15),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		    paneltabs[552], 0, 0),
		    PANEL_NOTIFY_PROC, change_couleur_segment,     
		    0);

    expose_segment_item = panel_create_item(mainpanel, 
		    PANEL_BUTTON,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_Y, ATTR_ROW(17),
		    PANEL_LABEL_X, ATTR_COL(10),	
		    PANEL_LABEL_IMAGE, panel_button_image(mainpanel, 
		    "Expose", 0, 0),
		    PANEL_NOTIFY_PROC, expose_segment,     
		    0);


    fond_item = panel_create_item(mainpanel, 
		    PANEL_TEXT,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_STRING, paneltabs[553],
		    PANEL_VALUE_DISPLAY_LENGTH, 3, 
		    PANEL_LABEL_Y, ATTR_ROW(15),
		    PANEL_LABEL_X, ATTR_COL(0),	
		    PANEL_NOTIFY_PROC, lire,     
		    0);

    couleur_seg_item = panel_create_item(mainpanel, 
		    PANEL_TEXT,
		    PANEL_SHOW_ITEM, FALSE,
		    PANEL_LABEL_STRING, paneltabs[554],
		    PANEL_VALUE_DISPLAY_LENGTH, 3, 
		    PANEL_LABEL_Y, ATTR_ROW(14),
		    PANEL_LABEL_X, ATTR_COL(0),	
		    PANEL_NOTIFY_PROC, lire,     
		    0);
    return;

}


/****************************************************************************************/
/*  nom	    :	lire_point								*/
/*											*/
/*  fonction:	lit les valeur pour les items donnant la valeur du point a dessiner.	*/
/*											*/
/*  entrees :	Panel_item  item                                                        */
/*		Event	    event							*/
/*											*/
/*  globales:	short	xdim                                                            */
/*	        short   ydim                                                            */
/*		int	type								*/
/*		int	fonction							*/
/*		short	couleur_courante						*/
/*		short	couleur_fond							*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	saisie_controle  							*/
/*		reaffichage								*/ 
/*											*/ 
/****************************************************************************************/


static Panel_setting lire_point(item,event)

Panel_item  item;
Event	*event;
{
    short   i = -1;
    short   c;

    i = atoi((char*) panel_get_value(item));
    if (i < 0)
    {
	panel_set_value (item, "");
	return;
    }
    if (item == pos_x_item)
    {
	if (i >= xdim)
	{
	    panel_set_value (item, "");
	    return; 
	}
	pos_x = i;
	return(PANEL_NEXT);
    }
    if (item == pos_y_item)
    {
	if (i >= ydim)
	{
	    panel_set_value (item, "");
	    return; 
	}
	pos_y = i;
	

    /* Mise a jour de la liste des points et affichage du point  ( dans ce cas la */
    /* contrainte est ignoree)							  */

	if (pt_debut == NULL)
	    {
		pt_debut = (ptr_point) calloc (1,sizeof (struct coords));
		pt_courant = pt_debut ;

		pt_courant -> next = NULL;
		pt_courant -> x = pos_x;
		pt_courant -> y = pos_y;
	    }
	else
	    {
		pt_courant -> next = (ptr_point) calloc (1,sizeof (struct coords));
		pt_courant = pt_courant -> next;

		pt_courant -> next = NULL;
		pt_courant -> x = pos_x;
		pt_courant -> y = pos_y;
	    }
	if (type == MONO)	c=1;
	else
	    if (couleur_fond >127) c=0;
	    else c=255;

	pw_put(pw, pt_courant -> x, pt_courant -> y, c);

    	nbr_pts++;

	panel_set_value (pos_x_item, "");
	panel_set_value (pos_y_item, "");
	return(PANEL_NEXT);
    }
}

/****************************************************************************************/
/*  nom	    :	lire								        */
/*											*/
/*  fonction:	lit les valeur pour tous les items de type texte.			*/
/*											*/
/*  entrees :	Panel_item  item                                                        */
/*		Event	    event							*/
/*											*/
/*  globales:	short	xdim                                                            */
/*	        short   ydim                                                            */
/*		int	type								*/
/*		int	fonction							*/
/*		short	couleur_courante						*/
/*		short	couleur_fond							*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	saisie_controle  							*/
/*		reaffichage								*/ 
/*											*/ 
/****************************************************************************************/


static Panel_setting lire(item,event)

Panel_item  item;
Event	*event;

{
    short i = 0;
 
    i = atoi((char*) panel_get_value(item));
    
    if (item == dimx_item) 
    {
	if (i <= 0) 
	{
	    panel_set_value (item, "");
	    return;
	}

	xdim = i;

	return(PANEL_NEXT);
    }
    else 
	if (item == dimy_item) 
	{  
	    if (i <= 0) 
	    {
		panel_set_value (item, "");
		return;
	    }

	    ydim = i;

	    if (type == MONO)
		panel_set (creation_item, PANEL_SHOW_ITEM, TRUE, 0);
	    else
		panel_set (creation_couleur_item, PANEL_SHOW_ITEM, TRUE, 0);
	    return(PANEL_NEXT);
	 }

    if (item == fond_item)
	if ((i > 255) || (i < 0))
	{
	    panel_set_value (item, "");
	    return;
	}
	else
	{
	    couleur_fond = i;
	    reaffichage();
	    panel_set (fond_item,PANEL_SHOW_ITEM, FALSE, 0);
	    panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, TRUE, 0);
	    panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, TRUE, 0);
	    panel_set (expose_segment_item, PANEL_SHOW_ITEM, TRUE, 0);
	    return(PANEL_NEXT);

	}
    if (item == couleur_seg_item)
	if ((i > 255) || (i < 0))
	{
	    panel_set_value (item, "");
	    return;
	}
	else
	    if (fonction != CHANGE_COULEUR)
	    {
		couleur_courante = i;
		panel_set (couleur_seg_item, PANEL_SHOW_ITEM, FALSE, 0);
		panel_set (plein_item, PANEL_SHOW_ITEM, TRUE, 0);
		panel_set (contour_item, PANEL_SHOW_ITEM, TRUE, 0);
		return(PANEL_NEXT);
	    }
	    else
	    {
		couleur_courante = i;
		panel_set (couleur_seg_item, PANEL_SHOW_ITEM, FALSE, 0);
		panel_set (mess1, PANEL_SHOW_ITEM, TRUE, 0);
		panel_set (mess2change, PANEL_SHOW_ITEM, TRUE, 0);
		panel_set (mess3, PANEL_SHOW_ITEM, TRUE, 0); 
    
		window_set (canvas, WIN_EVENT_PROC, saisie_controle, 0);
		return(PANEL_NEXT);
	    }
    return;
	
}

/****************************************************************************************/
/*  nom	    :	cree_fenetre_mono							*/
/*											*/
/*  fonction:	cree un frame independant contenant un canvas correspondant a l'image   */
/*              a creer (=> les dimensions du canvas sont celles de l'image).		*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:	short	xdim                                                            */
/*	        short   ydim                                                            */
/*		short	couleur_courante						*/
/*		short	couleur_fond							*/
/*		Pixwin  *pw                                                             */
/*              Frame   frame_image             					*/
/*              Canvas  canvas                 						*/
/*                               							*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	write_master  								*/
/*		saisie_pts								*/
/*		init_liste_pts								*/
/*		init_liste_seg								*/
/*											*/
/****************************************************************************************/


extern void cree_fenetre_mono()
{

unsigned char	*d;
char		*num;
int	j, pos_x, pos_y;
    
    if (flag_chablon >= 1)
    {
	xdim = (int) window_get(last_can, CANVAS_WIDTH);
	ydim = (int) window_get(last_can, CANVAS_HEIGHT);
	pos_x = (int) window_get(last_fr, WIN_X) - (int) window_get(frame, WIN_X)
		+ (int) window_get(last_fr, WIN_WIDTH);
	pos_y = (int) window_get(last_fr, WIN_Y) - (int) window_get(frame, WIN_Y)+ 15;
    }
    else
    {
	pos_x = 500;
	pos_y = 400;
    }
      


    frame_image = window_create(frame, FRAME,
		    FRAME_SHOW_LABEL, TRUE,
		    FRAME_EMBOLDEN_LABEL, TRUE,
		    FRAME_LABEL, "Mono Image: ",
		    WIN_SHOW, TRUE,
		    WIN_X, pos_x,
		    WIN_Y, pos_y,
		    0);	

    canvas = window_create(frame_image, CANVAS,
		    CANVAS_AUTO_SHRINK, FALSE,
		    CANVAS_AUTO_EXPAND, FALSE,
		    CANVAS_AUTO_CLEAR, TRUE,
		    CANVAS_FIXED_IMAGE, FALSE,
		    CANVAS_FAST_MONO, TRUE,	/* On cree le canvas dans l'overlay */
		    CANVAS_WIDTH, xdim,
		    CANVAS_HEIGHT, ydim,
		    WIN_WIDTH, xdim, 
		    WIN_HEIGHT, ydim,
		    WIN_EVENT_PROC, saisie_pts,
		    0);

    framemenu = (Menu) window_get(frame_image, WIN_MENU, 0);
    menu_set(framemenu, MENU_REMOVE, 1,
		MENU_ACTION_ITEM, "Quit*", quit_frame_image,
		0);
    window_set(frame_image, WIN_MENU, framemenu, 0);

    window_fit (frame_image);		/* L'ordre est important: il implique que lors*/
    window_fit (canvas);		/* d'un resize, le cadre du canvas reste a ses*/
					/* dimensions initiales                       */
    couleur_fond = 0;
    couleur_courante = 1;		/* Image noir/blanc dans l'overlay => 1 bit   */
    pw = canvas_pixwin (canvas);


      pw_writebackground (pw, 0, 0, xdim, ydim, PIX_SRC);
	
    if (flag_chablon == 0)
    {
	panel_set (creation_item, PANEL_SHOW_ITEM, FALSE, 0); 
	panel_set (dimx_item, PANEL_SHOW_ITEM, FALSE, 0); 
	panel_set (dimy_item, PANEL_SHOW_ITEM, FALSE, 0); 
	panel_set_value (dimx_item, "");
	panel_set_value (dimy_item, "");
    }
    else
    { 
	panel_set (aff_mess1_item, PANEL_SHOW_ITEM, FALSE, 0);		
	panel_set (aff_mess2_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (affiche_item, PANEL_SHOW_ITEM, FALSE, 0);
    }
    panel_set (sauve_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (sortie_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (contrainte_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (efface_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment1_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment2_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (segments_item, PANEL_SHOW_ITEM, TRUE, 0);

    num = (char *) calloc (10, sizeof(char));
    strcpy(buf, mastertabs[373]);
    write_master(buf);
    strcpy(buf, "X:");
    sprintf(num, " %d ", xdim);
    strcat(buf, num);
    strcat(buf, "  Y:");
    sprintf(num, " %d ", ydim);
    strcat(buf, num);
    strcat(buf,"\n");
    write_master(buf);

    
    init_liste_pts();
    init_liste_seg();
    return;

}


/****************************************************************************************/
/*  nom	    :	cree_fenetre_couleur							*/
/*											*/
/*  fonction:	cree un frame independant contenant un canvas correspondant a l'image   */
/*              couleur a creer (=> les dimensions du canvas sont celles de l'image).	*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:	short	xdim                                                            */
/*	        short   ydim                                                            */
/*		short	couleur_courante						*/
/*		short	couleur_fond							*/
/*		Pixwin  *pw                                                             */
/*              Frame   frame_image             					*/
/*              Canvas  canvas                 						*/
/*                               							*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	write_master  								*/
/*		saisie_pts								*/
/*		init_liste_pts								*/
/*		init_liste_seg								*/
/*											*/ 
/****************************************************************************************/


static void cree_fenetre_couleur()
{
    struct pixrect	*im_pixrect;
    unsigned char	*d;
    int			j;

    contrainte = 0;
    frame_image = window_create(frame, FRAME, 
		    FRAME_SHOW_LABEL, TRUE,
		    FRAME_EMBOLDEN_LABEL, TRUE,
		    FRAME_LABEL, paneltabs[555],
		    WIN_SHOW, TRUE,
		    WIN_X, 500,
		    WIN_Y, 400,
		    0);	

    canvas = window_create(frame_image, CANVAS,
		    CANVAS_AUTO_SHRINK, FALSE,
		    CANVAS_AUTO_EXPAND, FALSE,
		    CANVAS_AUTO_CLEAR, TRUE,
		    CANVAS_FIXED_IMAGE, FALSE,
		    CANVAS_WIDTH, xdim,
		    CANVAS_HEIGHT, ydim,
		    WIN_WIDTH, xdim, 
		    WIN_HEIGHT, ydim,
		    WIN_EVENT_PROC, saisie_pts,
		    0);
    framemenu = (Menu) window_get(frame_image, WIN_MENU, 0);
    menu_set(framemenu, MENU_REMOVE, 1,
		MENU_ACTION_ITEM, "Quit*", quit_frame_image,
		0);
    window_set(frame_image, WIN_MENU, framemenu, 0);

    window_fit (frame_image);		/* L'ordre est important: il implique que lors*/
    window_fit (canvas);		/* d'un resize, le cadre du canvas reste a ses*/
					/* dimensions initiales                       */
    couleur_fond = 0;
    couleur_courante = 255 ;		
    pw = canvas_pixwin (canvas);
    pw_setcmsname (pw, "lin");
    pw_putcolormap (pw, 0, 256, nivgrislin[0], nivgrislin[1], nivgrislin[2]);
    if (( im_pixrect = mem_create (xdim, ydim,8)) == NULL)
	{
	    write_erreur(3);
	    return;
	}

    d = (unsigned char *) mpr_d(im_pixrect) -> md_image;
    for (j = 0 ; j < (xdim*ydim); j++)
    {
	*d = couleur_fond;
	d++;
    }
        
    

    pw_write (pw, 0, 0, xdim, ydim, PIX_SRC, im_pixrect, 0, 0);

	
    
    panel_set (creation_couleur_item, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (dimx_item, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (dimy_item, PANEL_SHOW_ITEM, FALSE, 0); 

    panel_set (contrainte_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (sauve_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (efface_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (sortie_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment1_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment2_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (segments_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (expose_segment_item, PANEL_SHOW_ITEM, TRUE, 0);

    strcpy(buf, mastertabs[374]);
    write_master(buf);
    strcpy(buf, "X:");
    strcat(buf,panel_get_value(dimx_item));
    strcat(buf, "  Y:");
    strcat(buf,panel_get_value(dimy_item));
    strcat(buf,"\n");
    write_master(buf);

    panel_set_value (dimx_item, "");
    panel_set_value (dimy_item, "");

    init_liste_pts();
    init_liste_seg();
    return;
}

/****************************************************************************************/
/*  nom	    :	change_fond     							*/
/*											*/
/*  fonction:	change la couleur du fond de l'image					*/
/*											*/
/*  entrees :	aucune	                                                                */
/*											*/
/*  globales:	aucune		                                                        */
/*                               							*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	aucune									*/
/*											*/
/****************************************************************************************/

static void change_fond()
{
    panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (expose_segment_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (fond_item, PANEL_SHOW_ITEM, TRUE, 0);
    
    return;
}

/****************************************************************************************/
/*  nom	    :	change_couleur_segment							*/
/*											*/
/*  fonction:	initialise le panneau d'interaction pour changer la valeur d'un segment */
/*											*/
/*  entrees :	aucune	                                                                */
/*											*/
/*  globales:	short	controle_x                                                      */
/*              short	controle_y							*/
/*		int	fonction							*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	aucune									*/
/*											*/
/****************************************************************************************/

static void change_couleur_segment()
{
    fonction = CHANGE_COULEUR;
    controle_x = -1;
    controle_x = -1;
    
    panel_set (contrainte_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (annule_contrainte_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (sauve_item, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (efface_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (sortie_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (comment1_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (comment2_item, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (segments_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (expose_segment_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (couleur_seg_item, PANEL_SHOW_ITEM, TRUE, 0);
    
    return;
    
}

/****************************************************************************************/
/*  nom	    :	change_couleur_seg							*/
/*											*/
/*  fonction:	change la valeur d'un segment selectionne par un de ces points de       */
/*		controle.								*/
/*											*/
/*  entrees :	aucune	                                                                */
/*											*/
/*  globales:	short	    controle_x                                                  */
/*              short	    controle_y							*/	
/*              short	    couleur_courante						*/
/*		ptr_seg	    seg_debut                                                   */
/*                               							*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	reaffichage								*/
/*		saisie_pts								*/
/*											*/
/****************************************************************************************/

static void change_couleur_seg()
{   
    ptr_seg stemp, oldstemp;
    int	    found =0, px, py;

    if (seg_debut != NULL)
    {
	if ((controle_x >= 0) && (controle_y >= 0)) 
	{
	    recherche (&oldstemp,&stemp);
	
	    stemp -> couleur = couleur_courante;
	    reaffichage();
	}
    panel_set (mess1, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (mess2change, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (mess3, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (sauve_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (efface_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (sortie_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment1_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment2_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (segments_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, TRUE, 0); 
    panel_set (expose_segment_item, PANEL_SHOW_ITEM, TRUE, 0); 
    window_set (canvas, WIN_EVENT_PROC, saisie_pts, 0);
    }
    
    return;
}

/****************************************************************************************/
/*  nom	    :	saisie_souris       							*/
/*											*/
/*  fonction:	Mise a jour des items et de leur fonction respective pour reactiver     */
/*              la saisie des points a l'aide de la souris		                */
/*											*/
/*  entrees :	Canvas	canvas                                                          */
/*		Event   event								*/
/*											*/
/*  globales:	Canvas	canvas	                                                        */
/*                               							*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	saisie_pts								*/
/*											*/
/****************************************************************************************/

static void saisie_souris()
{
    panel_set (pos_x_item, PANEL_NOTIFY_PROC, NULL, 0);
    panel_set (pos_y_item, PANEL_NOTIFY_PROC, NULL, 0);

    panel_set_value (pos_x_item, "");
    panel_set_value (pos_y_item, "");

    window_set (canvas, WIN_EVENT_PROC, saisie_pts, 0);

    panel_set (souris_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (clavier_item, PANEL_SHOW_ITEM, TRUE, 0);

    return;
}

/****************************************************************************************/
/*  nom	    :	saisie_clavier      							*/
/*											*/
/*  fonction:	Mise a jour des items et de leur fonction respective pour reactiver     */
/*              la saisie des points a l'aide du clavier				*/
/*											*/
/*  entrees :	Canvas	canvas                                                          */
/*		Event   event								*/
/*											*/
/*  globales:	Canvas	canvas	                                                        */
/*                               							*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	lire_point								*/
/*											*/
/****************************************************************************************/

static void saisie_clavier()
{
    window_set (canvas, WIN_EVENT_PROC, NULL, 0);
    panel_set (clavier_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (souris_item, PANEL_SHOW_ITEM, TRUE, 0);

    panel_set_value (pos_x_item, "");
    panel_set_value (pos_y_item, "");

    panel_set (pos_x_item, PANEL_NOTIFY_PROC, lire_point, 0);
    panel_set (pos_y_item, PANEL_NOTIFY_PROC, lire_point, 0);
    return;
}



/****************************************************************************************/
/*  nom	    :	saisie_pts       							*/
/*											*/
/*  fonction:	affiche dans le canvas les points cliques par l'utilisateur  et stocke  */
/*              leur position (x,y) dans un tableau de coordonnees (tab_pts)            */
/*											*/
/*  entrees :	Canvas	canvas                                                          */
/*		Event   event								*/
/*											*/
/*  globales:	ptr_point  pt_debut                                                     */
/*              ptr_point  pt_courant   						*/
/*              short	nbr_pts                 			        	*/
/*              short	couleur_fond                			        	*/
/*              int	type          							*/
/*              int	contrainte     							*/
/*                               							*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	aucune									*/
/*											*/
/****************************************************************************************/


extern void saisie_pts (canvas, event) 
    Canvas	canvas;
    Event	*event;

{
    short   c;
    int	    x, y;
    char    *num;

    if (event_id(event) == MS_LEFT)
    {
	if (event_is_down(event) == TRUE)
	{   
	    if (pt_debut == NULL)
	    {
		pt_debut = (ptr_point) calloc (1,sizeof (struct coords));
		pt_courant = pt_debut ;

		pt_courant -> next = NULL;
		pt_courant -> x = event_x(event);
		pt_courant -> y = event_y(event);
	    }
	    else
		switch (contrainte) 
		{
		    case 0 : pt_courant -> next = (ptr_point) calloc (1,sizeof (struct coords));
			     pt_courant = pt_courant -> next;

			     pt_courant -> next = NULL;
			     pt_courant -> x = event_x(event);
			     pt_courant -> y = event_y(event);
			     break;

		    case 1 : if (abs((pt_courant -> x) - (event_x(event))) < 
						abs((pt_courant -> y) - (event_y(event))))
			     {
				 x = pt_courant -> x;
				 y = event_y(event);
			     }
			     else
			     {
				 x = event_x(event);
				 y = pt_courant -> y;
			     }
			     pt_courant -> next = (ptr_point) calloc (1,sizeof (struct coords));
			     pt_courant = pt_courant -> next;

			     pt_courant -> next = NULL;
			     pt_courant -> x = x;
			     pt_courant -> y = y;
			     break;
		 }

	    if (type == MONO)	c=1;
	    else
		if (couleur_fond >127) c=0;
		else c=255;

	    pw_put(pw, pt_courant -> x, pt_courant -> y, c);

	    nbr_pts++;
	
	    num = (char *) calloc (10, sizeof(char));
	    sprintf(num, "%d ", pt_courant -> x);
	    panel_set_value ( pos_x_item, num);
	    sprintf(num, "%d ", pt_courant -> y);
	    panel_set_value ( pos_y_item, num);
	}

    }
    
    return;
}

/****************************************************************************************/
/*  nom	    :	saisie_controle     							*/
/*											*/
/*  fonction:	lit dans le canvas le point clique par l'utilisateur , ce point est     */
/*              celui qui permettra de determiner le segment a traiter	                */
/*											*/
/*  entrees :	Canvas	canvas                                                          */
/*		Event   event								*/
/*											*/
/*  globales:	short	controle_x                                                      */
/*              short	controle_y                 					*/
/*              int	fonction               						*/
/*                               							*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	efface_seg								*/
/*              change_couleur_seg       						*/
/*              expose_seg	  							*/
/*											*/ 
/****************************************************************************************/


static void saisie_controle(canvas, event)

    Canvas  canvas;
    Event	*event;

{
    
if ((event_id(event) == MS_MIDDLE) && ((controle_x < 0) || (controle_y < 0)))
    {
	if (event_is_down(event) == TRUE)
	{
	    controle_x = event_x(event);
	    controle_y = event_y(event);
	    if (fonction == EFFACE) efface_seg();
	    if (fonction == CHANGE_COULEUR) change_couleur_seg();
	    if (fonction == EXPOSE) expose_seg();
	}
    }

    return;
}

/****************************************************************************************/
/*  nom	    :	contrainte_hv							        */
/*									                */
/*  fonction:	Oblige les segments de droites crees a etre soit verticaux soit		*/
/*		horizontaux (se contente de changer la variable globale contrainte),	*/
/*		la containte effective se fait au niveau de la saisie des points.	*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   int	contrainte      						*/
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	aucune	        							*/
/*											*/
/****************************************************************************************/

static void contrainte_hv()

{
    contrainte = 1;
    panel_set (contrainte_item, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (annule_contrainte_item, PANEL_SHOW_ITEM, TRUE, 0); 
    
    return;
}


/****************************************************************************************/
/*  nom	    :	annule_contrainte_hv						        */
/*									                */
/*  fonction:	Annule la contrainte sur les segments de droites (se contente de changer*/
/*		la variable globale contrainte).					*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   int	contrainte      						*/
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	aucune		     							*/
/*											*/
/****************************************************************************************/

static void annule_contrainte_hv()

{
    contrainte = 0;
    panel_set (annule_contrainte_item, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (contrainte_item, PANEL_SHOW_ITEM, TRUE, 0); 
    
    return;
}

/****************************************************************************************/
/*  nom	    :	efface								        */
/*									                */
/*  fonction:	Initialise variables et items pour l'effacement .   			*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   Canvas	canvas                                                          */
/*              short	controle_x                                                      */
/*	        short   controle_y                                                      */
/*              int	fonction       							*/
/*              int	flag_chablon       						*/
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	efface_tout	     							*/
/*		efface_segment								*/
/*											*/
/****************************************************************************************/

static void efface()

{
    fonction = EFFACE;
    controle_x = -1;
    controle_y = -1;
    
    window_set (canvas, WIN_EVENT_PROC, NULL, 0);

    panel_set (efface_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (comment1_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (comment2_item, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (segments_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (sauve_item, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (sortie_item, PANEL_SHOW_ITEM, FALSE, 0); 

    if (flag_chablon == 0)
    { 
	panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (expose_segment_item, PANEL_SHOW_ITEM, FALSE , 0);
    }
    panel_set (eff_tout, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (eff_seg, PANEL_SHOW_ITEM, TRUE, 0);

    return;        
}


/****************************************************************************************/
/*  nom	    :	efface_tout          							*/
/*											*/
/*  fonction:	efface le contenu du canvas et initialise les listes de segments et     */
/*		de points								*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   Pixwin  *pw                                                             */
/*              short	xdim                                                            */
/*	        short   ydim                                                            */
/*	        short   couleur_fond                                                    */
/*              Canvas	canvas                                                          */
/*              int	flag_chablon							*/
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	init_liste_pts								*/
/*		init_liste_seg								*/
/*		write_master								*/
/*		saisie_pts								*/
/*											*/
/****************************************************************************************/

static void efface_tout()
{ 
    init_liste_pts();
    init_liste_seg();
    pw_writebackground(pw, 0, 0, xdim, ydim, (PIX_SRC | PIX_COLOR(couleur_fond)));

    panel_set (eff_tout, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (eff_seg, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (efface_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment1_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment2_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (segments_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (sauve_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (sortie_item, PANEL_SHOW_ITEM, TRUE, 0);

    if (flag_chablon ==0)
    {
    panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (expose_segment_item, PANEL_SHOW_ITEM, TRUE, 0);
    }
    strcpy(buf, mastertabs[381]);
    write_master(buf);
    window_set (canvas, WIN_EVENT_PROC, saisie_pts, 0);

    return;
}

/****************************************************************************************/
/*  nom	    :	efface_segment         							*/
/*											*/
/*  fonction:	Initialisation pour l'effacement d'un segment				*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   Canvas	canvas                                                          */
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	saisie_controle								*/
/*											*/
/****************************************************************************************/

static void efface_segment()
{
    panel_set (eff_tout, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (eff_seg, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (mess1, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (mess2, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (mess3, PANEL_SHOW_ITEM, TRUE, 0);
    
    window_set (canvas, WIN_EVENT_PROC, saisie_controle, 0);

    return;
}

/****************************************************************************************/
/*  nom	    :	efface_seg          							*/
/*											*/
/*  fonction:	efface un segment choisi par l'utilisateur et met a jour la liste des	*/
/*		segments ainsi que celles des points.					*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   Canvas	canvas                                                          */
/*              short	controle_x                                                      */
/*	        short   controle_y                                                      */
/*              ptr_seg	seg_debut                                                       */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	recherche	  							*/
/*		reaffichage								*/
/*		saisie_pts								*/
/*		extract_seg								*/
/*		write_master								*/
/*											*/
/****************************************************************************************/

static  void efface_seg()


{
    ptr_seg stemp, oldstemp;

    
    if (seg_debut != NULL)
    {
	if ((controle_x >= 0) && (controle_y >= 0)) 
	{
	    recherche (&oldstemp,&stemp); 
			  
	    extract_seg (&oldstemp,&stemp);
	    reaffichage();
	    strcpy (buf, mastertabs[382]);
	    write_master (buf);
	}
    }
    panel_set (mess1, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (mess2, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (mess3, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (efface_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment1_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment2_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (segments_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (sauve_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (sortie_item, PANEL_SHOW_ITEM, TRUE, 0);

    if (flag_chablon == 0)
    {
	panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, TRUE, 0);
	panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, TRUE, 0);
	panel_set (expose_segment_item, PANEL_SHOW_ITEM, TRUE, 0);
    }
    window_set (canvas, WIN_EVENT_PROC, saisie_pts, 0);

    return;
}




/****************************************************************************************/
/*  nom	    :	recherche	          						*/
/*											*/
/*  fonction:	cherche le segment auquel appartient le point x,y                       */
/*											*/
/*  entrees :	short	xx,yy	                                                        */
/*		ptr_seg	*stemp								*/
/*											*/
/*  globales:   ptr_seg	seg_debut                                                       */ 
/*                                                                                      */
/*  return  :	aucun					    				*/
/*											*/
/*  routines:	aucune		 							*/
/*											*/ 
/****************************************************************************************/

static void recherche (old_seg_det, seg_det)

    ptr_seg	*seg_det;
    ptr_seg	*old_seg_det;

    

{
    ptr_point	ptemp;
    ptr_seg	seg_temp, old_seg_temp;
    float	norme, n;
    int		px, py;

    px = controle_x;
    py = controle_y;

    old_seg_temp = NULL;	/* Si reste nil => pt trouve dans premier segment     */
				/* sinon, pointe le segment precedent celui contenant */
				/* le point cherche.				      */
    seg_temp = seg_debut;
    norme = (float) sqrt ((float)((xdim*xdim) + (ydim*ydim))); 
    while ((seg_temp) != NULL) 
    {
	ptemp = (seg_temp) -> pts;
	while (ptemp != NULL)
	{
	    n = sqrt ((float)((ptemp -> x - px)*(ptemp -> x - px) + 
			(ptemp -> y - py)*(ptemp -> y - py))); 
	    if ( n < norme)
	    {
		norme = n;
		*seg_det = seg_temp;
		*old_seg_det = old_seg_temp;
	    }
	    ptemp = ptemp -> next;
	}
	old_seg_temp = seg_temp;
	seg_temp = (seg_temp) -> suivant;
    }
    return ;

}

/****************************************************************************************/
/*  nom	    :	free_liste_pts          						*/
/*											*/
/*  fonction:	libere la liste des points pointee par pptr .                           */
/*											*/
/*  entrees :	ptr_point   pptr                                                        */
/*											*/
/*  globales:   aucune                                                                  */ 
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	aucune		 							*/
/*											*/ 
/****************************************************************************************/

static void free_liste_pts(pptr)
	
    ptr_point   *pptr;
{
    ptr_point   p;

    while (*pptr != NULL)
    {
		
	p = *pptr;
	*pptr = (*pptr) -> next;
	cfree(p);
    }
    return;
}

/****************************************************************************************/
/*  nom	    :	expose_segment								*/
/*											*/
/*  fonction:	Initialise variables et items pour exposer un segment			*/
/*											*/
/*  entrees :	aucune		                                                        */
/*			    								*/
/*  globales:   Canvas	canvas                                                          */
/*              short	controle_x                                                      */
/*	        short   controle_y                                                      */
/*		int	fonction                                                        */
/*              ptr_seg seg_debut                                                       */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	saisie_controle								*/
/*											*/
/****************************************************************************************/

static void expose_segment()
{
    if (seg_debut != NULL)
    {
    fonction = EXPOSE;
    controle_x = -1;
    controle_y = -1;
    window_set (canvas, WIN_EVENT_PROC, NULL, 0);

    panel_set (sauve_item, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (efface_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (sortie_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (comment1_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (comment2_item, PANEL_SHOW_ITEM, FALSE, 0); 
    panel_set (segments_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (expose_segment_item, PANEL_SHOW_ITEM, FALSE , 0);   
    panel_set (mess1, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (mess2expose, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (mess3, PANEL_SHOW_ITEM, TRUE, 0); 
    
    window_set (canvas, WIN_EVENT_PROC, saisie_controle, 0); 
    }
    return;
}

/****************************************************************************************/
/*  nom	    :	expose_seg								*/
/*											*/
/*  fonction:	expose un segment choisi par l'utilisateur en mettant a jour la liste	*/
/*		des segments .								*/
/*											*/
/*  entrees :	aucune	         		                                        */
/*			    								*/
/*  globales:   Canvas	canvas                                                          */
/*              short	controle_x                                                      */
/*	        short   controle_y                                                      */
/*		ptr_seg	    seg_courant	                                                */
/*              ptr_seg	    seg_debut                                                   */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	free_liste_pts		 						*/
/*		reaffichage								*/
/*		recherche								*/
/*		saisie_pts								*/
/*											*/
/****************************************************************************************/

static void expose_seg()
{
   ptr_seg stemp, oldstemp;

    if (seg_debut != NULL)
    {
     if ((controle_x >= 0) && (controle_y >= 0)) 
     {
	recherche (&oldstemp,&stemp); 


    /* Extraction du segment et positionnement en fin de liste => dernier a etre */
    /* affiche, donc vient par dessus tout					 */
	if (stemp != seg_courant)
	{
	    if (oldstemp == NULL)	/* Premier segment de la liste */
		seg_debut = stemp -> suivant;
	    else
		oldstemp -> suivant = stemp -> suivant;
	    stemp -> suivant = NULL;
	    seg_courant -> suivant = stemp;
	    seg_courant = seg_courant -> suivant;

	    reaffichage();
	}
     }
    panel_set (mess1, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (mess2expose, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (mess3, PANEL_SHOW_ITEM, FALSE, 0); 	
    panel_set (sauve_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (efface_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (sortie_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment1_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment2_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (segments_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, TRUE, 0); 
    panel_set (expose_segment_item, PANEL_SHOW_ITEM, TRUE, 0); 
    window_set (canvas, WIN_EVENT_PROC, saisie_pts, 0); 
    }
    return;
}

/****************************************************************************************/
/*  nom	    :	extract_seg								*/
/*											*/
/*  fonction:	extrait un element pointe par sptr de la liste des segment et libere	*/
/*		l'espace memoire rattache a ce segment, oldsptr etant l'element le	*/
/*		precedant.								*/
/*											*/
/*  entrees :	ptr_seg	    *sptr                                                       */
/*		ptr_seg	    *oldsptr                                    		*/
/*			    								*/
/*  globales:   ptr_seg	    seg_courant	                                                */
/*              ptr_seg	    seg_debut                                                   */
/*              int	    nbr_seg                                                     */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	free_liste_pts		 						*/
/*											*/
/****************************************************************************************/

static void extract_seg(oldsptr,sptr)

    ptr_seg	*oldsptr;
    ptr_seg	*sptr;

{

    if ((*oldsptr) == NULL)                 /* On extrait le premier element */
    {
	if ((*sptr) -> suivant == NULL)	    /* Si on extrait le dernier element => */
	    seg_courant = *oldsptr;	    /* mise a jour du pointeur courant	   */

	seg_debut = (*sptr) -> suivant;
    }
    else
    {
	
	if ((*sptr) -> suivant == NULL)	    /* Si on extrait le dernier element => */
	    seg_courant = *oldsptr;	    /* mise a jour du pointeur courant	   */
	    
	(*oldsptr) -> suivant = (*sptr) -> suivant;
	
    }
    		/* On libere */
    free_liste_pts(&((*sptr) -> pts));
    (*sptr) -> suivant = NULL;
    cfree(*sptr);
    *sptr = NULL;
    nbr_seg--;

    return;
    
}



/****************************************************************************************/
/*  nom	    :	init_liste_pts          						*/
/*											*/
/*  fonction:	initialise les pointeurs de la liste des points ainsi que le  nombre de */
/*              points courants.							*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   ptr_point   pt_debut                                                    */ 
/*              ptr_point   pt_courant                                                  */
/*	        int	    nbr_pts                                                     */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	aucune		 							*/
/*											*/ 
/****************************************************************************************/

static void init_liste_pts()

    
{
    pt_debut = NULL;
    pt_courant = NULL;
    nbr_pts = 0;

    return;
}

/****************************************************************************************/
/*  nom	    :	init_liste_seg          						*/
/*											*/
/*  fonction:	initialise le pointeur de debut de la liste des segments, le pointeur   */
/*		du segment courant ainsi que le nombre de segments.			*/
/*		De plus, la place memoire des segments est liberee ainsi que celle de   */
/*		leur liste de points.							*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   ptr_seg	seg_debut                                                       */ 
/*              ptr_seg seg_courant                                                     */
/*              int	nbr_seg                                                         */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	free_liste_pts		  						*/
/*											*/
/****************************************************************************************/


static void  init_liste_seg()
{
    ptr_seg	    p;

    while (seg_debut != NULL) 
    {
	
				    	/* On extrait */
	p = seg_debut;		
	seg_debut = seg_debut -> suivant;		    
	    
					/* On libere */
	free_liste_pts(&(p -> pts));
	p -> suivant = NULL;
	cfree(p);
    }
    seg_courant = NULL;
    nbr_seg = 0;

    return;

}


/****************************************************************************************/
/*  nom	    :	detruit_fen_graph          						*/
/*											*/
/*  fonction:	detruit la fenetre graphique.                                           */
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   Frame	frame_image                                                     */  
/*              Panel	mainpanel                                                       */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	write_master								*/ 
/*		init_liste_pts								*/
/*		init_liste_seg								*/
/*											*/
/****************************************************************************************/

static void detruit_fen_graph()

{

if (Confirm("destroy canvas?") == 1){
    window_set(frame_image, FRAME_NO_CONFIRM, TRUE, 0);
    if (window_destroy(frame_image) == 1)
    {
	panel_set (contrainte_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (annule_contrainte_item, PANEL_SHOW_ITEM, FALSE, 0);
        panel_set (sortie_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (creation_item, PANEL_SHOW_ITEM, FALSE, 0);
        panel_set (sauve_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (efface_item, PANEL_SHOW_ITEM, FALSE, 0);
        panel_set (comment1_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (comment2_item, PANEL_SHOW_ITEM, FALSE, 0);
        panel_set (segments_item, PANEL_SHOW_ITEM, FALSE, 0);
        panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (expose_segment_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (dimx_item, PANEL_SHOW_ITEM, TRUE, 0); 
        panel_set (dimy_item, PANEL_SHOW_ITEM, TRUE, 0);
    
	/* Positionnement du curseur dans le panneau d'interaction */

	window_set (frame_base,WIN_MOUSE_XY, 
		(int)panel_get (dimx_item, PANEL_ITEM_X, 0) + 20 ,
		(int)panel_get (dimy_item, PANEL_ITEM_Y, 0) + 30 ,
		0);

	window_set (mainpanel, PANEL_CARET_ITEM, dimx_item, 0); 
 
	init_liste_pts();
	init_liste_seg();

	strcpy(buf, mastertabs[375]);
	write_master(buf);
    }  
    return;
 }
}

/****************************************************************************************/
/*  nom	    :	sauve_im_ds_plan       							*/
/*											*/
/*  fonction:	sauve l'image contenue par le canvas dans un plan d'image		*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globale :	int	    type                                                        */  
/*		int	    index_image[]						*/
/*		short	    xdim							*/
/*		short	    ydim							*/
/*		struct description_memoire  dir_desc[]					*/
/*		struct directoire_image	    dir_image[]					*/
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	         								*/
/*											*/ 
/****************************************************************************************/

static void sauve_im_ds_plan()
{
    struct pixrect  *dest_pr;
    unsigned char   *image_temp;
    unsigned char   val;
    char	    *num;
    short	    x, y;

 fromto(TO, DEFAUT);

    strcpy (buf, mastertabs[376]);
    num = (char *) calloc (10, sizeof(char));
    sprintf(num," %d ", index_image[1]);
    strcat(buf, num);
    strcat(buf, "\n");
    cfree(num);
    write_master (buf);



  /* Index_image[1] contient le numero du plan dans lequel on veut sauver l'image */
  
    liste_image[index_image[1]].nbr_seg = nbr_seg;	/* mise a jour du nombre de*/
							/* appartenant a une image */
    liste_image[index_image[1]].seg = seg_debut;	/* pointeur sur le debut de*/
							/* la liste des points	   */
    dir_desc[index_image[1]].nligne = ydim;
    dir_desc[index_image[1]].ncolonne = xdim;
    if (dir_image[index_image[1]].image != NULL)
	free(dir_image[index_image[1]].image);
    dir_image[index_image[1]].image = (unsigned char *) malloc
                      (dir_desc[index_image[1]].nligne*dir_desc[index_image[1]].ncolonne);

    image_temp = dir_image[index_image[1]].image;

    if (type == MONO)
    {
	if ((dest_pr = mem_create ( xdim, ydim, 1)) == NULL)
	{
	    write_erreur (3) ; 
	    return;	    
	}
	dir_desc[index_image[1]].type = -1;
    }
    else
    {
	if ((dest_pr = mem_create ( xdim, ydim, 8)) == NULL)
	{
	    write_erreur (3) ; 
	    return;	    
	}
	dir_desc[index_image[1]].type = 0;
    }

    pw_read (dest_pr, 0, 0, xdim, ydim, PIX_SRC, pw, 0, 0);     /*lecture de l'image*/
    for ( y =0 ; y < ydim ; y++)
	for ( x = 0 ; x < xdim ; x++)
        
	{
	    val = (unsigned char) pr_get ( dest_pr, x, y); 
	    if ((type == MONO) && (val == 1))
		*image_temp = 255;
	    else
		*image_temp = val;
	    image_temp++;
	}
    

    statis (dir_image[index_image[1]].image,
                dir_desc[index_image[1]].type, 
	        dir_desc[index_image[1]].nligne,
	        dir_desc[index_image[1]].ncolonne,
		&(dir_desc[index_image[1]].mmin),
		&(dir_desc[index_image[1]].mmax), 
	        &(dir_desc[index_image[1]].mu),
		&(dir_desc[index_image[1]].ecart));

    return;

}
/****************************************************************************************/
/*  nom	    :	segments         							*/
/*											*/
/*  fonction:	Initialise variables et items pour la liaison des points  		*/
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   int	type	                                                        */ 
/*              int	fonction                                                        */
/*              int	flag_chablon                                                    */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	aucune  								*/
/*                                                                                      */
/****************************************************************************************/

static void segments()
{
    fonction = 0;

    panel_set (efface_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (segments_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (sauve_item, PANEL_SHOW_ITEM, FALSE, 0);

    if (flag_chablon == 0)
    {
	
	panel_set (sortie_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (comment1_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (comment2_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (expose_segment_item, PANEL_SHOW_ITEM, FALSE, 0);
	panel_set (couleur_seg_item, PANEL_SHOW_ITEM, TRUE, 0);
    }	
	
    
    
    if (type == MONO)
    {
	panel_set (plein_item, PANEL_SHOW_ITEM, TRUE, 0);
	panel_set (contour_item, PANEL_SHOW_ITEM, TRUE, 0);
    }
    return;
}

/****************************************************************************************/
/*  nom	    :	ferme_et_insere_segment       						*/
/*											*/
/*  fonction:	Rajoute le point necessaire pour fermer le polygone et insere ce segment*/
/*	        dans la liste des segments                                              */
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   int	nbr_seg                                                         */ 
/*              int	nbr_pts                                                         */
/*              int	contrainte                                                      */
/*              ptr_point   pt_debut                                                    */
/*              ptr_point   pt_courant                                                  */
/*              ptr_seg	    seg_debut	                                                */
/*              ptr_seg	    seg_courant	                                                */
/*              short	    couleur_courante                                            */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	write_master  								*/
/*                                                                                      */
/****************************************************************************************/

static void ferme_et_insere_segment()
{
    int	    x, y;

    if (pt_debut != NULL)
    {
    /* On ferme le polygone */
	switch (contrainte)
	{
	    case 0 :pt_courant -> next = (ptr_point) calloc (1,sizeof (struct coords));
		    pt_courant =  pt_courant -> next;
		    pt_courant -> next = NULL;
		    pt_courant -> x = pt_debut -> x;
		    pt_courant -> y = pt_debut -> y;
		    nbr_pts++;
		    break;

    /* Si on a la contrainte hv il faut rajouter un point (en plus de celui pour fermer	*/ 
    /* la figure) afin que le dernier segment soit bien vertical ou horizontal	        */

	    case 1 :if ((pt_courant -> x) - (pt_debut -> x) < 0)
		    {
			pt_courant -> next = (ptr_point) calloc (1,sizeof (struct coords));
			x = pt_courant -> x;
			y = pt_debut -> y;
			pt_courant =  pt_courant -> next;
			pt_courant -> next = NULL;
			pt_courant -> x = x;
			pt_courant -> y = y;
			nbr_pts++;
		    }
		    else
		      if ((pt_courant -> x) - (pt_debut -> x) > 0)
		      {
			pt_courant -> next = (ptr_point) calloc (1,sizeof (struct coords));
			x = pt_debut -> x;
			y = pt_courant -> y;
			pt_courant =  pt_courant -> next;
			pt_courant -> next = NULL;
			pt_courant -> x = x;
			pt_courant -> y = y;
			nbr_pts++;
		      }	
		    pt_courant -> next = (ptr_point) calloc (1,sizeof (struct coords));
		    pt_courant =  pt_courant -> next;
		    pt_courant -> next = NULL;
		    pt_courant -> x = pt_debut -> x;
		    pt_courant -> y = pt_debut -> y;
		    nbr_pts++;
		    break;
	}

	/* On ajoute ce segment (liste de points) a la liste des segments */
	if (seg_debut == NULL)
	{
	    seg_debut = (ptr_seg) calloc (1, sizeof (struct el_seg));
	    seg_courant = seg_debut;
	}
	else
	{
	    seg_courant -> suivant = (ptr_seg) calloc (1, sizeof (struct el_seg));
	    seg_courant = seg_courant -> suivant;
	}
	seg_courant -> nbr_pts = nbr_pts;
	seg_courant -> pts = pt_debut;	    /* on pointe le debut de la chaine de points*/
	seg_courant -> couleur = couleur_courante;
	seg_courant -> suivant = NULL;
	nbr_seg++;
    }
    return;
}


/****************************************************************************************/
/*  nom	    :	segment_plein       							*/
/*											*/
/*  fonction:	relie successivement les points stockes dans la liste des points par des*/
/*	        segments de droite et rempli le polygone ainsi forme                    */
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   ptr_seg	    seg_courant	                                                */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	write_master 								*/
/*              init_liste_pts                                                          */
/*		ferme_et_insere_segment							*/
/*		remplit_seg								*/
/*											*/
/****************************************************************************************/

static void segment_plein()
{
    char    *num;
    if (pt_debut != NULL)
    {
        ferme_et_insere_segment();
	remplit_seg (seg_courant);
	seg_courant -> flag_plein = 1;
	init_liste_pts();
    }
    panel_set (plein_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (contour_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (efface_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment1_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment2_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (segments_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (sauve_item, PANEL_SHOW_ITEM, TRUE, 0);

    if (flag_chablon == 0)
    {
    panel_set (sortie_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (expose_segment_item, PANEL_SHOW_ITEM, TRUE, 0);
    }
    
    num = (char *) calloc (10, sizeof(char));
    sprintf(num," %d ",nbr_seg);
    strcpy(buf, mastertabs[377]); 
    strcat(buf, num);
    cfree(num);
    strcat(buf, mastertabs[378]);
    write_master(buf);

    return;
}

/****************************************************************************************/
/*  nom	    :	segment_contour       							*/
/*											*/
/*  fonction:	relie successivement les points stockes dans la liste par des segments  */
/*	        de droite                                                               */
/*											*/
/*  entrees :	aucune                                                                  */
/*											*/
/*  globales:   ptr_seg	    seg_courant	                                                */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	write_master  								*/
/*              init_liste_pts                                                          */
/*              dessine_contour                                                         */
/*              ferme_et_insere_segment                                                 */
/*                                                                                      */
/****************************************************************************************/

static void segment_contour()
{
    ptr_point	temp, oldtemp;
    char    *num;

    if ( pt_debut != NULL)
    {	
	ferme_et_insere_segment();
	seg_courant -> flag_plein = 0;
	dessine_contour (seg_courant);
	init_liste_pts();

    num = (char *) calloc (10, sizeof(char));
    sprintf(num," %d ",nbr_seg);
    strcpy(buf, mastertabs[377]);
    strcat(buf, num);
    cfree(num);
    strcat(buf, mastertabs[378]);
    write_master(buf);
    }
    panel_set (plein_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (contour_item, PANEL_SHOW_ITEM, FALSE, 0);
    panel_set (efface_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment1_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (comment2_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (segments_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (sauve_item, PANEL_SHOW_ITEM, TRUE, 0);

    if (flag_chablon == 0)
    {
    panel_set (sortie_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (change_couleur_fond_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (change_couleur_seg_item, PANEL_SHOW_ITEM, TRUE, 0);
    panel_set (expose_segment_item, PANEL_SHOW_ITEM, TRUE, 0);
    }
    return;
}

/****************************************************************************************/
/*  nom	    :	dessine_contour       							*/
/*											*/
/*  fonction:	relie successivement les points stockes dans la liste par des segments  */
/*	        de droite avec la couleur definie pour ce segment                       */
/*											*/
/*  entrees :	ptr_seg	sptr                                                            */
/*											*/
/*  globales:   aucune		                                                        */ 
/*											*/
/*  return  :	aucun									*/
/*											*/
/*  routines:	aucune									*/
/*                                                                                      */
/****************************************************************************************/

static void dessine_contour(sptr)

    ptr_seg sptr;
{
    ptr_point	temp, oldtemp;

 	oldtemp = sptr -> pts;
	temp = oldtemp -> next;
	while (temp != NULL)
	{         
	    pw_vector (pw, oldtemp -> x, oldtemp -> y, 
					temp -> x, temp -> y, PIX_SRC, sptr -> couleur);
	    oldtemp = temp;
	    temp = temp -> next;
	}
    return;
}


/****************************************************************************************/
/*  nom	    :	remplit_seg       							*/
/*											*/
/*  fonction:	relie successivement les points stockes dans la liste par des segments  */
/*	        de droite et remplit le polygone avec la couleur definie pour ce segment*/
/*											*/
/*  entrees :	ptr_seg	sptr                                                            */
/*											*/
/*  globales:	aucune		                                                        */ 
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	write_master  								*/
/*              init_liste_pts                                                          */
/*              dessine_contour                                                         */
/*                                                                                      */
/****************************************************************************************/

static void remplit_seg(sptr)

    ptr_seg sptr;
{
    struct pr_pos    *tab;
    ptr_point	    pos;
    int		    n, i, nbds = 1, npts[1];	/* nbds est le nombre de frontieres */
    
    n = sptr -> nbr_pts; 
    dessine_contour(sptr);
    if (n > 3) 
    {
	pos = sptr -> pts;

    /* n-1 car on ne prend pas le dernier point (qui sert a fermer le polygone): */
    /* pw_polygon_2 le fait tout seul						 */

	tab = (struct pr_pos *) calloc (( n-1) , sizeof (struct pr_pos));
    /* On initialise le	tableau */
	for (i = 0; i < (n-1); i++)	/* n-1 car on par de 0 avec un tableau */
	{
	    tab[i].x = pos -> x;
	    tab[i].y = pos -> y;
	    pos = pos -> next;
	}
	
	npts[0] = n-1;
	pw_polygon_2 (pw, 0, 0, nbds, npts, tab, (PIX_SRC | PIX_COLOR(sptr -> couleur)), NULL, 0, 0);
	cfree(tab);
	
    }
    return;
}


/****************************************************************************************/
/*  nom	    :	reaffichage     							*/
/*											*/
/*  fonction:	reaffiche l'image en lisant la liste des segments et en les affichant   */
/*	        successivement selon leur caracteristiques				*/
/*											*/
/*  entrees :	aucune	                                                                */
/*											*/
/*  globales:   Pixwin *pw                                                              */
/*                                                                                      */
/*  return  :	aucun									*/
/*											*/
/*  routines:	write_master  								*/
/*              init_liste_pts                                                          */
/*              dessine_contour                                                         */
/*		remplit_seg                                                             */
/*                                                                                      */
/****************************************************************************************/

static void reaffichage()
{
   struct pixrect   *pr;
   ptr_seg	    temp;

   /* Affichage du fond */
    pw_writebackground (pw, 0, 0, xdim, ydim, (PIX_SRC | PIX_COLOR(couleur_fond)));

   /* Affichage de la liste des segments */ 
    temp = seg_debut;
    while (temp != NULL)
    {
	if (temp -> flag_plein)	remplit_seg (temp);
	else dessine_contour (temp);
	temp = temp -> suivant;
    }
    return;
}


