/*
 * Decompiled with CFR 0.152.
 */
package jde.debugger.command;

import jde.debugger.Etc;
import jde.debugger.JDEException;
import jde.debugger.command.DebugProcessCommand;
import jde.debugger.spec.EventRequestSpec;
import jde.debugger.spec.EventRequestSpecList;

public class TraceExceptions
extends DebugProcessCommand {
    public void doCommand() throws JDEException {
        if (this.m_args.size() < 2) {
            throw new JDEException("Insufficient arguments");
        }
        String classPattern = this.m_args.remove(0).toString();
        String type = this.m_args.remove(0).toString().toLowerCase();
        boolean caught = false;
        boolean uncaught = false;
        if (type.equals("both")) {
            caught = true;
            uncaught = true;
        } else if (type.equals("caught")) {
            caught = true;
        } else if (type.equals("uncaught")) {
            uncaught = true;
        } else {
            throw new JDEException("'" + type + "' not understood");
        }
        EventRequestSpecList eventRequests = this.m_debugger.getEventRequestSpecList();
        EventRequestSpec er = eventRequests.createExceptionIntercept(classPattern, caught, uncaught);
        er.setThread(Etc.getThreadFromArgs(this.m_args));
        er.setSuspendPolicy(Etc.getSuspendPolicyFromArgs(this.m_args));
        er.setClassFilters(Etc.getClassFiltersFromArgs(this.m_args));
        er.setClassExFilters(Etc.getClassExFiltersFromArgs(this.m_args));
        eventRequests.install(er);
        this.m_debugger.signalCommandResult(this.m_cmdID, er.getID().toString(), true, false);
    }

    public Object clone() {
        return new TraceExceptions();
    }
}

