;;; DO NOT MODIFY THIS FILE
(if (featurep 'vc-autoloads) (error "Feature vc-autoloads already loaded"))
(defun vc-load-vc-hooks ()
 (interactive)
 (require 'vc-hooks)
 (vc-find-file-hook))
(and (featurep 'menubar)
    (featurep 'xemacs)
    (not (or (featurep 'vc-hooks) (featurep 'infodock)))
    current-menubar
    (car (find-menu-item current-menubar '("Tools")))
    (add-submenu '("Tools")
		  '("Version Control"
		   ["Load VC" vc-load-vc-hooks t])
	"Compare"))
 (defun vc-arch-registered-lite (file)
  (if (vc-find-root file "{arch}/=tagging-method")
      (progn
        (load "vc-arch")
        (vc-arch-registered file))))
 (defun vc-cvs-registered-lite (f)
  (when (file-readable-p (expand-file-name
 			  "CVS/Entries" (file-name-directory f)))
      (load "vc-cvs")
      (vc-cvs-registered f)))
 (defun vc-git-registered-lite (file)
  (with-temp-buffer
    (let* ((dir (file-name-directory file))
           (name (file-relative-name file dir)))
      (and (ignore-errors
             (when dir (cd dir))
             (eq 0 (call-process "git" nil '(t nil) nil "ls-files" "-c" "-z" "--" name)))
           (let ((str (buffer-string)))
             (and (> (length str) (length name))
                  (string= (substring str 0 (1+ (length name))) (concat name "\0"))))))))
 (defun vc-mcvs-registered-lite (file)
  (if (vc-find-root file "MCVS/CVS")
      (progn
        (load "vc-mcvs")
        (vc-mcvs-registered file))))

(package-provide 'vc :version 1.45 :author-version "No-Upstream-Ver" :type 'regular)

;;;### (autoloads (log-edit) "log-edit" "vc/log-edit.el")

(autoload 'log-edit "log-edit" "\
Setup a buffer to enter a log message.
\\<log-edit-mode-map>The buffer will be put in `log-edit-mode'.
If SETUP is non-nil, the buffer is then erased and `log-edit-hook' is run.
Mark and point will be set around the entire contents of the
buffer so that it is easy to kill the contents of the buffer with \\[kill-region].
Once you're done editing the message, pressing \\[log-edit-done] will call
`log-edit-done' which will end up calling CALLBACK to do the actual commit.
LISTFUN if non-nil is a function of no arguments returning the list of files
  that are concerned by the current operation (using relative names).
If BUFFER is non-nil `log-edit' will jump to that buffer, use it to edit the
  log message and go back to the current buffer when done.  Otherwise, it
  uses the current buffer." nil nil)

;;;***

;;;### (autoloads (vc-rcs-master-templates) "vc-rcs" "vc/vc-rcs.el")

(defvar vc-rcs-master-templates '("%sRCS/%s,v" "%s%s,v" "%sRCS/%s") "\
*Where to look for RCS master files.
For a description of possible values, see `vc-check-master-templates'.")
 (defun vc-rcs-registered (f) (vc-default-registered 'RCS f))

;;;***

;;;### (autoloads (vc-sccs-master-templates) "vc-sccs" "vc/vc-sccs.el")

(defvar vc-sccs-master-templates '("%sSCCS/s.%s" "%ss.%s" vc-sccs-search-project-dir) "\
*Where to look for SCCS master files.
For a description of possible values, see `vc-check-master-templates'.")
 (defun vc-sccs-registered(f) (vc-default-registered 'SCCS f))

(defun vc-sccs-search-project-dir (dirname basename) "\
Return the name of a master file in the SCCS project directory.
Does not check whether the file exists but returns nil if it does not
find any project directory." (let ((project-dir (getenv "PROJECTDIR")) dirs dir) (when project-dir (if (file-name-absolute-p project-dir) (setq dirs '("SCCS" "")) (setq dirs '("src/SCCS" "src" "source/SCCS" "source")) (setq project-dir (expand-file-name (concat "~" project-dir)))) (while (and (not dir) dirs) (setq dir (expand-file-name (car dirs) project-dir)) (unless (file-directory-p dir) (setq dir nil) (setq dirs (cdr dirs)))) (and dir (expand-file-name (concat "s." basename) dir)))))

;;;***
 (defun vc-svn-registered-lite (f)
  (let ((admin-dir (cond ((and (eq system-type 'windows-nt)
                               (getenv "SVN_ASP_DOT_NET_HACK"))
                          "_svn")
                         (t ".svn"))))
    (when (file-readable-p (expand-file-name
                            (concat admin-dir "/entries")
                            (file-name-directory f)))
      (load "vc-svn")
      (vc-svn-registered f))))

(add-to-list 'completion-ignored-extensions ".svn/")

;;;### (autoloads (vc-annotate vc-update-change-log vc-rename-file vc-transfer-file vc-switch-backend vc-cancel-version vc-update vc-revert-buffer vc-print-log vc-retrieve-snapshot vc-create-snapshot vc-directory vc-resolve-conflicts vc-merge vc-insert-headers vc-version-other-window vc-diff vc-register vc-next-action vc-do-command edit-vc-file with-vc-file vc-branch-part vc-trunk-p vc-before-checkin-hook vc-checkin-hook vc-checkout-hook) "vc" "vc/vc.el")

(defvar vc-checkout-hook nil "\
Normal hook (list of functions) run after checking out a file.
See `run-hooks'.")

(defvar vc-checkin-hook nil "\
Normal hook (list of functions) run after a checkin is done.
See also `log-edit-done-hook'.")

(defvar vc-before-checkin-hook nil "\
Normal hook (list of functions) run before a file is checked in.
See `run-hooks'.")

(autoload 'vc-trunk-p "vc" "\
Return t if REV is a revision on the trunk." nil nil)

(autoload 'vc-branch-part "vc" "\
Return the branch part of a revision number REV." nil nil)

(autoload 'with-vc-file "vc" "\
Check out a writable copy of FILE if necessary, then execute BODY.
Check in FILE with COMMENT (a string) after BODY has been executed.
FILE is passed through `expand-file-name'; BODY executed within
`save-excursion'.  If FILE is not under version control, or locked by
somebody else, signal error." nil 'macro)

(autoload 'edit-vc-file "vc" "\
Edit FILE under version control, executing body.
Checkin with COMMENT after executing BODY.
This macro uses `with-vc-file', passing args to it.
However, before executing BODY, find FILE, and after BODY, save buffer." nil 'macro)

(autoload 'vc-do-command "vc" "\
Execute a VC command, notifying user and checking for errors.
Output from COMMAND goes to BUFFER, or *vc* if BUFFER is nil or the
current buffer if BUFFER is t.  If the destination buffer is not
already current, set it up properly and erase it.  The command is
considered successful if its exit status does not exceed OKSTATUS (if
OKSTATUS is nil, that means to ignore error status, if it is `async', that
means not to wait for termination of the subprocess; if it is t it means to
ignore all execution errors).  FILE is the
name of the working file (may also be nil, to execute commands that
don't expect a file name).  If an optional list of FLAGS is present,
that is inserted into the command line before the filename." nil nil)

(autoload 'vc-next-action "vc" "\
Do the next logical version control operation on the current file.

If you call this from within a VC dired buffer with no files marked,
it will operate on the file in the current line.

If you call this from within a VC dired buffer, and one or more
files are marked, it will accept a log message and then operate on
each one.  The log message will be used as a comment for any register
or checkin operations, but ignored when doing checkouts.  Attempted
lock steals will raise an error.

A prefix argument lets you specify the version number to use.

For RCS and SCCS files:
   If the file is not already registered, this registers it for version
control.
   If the file is registered and not locked by anyone, this checks out
a writable and locked file ready for editing.
   If the file is checked out and locked by the calling user, this
first checks to see if the file has changed since checkout.  If not,
it performs a revert.
   If the file has been changed, this pops up a buffer for entry
of a log message; when the message has been entered, it checks in the
resulting changes along with the log message as change commentary.  If
the variable `vc-keep-workfiles' is non-nil (which is its default), a
read-only copy of the changed file is left in place afterwards.
   If the file is registered and locked by someone else, you are given
the option to steal the lock.

For CVS files:
   If the file is not already registered, this registers it for version
control.  This does a \"cvs add\", but no \"cvs commit\".
   If the file is added but not committed, it is committed.
   If your working file is changed, but the repository file is
unchanged, this pops up a buffer for entry of a log message; when the
message has been entered, it checks in the resulting changes along
with the logmessage as change commentary.  A writable file is retained.
   If the repository file is changed, you are asked if you want to
merge in the changes into your working copy." t nil)

(autoload 'vc-register "vc" "\
Register the current file into a version control system.
With prefix argument SET-VERSION, allow user to specify initial version
level.  If COMMENT is present, use that as an initial comment.

The version control system to use is found by cycling through the list
`vc-handled-backends'.  The first backend in that list which declares
itself responsible for the file (usually because other files in that
directory are already registered under that backend) will be used to
register the file.  If no backend declares itself responsible, the
first backend that could register the file is used." t nil)

(autoload 'vc-diff "vc" "\
Display diffs between file versions.
Normally this compares the current file and buffer with the most
recent checked in version of that file.  This uses no arguments.  With
a prefix argument HISTORIC, it reads the file name to use and two
version designators specifying which versions to compare.  The
optional argument NOT-URGENT non-nil means it is ok to say no to
saving the buffer." t nil)

(autoload 'vc-version-other-window "vc" "\
Visit version REV of the current file in another window.
If the current file is named `F', the version is named `F.~REV~'.
If `F.~REV~' already exists, use it instead of checking it out again." t nil)

(autoload 'vc-insert-headers "vc" "\
Insert headers into a file for use with a version control system.
Headers desired are inserted at point, and are pulled from
the variable `vc-BACKEND-header'." t nil)

(autoload 'vc-merge "vc" "\
Merge changes between two versions into the current buffer's file.
This asks for two versions to merge from in the minibuffer.  If the
first version is a branch number, then merge all changes from that
branch.  If the first version is empty, merge news, i.e. recent changes
from the current branch.

See Info node `Merging'." t nil)

(autoload 'vc-resolve-conflicts "vc" "\
Invoke ediff to resolve conflicts in the current buffer.
The conflicts must be marked with rcsmerge conflict markers." t nil)

(autoload 'vc-directory "vc" "\
Create a buffer in VC Dired Mode for directory DIR.

See Info node `VC Dired Mode'.

With prefix arg READ-SWITCHES, specify a value to override
`dired-listing-switches' when generating the listing." t nil)

(autoload 'vc-create-snapshot "vc" "\
Descending recursively from DIR, make a snapshot called NAME.
For each registered file, the version level of its latest version
becomes part of the named configuration.  If the prefix argument
BRANCHP is given, the snapshot is made as a new branch and the files
are checked out in that new branch." t nil)

(autoload 'vc-retrieve-snapshot "vc" "\
Descending recursively from DIR, retrieve the snapshot called NAME.
If NAME is empty, it refers to the latest versions.
If locking is used for the files in DIR, then there must not be any
locked files at or below DIR (but if NAME is empty, locked files are
allowed and simply skipped)." t nil)

(autoload 'vc-print-log "vc" "\
List the change log of the current buffer in a window.
If FOCUS-REV is non-nil, leave the point at that revision." t nil)

(autoload 'vc-revert-buffer "vc" "\
Revert the current buffer's file to the version it was based on.
This asks for confirmation if the buffer contents are not identical
to that version.  This function does not automatically pick up newer
changes found in the master file; use \\[universal-argument] \\[vc-next-action] to do so." t nil)

(autoload 'vc-update "vc" "\
Update the current buffer's file to the latest version on its branch.
If the file contains no changes, and is not locked, then this simply replaces
the working file with the latest version on its branch.  If the file contains
changes, and the backend supports merging news, then any recent changes from
the current branch are merged into the working file." t nil)

(autoload 'vc-cancel-version "vc" "\
Get rid of most recently checked in version of this file.
A prefix argument NOREVERT means do not revert the buffer afterwards." t nil)

(autoload 'vc-switch-backend "vc" "\
Make BACKEND the current version control system for FILE.
FILE must already be registered in BACKEND.  The change is not
permanent, only for the current session.  This function only changes
VC's perspective on FILE, it does not register or unregister it.
By default, this command cycles through the registered backends.
To get a prompt, use a prefix argument." t nil)

(autoload 'vc-transfer-file "vc" "\
Transfer FILE to another version control system NEW-BACKEND.
If NEW-BACKEND has a higher precedence than FILE's current backend
\(i.e.  it comes earlier in `vc-handled-backends'), then register FILE in
NEW-BACKEND, using the version number from the current backend as the
base level.  If NEW-BACKEND has a lower precedence than the current
backend, then commit all changes that were made under the current
backend to NEW-BACKEND, and unregister FILE from the current backend.
\(If FILE is not yet registered under NEW-BACKEND, register it.)" nil nil)

(autoload 'vc-rename-file "vc" "\
Rename file OLD to NEW, and rename its master file likewise." t nil)

(autoload 'vc-update-change-log "vc" "\
Find change log file and add entries from recent version control logs.
Normally, find log entries for all registered files in the default
directory.

With prefix arg of \\[universal-argument], only find log entries for the current buffer's file.

With any numeric prefix arg, find log entries for all currently visited
files that are under version control.  This puts all the entries in the
log for the default directory, which may not be appropriate.

From a program, any ARGS are assumed to be filenames for which
log entries should be gathered." t nil)

(autoload 'vc-annotate "vc" "\
Display the edit history of the current file using colors.

This command creates a buffer that shows, for each line of the current
file, when it was last edited and by whom.  Additionally, colors are
used to show the age of each line--blue means oldest, red means
youngest, and intermediate colors indicate intermediate ages.  By
default, the time scale stretches back one year into the past;
everything that is older than that is shown in blue.

With a prefix argument, this command asks two questions in the
minibuffer.  First, you may enter a version number; then the buffer
displays and annotates that version instead of the current version
\(type RET in the minibuffer to leave that default unchanged).  Then,
you are prompted for the time span in days which the color range
should cover.  For example, a time span of 20 days means that changes
over the past 20 days are shown in red to blue, according to their
age, and everything that is older than that is shown in blue.

Customization variables:

`vc-annotate-menu-elements' customizes the menu elements of the
mode-specific menu. `vc-annotate-color-map' and
`vc-annotate-very-old-color' defines the mapping of time to
colors. `vc-annotate-background' specifies the background color." t nil)

;;;***

(provide 'vc-autoloads)
