/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.ASTType;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterConstants;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.SimpleNode;

public class ASTBinaryExpression
extends SimpleNode
implements InterpreterConstants {
    public int kind;

    ASTBinaryExpression(int n) {
        super(n);
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        Object object = ((SimpleNode)this.jjtGetChild(0)).eval(nameSpace, interpreter);
        if (this.kind == 31) {
            if (object instanceof Primitive) {
                return new Primitive(false);
            }
            Class clazz = ((ASTType)this.jjtGetChild(1)).getType(nameSpace);
            boolean bl = Reflect.isAssignableFrom(clazz, object.getClass());
            return new Primitive(bl);
        }
        Object object2 = ((SimpleNode)this.jjtGetChild(1)).eval(nameSpace, interpreter);
        boolean bl = this.isWrapper(object);
        boolean bl2 = this.isWrapper(object2);
        if (!(!bl && !this.isPrimitiveValue(object) || !bl2 && !this.isPrimitiveValue(object2) || bl && bl2 && this.kind == 78)) {
            return ASTBinaryExpression.primitiveBinaryOperation(object, object2, this.kind);
        }
        switch (this.kind) {
            case 78: {
                return new Primitive(object == object2);
            }
            case 83: {
                return new Primitive(object != object2);
            }
            case 90: {
                if (!(object instanceof String) && !(object2 instanceof String)) break;
                return String.valueOf(object.toString()) + object2.toString();
            }
        }
        if (object instanceof Primitive || object2 instanceof Primitive) {
            if (object == Primitive.VOID || object2 == Primitive.VOID) {
                throw new EvalError("illegal use of undefined object or 'void' literal", this);
            }
            if (object == Primitive.NULL || object2 == Primitive.NULL) {
                throw new EvalError("illegal use of null object or 'null' literal", this);
            }
        }
        throw new EvalError("Operator: '" + InterpreterConstants.tokenImage[this.kind] + "' inappropriate for objects", this);
    }

    private boolean isPrimitiveValue(Object object) {
        return object instanceof Primitive && object != Primitive.VOID && object != Primitive.NULL;
    }

    private boolean isWrapper(Object object) {
        return object instanceof Boolean || object instanceof Character || object instanceof Number;
    }

    public static Object primitiveBinaryOperation(Object object, Object object2, int n) throws EvalError {
        if (object instanceof Primitive && object2 instanceof Primitive) {
            return Primitive.binaryOperation((Primitive)object, (Primitive)object2, n);
        }
        if (object instanceof Primitive) {
            object = ((Primitive)object).getValue();
        }
        if (object2 instanceof Primitive) {
            object2 = ((Primitive)object2).getValue();
        }
        Class<?> clazz = object.getClass();
        Class<?> clazz2 = object2.getClass();
        Object[] objectArray = Primitive.promotePrimitives(object, object2);
        Object object3 = objectArray[0];
        Object object4 = objectArray[1];
        if (object3.getClass() != object4.getClass()) {
            throw new EvalError("type mismatch in operator.  " + clazz + " cannot be matched with " + clazz2);
        }
        if (object3 instanceof Boolean) {
            return Primitive.booleanBinaryOperation((Boolean)object3, (Boolean)object4, n);
        }
        if (object3 instanceof Integer) {
            Object object5 = Primitive.intBinaryOperation((Integer)object3, (Integer)object4, n);
            return object5;
        }
        if (object3 instanceof Long) {
            return Primitive.longBinaryOperation((Long)object3, (Long)object4, n);
        }
        if (object3 instanceof Float) {
            return Primitive.floatBinaryOperation((Float)object3, (Float)object4, n);
        }
        if (object3 instanceof Double) {
            return Primitive.doubleBinaryOperation((Double)object3, (Double)object4, n);
        }
        throw new EvalError("Invalid types in binary operator");
    }
}

