(allocate 'cons (round (* 800 (/ 2048.0 si::lisp-pagesize))))


 ;; clean up make stuff
(if (find-package "MAKE")
 (sloop::sloop for v in-package 'make do (unintern v)))
 #+gcl (setq si::*top-level-hook* 'user::run)
 (in-package "MAXIMA")

(proclaim '(optimize (safety 0) (speed 3) (space 0)))
 (defun maxima-path (dir file)
   (format nil "~a~a/~a" maxima::*maxima-directory*
	   dir file))
 (load "version.lisp") 
 (load "autol.lisp") 
 (load "max_ext.lisp")




(defun set-pathnames ()
  (let* ((tem (si::getenv "MAXIMA_DIRECTORY"))
	 (n (length tem)))
    (cond ((> n 0)
	   (or (eql (aref tem (- n 1)) #\/)
	       (setq tem (format nil "~a/" tem)))
	   (setq *maxima-directory* tem)))
    (setq $DESCRIBE_DOCUMENTATION (maxima-path "doc" "macsym.doc"))
    
    (setq maxima::$file_search (list '(maxima::mlist)
				     (maxima-path "src" "foo.o")
				     (maxima-path "src" "foo.o")
				     (maxima-path "src" "foo.lisp")
				     (maxima-path "share" "foo.lisp")
				     (maxima-path "share1" "foo.o")
				     (maxima-path "share1" "foo.lisp")
				     (maxima-path "tensor" "foo.o")
				     (maxima-path "tensor" "foo.lisp")
				     (maxima-path "share" "foo.mc")
				     (maxima-path "share1" "foo.mc")
				     (maxima-path "share2" "foo.mc")
				     (maxima-path "sym" "foo.o")
				     (maxima-path "sym" "foo.lsp")
				     ))
    (setq $chemin
	  (maxima-path "sym" ""))

    ))
(defun user::run ()
  (catch 'to-lisp
    (set-pathnames)
    (maxima::macsyma-top-level)
  ))

($setup_autoload "eigen.mc" '$eigenvectors '$eigenvalues)
(defun $tkconnect() (si::tkconnect))
(defun $to_lisp () (format t "~%Type (run) to restart~%"(throw 'to-lisp t)))
(defvar $help "type describe(topic) or example(topic);")
(defun $help() $help);
(load "init_max2.lisp")

  
