#!/usr/bin/perl -w
use strict;

# ------------------------------------------------------------------------------
# CHANGES MADE HERE WILL BE OVERWRITTEN NEXT TIME `[#sys/proc/zname]` IS RUN!
# ------------------------------------------------------------------------------
# This script was generated by `[#sys/proc/zname]` on [#dt(ampm);sys/proc/tstamp]
# ------------------------------------------------------------------------------

use lib qw(../lib);
use Hub qw(:all);
our ($tidx,$test,$tinfo,$result,$total_tests) = (0,undef,undef,'',0);
$$Hub{'/sys/OPTS/v'} = 0 unless defined $$Hub{'/sys/OPTS/v'};
main();

# ------------------------------------------------------------------------------
# main - Test harness.
# ------------------------------------------------------------------------------

sub main {
  $test = 1; # start at 1 to match ExtUtils::Command::MM
  my ($pass_count,$fail_count) = (0,0);
  while (eval("defined &t$test")) {
    $tinfo = $$Hub{"/all.hf/testcases/$tidx"};
    die "Cannot find testcase: $tidx\n" unless defined $tinfo;
    $result = '';
    $total_tests++;
    my $passed = eval( "&t$test()" );
    if( $@ ) {
      $result = $@;
      $passed = 0;
    } else {
      $passed = !$passed if( $$tinfo{'invert'} );
    }
    if( $passed ) {
      $pass_count++;
      $result ||= '';
      printstatus( "passed: $result" ) if $$Hub{'/sys/OPTS/v'} > 1;
      printstatus( 'passed' ) if $$Hub{'/sys/OPTS/v'} eq 1;
    } else {
      $fail_count++;
      chomp $result;
      printstatus( "FAILED: $result" );
    }
    $test++;
    $tidx++;
  }
  print "$pass_count of $total_tests passed.\n";
}#main

# ------------------------------------------------------------------------------
# printstatus - Print pass/fail message
# ------------------------------------------------------------------------------

sub printstatus {
  printf "Test [%4d] %s line %5d: %s\n",
    $test,
    fw( 25, getname( $$tinfo{'package'} ) ),
    $$tinfo{'lineno'}, @_;
}#printstatus

# ------------------------------------------------------------------------------
# t1 - Match
# Generated from ../lib/Hub/Parse/Parser.pm line: 124
# ------------------------------------------------------------------------------

sub t1 {
  $result = eval {my $parser = mkinst( 'Parser', -template => 'Hello [#who]' );
              ${$parser->populate( { who => 'World' } )};
};
  $@ and die $@;
  return $result eq "Hello World";
}#t1

# ------------------------------------------------------------------------------
# t2 - False
# Generated from ../lib/Hub/Perl/Compare.pm line: 73
# ------------------------------------------------------------------------------

sub t2 {
  $result = eval {compare('eq','',undef);
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t2

# ------------------------------------------------------------------------------
# t3 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 74
# ------------------------------------------------------------------------------

sub t3 {
  $result = eval {compare('eq','abc','abc');
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t3

# ------------------------------------------------------------------------------
# t4 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 75
# ------------------------------------------------------------------------------

sub t4 {
  $result = eval {compare('ne','abc','Abc');
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t4

# ------------------------------------------------------------------------------
# t5 - False
# Generated from ../lib/Hub/Perl/Compare.pm line: 76
# ------------------------------------------------------------------------------

sub t5 {
  $result = eval {compare('eq','abc',undef);
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t5

# ------------------------------------------------------------------------------
# t6 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 77
# ------------------------------------------------------------------------------

sub t6 {
  $result = eval {compare('!~','abc','A');
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t6

# ------------------------------------------------------------------------------
# t7 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 78
# ------------------------------------------------------------------------------

sub t7 {
  $result = eval {compare('=~','abc','a');
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t7

# ------------------------------------------------------------------------------
# t8 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 79
# ------------------------------------------------------------------------------

sub t8 {
  $result = eval {compare('==',1234,1234);
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t8

# ------------------------------------------------------------------------------
# t9 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 80
# ------------------------------------------------------------------------------

sub t9 {
  $result = eval {compare('>=',1234,1234);
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t9

# ------------------------------------------------------------------------------
# t10 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 81
# ------------------------------------------------------------------------------

sub t10 {
  $result = eval {compare('eqic','abc','Abc');
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t10

# ------------------------------------------------------------------------------
# t11 - True
# Generated from ../lib/Hub/Perl/Compare.pm line: 82
# ------------------------------------------------------------------------------

sub t11 {
  $result = eval {compare('==',undef,undef);
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t11

# ------------------------------------------------------------------------------
# t12 - False
# Generated from ../lib/Hub/Perl/Compare.pm line: 83
# ------------------------------------------------------------------------------

sub t12 {
  $result = eval {compare('==',0,undef);
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t12

# ------------------------------------------------------------------------------
# t13 - Match
# Generated from ../lib/Hub/Perl/Compare.pm line: 84
# ------------------------------------------------------------------------------

sub t13 {
  $result = eval {my @numbers = ( 20, 1, 10, 2 );
              join ';', sort { &compare('<=>',$a,$b) } @numbers;
};
  $@ and die $@;
  return $result eq "1;2;10;20";
}#t13

# ------------------------------------------------------------------------------
# t14 - Match
# Generated from ../lib/Hub/Knots/SortedHash.pm line: 94
# ------------------------------------------------------------------------------

sub t14 {
  $result = eval {
  my %h = ();
  tie %h, 'Hub::Knots::SortedHash';
  $h{'first'} = "Apple";
  $h{'second'} = "Banana";
  $h{'third'} = "Pear";
  join ';', values %h;

};
  $@ and die $@;
  return $result eq "Apple;Banana;Pear";
}#t14

# ------------------------------------------------------------------------------
# t15 - Regex
# Generated from ../lib/Hub/Data/Create.pm line: 55
# ------------------------------------------------------------------------------

sub t15 {
  $result = eval {Hub::mkhandler('/jonnyboy.dat')
};
  $@ and die $@;
  return $result =~ "Hub::Data::HashFile";
}#t15

# ------------------------------------------------------------------------------
# t16 - Regex
# Generated from ../lib/Hub/Data/Create.pm line: 57
# ------------------------------------------------------------------------------

sub t16 {
  $result = eval {Hub::mkhandler('/jonnyboy.data')
};
  $@ and die $@;
  return $result =~ "Hub::Data::HashFile";
}#t16

# ------------------------------------------------------------------------------
# t17 - Regex
# Generated from ../lib/Hub/Data/Create.pm line: 59
# ------------------------------------------------------------------------------

sub t17 {
  $result = eval {Hub::mkhandler('/jonnyboy.hf')
};
  $@ and die $@;
  return $result =~ "Hub::Data::HashFile";
}#t17

# ------------------------------------------------------------------------------
# t18 - Regex
# Generated from ../lib/Hub/Data/Create.pm line: 61
# ------------------------------------------------------------------------------

sub t18 {
  $result = eval {Hub::mkhandler('/data.dat.foo')
};
  $@ and die $@;
  return $result =~ "Hub::Data::File";
}#t18

# ------------------------------------------------------------------------------
# t19 - Regex
# Generated from ../lib/Hub/Data/Create.pm line: 63
# ------------------------------------------------------------------------------

sub t19 {
  $result = eval {use Cwd qw(cwd); Hub::mkhandler(cwd())
};
  $@ and die $@;
  return $result =~ "Hub::Data::Directory";
}#t19

# ------------------------------------------------------------------------------
# t20 - Match
# Generated from ../lib/Hub/Misc/Transform.pm line: 25
# ------------------------------------------------------------------------------

sub t20 {
  $result = eval {safestr( 'Dogs (Waters, Gilmour) 17:06' );
};
  $@ and die $@;
  return $result eq "Dogs_0x20__0x28_Waters_0x2c__0x20_Gilmour_0x29__0x20_17_0x3a_06";
}#t20

# ------------------------------------------------------------------------------
# t21 - Match
# Generated from ../lib/Hub/Misc/Transform.pm line: 38
# ------------------------------------------------------------------------------

sub t21 {
  $result = eval {Hub::unpack_safestr('Dogs_0x20__0x28_Waters_0x2c__0x20_Gilmour_0x29__0x20_17_0x3a_06');
};
  $@ and die $@;
  return $result eq "Dogs (Waters, Gilmour) 17:06";
}#t21

# ------------------------------------------------------------------------------
# t22 - Match
# Generated from ../lib/Hub/Misc/Transform.pm line: 52
# ------------------------------------------------------------------------------

sub t22 {
  $result = eval {Hub::pack_ncr("This is a # of tests & bl/ah");
};
  $@ and die $@;
  return $result eq "This is a &#35; of tests &#38; bl&#47;ah";
}#t22

# ------------------------------------------------------------------------------
# t23 - Match
# Generated from ../lib/Hub/Misc/Transform.pm line: 67
# ------------------------------------------------------------------------------

sub t23 {
  $result = eval {Hub::unpack_ncr('This is a &#35; of tests &#38; bl&#47;ah');
};
  $@ and die $@;
  return $result eq "This is a # of tests & bl/ah";
}#t23

# ------------------------------------------------------------------------------
# t24 - Match
# Generated from ../lib/Hub/Misc/Transform.pm line: 174
# ------------------------------------------------------------------------------

sub t24 {
  $result = eval {populate('mu[#foo]m', { foo => 'shroo' });
};
  $@ and die $@;
  return $result eq "mushroom";
}#t24

# ------------------------------------------------------------------------------
# t25 - Match
# Generated from ../lib/Hub/Misc/Transform.pm line: 175
# ------------------------------------------------------------------------------

sub t25 {
  $result = eval {ref(populate('a[#b]c', { b => 'bee' }, '-as_ref=1'));
};
  $@ and die $@;
  return $result eq "SCALAR";
}#t25

# ------------------------------------------------------------------------------
# t26 - Match
# Generated from ../lib/Hub/Misc/Transform.pm line: 194
# ------------------------------------------------------------------------------

sub t26 {
  $result = eval {  my $hash = {
    'class'   => "foodidly",
    'name'    => "bobsmith",
    'height'  => "5px",
    'junk'    => "ignore me",
  };
  hashtoattrs($hash, ['junk']);
};
  $@ and die $@;
  return $result eq "class=\"foodidly\" height=\"5px\" name=\"bobsmith\"";
}#t26

# ------------------------------------------------------------------------------
# t27 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 70
# ------------------------------------------------------------------------------

sub t27 {
  $result = eval {sizeof( { a=>1, b=>2, c=>3 } );
};
  $@ and die $@;
  return $result eq "3";
}#t27

# ------------------------------------------------------------------------------
# t28 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 71
# ------------------------------------------------------------------------------

sub t28 {
  $result = eval {sizeof( [ 'a1', 'b2', 'c3' ] );
};
  $@ and die $@;
  return $result eq "3";
}#t28

# ------------------------------------------------------------------------------
# t29 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 72
# ------------------------------------------------------------------------------

sub t29 {
  $result = eval {sizeof( "abc"                );
};
  $@ and die $@;
  return $result eq "3";
}#t29

# ------------------------------------------------------------------------------
# t30 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 73
# ------------------------------------------------------------------------------

sub t30 {
  $result = eval {sizeof( \"abc"               );
};
  $@ and die $@;
  return $result eq "3";
}#t30

# ------------------------------------------------------------------------------
# t31 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 74
# ------------------------------------------------------------------------------

sub t31 {
  $result = eval {sizeof( undef                );
};
  $@ and die $@;
  return $result eq "0";
}#t31

# ------------------------------------------------------------------------------
# t32 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 75
# ------------------------------------------------------------------------------

sub t32 {
  $result = eval {sizeof( "a", "b", "c"        );
};
  $@ and die $@;
  return $result eq "3";
}#t32

# ------------------------------------------------------------------------------
# t33 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 131
# ------------------------------------------------------------------------------

sub t33 {
  $result = eval {my $compression = check( '-test=eval', 'use IO::Zlib' ) ? 1 : 0;
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t34 - False
# Generated from ../lib/Hub/Perl/Language.pm line: 141
# ------------------------------------------------------------------------------

sub t34 {
  $result = eval {check( undef, undef, undef );
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t34

# ------------------------------------------------------------------------------
# t35 - False
# Generated from ../lib/Hub/Perl/Language.pm line: 142
# ------------------------------------------------------------------------------

sub t35 {
  $result = eval {check( 1, undef );
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t35

# ------------------------------------------------------------------------------
# t36 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 143
# ------------------------------------------------------------------------------

sub t36 {
  $result = eval {check( 1, 1 );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t36

# ------------------------------------------------------------------------------
# t37 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 144
# ------------------------------------------------------------------------------

sub t37 {
  $result = eval {check( 1, undef, -opr => 'or' );

};
  $@ and die $@;
  return $result ? 1 : 0;
}#t37

# ------------------------------------------------------------------------------
# t38 - False
# Generated from ../lib/Hub/Perl/Language.pm line: 146
# ------------------------------------------------------------------------------

sub t38 {
  $result = eval {check( -opr => 'xor', 1, 1 );
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t38

# ------------------------------------------------------------------------------
# t39 - False
# Generated from ../lib/Hub/Perl/Language.pm line: 147
# ------------------------------------------------------------------------------

sub t39 {
  $result = eval {check( -opr => 'xor', undef, undef );

};
  $@ and die $@;
  return $result ? 0 : 1;
}#t39

# ------------------------------------------------------------------------------
# t40 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 149
# ------------------------------------------------------------------------------

sub t40 {
  $result = eval {check( -opr => 'xor', undef, 1 );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t40

# ------------------------------------------------------------------------------
# t41 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 150
# ------------------------------------------------------------------------------

sub t41 {
  $result = eval {check( -opr => 'xor', 1, undef );

};
  $@ and die $@;
  return $result ? 1 : 0;
}#t41

# ------------------------------------------------------------------------------
# t42 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 152
# ------------------------------------------------------------------------------

sub t42 {
  $result = eval {check( -opr => 'xor', 1, undef, 1, undef );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t42

# ------------------------------------------------------------------------------
# t43 - False
# Generated from ../lib/Hub/Perl/Language.pm line: 153
# ------------------------------------------------------------------------------

sub t43 {
  $result = eval {check( -opr => 'xor', 1, undef, 1, 1, undef );
};
  $@ and die $@;
  return $result ? 0 : 1;
}#t43

# ------------------------------------------------------------------------------
# t44 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 154
# ------------------------------------------------------------------------------

sub t44 {
  $result = eval {check( -opr => 'xor', undef, 1, undef, 1 );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t44

# ------------------------------------------------------------------------------
# t45 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 286
# ------------------------------------------------------------------------------

sub t45 {
  $result = eval {
   sub myjoin {
      my $opts = Hub::opts( \@_ );
      return join( $$opts{'with'}, @_ );
   }

   myjoin( 'a', 'b', '-with=;', 'c', 'd' );
};
  $@ and die $@;
  return $result eq "a;b;c;d";
}#t45

# ------------------------------------------------------------------------------
# t46 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 396
# ------------------------------------------------------------------------------

sub t46 {
  $result = eval {
  my $obj = mkinst( 'Object' );
  my @result = objopts( [ $obj ] );
  join( ',', map { ref($_) } @result );

};
  $@ and die $@;
  return $result eq "Hub::Base::Object,";
}#t46

# ------------------------------------------------------------------------------
# t47 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 431
# ------------------------------------------------------------------------------

sub t47 {
  $result = eval {  my $opts = cmdopts(['--letters=a', '++letters=b', '++letters=c']);
  join('-', @{$$opts{'letters'}});
};
  $@ and die $@;
  return $result eq "a-b-c";
}#t47

# ------------------------------------------------------------------------------
# t48 - Defined
# Generated from ../lib/Hub/Perl/Language.pm line: 473
# ------------------------------------------------------------------------------

sub t48 {
  $result = eval {  my ($opts, %hash) = Hub::hashopts(['key1', -foo]);
  $hash{'key1'}
};
  $@ and die $@;
  return defined $result ? 1 : 0;
}#t48

# ------------------------------------------------------------------------------
# t49 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 608
# ------------------------------------------------------------------------------

sub t49 {
  $result = eval {Hub::expect( -match => 'and|or|xor', 'and' );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t49

# ------------------------------------------------------------------------------
# t50 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 609
# ------------------------------------------------------------------------------

sub t50 {
  $result = eval {Hub::expect( HASH => {}, HASH => {} );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t50

# ------------------------------------------------------------------------------
# t51 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 610
# ------------------------------------------------------------------------------

sub t51 {
  $result = eval {Hub::expect( -blessed => {} );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t52 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 611
# ------------------------------------------------------------------------------

sub t52 {
  $result = eval {Hub::expect( -blessed => mkinst( 'Object' ) );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t52

# ------------------------------------------------------------------------------
# t53 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 612
# ------------------------------------------------------------------------------

sub t53 {
  $result = eval {Hub::expect( -match => 'and|or|xor', 'if', 'or', 'and' );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t54 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 613
# ------------------------------------------------------------------------------

sub t54 {
  $result = eval {Hub::expect( ARRAY => {} );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t55 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 614
# ------------------------------------------------------------------------------

sub t55 {
  $result = eval {Hub::expect( -blessed => 'abc' );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t56 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 615
# ------------------------------------------------------------------------------

sub t56 {
  $result = eval {Hub::expect( -ref => 'HASH', {} );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t56

# ------------------------------------------------------------------------------
# t57 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 616
# ------------------------------------------------------------------------------

sub t57 {
  $result = eval {Hub::expect( -ref => 'HASH', mkinst('Object') );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t57

# ------------------------------------------------------------------------------
# t58 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 652
# ------------------------------------------------------------------------------

sub t58 {
  $result = eval {Hub::fear( HASH => {} );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t59 - True
# Generated from ../lib/Hub/Perl/Language.pm line: 653
# ------------------------------------------------------------------------------

sub t59 {
  $result = eval {Hub::fear( HASH => [] );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t59

# ------------------------------------------------------------------------------
# t60 - Abort
# Generated from ../lib/Hub/Perl/Language.pm line: 666
# ------------------------------------------------------------------------------

sub t60 {
  $result = eval {abort( -msg => 'Goddamn hippies' );
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t61 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 723
# ------------------------------------------------------------------------------

sub t61 {
  $result = eval {Hub::min(1,2);
};
  $@ and die $@;
  return $result eq "1";
}#t61

# ------------------------------------------------------------------------------
# t62 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 724
# ------------------------------------------------------------------------------

sub t62 {
  $result = eval {Hub::min(2,1,3);
};
  $@ and die $@;
  return $result eq "1";
}#t62

# ------------------------------------------------------------------------------
# t63 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 725
# ------------------------------------------------------------------------------

sub t63 {
  $result = eval {Hub::min(2,-1,3);
};
  $@ and die $@;
  return $result eq "-1";
}#t63

# ------------------------------------------------------------------------------
# t64 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 726
# ------------------------------------------------------------------------------

sub t64 {
  $result = eval {Hub::min(1);
};
  $@ and die $@;
  return $result eq "1";
}#t64

# ------------------------------------------------------------------------------
# t65 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 727
# ------------------------------------------------------------------------------

sub t65 {
  $result = eval {Hub::min(1,undef);
};
  $@ and die $@;
  return $result eq "1";
}#t65

# ------------------------------------------------------------------------------
# t66 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 728
# ------------------------------------------------------------------------------

sub t66 {
  $result = eval {Hub::min(undef,1,0);
};
  $@ and die $@;
  return $result eq "0";
}#t66

# ------------------------------------------------------------------------------
# t67 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 729
# ------------------------------------------------------------------------------

sub t67 {
  $result = eval {Hub::min(.009,1.001);
};
  $@ and die $@;
  return $result eq "0.009";
}#t67

# ------------------------------------------------------------------------------
# t68 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 743
# ------------------------------------------------------------------------------

sub t68 {
  $result = eval {Hub::max(.009,-1.01,2,undef,0);
};
  $@ and die $@;
  return $result eq "2";
}#t68

# ------------------------------------------------------------------------------
# t69 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 758
# ------------------------------------------------------------------------------

sub t69 {
  $result = eval {join(',',Hub::intdiv(3,2));
};
  $@ and die $@;
  return $result eq "1,1";
}#t69

# ------------------------------------------------------------------------------
# t70 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 794
# ------------------------------------------------------------------------------

sub t70 {
  $result = eval {join('',@{rmval([1,2,3,4],3)});
};
  $@ and die $@;
  return $result eq "124";
}#t70

# ------------------------------------------------------------------------------
# t71 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 882
# ------------------------------------------------------------------------------

sub t71 {
  $result = eval {
  my $x = 'like catfood';
  Hub::checksum( 'my', { cats => 'breath' }, ( 'smells', $x ) );

};
  $@ and die $@;
  return $result eq "2023611966";
}#t71

# ------------------------------------------------------------------------------
# t72 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 1263
# ------------------------------------------------------------------------------

sub t72 {
  $result = eval {join( ';', dice( "a{b{c}}c{d}" ) );
};
  $@ and die $@;
  return $result eq "a;{b{c}};c;{d}";
}#t72

# ------------------------------------------------------------------------------
# t73 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 1336
# ------------------------------------------------------------------------------

sub t73 {
  $result = eval {indexmatch("abracadabra", "[cd]")
};
  $@ and die $@;
  return $result eq "4";
}#t73

# ------------------------------------------------------------------------------
# t74 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 1337
# ------------------------------------------------------------------------------

sub t74 {
  $result = eval {indexmatch("abracadabra", "a", 3)
};
  $@ and die $@;
  return $result eq "3";
}#t74

# ------------------------------------------------------------------------------
# t75 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 1338
# ------------------------------------------------------------------------------

sub t75 {
  $result = eval {indexmatch("abracadabra", "d{2,2}")
};
  $@ and die $@;
  return $result eq "-1";
}#t75

# ------------------------------------------------------------------------------
# t76 - Match
# Generated from ../lib/Hub/Perl/Language.pm line: 1339
# ------------------------------------------------------------------------------

sub t76 {
  $result = eval {indexmatch("scant", "can", "-after=1")
                - indexmatch("scant", "can")
};
  $@ and die $@;
  return $result eq "3";
}#t76

# ------------------------------------------------------------------------------
# t77 - Match
# Generated from ../lib/Hub/Console/Output.pm line: 96
# ------------------------------------------------------------------------------

sub t77 {
  $result = eval {ps( 10, "this is really short but splits on ten chars" );


};
  $@ and die $@;
  return $result eq "this is re
ally short
 but split
s on ten c
hars";
}#t77

# ------------------------------------------------------------------------------
# t78 - Match
# Generated from ../lib/Hub/Console/Output.pm line: 104
# ------------------------------------------------------------------------------

sub t78 {
  $result = eval {ps( 10, "this is really short but splits on ten chars", 3 );


};
  $@ and die $@;
  return $result eq "this is re
   ally short
    but split
   s on ten c
   hars";
}#t78

# ------------------------------------------------------------------------------
# t79 - Match
# Generated from ../lib/Hub/Console/Output.pm line: 112
# ------------------------------------------------------------------------------

sub t79 {
  $result = eval {ps( 10, "this  is really short but splits on ten chars", -keepwords );

};
  $@ and die $@;
  return $result eq "this  is 
really 
short but 
splits on 
ten ";
}#t79

# ------------------------------------------------------------------------------
# t80 - Match
# Generated from ../lib/Hub/Console/Output.pm line: 307
# ------------------------------------------------------------------------------

sub t80 {
  $result = eval {indenttext(4,"Hello\nWorld")
};
  $@ and die $@;
  return $result eq "    Hello
    World";
}#t80

# ------------------------------------------------------------------------------
# t81 - Match
# Generated from ../lib/Hub/Perl/Sort.pm line: 24
# ------------------------------------------------------------------------------

sub t81 {
  $result = eval {    my @months = qw/Jan Feb Mar/;
    my @sorted = anon_sort( \@months );
    return join ',', @sorted;
};
  $@ and die $@;
  return $result eq "Feb,Jan,Mar";
}#t81

# ------------------------------------------------------------------------------
# t82 - True
# Generated from ../lib/Hub.pm line: 326
# ------------------------------------------------------------------------------

sub t82 {
  $result = eval {ref(mkinst('Object')) eq 'Hub::Base::Object';
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t82

# ------------------------------------------------------------------------------
# t83 - Abort
# Generated from ../lib/Hub.pm line: 327
# ------------------------------------------------------------------------------

sub t83 {
  $result = eval {mkinst('DoesNotExist');
};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t84 - Abort
# Generated from ../lib/Hub.pm line: 475
# ------------------------------------------------------------------------------

sub t84 {
  $result = eval {Hub::blahblahblah();

};
  $@ and do { $result = $@; chomp $result };
  return $@ ? 1 : 0;
}

# ------------------------------------------------------------------------------
# t85 - True
# Generated from ../lib/Hub/Misc/Time.pm line: 69
# ------------------------------------------------------------------------------

sub t85 {
  $result = eval {datetime( );
};
  $@ and die $@;
  return $result ? 1 : 0;
}#t85

# ------------------------------------------------------------------------------
# t86 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 70
# ------------------------------------------------------------------------------

sub t86 {
  $result = eval {datetime( 1045837284 );
};
  $@ and die $@;
  return $result =~ "02\/..\/2003 ..:..:24";
}#t86

# ------------------------------------------------------------------------------
# t87 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 71
# ------------------------------------------------------------------------------

sub t87 {
  $result = eval {datetime( 1045837284, -nosec );
};
  $@ and die $@;
  return $result =~ "02\/..\/2003 ..:..";
}#t87

# ------------------------------------------------------------------------------
# t88 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 72
# ------------------------------------------------------------------------------

sub t88 {
  $result = eval {datetime( 1045837284, -noyear );
};
  $@ and die $@;
  return $result =~ "02\/.. ..:..:24";
}#t88

# ------------------------------------------------------------------------------
# t89 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 73
# ------------------------------------------------------------------------------

sub t89 {
  $result = eval {datetime( 1045837284, -ampm );
};
  $@ and die $@;
  return $result =~ "02\/..\/2003 ..:..:24am";
}#t89

# ------------------------------------------------------------------------------
# t90 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 74
# ------------------------------------------------------------------------------

sub t90 {
  $result = eval {datetime( 1045837284, -nozeros );
};
  $@ and die $@;
  return $result =~ "2\/..\/2003 .:..:24";
}#t90

# ------------------------------------------------------------------------------
# t91 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 75
# ------------------------------------------------------------------------------

sub t91 {
  $result = eval {datetime( 1045837284, -notime );
};
  $@ and die $@;
  return $result =~ "02\/..\/2003";
}#t91

# ------------------------------------------------------------------------------
# t92 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 76
# ------------------------------------------------------------------------------

sub t92 {
  $result = eval {datetime( 1045837284, -nodate );
};
  $@ and die $@;
  return $result =~ "..:..:24";
}#t92

# ------------------------------------------------------------------------------
# t93 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 77
# ------------------------------------------------------------------------------

sub t93 {
  $result = eval {datetime( 1045837284, -letter );
};
  $@ and die $@;
  return $result =~ "February .., 2003 ..:..:24";
}#t93

# ------------------------------------------------------------------------------
# t94 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 81
# ------------------------------------------------------------------------------

sub t94 {
  $result = eval {datetime( 1045837284, -ampm, -nosec );              
};
  $@ and die $@;
  return $result =~ "02\/..\/2003 ..:..am";
}#t94

# ------------------------------------------------------------------------------
# t95 - Regex
# Generated from ../lib/Hub/Misc/Time.pm line: 84
# ------------------------------------------------------------------------------

sub t95 {
  $result = eval {datetime( 1045837284, -nosec, -nozeros, -noyear );
};
  $@ and die $@;
  return $result =~ "2\/.. .:..";
}#t95

# ------------------------------------------------------------------------------
# t96 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 955
# ------------------------------------------------------------------------------

sub t96 {
  $result = eval {fixpath( "../../../users/newuser/web/bin/../src/screens" );
};
  $@ and die $@;
  return $result eq "../../../users/newuser/web/src/screens";
}#t96

# ------------------------------------------------------------------------------
# t97 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 958
# ------------------------------------------------------------------------------

sub t97 {
  $result = eval {fixpath( "users/newuser/web/" );
};
  $@ and die $@;
  return $result eq "users/newuser/web";
}#t97

# ------------------------------------------------------------------------------
# t98 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 961
# ------------------------------------------------------------------------------

sub t98 {
  $result = eval {fixpath( "users/../web/bin/../src" );
};
  $@ and die $@;
  return $result eq "web/src";
}#t98

# ------------------------------------------------------------------------------
# t99 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 964
# ------------------------------------------------------------------------------

sub t99 {
  $result = eval {fixpath( "users//newuser" );
};
  $@ and die $@;
  return $result eq "users/newuser";
}#t99

# ------------------------------------------------------------------------------
# t100 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 967
# ------------------------------------------------------------------------------

sub t100 {
  $result = eval {fixpath( "users//newuser/./files" );
};
  $@ and die $@;
  return $result eq "users/newuser/files";
}#t100

# ------------------------------------------------------------------------------
# t101 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 970
# ------------------------------------------------------------------------------

sub t101 {
  $result = eval {fixpath( "http://site/users//newuser" );
};
  $@ and die $@;
  return $result eq "http://site/users/newuser";
}#t101

# ------------------------------------------------------------------------------
# t102 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 972
# ------------------------------------------------------------------------------

sub t102 {
  $result = eval {fixpath( '/home/hub/build/../../../out/doc/pod' );
};
  $@ and die $@;
  return $result eq "/out/doc/pod";
}#t102

# ------------------------------------------------------------------------------
# t103 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1017
# ------------------------------------------------------------------------------

sub t103 {
  $result = eval {getpath( "/etc/passwd" )
};
  $@ and die $@;
  return $result eq "/etc";
}#t103

# ------------------------------------------------------------------------------
# t104 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1018
# ------------------------------------------------------------------------------

sub t104 {
  $result = eval {getpath( "/usr/local/bin" )
};
  $@ and die $@;
  return $result eq "/usr/local";
}#t104

# ------------------------------------------------------------------------------
# t105 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1047
# ------------------------------------------------------------------------------

sub t105 {
  $result = eval {getname("../../../users/newuser/web/data/p001/batman-small.jpg");
};
  $@ and die $@;
  return $result eq "batman-small.jpg";
}#t105

# ------------------------------------------------------------------------------
# t106 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1049
# ------------------------------------------------------------------------------

sub t106 {
  $result = eval {getname("../../../users/newuser/web/data/p001");
};
  $@ and die $@;
  return $result eq "p001";
}#t106

# ------------------------------------------------------------------------------
# t107 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1051
# ------------------------------------------------------------------------------

sub t107 {
  $result = eval {getname("/var/log/*.log");
};
  $@ and die $@;
  return $result eq "*.log";
}#t107

# ------------------------------------------------------------------------------
# t108 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1064
# ------------------------------------------------------------------------------

sub t108 {
  $result = eval {getext( "/foo/bar/filename.ext" )
};
  $@ and die $@;
  return $result eq "ext";
}#t108

# ------------------------------------------------------------------------------
# t109 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1066
# ------------------------------------------------------------------------------

sub t109 {
  $result = eval {getext( "filename.cgi" )
};
  $@ and die $@;
  return $result eq "cgi";
}#t109

# ------------------------------------------------------------------------------
# t110 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1143
# ------------------------------------------------------------------------------

sub t110 {
  $result = eval {relpath("/home/docs", "/home/docs/install");
};
  $@ and die $@;
  return $result eq "..";
}#t110

# ------------------------------------------------------------------------------
# t111 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1144
# ------------------------------------------------------------------------------

sub t111 {
  $result = eval {relpath("/home/src", "/home/docs/install");
};
  $@ and die $@;
  return $result eq "../../src";
}#t111

# ------------------------------------------------------------------------------
# t112 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1146
# ------------------------------------------------------------------------------

sub t112 {
  $result = eval {relpath("/home/docs/README.txt", "/home/docs");
};
  $@ and die $@;
  return $result eq "README.txt";
}#t112

# ------------------------------------------------------------------------------
# t113 - Match
# Generated from ../lib/Hub/Base/FileSystem.pm line: 1148
# ------------------------------------------------------------------------------

sub t113 {
  $result = eval {relpath("README.txt", "/DEBUG");
};
  $@ and die $@;
  return $result eq "README.txt";
}#t113

# ------------------------------------------------------------------------------
# t114 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 23
# ------------------------------------------------------------------------------

sub t114 {
  $result = eval {keydepth( 'and:then:came:the:rain' )
};
  $@ and die $@;
  return $result eq "4";
}#t114

# ------------------------------------------------------------------------------
# t115 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 35
# ------------------------------------------------------------------------------

sub t115 {
  $result = eval {vartype( );
};
  $@ and die $@;
  return $result eq "";
}#t115

# ------------------------------------------------------------------------------
# t116 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 36
# ------------------------------------------------------------------------------

sub t116 {
  $result = eval {vartype( "clr-bg" );
};
  $@ and die $@;
  return $result eq "clr";
}#t116

# ------------------------------------------------------------------------------
# t117 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 37
# ------------------------------------------------------------------------------

sub t117 {
  $result = eval {vartype( "clr-bg", "default" );
};
  $@ and die $@;
  return $result eq "clr";
}#t117

# ------------------------------------------------------------------------------
# t118 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 38
# ------------------------------------------------------------------------------

sub t118 {
  $result = eval {vartype( "whatev", "default" );
};
  $@ and die $@;
  return $result eq "default";
}#t118

# ------------------------------------------------------------------------------
# t119 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 39
# ------------------------------------------------------------------------------

sub t119 {
  $result = eval {vartype( "whatev" );
};
  $@ and die $@;
  return $result eq "";
}#t119

# ------------------------------------------------------------------------------
# t120 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 40
# ------------------------------------------------------------------------------

sub t120 {
  $result = eval {vartype( "a:b:c" );
};
  $@ and die $@;
  return $result eq "";
}#t120

# ------------------------------------------------------------------------------
# t121 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 41
# ------------------------------------------------------------------------------

sub t121 {
  $result = eval {vartype( "x-a:b:c" );
};
  $@ and die $@;
  return $result eq "x";
}#t121

# ------------------------------------------------------------------------------
# t122 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 42
# ------------------------------------------------------------------------------

sub t122 {
  $result = eval {vartype( "a:b:x-c" );
};
  $@ and die $@;
  return $result eq "x";
}#t122

# ------------------------------------------------------------------------------
# t123 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 59
# ------------------------------------------------------------------------------

sub t123 {
  $result = eval {varroot( "p001:items:1002:text-description" );
};
  $@ and die $@;
  return $result eq "p001";
}#t123

# ------------------------------------------------------------------------------
# t124 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 60
# ------------------------------------------------------------------------------

sub t124 {
  $result = eval {varroot( "p001" );
};
  $@ and die $@;
  return $result eq "p001";
}#t124

# ------------------------------------------------------------------------------
# t125 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 73
# ------------------------------------------------------------------------------

sub t125 {
  $result = eval {varname( "p001:items:1002:text-desc" );
};
  $@ and die $@;
  return $result eq "text-desc";
}#t125

# ------------------------------------------------------------------------------
# t126 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 74
# ------------------------------------------------------------------------------

sub t126 {
  $result = eval {varname( "p001" );
};
  $@ and die $@;
  return $result eq "p001";
}#t126

# ------------------------------------------------------------------------------
# t127 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 88
# ------------------------------------------------------------------------------

sub t127 {
  $result = eval {varparent( "p001:items:12:1000" );
};
  $@ and die $@;
  return $result eq "p001:items:12";
}#t127

# ------------------------------------------------------------------------------
# t128 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 89
# ------------------------------------------------------------------------------

sub t128 {
  $result = eval {varparent( "p001:items:10:subs:100" );
};
  $@ and die $@;
  return $result eq "p001:items:10:subs";
}#t128

# ------------------------------------------------------------------------------
# t129 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 90
# ------------------------------------------------------------------------------

sub t129 {
  $result = eval {varparent( "p001" );
};
  $@ and die $@;
  return $result eq "";
}#t129

# ------------------------------------------------------------------------------
# t130 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 105
# ------------------------------------------------------------------------------

sub t130 {
  $result = eval {dotaddr("p004:proj:1000");
};
  $@ and die $@;
  return $result eq "p004.proj.1000";
}#t130

# ------------------------------------------------------------------------------
# t131 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 106
# ------------------------------------------------------------------------------

sub t131 {
  $result = eval {dotaddr("p004:proj:1000:name");
};
  $@ and die $@;
  return $result eq "p004.proj.1000.name";
}#t131

# ------------------------------------------------------------------------------
# t132 - Match
# Generated from ../lib/Hub/Data/Address.pm line: 107
# ------------------------------------------------------------------------------

sub t132 {
  $result = eval {dotaddr("p001");
};
  $@ and die $@;
  return $result eq "p001";
}#t132

# ------------------------------------------------------------------------------
# t133 - Defined
# Generated from ../lib/Hub/Data/Address.pm line: 108
# ------------------------------------------------------------------------------

sub t133 {
  $result = eval {dotaddr("");
};
  $@ and die $@;
  return defined $result ? 1 : 0;
}#t133

