package Math::DWT::Wavelet::Coiflet;


=head1 NAME

Math::DWT::Wavelet::Coiflet - FIR lo- & hi-pass filter coefficients for the Coiflet wavelet.

=head1 VERSION

Version 0.01_1

=cut

our $VERSION = '0.01_1';

=head1 SYNOPSIS

This module provides the lo- and hi-pass decomposition and reconstruction filter coefficients for the Coiflet wavelet.  It is meant to be used with other Math::DWT modules:

    use Math::DWT;
    use Math::DWT::UDWT;

    my $dwt = Math::DWT->new('Coiflet');
    my $udwt = Math::DWT::UDWT->new('Coiflet');


=cut

=head1 SUBROUTINES/METHODS

=head2 new(VAR)

Takes a single argument, var, which determines the particular filter set which the object will provide.  You can get a list of available filter sets with the vars() method.

    my $coiflet4 = Math::DWT::Wavelet::Coiflet->new(4);

This method returns a Math::DWT::Wavelet::Coiflet object;

=head2 vars()

This method returns a list of possible choices for VAR when creating a new object, e.g.:

    my @v = Math::DWT::Wavelet::Coiflet->vars();
    print scalar(@v); # 5


=head2 filters()

Depending on the context in which it is called, returns an array or an arrayref containing (lo_d, hi_d, lo_r, hi_r) - the set of filters which are defined with the instantiated object.


=head2 lo_d()

=head2 hi_d()

=head2 lo_r()

=head2 hi_r()

Returns the requested set of filter coefficients as either an array or arrayref, depending on calling context.

=head1 SEE ALSO

Math::DWT(3pm), Math::DWT::UDWT(3pm), Math::DWT::Wavelet::Haar(3pm), Math::DWT::Wavelet::Daubechies(3pm), Math::DWT::Wavelet::Symlet(3pm), Math::DWT::Wavelet::Biorthogonal(3pm), Math::DWT::Wavelet::ReverseBiorthogonal(3pm), Math::DWT::Wavelet::DiscreteMeyer(3pm), perl(1)


=head1 AUTHOR


Mike Kroh, C<< <kroh at cpan.org> >>

=head1 BUGS


Please report any bugs or feature requests to C<bug-math-dwt-wavelet-coiflet at rt.cpan.org>, or through the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Math-DWT-Wavelet-Coiflet>.  I will be notified, and then you'll automatically be notified of progress on your bug as I make changes.



=head1 ACKNOWLEDGEMENTS

These wavelet filter coefficients were scraped from this site: L<http://wavelets.pybytes.com/>.

=head1 LICENSE AND COPYRIGHT


Copyright 2016 Mike Kroh.

This program is free software; you can redistribute it and/or modify it
under the terms of the the Artistic License (2.0). You may obtain a
copy of the full license at:

L<http://www.perlfoundation.org/artistic_license_2_0>

Any use, modification, and distribution of the Standard or Modified
Versions is governed by this Artistic License. By using, modifying or
distributing the Package, you accept this license. Do not use, modify,
or distribute the Package, if you do not accept this license.

If your Modified Version has been derived from a Modified Version made
by someone other than you, you are nevertheless required to ensure that
your Modified Version complies with the requirements of this license.

This license does not grant you the right to use any trademark, service
mark, tradename, or logo of the Copyright Holder.

This license includes the non-exclusive, worldwide, free-of-charge
patent license to make, have made, use, offer to sell, sell, import and
otherwise transfer the Package with respect to any patent claims
licensable by the Copyright Holder that are necessarily infringed by the
Package. If you institute patent litigation (including a cross-claim or
counterclaim) against any party alleging that the Package constitutes
direct or contributory patent infringement, then this Artistic License
to you shall terminate on the date that such litigation is filed.

Disclaimer of Warranty: THE PACKAGE IS PROVIDED BY THE COPYRIGHT HOLDER
AND CONTRIBUTORS "AS IS' AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
PURPOSE, OR NON-INFRINGEMENT ARE DISCLAIMED TO THE EXTENT PERMITTED BY
YOUR LOCAL LAW. UNLESS REQUIRED BY LAW, NO COPYRIGHT HOLDER OR
CONTRIBUTOR WILL BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING IN ANY WAY OUT OF THE USE OF THE PACKAGE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


=cut



my @vars=qw/1 2 3 4 5/;

my %lo_d; my %hi_d; my %lo_r; my %hi_r;


$lo_d{1}=[qw/-0.01565572813546454 -0.0727326195128539 0.38486484686420286 0.8525720202122554 0.3378976624578092 -0.0727326195128539/];
$hi_d{1}=[qw/0.0727326195128539 0.3378976624578092 -0.8525720202122554 0.38486484686420286 0.0727326195128539 -0.01565572813546454/];
$lo_r{1}=[qw/-0.0727326195128539 0.3378976624578092 0.8525720202122554 0.38486484686420286 -0.0727326195128539 -0.01565572813546454/];
$hi_r{1}=[qw/-0.01565572813546454 0.0727326195128539 0.38486484686420286 -0.8525720202122554 0.3378976624578092 0.0727326195128539/];

$lo_d{2}=[qw/-0.0007205494453645122 -0.0018232088707029932 0.0056114348193944995 0.023680171946334084 -0.0594344186464569 -0.0764885990783064 0.41700518442169254 0.8127236354455423 0.3861100668211622 -0.06737255472196302 -0.04146493678175915 0.016387336463522112/];
$hi_d{2}=[qw/-0.016387336463522112 -0.04146493678175915 0.06737255472196302 0.3861100668211622 -0.8127236354455423 0.41700518442169254 0.0764885990783064 -0.0594344186464569 -0.023680171946334084 0.0056114348193944995 0.0018232088707029932 -0.0007205494453645122/];
$lo_r{2}=[qw/0.016387336463522112 -0.04146493678175915 -0.06737255472196302 0.3861100668211622 0.8127236354455423 0.41700518442169254 -0.0764885990783064 -0.0594344186464569 0.023680171946334084 0.0056114348193944995 -0.0018232088707029932 -0.0007205494453645122/];
$hi_r{2}=[qw/-0.0007205494453645122 0.0018232088707029932 0.0056114348193944995 -0.023680171946334084 -0.0594344186464569 0.0764885990783064 0.41700518442169254 -0.8127236354455423 0.3861100668211622 0.06737255472196302 -0.04146493678175915 -0.016387336463522112/];

$lo_d{3}=[qw/-3.459977283621256e-05 -7.098330313814125e-05 0.0004662169601128863 0.0011175187708906016 -0.0025745176887502236 -0.00900797613666158 0.015880544863615904 0.03455502757306163 -0.08230192710688598 -0.07179982161931202 0.42848347637761874 0.7937772226256206 0.4051769024096169 -0.06112339000267287 -0.0657719112818555 0.023452696141836267 0.007782596427325418 -0.003793512864491014/];
$hi_d{3}=[qw/0.003793512864491014 0.007782596427325418 -0.023452696141836267 -0.0657719112818555 0.06112339000267287 0.4051769024096169 -0.7937772226256206 0.42848347637761874 0.07179982161931202 -0.08230192710688598 -0.03455502757306163 0.015880544863615904 0.00900797613666158 -0.0025745176887502236 -0.0011175187708906016 0.0004662169601128863 7.098330313814125e-05 -3.459977283621256e-05/];
$lo_r{3}=[qw/-0.003793512864491014 0.007782596427325418 0.023452696141836267 -0.0657719112818555 -0.06112339000267287 0.4051769024096169 0.7937772226256206 0.42848347637761874 -0.07179982161931202 -0.08230192710688598 0.03455502757306163 0.015880544863615904 -0.00900797613666158 -0.0025745176887502236 0.0011175187708906016 0.0004662169601128863 -7.098330313814125e-05 -3.459977283621256e-05/];
$hi_r{3}=[qw/-3.459977283621256e-05 7.098330313814125e-05 0.0004662169601128863 -0.0011175187708906016 -0.0025745176887502236 0.00900797613666158 0.015880544863615904 -0.03455502757306163 -0.08230192710688598 0.07179982161931202 0.42848347637761874 -0.7937772226256206 0.4051769024096169 0.06112339000267287 -0.0657719112818555 -0.023452696141836267 0.007782596427325418 0.003793512864491014/];

$lo_d{4}=[qw/-1.7849850030882614e-06 -3.2596802368833675e-06 3.1229875865345646e-05 6.233903446100713e-05 -0.00025997455248771324 -0.0005890207562443383 0.0012665619292989445 0.003751436157278457 -0.00565828668661072 -0.015211731527946259 0.025082261844864097 0.03933442712333749 -0.09622044203398798 -0.06662747426342504 0.4343860564914685 0.782238930920499 0.41530840703043026 -0.05607731331675481 -0.08126669968087875 0.026682300156053072 0.016068943964776348 -0.0073461663276420935 -0.0016294920126017326 0.0008923136685823146/];
$hi_d{4}=[qw/-0.0008923136685823146 -0.0016294920126017326 0.0073461663276420935 0.016068943964776348 -0.026682300156053072 -0.08126669968087875 0.05607731331675481 0.41530840703043026 -0.782238930920499 0.4343860564914685 0.06662747426342504 -0.09622044203398798 -0.03933442712333749 0.025082261844864097 0.015211731527946259 -0.00565828668661072 -0.003751436157278457 0.0012665619292989445 0.0005890207562443383 -0.00025997455248771324 -6.233903446100713e-05 3.1229875865345646e-05 3.2596802368833675e-06 -1.7849850030882614e-06/];
$lo_r{4}=[qw/0.0008923136685823146 -0.0016294920126017326 -0.0073461663276420935 0.016068943964776348 0.026682300156053072 -0.08126669968087875 -0.05607731331675481 0.41530840703043026 0.782238930920499 0.4343860564914685 -0.06662747426342504 -0.09622044203398798 0.03933442712333749 0.025082261844864097 -0.015211731527946259 -0.00565828668661072 0.003751436157278457 0.0012665619292989445 -0.0005890207562443383 -0.00025997455248771324 6.233903446100713e-05 3.1229875865345646e-05 -3.2596802368833675e-06 -1.7849850030882614e-06/];
$hi_r{4}=[qw/-1.7849850030882614e-06 3.2596802368833675e-06 3.1229875865345646e-05 -6.233903446100713e-05 -0.00025997455248771324 0.0005890207562443383 0.0012665619292989445 -0.003751436157278457 -0.00565828668661072 0.015211731527946259 0.025082261844864097 -0.03933442712333749 -0.09622044203398798 0.06662747426342504 0.4343860564914685 -0.782238930920499 0.41530840703043026 0.05607731331675481 -0.08126669968087875 -0.026682300156053072 0.016068943964776348 0.0073461663276420935 -0.0016294920126017326 -0.0008923136685823146/];

$lo_d{5}=[qw/-9.517657273819165e-08 -1.6744288576823017e-07 2.0637618513646814e-06 3.7346551751414047e-06 -2.1315026809955787e-05 -4.134043227251251e-05 0.00014054114970203437 0.00030225958181306315 -0.0006381313430451114 -0.0016628637020130838 0.0024333732126576722 0.006764185448053083 -0.009164231162481846 -0.01976177894257264 0.03268357426711183 0.0412892087501817 -0.10557420870333893 -0.06203596396290357 0.4379916261718371 0.7742896036529562 0.4215662066908515 -0.05204316317624377 -0.09192001055969624 0.02816802897093635 0.023408156785839195 -0.010131117519849788 -0.004159358781386048 0.0021782363581090178 0.00035858968789573785 -0.00021208083980379827/];
$hi_d{5}=[qw/0.00021208083980379827 0.00035858968789573785 -0.0021782363581090178 -0.004159358781386048 0.010131117519849788 0.023408156785839195 -0.02816802897093635 -0.09192001055969624 0.05204316317624377 0.4215662066908515 -0.7742896036529562 0.4379916261718371 0.06203596396290357 -0.10557420870333893 -0.0412892087501817 0.03268357426711183 0.01976177894257264 -0.009164231162481846 -0.006764185448053083 0.0024333732126576722 0.0016628637020130838 -0.0006381313430451114 -0.00030225958181306315 0.00014054114970203437 4.134043227251251e-05 -2.1315026809955787e-05 -3.7346551751414047e-06 2.0637618513646814e-06 1.6744288576823017e-07 -9.517657273819165e-08/];
$lo_r{5}=[qw/-0.00021208083980379827 0.00035858968789573785 0.0021782363581090178 -0.004159358781386048 -0.010131117519849788 0.023408156785839195 0.02816802897093635 -0.09192001055969624 -0.05204316317624377 0.4215662066908515 0.7742896036529562 0.4379916261718371 -0.06203596396290357 -0.10557420870333893 0.0412892087501817 0.03268357426711183 -0.01976177894257264 -0.009164231162481846 0.006764185448053083 0.0024333732126576722 -0.0016628637020130838 -0.0006381313430451114 0.00030225958181306315 0.00014054114970203437 -4.134043227251251e-05 -2.1315026809955787e-05 3.7346551751414047e-06 2.0637618513646814e-06 -1.6744288576823017e-07 -9.517657273819165e-08/];
$hi_r{5}=[qw/-9.517657273819165e-08 1.6744288576823017e-07 2.0637618513646814e-06 -3.7346551751414047e-06 -2.1315026809955787e-05 4.134043227251251e-05 0.00014054114970203437 -0.00030225958181306315 -0.0006381313430451114 0.0016628637020130838 0.0024333732126576722 -0.006764185448053083 -0.009164231162481846 0.01976177894257264 0.03268357426711183 -0.0412892087501817 -0.10557420870333893 0.06203596396290357 0.4379916261718371 -0.7742896036529562 0.4215662066908515 0.05204316317624377 -0.09192001055969624 -0.02816802897093635 0.023408156785839195 0.010131117519849788 -0.004159358781386048 -0.0021782363581090178 0.00035858968789573785 0.00021208083980379827/];
;

sub new {
	my $class=shift;
	my $self={};
	my $var=shift;

	$self={lo_d=>$lo_d{$var},
		hi_d=>$hi_d{$var},
		lo_r=>$lo_r{$var},
		hi_r=>$hi_r{$var}
		};
	
	bless $self,$class;
	return $self;
};

sub vars {
	my $self=shift;
	if (wantarray()) {
		return (@vars);
	};
	return \@vars;
};

sub filters {
	my $self=shift;
	my $lo_d=$self->lo_d;
	my $hi_d=$self->hi_d;
	my $lo_r=$self->lo_r;
	my $hi_r=$self->hi_r;
	my @a=( $lo_d,$hi_d,$lo_r,$hi_r);
	if (wantarray()) {
		return (@a);
	};
	return \@a;
};

sub lo_d {
	my $self=shift;
	my $a=$self->{lo_d};
	if (wantarray()) {
		return (@{$a});
	};
	return $a;
};	
sub hi_d {
	my $self=shift;
	my $a=$self->{hi_d};
	if (wantarray()) {
		return (@{$a});
	};
	return $a;
};	
sub lo_r {
	my $self=shift;
	my $a=$self->{lo_r};
	if (wantarray()) {
		return (@{$a});
	};
	return $a;
};	
sub hi_r {
	my $self=shift;
	my $a=$self->{hi_r};
	if (wantarray()) {
		return (@{$a});
	};
	return $a;
};	

		
1;
