use Dist::Iller::Standard;

# PODNAME: Dist::Iller::Configuration::Prereq

class Dist::Iller::Configuration::Prereq using Moose {

    our $VERSION = '0.1201'; # VERSION

    has module => (
        is => 'ro',
        isa => Str,
        required => 1,
    );
    has phase => (
        is => 'ro',
        isa => Enum[qw/build configure develop runtime test/],
        required => 1,
    );
    has relation => (
        is => 'ro',
        isa => Enum[qw/requires recommends suggests conflicts/],
        required => 1,
    );
    has version => (
        is => 'ro',
        isa => Str,
        default => '0',
    );

}

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Iller::Configuration::Prereq

=head1 VERSION

Version 0.1201, released 2015-11-24.

=head1 SOURCE

L<https://github.com/Csson/p5-Dist-Iller>

=head1 HOMEPAGE

L<https://metacpan.org/release/Dist-Iller>

=head1 AUTHOR

Erik Carlsson <info@code301.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Erik Carlsson.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
