/* search.c generated by valac 0.56.17, the Vala compiler
 * generated from search.vala, do not modify */

/* Search and replace functions

   Copyright (c) 1997-2021 Free Software Foundation, Inc.

   This file is part of GNU Zile.

   GNU Zile is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3, or (at your option)
   any later version.

   GNU Zile is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, see <https://www.gnu.org/licenses/>.  */

#define _GNU_SOURCE

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <regex.h>
#include <estr.h>
#include <glib-object.h>
#include <gee.h>

#define REGEX_SYNTAX_PLAIN ((gint) (RE_NO_SUB << 1))
#define GETKEY_DEFAULT -1
#define KBD_CTRL ((Keystroke) 01000)
#define KBD_CANCEL (KBD_CTRL | 'g')
#define KBD_BS ((Keystroke) 00411)
#define KBD_META ((Keystroke) 02000)
#define KBD_TAB ((Keystroke) 00402)
#define KBD_RET ((Keystroke) 00403)
#define KBD_DEL ((Keystroke) 00410)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_BUFFER (buffer_get_type ())
#define BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUFFER, Buffer))
#define BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUFFER, BufferClass))
#define IS_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUFFER))
#define IS_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUFFER))
#define BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUFFER, BufferClass))

typedef struct _Buffer Buffer;
typedef struct _BufferClass BufferClass;
#define _immutable_estr_unref0(var) ((var == NULL) ? NULL : (var = (immutable_estr_unref (var), NULL)))
typedef enum  {
	FLAGS_NEED_RESYNC = 1 << 0,
	FLAGS_SET_UNIARG = 1 << 1,
	FLAGS_UNIARG_EMPTY = 1 << 2,
	FLAGS_DEFINING_MACRO = 1 << 3
} Flags;

#define TYPE_FLAGS (flags_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MARKER, MarkerClass))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define IS_MARKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MARKER))
#define MARKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MARKER, MarkerClass))

typedef struct _Marker Marker;
typedef struct _MarkerClass MarkerClass;

#define TYPE_WINDOW (window_get_type ())
#define WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WINDOW, Window))
#define WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WINDOW, WindowClass))
#define IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WINDOW))
#define IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WINDOW))
#define WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WINDOW, WindowClass))

typedef struct _Window Window;
typedef struct _WindowClass WindowClass;
typedef struct _WindowPrivate WindowPrivate;
typedef struct _BufferPrivate BufferPrivate;

#define TYPE_UNDO (undo_get_type ())
#define UNDO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO, Undo))
#define UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO, UndoClass))
#define IS_UNDO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO))
#define IS_UNDO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO))
#define UNDO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO, UndoClass))

typedef struct _Undo Undo;
typedef struct _UndoClass UndoClass;

#define TYPE_VAR_ENTRY (var_entry_get_type ())
#define VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VAR_ENTRY, VarEntry))
#define VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VAR_ENTRY, VarEntryClass))
#define IS_VAR_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VAR_ENTRY))
#define IS_VAR_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VAR_ENTRY))
#define VAR_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VAR_ENTRY, VarEntryClass))

typedef struct _VarEntry VarEntry;
typedef struct _VarEntryClass VarEntryClass;
typedef guint Keystroke;
#define _marker_unref0(var) ((var == NULL) ? NULL : (var = (marker_unref (var), NULL)))
typedef enum  {
	CASE_upper = 1,
	CASE_lower,
	CASE_capitalized
} Case;

#define TYPE_CASE (case_get_type ())
typedef gboolean (*Function) (glong uniarg, GeeQueue* args);

#define TYPE_LISP_FUNC (lisp_func_get_type ())
#define LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LISP_FUNC, LispFunc))
#define LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LISP_FUNC, LispFuncClass))
#define IS_LISP_FUNC(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LISP_FUNC))
#define IS_LISP_FUNC_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LISP_FUNC))
#define LISP_FUNC_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LISP_FUNC, LispFuncClass))

typedef struct _LispFunc LispFunc;
typedef struct _LispFuncClass LispFuncClass;
#define _lisp_func_unref0(var) ((var == NULL) ? NULL : (var = (lisp_func_unref (var), NULL)))

#define TYPE_REGION (region_get_type ())
#define REGION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REGION, Region))
#define REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_REGION, RegionClass))
#define IS_REGION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REGION))
#define IS_REGION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_REGION))
#define REGION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_REGION, RegionClass))

typedef struct _Region Region;
typedef struct _RegionClass RegionClass;
#define _region_unref0(var) ((var == NULL) ? NULL : (var = (region_unref (var), NULL)))

struct _Window {
	GTypeInstance parent_instance;
	volatile int ref_count;
	WindowPrivate * priv;
	Window* next;
	Buffer* bp;
	gsize topdelta;
	gsize start_column;
	Marker* saved_pt;
	gsize fwidth;
	gsize fheight;
	gsize ewidth;
	gsize eheight;
	gboolean all_displayed;
	gsize lastpointn;
};

struct _WindowClass {
	GTypeClass parent_class;
	void (*finalize) (Window *self);
};

struct _Buffer {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BufferPrivate * priv;
	gchar* name;
	gchar* filename;
	Buffer* next;
	gsize goalc;
	Marker* mark;
	Marker* markers;
	GList* last_undop;
	GList* next_undop;
	GHashTable* vars;
	gboolean modified;
	gboolean nosave;
	gboolean needname;
	gboolean temporary;
	gboolean readonly;
	gboolean backup;
	gboolean noundo;
	gboolean autofill;
	gboolean isearch;
	gboolean mark_active;
	gchar* dir;
};

struct _BufferClass {
	GTypeClass parent_class;
	void (*finalize) (Buffer *self);
	gsize (*get_length) (Buffer* self);
	const gchar* (*get_eol) (Buffer* self);
};

VALA_EXTERN const gchar* re_find_err;
const gchar* re_find_err = NULL;
VALA_EXTERN Buffer* cur_bp;
VALA_EXTERN Flags thisflag;
VALA_EXTERN gchar* last_search;
gchar* last_search = NULL;
VALA_EXTERN Window* cur_wp;
VALA_EXTERN Flags lastflag;

VALA_EXTERN gboolean no_upper (const gchar* s,
                   guint len,
                   gboolean regex);
VALA_EXTERN glong find_substr (ImmutableEstr* es,
                   const gchar* n,
                   gboolean forward,
                   gboolean notbol,
                   gboolean noteol,
                   gboolean regex,
                   gboolean icase);
VALA_EXTERN gboolean search (const gchar* s,
                 gboolean forward,
                 gboolean regexp);
VALA_EXTERN gpointer buffer_ref (gpointer instance);
VALA_EXTERN void buffer_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_buffer (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_buffer (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_buffer (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_buffer (const GValue* value);
VALA_EXTERN GType buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Buffer, buffer_unref)
VALA_EXTERN gsize buffer_get_pt (Buffer* self);
VALA_EXTERN gsize buffer_get_length (Buffer* self);
VALA_EXTERN ImmutableEstr* buffer_post_point (Buffer* self);
VALA_EXTERN ImmutableEstr* buffer_pre_point (Buffer* self);
VALA_EXTERN gboolean get_variable_bool (const gchar* name);
VALA_EXTERN void buffer_goto_offset (Buffer* self,
                         gsize o);
VALA_EXTERN GType flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean do_search (gboolean forward,
                    gboolean regexp,
                    const gchar* pattern_in);
VALA_EXTERN gchar* minibuf_read (const gchar* fmt,
                     const gchar* value,
                     ...);
VALA_EXTERN gboolean funcall (const gchar* name,
                  glong* maybe_uniarg,
                  GeeQueue* args);
VALA_EXTERN void minibuf_error (const gchar* fmt,
                    ...);
VALA_EXTERN gboolean isearch (gboolean forward,
                  gboolean regexp);
VALA_EXTERN gpointer marker_ref (gpointer instance);
VALA_EXTERN void marker_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_marker (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_marker (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_marker (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_marker (const GValue* value);
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, marker_unref)
VALA_EXTERN Marker* marker_copy (Marker* m);
VALA_EXTERN gpointer window_ref (gpointer instance);
VALA_EXTERN void window_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_window (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_window (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_window (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_window (const GValue* value);
VALA_EXTERN GType window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Window, window_unref)
VALA_EXTERN gpointer undo_ref (gpointer instance);
VALA_EXTERN void undo_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags);
VALA_EXTERN void value_set_undo (GValue* value,
                     gpointer v_object);
VALA_EXTERN void value_take_undo (GValue* value,
                      gpointer v_object);
VALA_EXTERN gpointer value_get_undo (const GValue* value);
VALA_EXTERN GType undo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Undo, undo_unref)
VALA_EXTERN gpointer var_entry_ref (gpointer instance);
VALA_EXTERN void var_entry_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_var_entry (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_var_entry (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_var_entry (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_var_entry (const GValue* value);
VALA_EXTERN GType var_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VarEntry, var_entry_unref)
VALA_EXTERN void minibuf_write (const gchar* fmt,
                    ...);
VALA_EXTERN Keystroke getkey (gint delay);
VALA_EXTERN void marker_unchain (Marker* self);
VALA_EXTERN void ding (void);
VALA_EXTERN Keystroke getkey_unfiltered (gint mode);
VALA_EXTERN void set_mark (void);
VALA_EXTERN void marker_set_o (Marker* self,
                   gsize value);
VALA_EXTERN void minibuf_clear (void);
VALA_EXTERN void ungetkey (Keystroke key);
VALA_EXTERN void window_resync (Window* self);
VALA_EXTERN void term_redisplay (void);
VALA_EXTERN GType case_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Case check_case (ImmutableEstr* a);
VALA_EXTERN void search_init (void);
static gboolean __lambda123_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda123__function (glong uniarg,
                                 GeeQueue* args);
VALA_EXTERN LispFunc* lisp_func_new (const gchar* name,
                         Function func,
                         gboolean interactive,
                         const gchar* doc);
VALA_EXTERN LispFunc* lisp_func_construct (GType object_type,
                               const gchar* name,
                               Function func,
                               gboolean interactive,
                               const gchar* doc);
VALA_EXTERN gpointer lisp_func_ref (gpointer instance);
VALA_EXTERN void lisp_func_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_lisp_func (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_lisp_func (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_lisp_func (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_lisp_func (const GValue* value);
VALA_EXTERN GType lisp_func_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LispFunc, lisp_func_unref)
static gboolean __lambda124_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda124__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda125_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda125__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda126_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda126__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda127_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda127__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda128_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda128__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda129_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda129__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda130_ (glong uniarg,
                       GeeQueue* args);
static gboolean ___lambda130__function (glong uniarg,
                                 GeeQueue* args);
static gboolean __lambda131_ (glong uniarg,
                       GeeQueue* args);
VALA_EXTERN gpointer region_ref (gpointer instance);
VALA_EXTERN void region_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_region (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags);
VALA_EXTERN void value_set_region (GValue* value,
                       gpointer v_object);
VALA_EXTERN void value_take_region (GValue* value,
                        gpointer v_object);
VALA_EXTERN gpointer value_get_region (const GValue* value);
VALA_EXTERN GType region_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Region, region_unref)
VALA_EXTERN Region* region_new (gsize o1,
                    gsize o2);
VALA_EXTERN Region* region_construct (GType object_type,
                          gsize o1,
                          gsize o2);
VALA_EXTERN ImmutableEstr* buffer_get_region (Buffer* self,
                                  Region* r);
VALA_EXTERN gchar* recase (const gchar* s,
               Case rcase);
VALA_EXTERN Marker* marker_point (void);
VALA_EXTERN gsize region_get_start (Region* self);
VALA_EXTERN gboolean buffer_replace_estr (Buffer* self,
                              gsize del,
                              ImmutableEstr* es);
VALA_EXTERN const gchar* buffer_get_eol (Buffer* self);
VALA_EXTERN gsize marker_get_o (Marker* self);
static gboolean ___lambda131__function (glong uniarg,
                                 GeeQueue* args);

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 444 "search.c"
}

gboolean
no_upper (const gchar* s,
          guint len,
          gboolean regex)
{
	gboolean quote_flag = FALSE;
	gboolean result;
#line 24 "src/search.vala"
	g_return_val_if_fail (s != NULL, FALSE);
#line 25 "src/search.vala"
	quote_flag = FALSE;
#line 458 "search.c"
	{
		guint i = 0U;
#line 27 "src/search.vala"
		i = (guint) 0;
#line 463 "search.c"
		{
			gboolean _tmp0_ = FALSE;
#line 27 "src/search.vala"
			_tmp0_ = TRUE;
#line 27 "src/search.vala"
			while (TRUE) {
#line 470 "search.c"
				gboolean _tmp2_ = FALSE;
#line 27 "src/search.vala"
				if (!_tmp0_) {
#line 474 "search.c"
					guint _tmp1_;
#line 27 "src/search.vala"
					_tmp1_ = i;
#line 27 "src/search.vala"
					i = _tmp1_ + 1;
#line 480 "search.c"
				}
#line 27 "src/search.vala"
				_tmp0_ = FALSE;
#line 27 "src/search.vala"
				if (!(i < len)) {
#line 27 "src/search.vala"
					break;
#line 488 "search.c"
				}
#line 28 "src/search.vala"
				if (regex) {
#line 28 "src/search.vala"
					_tmp2_ = string_get (s, (glong) i) == '\\';
#line 494 "search.c"
				} else {
#line 28 "src/search.vala"
					_tmp2_ = FALSE;
#line 498 "search.c"
				}
#line 28 "src/search.vala"
				if (_tmp2_) {
#line 29 "src/search.vala"
					quote_flag = !quote_flag;
#line 504 "search.c"
				} else {
					gboolean _tmp3_ = FALSE;
#line 30 "src/search.vala"
					if (!quote_flag) {
#line 30 "src/search.vala"
						_tmp3_ = g_ascii_isupper (string_get (s, (glong) i));
#line 511 "search.c"
					} else {
#line 30 "src/search.vala"
						_tmp3_ = FALSE;
#line 515 "search.c"
					}
#line 30 "src/search.vala"
					if (_tmp3_) {
#line 31 "src/search.vala"
						result = FALSE;
#line 31 "src/search.vala"
						return result;
#line 523 "search.c"
					}
				}
			}
		}
	}
#line 34 "src/search.vala"
	result = TRUE;
#line 34 "src/search.vala"
	return result;
#line 533 "search.c"
}

static void
regex_registers_destroy (struct re_registers *self)
{
	regoff_t* _tmp0_;
	gint _tmp0__length1;
	regoff_t* _tmp1_;
	gint _tmp1__length1;
#line 3928 "posix.vapi"
	_tmp0_ = (*self).start;
#line 3928 "posix.vapi"
	_tmp0__length1 = (*self).num_regs;
#line 3928 "posix.vapi"
	free (_tmp0_);
#line 3929 "posix.vapi"
	_tmp1_ = (*self).end;
#line 3929 "posix.vapi"
	_tmp1__length1 = (*self).num_regs;
#line 3929 "posix.vapi"
	free (_tmp1_);
#line 555 "search.c"
}

glong
find_substr (ImmutableEstr* es,
             const gchar* n,
             gboolean forward,
             gboolean notbol,
             gboolean noteol,
             gboolean regex,
             gboolean icase)
{
	glong ret = 0L;
	struct re_pattern_buffer pattern = {0};
	struct re_registers search_regs = {0};
	reg_syntax_t syntax = 0U;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	glong result;
#line 40 "src/search.vala"
	g_return_val_if_fail (es != NULL, 0L);
#line 40 "src/search.vala"
	g_return_val_if_fail (n != NULL, 0L);
#line 41 "src/search.vala"
	ret = (glong) -1;
#line 42 "src/search.vala"
	memset (&pattern, 0, sizeof (struct re_pattern_buffer));
#line 43 "src/search.vala"
	memset (&search_regs, 0, sizeof (struct re_registers));
#line 44 "src/search.vala"
	syntax = RE_SYNTAX_EMACS;
#line 46 "src/search.vala"
	if (!regex) {
#line 47 "src/search.vala"
		syntax |= REGEX_SYNTAX_PLAIN;
#line 592 "search.c"
	}
#line 48 "src/search.vala"
	if (icase) {
#line 49 "src/search.vala"
		syntax |= RE_ICASE;
#line 598 "search.c"
	}
#line 50 "src/search.vala"
	re_set_syntax (syntax);
#line 51 "src/search.vala"
	search_regs.num_regs = (__re_size_t) 1;
#line 53 "src/search.vala"
	_tmp0_ = strlen (n);
#line 53 "src/search.vala"
	_tmp1_ = _tmp0_;
#line 53 "src/search.vala"
	_tmp2_ = re_compile_pattern (n, (gsize) ((gint) _tmp1_), &pattern);
#line 53 "src/search.vala"
	re_find_err = _tmp2_;
#line 54 "src/search.vala"
	pattern.not_bol = notbol;
#line 55 "src/search.vala"
	pattern.not_eol = noteol;
#line 56 "src/search.vala"
	_tmp3_ = re_find_err;
#line 56 "src/search.vala"
	if (_tmp3_ == NULL) {
#line 620 "search.c"
		gsize _tmp4_ = 0UL;
		gsize _tmp7_ = 0UL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gsize _tmp14_;
		gsize _tmp15_;
		struct re_registers _tmp16_ = {0};
		regoff_t _tmp17_;
#line 58 "src/search.vala"
		if (forward) {
#line 58 "src/search.vala"
			_tmp4_ = (gsize) 0;
#line 633 "search.c"
		} else {
			gsize _tmp5_;
			gsize _tmp6_;
#line 58 "src/search.vala"
			_tmp5_ = immutable_estr_get_length (es);
#line 58 "src/search.vala"
			_tmp6_ = _tmp5_;
#line 58 "src/search.vala"
			_tmp4_ = _tmp6_;
#line 643 "search.c"
		}
#line 59 "src/search.vala"
		if (forward) {
#line 647 "search.c"
			gsize _tmp8_;
			gsize _tmp9_;
#line 59 "src/search.vala"
			_tmp8_ = immutable_estr_get_length (es);
#line 59 "src/search.vala"
			_tmp9_ = _tmp8_;
#line 59 "src/search.vala"
			_tmp7_ = _tmp9_;
#line 656 "search.c"
		} else {
			gsize _tmp10_;
			gsize _tmp11_;
#line 59 "src/search.vala"
			_tmp10_ = immutable_estr_get_length (es);
#line 59 "src/search.vala"
			_tmp11_ = _tmp10_;
#line 59 "src/search.vala"
			_tmp7_ = -_tmp11_;
#line 666 "search.c"
		}
#line 57 "src/search.vala"
		_tmp12_ = immutable_estr_get_text (es);
#line 57 "src/search.vala"
		_tmp13_ = _tmp12_;
#line 57 "src/search.vala"
		_tmp14_ = immutable_estr_get_length (es);
#line 57 "src/search.vala"
		_tmp15_ = _tmp14_;
#line 57 "src/search.vala"
		_tmp17_ = re_search (&pattern, (const gchar*) _tmp13_, (regoff_t) _tmp15_, (regoff_t) _tmp4_, (regoff_t) _tmp7_, &_tmp16_);
#line 57 "src/search.vala"
		 (&search_regs);
#line 57 "src/search.vala"
		search_regs = _tmp16_;
#line 57 "src/search.vala"
		ret = (glong) _tmp17_;
#line 684 "search.c"
	}
#line 62 "src/search.vala"
	if (ret >= ((glong) 0)) {
#line 688 "search.c"
		regoff_t _tmp18_ = {0};
#line 63 "src/search.vala"
		if (forward) {
#line 692 "search.c"
			struct re_registers _tmp19_;
			regoff_t* _tmp20_;
			gint _tmp20__length1;
			regoff_t _tmp21_;
#line 63 "src/search.vala"
			_tmp19_ = search_regs;
#line 63 "src/search.vala"
			_tmp20_ = _tmp19_.end;
#line 63 "src/search.vala"
			_tmp20__length1 = _tmp19_.num_regs;
#line 63 "src/search.vala"
			_tmp21_ = _tmp20_[0];
#line 63 "src/search.vala"
			_tmp18_ = _tmp21_;
#line 707 "search.c"
		} else {
#line 63 "src/search.vala"
			_tmp18_ = (regoff_t) ret;
#line 711 "search.c"
		}
#line 63 "src/search.vala"
		ret = (glong) _tmp18_;
#line 715 "search.c"
	}
#line 65 "src/search.vala"
	regex_registers_destroy (&search_regs);
#line 66 "src/search.vala"
	result = ret;
#line 66 "src/search.vala"
	 (&search_regs);
#line 66 "src/search.vala"
	regfree (&pattern);
#line 66 "src/search.vala"
	return result;
#line 727 "search.c"
}

static gpointer
_immutable_estr_ref0 (gpointer self)
{
#line 77 "src/search.vala"
	return self ? immutable_estr_ref (self) : NULL;
#line 735 "search.c"
}

gboolean
search (const gchar* s,
        gboolean forward,
        gboolean regexp)
{
	gint _tmp0_;
	gint _tmp1_;
	gsize o = 0UL;
	Buffer* _tmp2_;
	gsize _tmp3_;
	gsize _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean notbol = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean noteol = FALSE;
	ImmutableEstr* _tmp10_ = NULL;
	ImmutableEstr* es = NULL;
	ImmutableEstr* _tmp15_;
	gboolean _tmp16_ = FALSE;
	glong pos = 0L;
	ImmutableEstr* _tmp19_;
	gsize _tmp20_ = 0UL;
	Buffer* _tmp24_;
	gboolean result;
#line 69 "src/search.vala"
	g_return_val_if_fail (s != NULL, FALSE);
#line 70 "src/search.vala"
	_tmp0_ = strlen (s);
#line 70 "src/search.vala"
	_tmp1_ = _tmp0_;
#line 70 "src/search.vala"
	if (_tmp1_ < 1) {
#line 71 "src/search.vala"
		result = FALSE;
#line 71 "src/search.vala"
		return result;
#line 774 "search.c"
	}
#line 74 "src/search.vala"
	_tmp2_ = cur_bp;
#line 74 "src/search.vala"
	_tmp3_ = buffer_get_pt (_tmp2_);
#line 74 "src/search.vala"
	_tmp4_ = _tmp3_;
#line 74 "src/search.vala"
	o = _tmp4_;
#line 75 "src/search.vala"
	if (forward) {
#line 75 "src/search.vala"
		_tmp5_ = o > ((gsize) 0);
#line 788 "search.c"
	} else {
#line 75 "src/search.vala"
		_tmp5_ = FALSE;
#line 792 "search.c"
	}
#line 75 "src/search.vala"
	notbol = _tmp5_;
#line 76 "src/search.vala"
	if (forward) {
#line 76 "src/search.vala"
		_tmp6_ = FALSE;
#line 800 "search.c"
	} else {
		Buffer* _tmp7_;
		gsize _tmp8_;
		gsize _tmp9_;
#line 76 "src/search.vala"
		_tmp7_ = cur_bp;
#line 76 "src/search.vala"
		_tmp8_ = buffer_get_length (_tmp7_);
#line 76 "src/search.vala"
		_tmp9_ = _tmp8_;
#line 76 "src/search.vala"
		_tmp6_ = o < _tmp9_;
#line 813 "search.c"
	}
#line 76 "src/search.vala"
	noteol = _tmp6_;
#line 77 "src/search.vala"
	if (forward) {
#line 819 "search.c"
		Buffer* _tmp11_;
		ImmutableEstr* _tmp12_;
#line 77 "src/search.vala"
		_tmp11_ = cur_bp;
#line 77 "src/search.vala"
		_tmp12_ = buffer_post_point (_tmp11_);
#line 77 "src/search.vala"
		_immutable_estr_unref0 (_tmp10_);
#line 77 "src/search.vala"
		_tmp10_ = _tmp12_;
#line 830 "search.c"
	} else {
		Buffer* _tmp13_;
		ImmutableEstr* _tmp14_;
#line 77 "src/search.vala"
		_tmp13_ = cur_bp;
#line 77 "src/search.vala"
		_tmp14_ = buffer_pre_point (_tmp13_);
#line 77 "src/search.vala"
		_immutable_estr_unref0 (_tmp10_);
#line 77 "src/search.vala"
		_tmp10_ = _tmp14_;
#line 842 "search.c"
	}
#line 77 "src/search.vala"
	_tmp15_ = _immutable_estr_ref0 (_tmp10_);
#line 77 "src/search.vala"
	es = _tmp15_;
#line 79 "src/search.vala"
	if (get_variable_bool ("case-fold-search")) {
#line 850 "search.c"
		gint _tmp17_;
		gint _tmp18_;
#line 79 "src/search.vala"
		_tmp17_ = strlen (s);
#line 79 "src/search.vala"
		_tmp18_ = _tmp17_;
#line 79 "src/search.vala"
		_tmp16_ = no_upper (s, (guint) _tmp18_, regexp);
#line 859 "search.c"
	} else {
#line 79 "src/search.vala"
		_tmp16_ = FALSE;
#line 863 "search.c"
	}
#line 78 "src/search.vala"
	_tmp19_ = es;
#line 78 "src/search.vala"
	pos = find_substr (_tmp19_, s, forward, notbol, noteol, regexp, _tmp16_);
#line 80 "src/search.vala"
	if (pos < ((glong) 0)) {
#line 81 "src/search.vala"
		result = FALSE;
#line 81 "src/search.vala"
		_immutable_estr_unref0 (es);
#line 81 "src/search.vala"
		_immutable_estr_unref0 (_tmp10_);
#line 81 "src/search.vala"
		return result;
#line 879 "search.c"
	}
#line 83 "src/search.vala"
	if (forward) {
#line 883 "search.c"
		Buffer* _tmp21_;
		gsize _tmp22_;
		gsize _tmp23_;
#line 83 "src/search.vala"
		_tmp21_ = cur_bp;
#line 83 "src/search.vala"
		_tmp22_ = buffer_get_pt (_tmp21_);
#line 83 "src/search.vala"
		_tmp23_ = _tmp22_;
#line 83 "src/search.vala"
		_tmp20_ = _tmp23_;
#line 895 "search.c"
	} else {
#line 83 "src/search.vala"
		_tmp20_ = (gsize) 0;
#line 899 "search.c"
	}
#line 83 "src/search.vala"
	_tmp24_ = cur_bp;
#line 83 "src/search.vala"
	buffer_goto_offset (_tmp24_, pos + _tmp20_);
#line 84 "src/search.vala"
	thisflag = thisflag | FLAGS_NEED_RESYNC;
#line 85 "src/search.vala"
	result = TRUE;
#line 85 "src/search.vala"
	_immutable_estr_unref0 (es);
#line 85 "src/search.vala"
	_immutable_estr_unref0 (_tmp10_);
#line 85 "src/search.vala"
	return result;
#line 915 "search.c"
}

gboolean
do_search (gboolean forward,
           gboolean regexp,
           const gchar* pattern_in)
{
	gboolean ok = FALSE;
	gchar* pattern = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gboolean result;
#line 91 "src/search.vala"
	ok = FALSE;
#line 92 "src/search.vala"
	_tmp0_ = g_strdup (pattern_in);
#line 92 "src/search.vala"
	pattern = _tmp0_;
#line 94 "src/search.vala"
	_tmp1_ = pattern;
#line 94 "src/search.vala"
	if (_tmp1_ == NULL) {
#line 942 "search.c"
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 96 "src/search.vala"
		if (regexp) {
#line 96 "src/search.vala"
			_tmp2_ = "RE search";
#line 951 "search.c"
		} else {
#line 96 "src/search.vala"
			_tmp2_ = "Search";
#line 955 "search.c"
		}
#line 96 "src/search.vala"
		if (forward) {
#line 96 "src/search.vala"
			_tmp3_ = "";
#line 961 "search.c"
		} else {
#line 96 "src/search.vala"
			_tmp3_ = " backward";
#line 965 "search.c"
		}
#line 95 "src/search.vala"
		_tmp4_ = last_search;
#line 95 "src/search.vala"
		_tmp5_ = minibuf_read ("%s%s: ", _tmp4_, _tmp2_, _tmp3_, NULL);
#line 95 "src/search.vala"
		_g_free0 (pattern);
#line 95 "src/search.vala"
		pattern = _tmp5_;
#line 975 "search.c"
	}
#line 98 "src/search.vala"
	_tmp6_ = pattern;
#line 98 "src/search.vala"
	if (_tmp6_ == NULL) {
#line 99 "src/search.vala"
		result = funcall ("keyboard-quit", NULL, NULL);
#line 99 "src/search.vala"
		_g_free0 (pattern);
#line 99 "src/search.vala"
		return result;
#line 987 "search.c"
	}
#line 100 "src/search.vala"
	_tmp7_ = pattern;
#line 100 "src/search.vala"
	_tmp8_ = strlen (_tmp7_);
#line 100 "src/search.vala"
	_tmp9_ = _tmp8_;
#line 100 "src/search.vala"
	if (_tmp9_ != 0) {
#line 997 "search.c"
		const gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
#line 101 "src/search.vala"
		_tmp10_ = pattern;
#line 101 "src/search.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 101 "src/search.vala"
		_g_free0 (last_search);
#line 101 "src/search.vala"
		last_search = _tmp11_;
#line 103 "src/search.vala"
		_tmp12_ = pattern;
#line 103 "src/search.vala"
		if (!search (_tmp12_, forward, regexp)) {
#line 1013 "search.c"
			const gchar* _tmp13_;
#line 104 "src/search.vala"
			_tmp13_ = pattern;
#line 104 "src/search.vala"
			minibuf_error ("Search failed: \"%s\"", _tmp13_, NULL);
#line 1019 "search.c"
		} else {
#line 106 "src/search.vala"
			ok = TRUE;
#line 1023 "search.c"
		}
	}
#line 109 "src/search.vala"
	result = ok;
#line 109 "src/search.vala"
	_g_free0 (pattern);
#line 109 "src/search.vala"
	return result;
#line 1032 "search.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 1045 "search.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 1072 "search.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 1078 "search.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 1084 "search.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 1088 "search.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 1096 "search.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 1100 "search.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 1112 "search.c"
}

gboolean
isearch (gboolean forward,
         gboolean regexp)
{
	Marker* old_mark = NULL;
	Window* _tmp0_;
	Buffer* _tmp1_;
	Marker* _tmp2_;
	Marker* _tmp3_;
	Window* _tmp4_;
	Buffer* _tmp5_;
	gboolean last = FALSE;
	gchar* pattern = NULL;
	gchar* _tmp6_;
	gsize start = 0UL;
	Buffer* _tmp7_;
	gsize _tmp8_;
	gsize _tmp9_;
	gsize cur = 0UL;
	Window* _tmp86_;
	Buffer* _tmp87_;
	Marker* _tmp88_;
	gboolean result;
#line 116 "src/search.vala"
	_tmp0_ = cur_wp;
#line 116 "src/search.vala"
	_tmp1_ = _tmp0_->bp;
#line 116 "src/search.vala"
	_tmp2_ = _tmp1_->mark;
#line 116 "src/search.vala"
	_tmp3_ = marker_copy (_tmp2_);
#line 116 "src/search.vala"
	old_mark = _tmp3_;
#line 118 "src/search.vala"
	_tmp4_ = cur_wp;
#line 118 "src/search.vala"
	_tmp5_ = _tmp4_->bp;
#line 118 "src/search.vala"
	_tmp5_->isearch = TRUE;
#line 120 "src/search.vala"
	last = TRUE;
#line 121 "src/search.vala"
	_tmp6_ = g_strdup ("");
#line 121 "src/search.vala"
	pattern = _tmp6_;
#line 122 "src/search.vala"
	_tmp7_ = cur_bp;
#line 122 "src/search.vala"
	_tmp8_ = buffer_get_pt (_tmp7_);
#line 122 "src/search.vala"
	_tmp9_ = _tmp8_;
#line 122 "src/search.vala"
	start = _tmp9_;
#line 122 "src/search.vala"
	cur = start;
#line 1170 "search.c"
	{
		gboolean _tmp10_ = FALSE;
#line 123 "src/search.vala"
		_tmp10_ = TRUE;
#line 123 "src/search.vala"
		while (TRUE) {
#line 1177 "search.c"
			const gchar* _tmp11_ = NULL;
			const gchar* _tmp14_ = NULL;
			gchar* msg = NULL;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp29_;
			Keystroke c = 0U;
			const gchar* _tmp80_;
			gint _tmp81_;
			gint _tmp82_;
#line 123 "src/search.vala"
			if (!_tmp10_) {
#line 1191 "search.c"
			}
#line 123 "src/search.vala"
			_tmp10_ = FALSE;
#line 126 "src/search.vala"
			if (last) {
#line 1197 "search.c"
				const gchar* _tmp12_ = NULL;
#line 127 "src/search.vala"
				if (regexp) {
#line 127 "src/search.vala"
					_tmp12_ = "Regexp ";
#line 1203 "search.c"
				} else {
#line 127 "src/search.vala"
					_tmp12_ = "";
#line 1207 "search.c"
				}
#line 127 "src/search.vala"
				_tmp11_ = _tmp12_;
#line 1211 "search.c"
			} else {
				const gchar* _tmp13_ = NULL;
#line 128 "src/search.vala"
				if (regexp) {
#line 128 "src/search.vala"
					_tmp13_ = "Failing regexp ";
#line 1218 "search.c"
				} else {
#line 128 "src/search.vala"
					_tmp13_ = "Failing ";
#line 1222 "search.c"
				}
#line 128 "src/search.vala"
				_tmp11_ = _tmp13_;
#line 1226 "search.c"
			}
#line 129 "src/search.vala"
			if (forward) {
#line 129 "src/search.vala"
				_tmp14_ = "";
#line 1232 "search.c"
			} else {
#line 129 "src/search.vala"
				_tmp14_ = " backward";
#line 1236 "search.c"
			}
#line 125 "src/search.vala"
			_tmp15_ = pattern;
#line 125 "src/search.vala"
			_tmp16_ = g_strdup_printf ("%sI-search%s: %s", _tmp11_, _tmp14_, _tmp15_);
#line 125 "src/search.vala"
			msg = _tmp16_;
#line 133 "src/search.vala"
			_tmp17_ = re_find_err;
#line 133 "src/search.vala"
			if (_tmp17_ != NULL) {
#line 1248 "search.c"
				gboolean _tmp18_ = FALSE;
				gboolean _tmp19_ = FALSE;
				const gchar* _tmp20_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
#line 134 "src/search.vala"
				_tmp20_ = re_find_err;
#line 134 "src/search.vala"
				if (g_str_has_prefix (_tmp20_, "Premature ")) {
#line 134 "src/search.vala"
					_tmp19_ = TRUE;
#line 1264 "search.c"
				} else {
					const gchar* _tmp21_;
#line 135 "src/search.vala"
					_tmp21_ = re_find_err;
#line 135 "src/search.vala"
					_tmp19_ = g_str_has_prefix (_tmp21_, "Unmatched ");
#line 1271 "search.c"
				}
#line 134 "src/search.vala"
				if (_tmp19_) {
#line 134 "src/search.vala"
					_tmp18_ = TRUE;
#line 1277 "search.c"
				} else {
					const gchar* _tmp22_;
#line 136 "src/search.vala"
					_tmp22_ = re_find_err;
#line 136 "src/search.vala"
					_tmp18_ = g_str_has_prefix (_tmp22_, "Invalid ");
#line 1284 "search.c"
				}
#line 134 "src/search.vala"
				if (_tmp18_) {
#line 137 "src/search.vala"
					re_find_err = "incomplete input";
#line 1290 "search.c"
				}
#line 139 "src/search.vala"
				_tmp23_ = msg;
#line 139 "src/search.vala"
				_tmp24_ = re_find_err;
#line 139 "src/search.vala"
				_tmp25_ = string_to_string (_tmp24_);
#line 139 "src/search.vala"
				_tmp26_ = g_strconcat (" [", _tmp25_, "]", NULL);
#line 139 "src/search.vala"
				_tmp27_ = _tmp26_;
#line 139 "src/search.vala"
				_tmp28_ = g_strconcat (_tmp23_, _tmp27_, NULL);
#line 139 "src/search.vala"
				_g_free0 (msg);
#line 139 "src/search.vala"
				msg = _tmp28_;
#line 139 "src/search.vala"
				_g_free0 (_tmp27_);
#line 140 "src/search.vala"
				re_find_err = NULL;
#line 1312 "search.c"
			}
#line 143 "src/search.vala"
			_tmp29_ = msg;
#line 143 "src/search.vala"
			minibuf_write ("%s", _tmp29_, NULL);
#line 145 "src/search.vala"
			c = getkey (GETKEY_DEFAULT);
#line 147 "src/search.vala"
			if (c == KBD_CANCEL) {
#line 1322 "search.c"
				Buffer* _tmp30_;
				Buffer* _tmp31_;
				Marker* _tmp32_;
				Buffer* _tmp35_;
				Marker* _tmp36_;
				Marker* _tmp37_;
#line 148 "src/search.vala"
				_tmp30_ = cur_bp;
#line 148 "src/search.vala"
				buffer_goto_offset (_tmp30_, start);
#line 149 "src/search.vala"
				thisflag = thisflag | FLAGS_NEED_RESYNC;
#line 152 "src/search.vala"
				funcall ("keyboard-quit", NULL, NULL);
#line 155 "src/search.vala"
				_tmp31_ = cur_bp;
#line 155 "src/search.vala"
				_tmp32_ = _tmp31_->mark;
#line 155 "src/search.vala"
				if (_tmp32_ != NULL) {
#line 1343 "search.c"
					Buffer* _tmp33_;
					Marker* _tmp34_;
#line 156 "src/search.vala"
					_tmp33_ = cur_bp;
#line 156 "src/search.vala"
					_tmp34_ = _tmp33_->mark;
#line 156 "src/search.vala"
					marker_unchain (_tmp34_);
#line 1352 "search.c"
				}
#line 158 "src/search.vala"
				_tmp35_ = cur_bp;
#line 158 "src/search.vala"
				_tmp36_ = old_mark;
#line 158 "src/search.vala"
				_tmp37_ = marker_copy (_tmp36_);
#line 158 "src/search.vala"
				_marker_unref0 (_tmp35_->mark);
#line 158 "src/search.vala"
				_tmp35_->mark = _tmp37_;
#line 159 "src/search.vala"
				_g_free0 (msg);
#line 159 "src/search.vala"
				break;
#line 1368 "search.c"
			} else {
#line 160 "src/search.vala"
				if (c == KBD_BS) {
#line 1372 "search.c"
					const gchar* _tmp38_;
					gint _tmp39_;
					gint _tmp40_;
#line 161 "src/search.vala"
					_tmp38_ = pattern;
#line 161 "src/search.vala"
					_tmp39_ = strlen (_tmp38_);
#line 161 "src/search.vala"
					_tmp40_ = _tmp39_;
#line 161 "src/search.vala"
					if (_tmp40_ > 0) {
#line 1384 "search.c"
						const gchar* _tmp41_;
						gchar* _tmp42_;
						Buffer* _tmp43_;
#line 162 "src/search.vala"
						_tmp41_ = pattern;
#line 162 "src/search.vala"
						_tmp42_ = string_slice (_tmp41_, (glong) 0, (glong) -1);
#line 162 "src/search.vala"
						_g_free0 (pattern);
#line 162 "src/search.vala"
						pattern = _tmp42_;
#line 163 "src/search.vala"
						cur = start;
#line 164 "src/search.vala"
						_tmp43_ = cur_bp;
#line 164 "src/search.vala"
						buffer_goto_offset (_tmp43_, start);
#line 165 "src/search.vala"
						thisflag = thisflag | FLAGS_NEED_RESYNC;
#line 1404 "search.c"
					} else {
#line 167 "src/search.vala"
						ding ();
#line 1408 "search.c"
					}
				} else {
					gboolean _tmp44_ = FALSE;
#line 168 "src/search.vala"
					if ((c & KBD_CTRL) != ((Keystroke) 0)) {
#line 168 "src/search.vala"
						_tmp44_ = (c & 0xff) == ((Keystroke) 'q');
#line 1416 "search.c"
					} else {
#line 168 "src/search.vala"
						_tmp44_ = FALSE;
#line 1420 "search.c"
					}
#line 168 "src/search.vala"
					if (_tmp44_) {
#line 1424 "search.c"
						const gchar* _tmp45_;
						const gchar* _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
						gchar* _tmp49_;
#line 169 "src/search.vala"
						_tmp45_ = msg;
#line 169 "src/search.vala"
						minibuf_write ("%s^Q-", _tmp45_, NULL);
#line 170 "src/search.vala"
						_tmp46_ = pattern;
#line 170 "src/search.vala"
						_tmp47_ = g_strdup_printf ("%c", (gchar) getkey_unfiltered (GETKEY_DEFAULT));
#line 170 "src/search.vala"
						_tmp48_ = _tmp47_;
#line 170 "src/search.vala"
						_tmp49_ = g_strconcat (_tmp46_, _tmp48_, NULL);
#line 170 "src/search.vala"
						_g_free0 (pattern);
#line 170 "src/search.vala"
						pattern = _tmp49_;
#line 170 "src/search.vala"
						_g_free0 (_tmp48_);
#line 1448 "search.c"
					} else {
						gboolean _tmp50_ = FALSE;
#line 171 "src/search.vala"
						if ((c & KBD_CTRL) != ((Keystroke) 0)) {
#line 1453 "search.c"
							gboolean _tmp51_ = FALSE;
#line 171 "src/search.vala"
							if (((gchar) (c & 0xff)) == 'r') {
#line 171 "src/search.vala"
								_tmp51_ = TRUE;
#line 1459 "search.c"
							} else {
#line 171 "src/search.vala"
								_tmp51_ = ((gchar) (c & 0xff)) == 's';
#line 1463 "search.c"
							}
#line 171 "src/search.vala"
							_tmp50_ = _tmp51_;
#line 1467 "search.c"
						} else {
#line 171 "src/search.vala"
							_tmp50_ = FALSE;
#line 1471 "search.c"
						}
#line 171 "src/search.vala"
						if (_tmp50_) {
#line 1475 "search.c"
							const gchar* _tmp52_;
							gint _tmp53_;
							gint _tmp54_;
#line 173 "src/search.vala"
							if (((gchar) (c & 0xff)) == 'r') {
#line 174 "src/search.vala"
								forward = FALSE;
#line 1483 "search.c"
							} else {
#line 175 "src/search.vala"
								if (((gchar) (c & 0xff)) == 's') {
#line 176 "src/search.vala"
									forward = TRUE;
#line 1489 "search.c"
								}
							}
#line 177 "src/search.vala"
							_tmp52_ = pattern;
#line 177 "src/search.vala"
							_tmp53_ = strlen (_tmp52_);
#line 177 "src/search.vala"
							_tmp54_ = _tmp53_;
#line 177 "src/search.vala"
							if (_tmp54_ > 0) {
#line 1500 "search.c"
								Buffer* _tmp55_;
								gsize _tmp56_;
								gsize _tmp57_;
								const gchar* _tmp58_;
								gchar* _tmp59_;
#line 179 "src/search.vala"
								_tmp55_ = cur_bp;
#line 179 "src/search.vala"
								_tmp56_ = buffer_get_pt (_tmp55_);
#line 179 "src/search.vala"
								_tmp57_ = _tmp56_;
#line 179 "src/search.vala"
								cur = _tmp57_;
#line 181 "src/search.vala"
								_tmp58_ = pattern;
#line 181 "src/search.vala"
								_tmp59_ = g_strdup (_tmp58_);
#line 181 "src/search.vala"
								_g_free0 (last_search);
#line 181 "src/search.vala"
								last_search = _tmp59_;
#line 1522 "search.c"
							} else {
								const gchar* _tmp60_;
#line 182 "src/search.vala"
								_tmp60_ = last_search;
#line 182 "src/search.vala"
								if (_tmp60_ != NULL) {
#line 1529 "search.c"
									const gchar* _tmp61_;
									gchar* _tmp62_;
#line 183 "src/search.vala"
									_tmp61_ = last_search;
#line 183 "src/search.vala"
									_tmp62_ = g_strdup (_tmp61_);
#line 183 "src/search.vala"
									_g_free0 (pattern);
#line 183 "src/search.vala"
									pattern = _tmp62_;
#line 1540 "search.c"
								}
							}
						} else {
							gboolean _tmp63_ = FALSE;
							gboolean _tmp64_ = FALSE;
#line 184 "src/search.vala"
							if ((c & KBD_META) != ((Keystroke) 0)) {
#line 184 "src/search.vala"
								_tmp64_ = TRUE;
#line 1550 "search.c"
							} else {
#line 184 "src/search.vala"
								_tmp64_ = (c & KBD_CTRL) != ((Keystroke) 0);
#line 1554 "search.c"
							}
#line 184 "src/search.vala"
							if (_tmp64_) {
#line 184 "src/search.vala"
								_tmp63_ = TRUE;
#line 1560 "search.c"
							} else {
#line 184 "src/search.vala"
								_tmp63_ = c > KBD_TAB;
#line 1564 "search.c"
							}
#line 184 "src/search.vala"
							if (_tmp63_) {
#line 1568 "search.c"
								gboolean _tmp65_ = FALSE;
#line 185 "src/search.vala"
								if (c == KBD_RET) {
#line 1572 "search.c"
									const gchar* _tmp66_;
									gint _tmp67_;
									gint _tmp68_;
#line 185 "src/search.vala"
									_tmp66_ = pattern;
#line 185 "src/search.vala"
									_tmp67_ = strlen (_tmp66_);
#line 185 "src/search.vala"
									_tmp68_ = _tmp67_;
#line 185 "src/search.vala"
									_tmp65_ = _tmp68_ == 0;
#line 1584 "search.c"
								} else {
#line 185 "src/search.vala"
									_tmp65_ = FALSE;
#line 1588 "search.c"
								}
#line 185 "src/search.vala"
								if (_tmp65_) {
#line 186 "src/search.vala"
									do_search (forward, regexp, NULL);
#line 1594 "search.c"
								} else {
									const gchar* _tmp69_;
									gint _tmp70_;
									gint _tmp71_;
#line 188 "src/search.vala"
									_tmp69_ = pattern;
#line 188 "src/search.vala"
									_tmp70_ = strlen (_tmp69_);
#line 188 "src/search.vala"
									_tmp71_ = _tmp70_;
#line 188 "src/search.vala"
									if (_tmp71_ > 0) {
#line 1607 "search.c"
										Buffer* _tmp72_;
										Marker* _tmp73_;
										const gchar* _tmp74_;
										gchar* _tmp75_;
#line 190 "src/search.vala"
										set_mark ();
#line 191 "src/search.vala"
										_tmp72_ = cur_bp;
#line 191 "src/search.vala"
										_tmp73_ = _tmp72_->mark;
#line 191 "src/search.vala"
										marker_set_o (_tmp73_, start);
#line 194 "src/search.vala"
										_tmp74_ = pattern;
#line 194 "src/search.vala"
										_tmp75_ = g_strdup (_tmp74_);
#line 194 "src/search.vala"
										_g_free0 (last_search);
#line 194 "src/search.vala"
										last_search = _tmp75_;
#line 196 "src/search.vala"
										minibuf_write ("Mark saved when search started", NULL);
#line 1630 "search.c"
									} else {
#line 198 "src/search.vala"
										minibuf_clear ();
#line 1634 "search.c"
									}
#line 199 "src/search.vala"
									if (c != KBD_RET) {
#line 200 "src/search.vala"
										ungetkey (c);
#line 1640 "search.c"
									}
								}
#line 202 "src/search.vala"
								_g_free0 (msg);
#line 202 "src/search.vala"
								break;
#line 1647 "search.c"
							} else {
								const gchar* _tmp76_;
								gchar* _tmp77_;
								gchar* _tmp78_;
								gchar* _tmp79_;
#line 204 "src/search.vala"
								_tmp76_ = pattern;
#line 204 "src/search.vala"
								_tmp77_ = g_strdup_printf ("%c", (gchar) c);
#line 204 "src/search.vala"
								_tmp78_ = _tmp77_;
#line 204 "src/search.vala"
								_tmp79_ = g_strconcat (_tmp76_, _tmp78_, NULL);
#line 204 "src/search.vala"
								_g_free0 (pattern);
#line 204 "src/search.vala"
								pattern = _tmp79_;
#line 204 "src/search.vala"
								_g_free0 (_tmp78_);
#line 1667 "search.c"
							}
						}
					}
				}
			}
#line 206 "src/search.vala"
			_tmp80_ = pattern;
#line 206 "src/search.vala"
			_tmp81_ = strlen (_tmp80_);
#line 206 "src/search.vala"
			_tmp82_ = _tmp81_;
#line 206 "src/search.vala"
			if (_tmp82_ > 0) {
#line 1681 "search.c"
				Buffer* _tmp83_;
				const gchar* _tmp84_;
#line 207 "src/search.vala"
				_tmp83_ = cur_bp;
#line 207 "src/search.vala"
				buffer_goto_offset (_tmp83_, cur);
#line 208 "src/search.vala"
				_tmp84_ = pattern;
#line 208 "src/search.vala"
				last = search (_tmp84_, forward, regexp);
#line 1692 "search.c"
			} else {
#line 210 "src/search.vala"
				last = TRUE;
#line 1696 "search.c"
			}
#line 212 "src/search.vala"
			if ((thisflag & FLAGS_NEED_RESYNC) == FLAGS_NEED_RESYNC) {
#line 1700 "search.c"
				Window* _tmp85_;
#line 213 "src/search.vala"
				_tmp85_ = cur_wp;
#line 213 "src/search.vala"
				window_resync (_tmp85_);
#line 214 "src/search.vala"
				term_redisplay ();
#line 1708 "search.c"
			}
#line 123 "src/search.vala"
			_g_free0 (msg);
#line 1712 "search.c"
		}
	}
#line 219 "src/search.vala"
	_tmp86_ = cur_wp;
#line 219 "src/search.vala"
	_tmp87_ = _tmp86_->bp;
#line 219 "src/search.vala"
	_tmp87_->isearch = FALSE;
#line 221 "src/search.vala"
	_tmp88_ = old_mark;
#line 221 "src/search.vala"
	if (_tmp88_ != NULL) {
#line 1725 "search.c"
		Marker* _tmp89_;
#line 222 "src/search.vala"
		_tmp89_ = old_mark;
#line 222 "src/search.vala"
		marker_unchain (_tmp89_);
#line 1731 "search.c"
	}
#line 224 "src/search.vala"
	result = TRUE;
#line 224 "src/search.vala"
	_g_free0 (pattern);
#line 224 "src/search.vala"
	_marker_unref0 (old_mark);
#line 224 "src/search.vala"
	return result;
#line 1741 "search.c"
}

Case
check_case (ImmutableEstr* a)
{
	guint i = 0U;
	gsize _tmp8_;
	gsize _tmp9_;
	Case _tmp18_ = 0;
	gsize _tmp19_;
	gsize _tmp20_;
	Case result;
#line 230 "src/search.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 1756 "search.c"
	{
		gboolean _tmp0_ = FALSE;
#line 232 "src/search.vala"
		i = (guint) 0;
#line 232 "src/search.vala"
		_tmp0_ = TRUE;
#line 232 "src/search.vala"
		while (TRUE) {
#line 1765 "search.c"
			gboolean _tmp2_ = FALSE;
			gsize _tmp3_;
			gsize _tmp4_;
#line 232 "src/search.vala"
			if (!_tmp0_) {
#line 1771 "search.c"
				guint _tmp1_;
#line 232 "src/search.vala"
				_tmp1_ = i;
#line 232 "src/search.vala"
				i = _tmp1_ + 1;
#line 1777 "search.c"
			}
#line 232 "src/search.vala"
			_tmp0_ = FALSE;
#line 232 "src/search.vala"
			_tmp3_ = immutable_estr_get_length (a);
#line 232 "src/search.vala"
			_tmp4_ = _tmp3_;
#line 232 "src/search.vala"
			if (((gsize) i) < _tmp4_) {
#line 1787 "search.c"
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar _tmp7_;
#line 232 "src/search.vala"
				_tmp5_ = immutable_estr_get_text (a);
#line 232 "src/search.vala"
				_tmp6_ = _tmp5_;
#line 232 "src/search.vala"
				_tmp7_ = _tmp6_[i];
#line 232 "src/search.vala"
				_tmp2_ = g_ascii_isupper (_tmp7_);
#line 1799 "search.c"
			} else {
#line 232 "src/search.vala"
				_tmp2_ = FALSE;
#line 1803 "search.c"
			}
#line 232 "src/search.vala"
			if (!_tmp2_) {
#line 232 "src/search.vala"
				break;
#line 1809 "search.c"
			}
		}
	}
#line 234 "src/search.vala"
	_tmp8_ = immutable_estr_get_length (a);
#line 234 "src/search.vala"
	_tmp9_ = _tmp8_;
#line 234 "src/search.vala"
	if (((gsize) i) == _tmp9_) {
#line 235 "src/search.vala"
		result = CASE_upper;
#line 235 "src/search.vala"
		return result;
#line 1823 "search.c"
	} else {
#line 236 "src/search.vala"
		if (i == ((guint) 1)) {
#line 1827 "search.c"
			{
				gboolean _tmp10_ = FALSE;
#line 237 "src/search.vala"
				_tmp10_ = TRUE;
#line 237 "src/search.vala"
				while (TRUE) {
#line 1834 "search.c"
					gboolean _tmp12_ = FALSE;
					gsize _tmp13_;
					gsize _tmp14_;
#line 237 "src/search.vala"
					if (!_tmp10_) {
#line 1840 "search.c"
						guint _tmp11_;
#line 237 "src/search.vala"
						_tmp11_ = i;
#line 237 "src/search.vala"
						i = _tmp11_ + 1;
#line 1846 "search.c"
					}
#line 237 "src/search.vala"
					_tmp10_ = FALSE;
#line 237 "src/search.vala"
					_tmp13_ = immutable_estr_get_length (a);
#line 237 "src/search.vala"
					_tmp14_ = _tmp13_;
#line 237 "src/search.vala"
					if (((gsize) i) < _tmp14_) {
#line 1856 "search.c"
						gchar* _tmp15_;
						gchar* _tmp16_;
						gchar _tmp17_;
#line 237 "src/search.vala"
						_tmp15_ = immutable_estr_get_text (a);
#line 237 "src/search.vala"
						_tmp16_ = _tmp15_;
#line 237 "src/search.vala"
						_tmp17_ = _tmp16_[i];
#line 237 "src/search.vala"
						_tmp12_ = !g_ascii_isupper (_tmp17_);
#line 1868 "search.c"
					} else {
#line 237 "src/search.vala"
						_tmp12_ = FALSE;
#line 1872 "search.c"
					}
#line 237 "src/search.vala"
					if (!_tmp12_) {
#line 237 "src/search.vala"
						break;
#line 1878 "search.c"
					}
				}
			}
		}
	}
#line 239 "src/search.vala"
	_tmp19_ = immutable_estr_get_length (a);
#line 239 "src/search.vala"
	_tmp20_ = _tmp19_;
#line 239 "src/search.vala"
	if (((gsize) i) == _tmp20_) {
#line 239 "src/search.vala"
		_tmp18_ = CASE_capitalized;
#line 1892 "search.c"
	} else {
#line 239 "src/search.vala"
		_tmp18_ = CASE_lower;
#line 1896 "search.c"
	}
#line 239 "src/search.vala"
	result = _tmp18_;
#line 239 "src/search.vala"
	return result;
#line 1902 "search.c"
}

static gboolean
__lambda123_ (glong uniarg,
              GeeQueue* args)
{
	gchar* pattern = NULL;
	gpointer _tmp0_;
	gboolean result;
#line 247 "src/search.vala"
	_tmp0_ = gee_queue_poll (args);
#line 247 "src/search.vala"
	pattern = (gchar*) _tmp0_;
#line 248 "src/search.vala"
	result = do_search (TRUE, FALSE, pattern);
#line 248 "src/search.vala"
	_g_free0 (pattern);
#line 248 "src/search.vala"
	return result;
#line 1922 "search.c"
}

static gboolean
___lambda123__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda123_ (uniarg, args);
#line 244 "src/search.vala"
	return result;
#line 1933 "search.c"
}

static gboolean
__lambda124_ (glong uniarg,
              GeeQueue* args)
{
	gchar* pattern = NULL;
	gpointer _tmp0_;
	gboolean result;
#line 257 "src/search.vala"
	_tmp0_ = gee_queue_poll (args);
#line 257 "src/search.vala"
	pattern = (gchar*) _tmp0_;
#line 258 "src/search.vala"
	result = do_search (FALSE, FALSE, pattern);
#line 258 "src/search.vala"
	_g_free0 (pattern);
#line 258 "src/search.vala"
	return result;
#line 1953 "search.c"
}

static gboolean
___lambda124__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda124_ (uniarg, args);
#line 254 "src/search.vala"
	return result;
#line 1964 "search.c"
}

static gboolean
__lambda125_ (glong uniarg,
              GeeQueue* args)
{
	gchar* pattern = NULL;
	gpointer _tmp0_;
	gboolean result;
#line 267 "src/search.vala"
	_tmp0_ = gee_queue_poll (args);
#line 267 "src/search.vala"
	pattern = (gchar*) _tmp0_;
#line 268 "src/search.vala"
	result = do_search (TRUE, TRUE, pattern);
#line 268 "src/search.vala"
	_g_free0 (pattern);
#line 268 "src/search.vala"
	return result;
#line 1984 "search.c"
}

static gboolean
___lambda125__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda125_ (uniarg, args);
#line 264 "src/search.vala"
	return result;
#line 1995 "search.c"
}

static gboolean
__lambda126_ (glong uniarg,
              GeeQueue* args)
{
	gchar* pattern = NULL;
	gpointer _tmp0_;
	gboolean result;
#line 277 "src/search.vala"
	_tmp0_ = gee_queue_poll (args);
#line 277 "src/search.vala"
	pattern = (gchar*) _tmp0_;
#line 278 "src/search.vala"
	result = do_search (FALSE, TRUE, pattern);
#line 278 "src/search.vala"
	_g_free0 (pattern);
#line 278 "src/search.vala"
	return result;
#line 2015 "search.c"
}

static gboolean
___lambda126__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda126_ (uniarg, args);
#line 274 "src/search.vala"
	return result;
#line 2026 "search.c"
}

static gboolean
__lambda127_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result;
#line 287 "src/search.vala"
	result = isearch (TRUE, (lastflag & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG);
#line 287 "src/search.vala"
	return result;
#line 2038 "search.c"
}

static gboolean
___lambda127__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda127_ (uniarg, args);
#line 284 "src/search.vala"
	return result;
#line 2049 "search.c"
}

static gboolean
__lambda128_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result;
#line 303 "src/search.vala"
	result = isearch (FALSE, (lastflag & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG);
#line 303 "src/search.vala"
	return result;
#line 2061 "search.c"
}

static gboolean
___lambda128__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda128_ (uniarg, args);
#line 300 "src/search.vala"
	return result;
#line 2072 "search.c"
}

static gboolean
__lambda129_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result;
#line 314 "src/search.vala"
	result = isearch (TRUE, !((lastflag & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG));
#line 314 "src/search.vala"
	return result;
#line 2084 "search.c"
}

static gboolean
___lambda129__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda129_ (uniarg, args);
#line 311 "src/search.vala"
	return result;
#line 2095 "search.c"
}

static gboolean
__lambda130_ (glong uniarg,
              GeeQueue* args)
{
	gboolean result;
#line 326 "src/search.vala"
	result = isearch (FALSE, !((lastflag & FLAGS_SET_UNIARG) == FLAGS_SET_UNIARG));
#line 326 "src/search.vala"
	return result;
#line 2107 "search.c"
}

static gboolean
___lambda130__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda130_ (uniarg, args);
#line 323 "src/search.vala"
	return result;
#line 2118 "search.c"
}

static gboolean
__lambda131_ (glong uniarg,
              GeeQueue* args)
{
	gboolean ok = FALSE;
	gchar* find = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean find_no_upper = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gchar* repl = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean noask = FALSE;
	gsize count = 0UL;
	gboolean result;
#line 338 "src/search.vala"
	ok = TRUE;
#line 339 "src/search.vala"
	_tmp0_ = minibuf_read ("Query replace string: ", "", NULL);
#line 339 "src/search.vala"
	find = _tmp0_;
#line 340 "src/search.vala"
	_tmp1_ = find;
#line 340 "src/search.vala"
	if (_tmp1_ == NULL) {
#line 341 "src/search.vala"
		result = funcall ("keyboard-quit", NULL, NULL);
#line 341 "src/search.vala"
		_g_free0 (find);
#line 341 "src/search.vala"
		return result;
#line 2160 "search.c"
	}
#line 342 "src/search.vala"
	_tmp2_ = find;
#line 342 "src/search.vala"
	_tmp3_ = strlen (_tmp2_);
#line 342 "src/search.vala"
	_tmp4_ = _tmp3_;
#line 342 "src/search.vala"
	if (_tmp4_ == 0) {
#line 343 "src/search.vala"
		result = FALSE;
#line 343 "src/search.vala"
		_g_free0 (find);
#line 343 "src/search.vala"
		return result;
#line 2176 "search.c"
	}
#line 344 "src/search.vala"
	_tmp5_ = find;
#line 344 "src/search.vala"
	_tmp6_ = find;
#line 344 "src/search.vala"
	_tmp7_ = strlen (_tmp6_);
#line 344 "src/search.vala"
	_tmp8_ = _tmp7_;
#line 344 "src/search.vala"
	find_no_upper = no_upper (_tmp5_, (guint) _tmp8_, FALSE);
#line 346 "src/search.vala"
	_tmp9_ = find;
#line 346 "src/search.vala"
	_tmp10_ = minibuf_read ("Query replace `%s' with: ", "", _tmp9_, NULL);
#line 346 "src/search.vala"
	repl = _tmp10_;
#line 347 "src/search.vala"
	_tmp11_ = repl;
#line 347 "src/search.vala"
	if (_tmp11_ == NULL) {
#line 348 "src/search.vala"
		result = funcall ("keyboard-quit", NULL, NULL);
#line 348 "src/search.vala"
		_g_free0 (repl);
#line 348 "src/search.vala"
		_g_free0 (find);
#line 348 "src/search.vala"
		return result;
#line 2206 "search.c"
	}
#line 350 "src/search.vala"
	noask = FALSE;
#line 351 "src/search.vala"
	count = (gsize) 0;
#line 352 "src/search.vala"
	while (TRUE) {
#line 2214 "search.c"
		const gchar* _tmp12_;
		Keystroke c = 0U;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
#line 352 "src/search.vala"
		_tmp12_ = find;
#line 352 "src/search.vala"
		if (!search (_tmp12_, TRUE, FALSE)) {
#line 352 "src/search.vala"
			break;
#line 2228 "search.c"
		}
#line 353 "src/search.vala"
		c = (Keystroke) ' ';
#line 355 "src/search.vala"
		if (!noask) {
#line 2234 "search.c"
			const gchar* _tmp14_;
			const gchar* _tmp15_;
#line 356 "src/search.vala"
			if ((thisflag & FLAGS_NEED_RESYNC) == FLAGS_NEED_RESYNC) {
#line 2239 "search.c"
				Window* _tmp13_;
#line 357 "src/search.vala"
				_tmp13_ = cur_wp;
#line 357 "src/search.vala"
				window_resync (_tmp13_);
#line 2245 "search.c"
			}
#line 359 "src/search.vala"
			_tmp14_ = find;
#line 359 "src/search.vala"
			_tmp15_ = repl;
#line 359 "src/search.vala"
			minibuf_write ("Query replacing `%s' with `%s' (y, n, !, ., q)? ", _tmp14_, _tmp15_, NULL);
#line 360 "src/search.vala"
			c = getkey (GETKEY_DEFAULT);
#line 361 "src/search.vala"
			minibuf_clear ();
#line 363 "src/search.vala"
			if (c == ((Keystroke) 'q')) {
#line 364 "src/search.vala"
				break;
#line 2261 "search.c"
			} else {
#line 365 "src/search.vala"
				if (c == KBD_CANCEL) {
#line 366 "src/search.vala"
					ok = funcall ("keyboard-quit", NULL, NULL);
#line 367 "src/search.vala"
					break;
#line 2269 "search.c"
				} else {
#line 368 "src/search.vala"
					if (c == ((Keystroke) '!')) {
#line 369 "src/search.vala"
						noask = TRUE;
#line 2275 "search.c"
					}
				}
			}
		}
#line 372 "src/search.vala"
		if (c == KBD_RET) {
#line 372 "src/search.vala"
			_tmp20_ = TRUE;
#line 2284 "search.c"
		} else {
#line 372 "src/search.vala"
			_tmp20_ = c == ((Keystroke) ' ');
#line 2288 "search.c"
		}
#line 372 "src/search.vala"
		if (_tmp20_) {
#line 372 "src/search.vala"
			_tmp19_ = TRUE;
#line 2294 "search.c"
		} else {
#line 372 "src/search.vala"
			_tmp19_ = c == ((Keystroke) 'y');
#line 2298 "search.c"
		}
#line 372 "src/search.vala"
		if (_tmp19_) {
#line 372 "src/search.vala"
			_tmp18_ = TRUE;
#line 2304 "search.c"
		} else {
#line 372 "src/search.vala"
			_tmp18_ = c == ((Keystroke) 'Y');
#line 2308 "search.c"
		}
#line 372 "src/search.vala"
		if (_tmp18_) {
#line 372 "src/search.vala"
			_tmp17_ = TRUE;
#line 2314 "search.c"
		} else {
#line 372 "src/search.vala"
			_tmp17_ = c == ((Keystroke) '.');
#line 2318 "search.c"
		}
#line 372 "src/search.vala"
		if (_tmp17_) {
#line 372 "src/search.vala"
			_tmp16_ = TRUE;
#line 2324 "search.c"
		} else {
#line 372 "src/search.vala"
			_tmp16_ = c == ((Keystroke) '!');
#line 2328 "search.c"
		}
#line 372 "src/search.vala"
		if (_tmp16_) {
#line 2332 "search.c"
			gsize _tmp21_;
			gchar* case_repl = NULL;
			const gchar* _tmp22_;
			gchar* _tmp23_;
			Region* r = NULL;
			Buffer* _tmp24_;
			gsize _tmp25_;
			gsize _tmp26_;
			const gchar* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			Buffer* _tmp30_;
			gsize _tmp31_;
			gsize _tmp32_;
			Region* _tmp33_;
			gboolean _tmp34_ = FALSE;
			Marker* m = NULL;
			Marker* _tmp42_;
			Buffer* _tmp43_;
			Region* _tmp44_;
			gsize _tmp45_;
			gsize _tmp46_;
			Buffer* _tmp47_;
			const gchar* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			Buffer* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			ImmutableEstr* _tmp58_;
			ImmutableEstr* _tmp59_;
			Buffer* _tmp60_;
			Marker* _tmp61_;
			gsize _tmp62_;
			gsize _tmp63_;
			Marker* _tmp64_;
#line 373 "src/search.vala"
			count = count + 1;
#line 373 "src/search.vala"
			_tmp21_ = count;
#line 374 "src/search.vala"
			_tmp22_ = repl;
#line 374 "src/search.vala"
			_tmp23_ = g_strdup (_tmp22_);
#line 374 "src/search.vala"
			case_repl = _tmp23_;
#line 375 "src/search.vala"
			_tmp24_ = cur_bp;
#line 375 "src/search.vala"
			_tmp25_ = buffer_get_pt (_tmp24_);
#line 375 "src/search.vala"
			_tmp26_ = _tmp25_;
#line 375 "src/search.vala"
			_tmp27_ = find;
#line 375 "src/search.vala"
			_tmp28_ = strlen (_tmp27_);
#line 375 "src/search.vala"
			_tmp29_ = _tmp28_;
#line 375 "src/search.vala"
			_tmp30_ = cur_bp;
#line 375 "src/search.vala"
			_tmp31_ = buffer_get_pt (_tmp30_);
#line 375 "src/search.vala"
			_tmp32_ = _tmp31_;
#line 375 "src/search.vala"
			_tmp33_ = region_new (_tmp26_ - _tmp29_, _tmp32_);
#line 375 "src/search.vala"
			r = _tmp33_;
#line 376 "src/search.vala"
			if (find_no_upper) {
#line 376 "src/search.vala"
				_tmp34_ = get_variable_bool ("case-replace");
#line 2409 "search.c"
			} else {
#line 376 "src/search.vala"
				_tmp34_ = FALSE;
#line 2413 "search.c"
			}
#line 376 "src/search.vala"
			if (_tmp34_) {
#line 2417 "search.c"
				Case case_type = 0;
				Buffer* _tmp35_;
				Region* _tmp36_;
				ImmutableEstr* _tmp37_;
				ImmutableEstr* _tmp38_;
				Case _tmp39_;
#line 377 "src/search.vala"
				_tmp35_ = cur_bp;
#line 377 "src/search.vala"
				_tmp36_ = r;
#line 377 "src/search.vala"
				_tmp37_ = buffer_get_region (_tmp35_, _tmp36_);
#line 377 "src/search.vala"
				_tmp38_ = _tmp37_;
#line 377 "src/search.vala"
				_tmp39_ = check_case (_tmp38_);
#line 377 "src/search.vala"
				_immutable_estr_unref0 (_tmp38_);
#line 377 "src/search.vala"
				case_type = _tmp39_;
#line 378 "src/search.vala"
				if (case_type != CASE_lower) {
#line 2440 "search.c"
					const gchar* _tmp40_;
					gchar* _tmp41_;
#line 379 "src/search.vala"
					_tmp40_ = repl;
#line 379 "src/search.vala"
					_tmp41_ = recase (_tmp40_, case_type);
#line 379 "src/search.vala"
					_g_free0 (repl);
#line 379 "src/search.vala"
					repl = _tmp41_;
#line 2451 "search.c"
				}
			}
#line 382 "src/search.vala"
			_tmp42_ = marker_point ();
#line 382 "src/search.vala"
			m = _tmp42_;
#line 383 "src/search.vala"
			_tmp43_ = cur_bp;
#line 383 "src/search.vala"
			_tmp44_ = r;
#line 383 "src/search.vala"
			_tmp45_ = region_get_start (_tmp44_);
#line 383 "src/search.vala"
			_tmp46_ = _tmp45_;
#line 383 "src/search.vala"
			buffer_goto_offset (_tmp43_, _tmp46_);
#line 384 "src/search.vala"
			_tmp47_ = cur_bp;
#line 384 "src/search.vala"
			_tmp48_ = find;
#line 384 "src/search.vala"
			_tmp49_ = strlen (_tmp48_);
#line 384 "src/search.vala"
			_tmp50_ = _tmp49_;
#line 384 "src/search.vala"
			_tmp51_ = case_repl;
#line 384 "src/search.vala"
			_tmp52_ = case_repl;
#line 384 "src/search.vala"
			_tmp53_ = strlen (_tmp52_);
#line 384 "src/search.vala"
			_tmp54_ = _tmp53_;
#line 384 "src/search.vala"
			_tmp55_ = cur_bp;
#line 384 "src/search.vala"
			_tmp56_ = buffer_get_eol (_tmp55_);
#line 384 "src/search.vala"
			_tmp57_ = _tmp56_;
#line 384 "src/search.vala"
			_tmp58_ = immutable_estr_of (_tmp51_, (gsize) _tmp54_, _tmp57_);
#line 384 "src/search.vala"
			_tmp59_ = _tmp58_;
#line 384 "src/search.vala"
			buffer_replace_estr (_tmp47_, (gsize) _tmp50_, _tmp59_);
#line 384 "src/search.vala"
			_immutable_estr_unref0 (_tmp59_);
#line 385 "src/search.vala"
			_tmp60_ = cur_bp;
#line 385 "src/search.vala"
			_tmp61_ = m;
#line 385 "src/search.vala"
			_tmp62_ = marker_get_o (_tmp61_);
#line 385 "src/search.vala"
			_tmp63_ = _tmp62_;
#line 385 "src/search.vala"
			buffer_goto_offset (_tmp60_, _tmp63_);
#line 386 "src/search.vala"
			_tmp64_ = m;
#line 386 "src/search.vala"
			marker_unchain (_tmp64_);
#line 388 "src/search.vala"
			if (c == ((Keystroke) '.')) {
#line 389 "src/search.vala"
				_marker_unref0 (m);
#line 389 "src/search.vala"
				_region_unref0 (r);
#line 389 "src/search.vala"
				_g_free0 (case_repl);
#line 389 "src/search.vala"
				break;
#line 2522 "search.c"
			}
#line 372 "src/search.vala"
			_marker_unref0 (m);
#line 372 "src/search.vala"
			_region_unref0 (r);
#line 372 "src/search.vala"
			_g_free0 (case_repl);
#line 2530 "search.c"
		} else {
			gboolean _tmp65_ = FALSE;
			gboolean _tmp66_ = FALSE;
			gboolean _tmp67_ = FALSE;
#line 390 "src/search.vala"
			if (c == KBD_RET) {
#line 390 "src/search.vala"
				_tmp67_ = TRUE;
#line 2539 "search.c"
			} else {
#line 390 "src/search.vala"
				_tmp67_ = c == KBD_DEL;
#line 2543 "search.c"
			}
#line 390 "src/search.vala"
			if (_tmp67_) {
#line 390 "src/search.vala"
				_tmp66_ = TRUE;
#line 2549 "search.c"
			} else {
#line 390 "src/search.vala"
				_tmp66_ = c == ((Keystroke) 'n');
#line 2553 "search.c"
			}
#line 390 "src/search.vala"
			if (_tmp66_) {
#line 390 "src/search.vala"
				_tmp65_ = TRUE;
#line 2559 "search.c"
			} else {
#line 390 "src/search.vala"
				_tmp65_ = c == ((Keystroke) 'N');
#line 2563 "search.c"
			}
#line 390 "src/search.vala"
			if (!_tmp65_) {
#line 391 "src/search.vala"
				ungetkey (c);
#line 392 "src/search.vala"
				ok = FALSE;
#line 393 "src/search.vala"
				break;
#line 2573 "search.c"
			}
		}
	}
#line 397 "src/search.vala"
	if ((thisflag & FLAGS_NEED_RESYNC) == FLAGS_NEED_RESYNC) {
#line 2579 "search.c"
		Window* _tmp68_;
#line 398 "src/search.vala"
		_tmp68_ = cur_wp;
#line 398 "src/search.vala"
		window_resync (_tmp68_);
#line 2585 "search.c"
	}
#line 400 "src/search.vala"
	if (ok) {
#line 401 "src/search.vala"
		minibuf_write ("Replaced %zu occurrences", count, NULL);
#line 2591 "search.c"
	}
#line 403 "src/search.vala"
	result = ok;
#line 403 "src/search.vala"
	_g_free0 (repl);
#line 403 "src/search.vala"
	_g_free0 (find);
#line 403 "src/search.vala"
	return result;
#line 2601 "search.c"
}

static gboolean
___lambda131__function (glong uniarg,
                        GeeQueue* args)
{
	gboolean result;
	result = __lambda131_ (uniarg, args);
#line 335 "src/search.vala"
	return result;
#line 2612 "search.c"
}

void
search_init (void)
{
	LispFunc* _tmp0_;
	LispFunc* _tmp1_;
	LispFunc* _tmp2_;
	LispFunc* _tmp3_;
	LispFunc* _tmp4_;
	LispFunc* _tmp5_;
	LispFunc* _tmp6_;
	LispFunc* _tmp7_;
	LispFunc* _tmp8_;
	LispFunc* _tmp9_;
	LispFunc* _tmp10_;
	LispFunc* _tmp11_;
	LispFunc* _tmp12_;
	LispFunc* _tmp13_;
	LispFunc* _tmp14_;
	LispFunc* _tmp15_;
	LispFunc* _tmp16_;
	LispFunc* _tmp17_;
#line 244 "src/search.vala"
	_tmp0_ = lisp_func_new ("search-forward", ___lambda123__function, TRUE, "Search forward from point for the user specified text.");
#line 244 "src/search.vala"
	_tmp1_ = _tmp0_;
#line 244 "src/search.vala"
	_lisp_func_unref0 (_tmp1_);
#line 254 "src/search.vala"
	_tmp2_ = lisp_func_new ("search-backward", ___lambda124__function, TRUE, "Search backward from point for the user specified text.");
#line 254 "src/search.vala"
	_tmp3_ = _tmp2_;
#line 254 "src/search.vala"
	_lisp_func_unref0 (_tmp3_);
#line 264 "src/search.vala"
	_tmp4_ = lisp_func_new ("search-forward-regexp", ___lambda125__function, TRUE, "Search forward from point for regular expression REGEXP.");
#line 264 "src/search.vala"
	_tmp5_ = _tmp4_;
#line 264 "src/search.vala"
	_lisp_func_unref0 (_tmp5_);
#line 274 "src/search.vala"
	_tmp6_ = lisp_func_new ("search-backward-regexp", ___lambda126__function, TRUE, "Search backward from point for match for regular expression REGEXP.");
#line 274 "src/search.vala"
	_tmp7_ = _tmp6_;
#line 274 "src/search.vala"
	_lisp_func_unref0 (_tmp7_);
#line 284 "src/search.vala"
	_tmp8_ = lisp_func_new ("isearch-forward", ___lambda127__function, TRUE, "Do incremental search forward.\n" \
"With a prefix argument, do an incremental regular expression search in" \
"stead.\n" \
"\n" \
"As you type characters, they add to the search string and are found.\n" \
"\n" \
"Type \\\\[isearch-exit] to exit, leaving point at location found.\n" \
"Type \\\\[isearch-repeat-forward] to search again forward, \\\\[isearc" \
"h-repeat-backward] to search again backward.\n" \
"\\\\[isearch-abort] when search is successful aborts and moves point t" \
"o starting point.");
#line 284 "src/search.vala"
	_tmp9_ = _tmp8_;
#line 284 "src/search.vala"
	_lisp_func_unref0 (_tmp9_);
#line 300 "src/search.vala"
	_tmp10_ = lisp_func_new ("isearch-backward", ___lambda128__function, TRUE, "Do incremental search backward.\n" \
"With a prefix argument, do a regular expression search instead.\n" \
"See the command `isearch-forward' for more information.");
#line 300 "src/search.vala"
	_tmp11_ = _tmp10_;
#line 300 "src/search.vala"
	_lisp_func_unref0 (_tmp11_);
#line 311 "src/search.vala"
	_tmp12_ = lisp_func_new ("isearch-forward-regexp", ___lambda129__function, TRUE, "Do incremental search forward for regular expression.\n" \
"With a prefix argument, do a regular string search instead.\n" \
"Like ordinary incremental search except that your input is treated\n" \
"as a regexp.  See the command `isearch-forward' for more information.");
#line 311 "src/search.vala"
	_tmp13_ = _tmp12_;
#line 311 "src/search.vala"
	_lisp_func_unref0 (_tmp13_);
#line 323 "src/search.vala"
	_tmp14_ = lisp_func_new ("isearch-backward-regexp", ___lambda130__function, TRUE, "Do incremental search backward for regular expression.\n" \
"With a prefix argument, do a regular string search instead.\n" \
"Like ordinary incremental search except that your input is treated\n" \
"as a regexp.  See the command `isearch-forward-regexp` for more inform" \
"ation.");
#line 323 "src/search.vala"
	_tmp15_ = _tmp14_;
#line 323 "src/search.vala"
	_lisp_func_unref0 (_tmp15_);
#line 335 "src/search.vala"
	_tmp16_ = lisp_func_new ("query-replace", ___lambda131__function, TRUE, "Replace occurrences of a string with other text.\n" \
"As each match is found, the user must type a character saying\n" \
"what to do with it.");
#line 335 "src/search.vala"
	_tmp17_ = _tmp16_;
#line 335 "src/search.vala"
	_lisp_func_unref0 (_tmp17_);
#line 2690 "search.c"
}

