/*
 * Copyright (C) 2010 Free Software Foundation, Inc.
 *
 * This file is part of LIBTASN1.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "libtasn1.h"

int
main (int argc, char *argv[])
{
  asn1_retCode ec = 0;
  const char *errstr;

  do
    {
      errstr = asn1_strerror (ec);
      asn1_perror (ec);
#ifndef ASN1_DISABLE_DEPRECATED
      errstr = libtasn1_strerror (ec);
      libtasn1_perror (ec);
#endif
      ec++;
    }
  while (errstr);

  return 0;
}
