/*
 *  Copyright (c) 2011 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */


/*
 * This file contains the Q14 radix-8 tables used in ARM9e optimizations.
 *
 */

extern const int s_Q14S_8;
const int s_Q14S_8 = 1024;
extern const unsigned short t_Q14S_8[2032];
const unsigned short t_Q14S_8[2032] = {
  0x4000,0x0000 ,0x4000,0x0000 ,0x4000,0x0000 ,
  0x22a3,0x187e ,0x3249,0x0c7c ,0x11a8,0x238e ,
  0x0000,0x2d41 ,0x22a3,0x187e ,0xdd5d,0x3b21 ,
  0xdd5d,0x3b21 ,0x11a8,0x238e ,0xb4be,0x3ec5 ,
  0xc000,0x4000 ,0x0000,0x2d41 ,0xa57e,0x2d41 ,
  0xac61,0x3b21 ,0xee58,0x3537 ,0xb4be,0x0c7c ,
  0xa57e,0x2d41 ,0xdd5d,0x3b21 ,0xdd5d,0xe782 ,
  0xac61,0x187e ,0xcdb7,0x3ec5 ,0x11a8,0xcac9 ,
  0x4000,0x0000 ,0x4000,0x0000 ,0x4000,0x0000 ,
  0x396b,0x0646 ,0x3cc8,0x0324 ,0x35eb,0x0964 ,
  0x3249,0x0c7c ,0x396b,0x0646 ,0x2aaa,0x1294 ,
  0x2aaa,0x1294 ,0x35eb,0x0964 ,0x1e7e,0x1b5d ,
  0x22a3,0x187e ,0x3249,0x0c7c ,0x11a8,0x238e ,
  0x1a46,0x1e2b ,0x2e88,0x0f8d ,0x0471,0x2afb ,
  0x11a8,0x238e ,0x2aaa,0x1294 ,0xf721,0x3179 ,
  0x08df,0x289a ,0x26b3,0x1590 ,0xea02,0x36e5 ,
  0x0000,0x2d41 ,0x22a3,0x187e ,0xdd5d,0x3b21 ,
  0xf721,0x3179 ,0x1e7e,0x1b5d ,0xd178,0x3e15 ,
  0xee58,0x3537 ,0x1a46,0x1e2b ,0xc695,0x3fb1 ,
  0xe5ba,0x3871 ,0x15fe,0x20e7 ,0xbcf0,0x3fec ,
  0xdd5d,0x3b21 ,0x11a8,0x238e ,0xb4be,0x3ec5 ,
  0xd556,0x3d3f ,0x0d48,0x2620 ,0xae2e,0x3c42 ,
  0xcdb7,0x3ec5 ,0x08df,0x289a ,0xa963,0x3871 ,
  0xc695,0x3fb1 ,0x0471,0x2afb ,0xa678,0x3368 ,
  0xc000,0x4000 ,0x0000,0x2d41 ,0xa57e,0x2d41 ,
  0xba09,0x3fb1 ,0xfb8f,0x2f6c ,0xa678,0x2620 ,
  0xb4be,0x3ec5 ,0xf721,0x3179 ,0xa963,0x1e2b ,
  0xb02d,0x3d3f ,0xf2b8,0x3368 ,0xae2e,0x1590 ,
  0xac61,0x3b21 ,0xee58,0x3537 ,0xb4be,0x0c7c ,
  0xa963,0x3871 ,0xea02,0x36e5 ,0xbcf0,0x0324 ,
  0xa73b,0x3537 ,0xe5ba,0x3871 ,0xc695,0xf9ba ,
  0xa5ed,0x3179 ,0xe182,0x39db ,0xd178,0xf073 ,
  0xa57e,0x2d41 ,0xdd5d,0x3b21 ,0xdd5d,0xe782 ,
  0xa5ed,0x289a ,0xd94d,0x3c42 ,0xea02,0xdf19 ,
  0xa73b,0x238e ,0xd556,0x3d3f ,0xf721,0xd766 ,
  0xa963,0x1e2b ,0xd178,0x3e15 ,0x0471,0xd094 ,
  0xac61,0x187e ,0xcdb7,0x3ec5 ,0x11a8,0xcac9 ,
  0xb02d,0x1294 ,0xca15,0x3f4f ,0x1e7e,0xc625 ,
  0xb4be,0x0c7c ,0xc695,0x3fb1 ,0x2aaa,0xc2c1 ,
  0xba09,0x0646 ,0xc338,0x3fec ,0x35eb,0xc0b1 ,
  0x4000,0x0000 ,0x4000,0x0000 ,0x4000,0x0000 ,
  0x3e69,0x0192 ,0x3f36,0x00c9 ,0x3d9a,0x025b ,
  0x3cc8,0x0324 ,0x3e69,0x0192 ,0x3b1e,0x04b5 ,
  0x3b1e,0x04b5 ,0x3d9a,0x025b ,0x388e,0x070e ,
  0x396b,0x0646 ,0x3cc8,0x0324 ,0x35eb,0x0964 ,
  0x37af,0x07d6 ,0x3bf4,0x03ed ,0x3334,0x0bb7 ,
  0x35eb,0x0964 ,0x3b1e,0x04b5 ,0x306c,0x0e06 ,
  0x341e,0x0af1 ,0x3a46,0x057e ,0x2d93,0x1050 ,
  0x3249,0x0c7c ,0x396b,0x0646 ,0x2aaa,0x1294 ,
  0x306c,0x0e06 ,0x388e,0x070e ,0x27b3,0x14d2 ,
  0x2e88,0x0f8d ,0x37af,0x07d6 ,0x24ae,0x1709 ,
  0x2c9d,0x1112 ,0x36ce,0x089d ,0x219c,0x1937 ,
  0x2aaa,0x1294 ,0x35eb,0x0964 ,0x1e7e,0x1b5d ,
  0x28b2,0x1413 ,0x3505,0x0a2b ,0x1b56,0x1d79 ,
  0x26b3,0x1590 ,0x341e,0x0af1 ,0x1824,0x1f8c ,
  0x24ae,0x1709 ,0x3334,0x0bb7 ,0x14ea,0x2193 ,
  0x22a3,0x187e ,0x3249,0x0c7c ,0x11a8,0x238e ,
  0x2093,0x19ef ,0x315b,0x0d41 ,0x0e61,0x257e ,
  0x1e7e,0x1b5d ,0x306c,0x0e06 ,0x0b14,0x2760 ,
  0x1c64,0x1cc6 ,0x2f7b,0x0eca ,0x07c4,0x2935 ,
  0x1a46,0x1e2b ,0x2e88,0x0f8d ,0x0471,0x2afb ,
  0x1824,0x1f8c ,0x2d93,0x1050 ,0x011c,0x2cb2 ,
  0x15fe,0x20e7 ,0x2c9d,0x1112 ,0xfdc7,0x2e5a ,
  0x13d5,0x223d ,0x2ba4,0x11d3 ,0xfa73,0x2ff2 ,
  0x11a8,0x238e ,0x2aaa,0x1294 ,0xf721,0x3179 ,
  0x0f79,0x24da ,0x29af,0x1354 ,0xf3d2,0x32ef ,
  0x0d48,0x2620 ,0x28b2,0x1413 ,0xf087,0x3453 ,
  0x0b14,0x2760 ,0x27b3,0x14d2 ,0xed41,0x35a5 ,
  0x08df,0x289a ,0x26b3,0x1590 ,0xea02,0x36e5 ,
  0x06a9,0x29ce ,0x25b1,0x164c ,0xe6cb,0x3812 ,
  0x0471,0x2afb ,0x24ae,0x1709 ,0xe39c,0x392b ,
  0x0239,0x2c21 ,0x23a9,0x17c4 ,0xe077,0x3a30 ,
  0x0000,0x2d41 ,0x22a3,0x187e ,0xdd5d,0x3b21 ,
  0xfdc7,0x2e5a ,0x219c,0x1937 ,0xda4f,0x3bfd ,
  0xfb8f,0x2f6c ,0x2093,0x19ef ,0xd74e,0x3cc5 ,
  0xf957,0x3076 ,0x1f89,0x1aa7 ,0xd45c,0x3d78 ,
  0xf721,0x3179 ,0x1e7e,0x1b5d ,0xd178,0x3e15 ,
  0xf4ec,0x3274 ,0x1d72,0x1c12 ,0xcea5,0x3e9d ,
  0xf2b8,0x3368 ,0x1c64,0x1cc6 ,0xcbe2,0x3f0f ,
  0xf087,0x3453 ,0x1b56,0x1d79 ,0xc932,0x3f6b ,
  0xee58,0x3537 ,0x1a46,0x1e2b ,0xc695,0x3fb1 ,
  0xec2b,0x3612 ,0x1935,0x1edc ,0xc40c,0x3fe1 ,
  0xea02,0x36e5 ,0x1824,0x1f8c ,0xc197,0x3ffb ,
  0xe7dc,0x37b0 ,0x1711,0x203a ,0xbf38,0x3fff ,
  0xe5ba,0x3871 ,0x15fe,0x20e7 ,0xbcf0,0x3fec ,
  0xe39c,0x392b ,0x14ea,0x2193 ,0xbabf,0x3fc4 ,
  0xe182,0x39db ,0x13d5,0x223d ,0xb8a6,0x3f85 ,
  0xdf6d,0x3a82 ,0x12bf,0x22e7 ,0xb6a5,0x3f30 ,
  0xdd5d,0x3b21 ,0x11a8,0x238e ,0xb4be,0x3ec5 ,
  0xdb52,0x3bb6 ,0x1091,0x2435 ,0xb2f2,0x3e45 ,
  0xd94d,0x3c42 ,0x0f79,0x24da ,0xb140,0x3daf ,
  0xd74e,0x3cc5 ,0x0e61,0x257e ,0xafa9,0x3d03 ,
  0xd556,0x3d3f ,0x0d48,0x2620 ,0xae2e,0x3c42 ,
  0xd363,0x3daf ,0x0c2e,0x26c1 ,0xacd0,0x3b6d ,
  0xd178,0x3e15 ,0x0b14,0x2760 ,0xab8e,0x3a82 ,
  0xcf94,0x3e72 ,0x09fa,0x27fe ,0xaa6a,0x3984 ,
  0xcdb7,0x3ec5 ,0x08df,0x289a ,0xa963,0x3871 ,
  0xcbe2,0x3f0f ,0x07c4,0x2935 ,0xa87b,0x374b ,
  0xca15,0x3f4f ,0x06a9,0x29ce ,0xa7b1,0x3612 ,
  0xc851,0x3f85 ,0x058d,0x2a65 ,0xa705,0x34c6 ,
  0xc695,0x3fb1 ,0x0471,0x2afb ,0xa678,0x3368 ,
  0xc4e2,0x3fd4 ,0x0355,0x2b8f ,0xa60b,0x31f8 ,
  0xc338,0x3fec ,0x0239,0x2c21 ,0xa5bc,0x3076 ,
  0xc197,0x3ffb ,0x011c,0x2cb2 ,0xa58d,0x2ee4 ,
  0xc000,0x4000 ,0x0000,0x2d41 ,0xa57e,0x2d41 ,
  0xbe73,0x3ffb ,0xfee4,0x2dcf ,0xa58d,0x2b8f ,
  0xbcf0,0x3fec ,0xfdc7,0x2e5a ,0xa5bc,0x29ce ,
  0xbb77,0x3fd4 ,0xfcab,0x2ee4 ,0xa60b,0x27fe ,
  0xba09,0x3fb1 ,0xfb8f,0x2f6c ,0xa678,0x2620 ,
  0xb8a6,0x3f85 ,0xfa73,0x2ff2 ,0xa705,0x2435 ,
  0xb74d,0x3f4f ,0xf957,0x3076 ,0xa7b1,0x223d ,
  0xb600,0x3f0f ,0xf83c,0x30f9 ,0xa87b,0x203a ,
  0xb4be,0x3ec5 ,0xf721,0x3179 ,0xa963,0x1e2b ,
  0xb388,0x3e72 ,0xf606,0x31f8 ,0xaa6a,0x1c12 ,
  0xb25e,0x3e15 ,0xf4ec,0x3274 ,0xab8e,0x19ef ,
  0xb140,0x3daf ,0xf3d2,0x32ef ,0xacd0,0x17c4 ,
  0xb02d,0x3d3f ,0xf2b8,0x3368 ,0xae2e,0x1590 ,
  0xaf28,0x3cc5 ,0xf19f,0x33df ,0xafa9,0x1354 ,
  0xae2e,0x3c42 ,0xf087,0x3453 ,0xb140,0x1112 ,
  0xad41,0x3bb6 ,0xef6f,0x34c6 ,0xb2f2,0x0eca ,
  0xac61,0x3b21 ,0xee58,0x3537 ,0xb4be,0x0c7c ,
  0xab8e,0x3a82 ,0xed41,0x35a5 ,0xb6a5,0x0a2b ,
  0xaac8,0x39db ,0xec2b,0x3612 ,0xb8a6,0x07d6 ,
  0xaa0f,0x392b ,0xeb16,0x367d ,0xbabf,0x057e ,
  0xa963,0x3871 ,0xea02,0x36e5 ,0xbcf0,0x0324 ,
  0xa8c5,0x37b0 ,0xe8ef,0x374b ,0xbf38,0x00c9 ,
  0xa834,0x36e5 ,0xe7dc,0x37b0 ,0xc197,0xfe6e ,
  0xa7b1,0x3612 ,0xe6cb,0x3812 ,0xc40c,0xfc13 ,
  0xa73b,0x3537 ,0xe5ba,0x3871 ,0xc695,0xf9ba ,
  0xa6d3,0x3453 ,0xe4aa,0x38cf ,0xc932,0xf763 ,
  0xa678,0x3368 ,0xe39c,0x392b ,0xcbe2,0xf50f ,
  0xa62c,0x3274 ,0xe28e,0x3984 ,0xcea5,0xf2bf ,
  0xa5ed,0x3179 ,0xe182,0x39db ,0xd178,0xf073 ,
  0xa5bc,0x3076 ,0xe077,0x3a30 ,0xd45c,0xee2d ,
  0xa599,0x2f6c ,0xdf6d,0x3a82 ,0xd74e,0xebed ,
  0xa585,0x2e5a ,0xde64,0x3ad3 ,0xda4f,0xe9b4 ,
  0xa57e,0x2d41 ,0xdd5d,0x3b21 ,0xdd5d,0xe782 ,
  0xa585,0x2c21 ,0xdc57,0x3b6d ,0xe077,0xe559 ,
  0xa599,0x2afb ,0xdb52,0x3bb6 ,0xe39c,0xe33a ,
  0xa5bc,0x29ce ,0xda4f,0x3bfd ,0xe6cb,0xe124 ,
  0xa5ed,0x289a ,0xd94d,0x3c42 ,0xea02,0xdf19 ,
  0xa62c,0x2760 ,0xd84d,0x3c85 ,0xed41,0xdd19 ,
  0xa678,0x2620 ,0xd74e,0x3cc5 ,0xf087,0xdb26 ,
  0xa6d3,0x24da ,0xd651,0x3d03 ,0xf3d2,0xd93f ,
  0xa73b,0x238e ,0xd556,0x3d3f ,0xf721,0xd766 ,
  0xa7b1,0x223d ,0xd45c,0x3d78 ,0xfa73,0xd59b ,
  0xa834,0x20e7 ,0xd363,0x3daf ,0xfdc7,0xd3df ,
  0xa8c5,0x1f8c ,0xd26d,0x3de3 ,0x011c,0xd231 ,
  0xa963,0x1e2b ,0xd178,0x3e15 ,0x0471,0xd094 ,
  0xaa0f,0x1cc6 ,0xd085,0x3e45 ,0x07c4,0xcf07 ,
  0xaac8,0x1b5d ,0xcf94,0x3e72 ,0x0b14,0xcd8c ,
  0xab8e,0x19ef ,0xcea5,0x3e9d ,0x0e61,0xcc21 ,
  0xac61,0x187e ,0xcdb7,0x3ec5 ,0x11a8,0xcac9 ,
  0xad41,0x1709 ,0xcccc,0x3eeb ,0x14ea,0xc983 ,
  0xae2e,0x1590 ,0xcbe2,0x3f0f ,0x1824,0xc850 ,
  0xaf28,0x1413 ,0xcafb,0x3f30 ,0x1b56,0xc731 ,
  0xb02d,0x1294 ,0xca15,0x3f4f ,0x1e7e,0xc625 ,
  0xb140,0x1112 ,0xc932,0x3f6b ,0x219c,0xc52d ,
  0xb25e,0x0f8d ,0xc851,0x3f85 ,0x24ae,0xc44a ,
  0xb388,0x0e06 ,0xc772,0x3f9c ,0x27b3,0xc37b ,
  0xb4be,0x0c7c ,0xc695,0x3fb1 ,0x2aaa,0xc2c1 ,
  0xb600,0x0af1 ,0xc5ba,0x3fc4 ,0x2d93,0xc21d ,
  0xb74d,0x0964 ,0xc4e2,0x3fd4 ,0x306c,0xc18e ,
  0xb8a6,0x07d6 ,0xc40c,0x3fe1 ,0x3334,0xc115 ,
  0xba09,0x0646 ,0xc338,0x3fec ,0x35eb,0xc0b1 ,
  0xbb77,0x04b5 ,0xc266,0x3ff5 ,0x388e,0xc064 ,
  0xbcf0,0x0324 ,0xc197,0x3ffb ,0x3b1e,0xc02c ,
  0xbe73,0x0192 ,0xc0ca,0x3fff ,0x3d9a,0xc00b ,
  0x4000,0x0000 ,0x3f9b,0x0065 ,0x3f36,0x00c9 ,
  0x3ed0,0x012e ,0x3e69,0x0192 ,0x3e02,0x01f7 ,
  0x3d9a,0x025b ,0x3d31,0x02c0 ,0x3cc8,0x0324 ,
  0x3c5f,0x0388 ,0x3bf4,0x03ed ,0x3b8a,0x0451 ,
  0x3b1e,0x04b5 ,0x3ab2,0x051a ,0x3a46,0x057e ,
  0x39d9,0x05e2 ,0x396b,0x0646 ,0x38fd,0x06aa ,
  0x388e,0x070e ,0x381f,0x0772 ,0x37af,0x07d6 ,
  0x373f,0x0839 ,0x36ce,0x089d ,0x365d,0x0901 ,
  0x35eb,0x0964 ,0x3578,0x09c7 ,0x3505,0x0a2b ,
  0x3492,0x0a8e ,0x341e,0x0af1 ,0x33a9,0x0b54 ,
  0x3334,0x0bb7 ,0x32bf,0x0c1a ,0x3249,0x0c7c ,
  0x31d2,0x0cdf ,0x315b,0x0d41 ,0x30e4,0x0da4 ,
  0x306c,0x0e06 ,0x2ff4,0x0e68 ,0x2f7b,0x0eca ,
  0x2f02,0x0f2b ,0x2e88,0x0f8d ,0x2e0e,0x0fee ,
  0x2d93,0x1050 ,0x2d18,0x10b1 ,0x2c9d,0x1112 ,
  0x2c21,0x1173 ,0x2ba4,0x11d3 ,0x2b28,0x1234 ,
  0x2aaa,0x1294 ,0x2a2d,0x12f4 ,0x29af,0x1354 ,
  0x2931,0x13b4 ,0x28b2,0x1413 ,0x2833,0x1473 ,
  0x27b3,0x14d2 ,0x2733,0x1531 ,0x26b3,0x1590 ,
  0x2632,0x15ee ,0x25b1,0x164c ,0x252f,0x16ab ,
  0x24ae,0x1709 ,0x242b,0x1766 ,0x23a9,0x17c4 ,
  0x2326,0x1821 ,0x22a3,0x187e ,0x221f,0x18db ,
  0x219c,0x1937 ,0x2117,0x1993 ,0x2093,0x19ef ,
  0x200e,0x1a4b ,0x1f89,0x1aa7 ,0x1f04,0x1b02 ,
  0x1e7e,0x1b5d ,0x1df8,0x1bb8 ,0x1d72,0x1c12 ,
  0x1ceb,0x1c6c ,0x1c64,0x1cc6 ,0x1bdd,0x1d20 ,
  0x1b56,0x1d79 ,0x1ace,0x1dd3 ,0x1a46,0x1e2b ,
  0x19be,0x1e84 ,0x1935,0x1edc ,0x18ad,0x1f34 ,
  0x1824,0x1f8c ,0x179b,0x1fe3 ,0x1711,0x203a ,
  0x1688,0x2091 ,0x15fe,0x20e7 ,0x1574,0x213d ,
  0x14ea,0x2193 ,0x145f,0x21e8 ,0x13d5,0x223d ,
  0x134a,0x2292 ,0x12bf,0x22e7 ,0x1234,0x233b ,
  0x11a8,0x238e ,0x111d,0x23e2 ,0x1091,0x2435 ,
  0x1005,0x2488 ,0x0f79,0x24da ,0x0eed,0x252c ,
  0x0e61,0x257e ,0x0dd4,0x25cf ,0x0d48,0x2620 ,
  0x0cbb,0x2671 ,0x0c2e,0x26c1 ,0x0ba1,0x2711 ,
  0x0b14,0x2760 ,0x0a87,0x27af ,0x09fa,0x27fe ,
  0x096d,0x284c ,0x08df,0x289a ,0x0852,0x28e7 ,
  0x07c4,0x2935 ,0x0736,0x2981 ,0x06a9,0x29ce ,
  0x061b,0x2a1a ,0x058d,0x2a65 ,0x04ff,0x2ab0 ,
  0x0471,0x2afb ,0x03e3,0x2b45 ,0x0355,0x2b8f ,
  0x02c7,0x2bd8 ,0x0239,0x2c21 ,0x01aa,0x2c6a ,
  0x011c,0x2cb2 ,0x008e,0x2cfa ,0x0000,0x2d41 ,
  0xff72,0x2d88 ,0xfee4,0x2dcf ,0xfe56,0x2e15 ,
  0xfdc7,0x2e5a ,0xfd39,0x2e9f ,0xfcab,0x2ee4 ,
  0xfc1d,0x2f28 ,0xfb8f,0x2f6c ,0xfb01,0x2faf ,
  0xfa73,0x2ff2 ,0xf9e5,0x3034 ,0xf957,0x3076 ,
  0xf8ca,0x30b8 ,0xf83c,0x30f9 ,0xf7ae,0x3139 ,
  0xf721,0x3179 ,0xf693,0x31b9 ,0xf606,0x31f8 ,
  0xf579,0x3236 ,0xf4ec,0x3274 ,0xf45f,0x32b2 ,
  0xf3d2,0x32ef ,0xf345,0x332c ,0xf2b8,0x3368 ,
  0xf22c,0x33a3 ,0xf19f,0x33df ,0xf113,0x3419 ,
  0xf087,0x3453 ,0xeffb,0x348d ,0xef6f,0x34c6 ,
  0xeee3,0x34ff ,0xee58,0x3537 ,0xedcc,0x356e ,
  0xed41,0x35a5 ,0xecb6,0x35dc ,0xec2b,0x3612 ,
  0xeba1,0x3648 ,0xeb16,0x367d ,0xea8c,0x36b1 ,
  0xea02,0x36e5 ,0xe978,0x3718 ,0xe8ef,0x374b ,
  0xe865,0x377e ,0xe7dc,0x37b0 ,0xe753,0x37e1 ,
  0xe6cb,0x3812 ,0xe642,0x3842 ,0xe5ba,0x3871 ,
  0xe532,0x38a1 ,0xe4aa,0x38cf ,0xe423,0x38fd ,
  0xe39c,0x392b ,0xe315,0x3958 ,0xe28e,0x3984 ,
  0xe208,0x39b0 ,0xe182,0x39db ,0xe0fc,0x3a06 ,
  0xe077,0x3a30 ,0xdff2,0x3a59 ,0xdf6d,0x3a82 ,
  0xdee9,0x3aab ,0xde64,0x3ad3 ,0xdde1,0x3afa ,
  0xdd5d,0x3b21 ,0xdcda,0x3b47 ,0xdc57,0x3b6d ,
  0xdbd5,0x3b92 ,0xdb52,0x3bb6 ,0xdad1,0x3bda ,
  0xda4f,0x3bfd ,0xd9ce,0x3c20 ,0xd94d,0x3c42 ,
  0xd8cd,0x3c64 ,0xd84d,0x3c85 ,0xd7cd,0x3ca5 ,
  0xd74e,0x3cc5 ,0xd6cf,0x3ce4 ,0xd651,0x3d03 ,
  0xd5d3,0x3d21 ,0xd556,0x3d3f ,0xd4d8,0x3d5b ,
  0xd45c,0x3d78 ,0xd3df,0x3d93 ,0xd363,0x3daf ,
  0xd2e8,0x3dc9 ,0xd26d,0x3de3 ,0xd1f2,0x3dfc ,
  0xd178,0x3e15 ,0xd0fe,0x3e2d ,0xd085,0x3e45 ,
  0xd00c,0x3e5c ,0xcf94,0x3e72 ,0xcf1c,0x3e88 ,
  0xcea5,0x3e9d ,0xce2e,0x3eb1 ,0xcdb7,0x3ec5 ,
  0xcd41,0x3ed8 ,0xcccc,0x3eeb ,0xcc57,0x3efd ,
  0xcbe2,0x3f0f ,0xcb6e,0x3f20 ,0xcafb,0x3f30 ,
  0xca88,0x3f40 ,0xca15,0x3f4f ,0xc9a3,0x3f5d ,
  0xc932,0x3f6b ,0xc8c1,0x3f78 ,0xc851,0x3f85 ,
  0xc7e1,0x3f91 ,0xc772,0x3f9c ,0xc703,0x3fa7 ,
  0xc695,0x3fb1 ,0xc627,0x3fbb ,0xc5ba,0x3fc4 ,
  0xc54e,0x3fcc ,0xc4e2,0x3fd4 ,0xc476,0x3fdb ,
  0xc40c,0x3fe1 ,0xc3a1,0x3fe7 ,0xc338,0x3fec ,
  0xc2cf,0x3ff1 ,0xc266,0x3ff5 ,0xc1fe,0x3ff8 ,
  0xc197,0x3ffb ,0xc130,0x3ffd ,0xc0ca,0x3fff ,
  0xc065,0x4000 ,0xc000,0x4000 ,0xbf9c,0x4000 ,
  0xbf38,0x3fff ,0xbed5,0x3ffd ,0xbe73,0x3ffb ,
  0xbe11,0x3ff8 ,0xbdb0,0x3ff5 ,0xbd50,0x3ff1 ,
  0xbcf0,0x3fec ,0xbc91,0x3fe7 ,0xbc32,0x3fe1 ,
  0xbbd4,0x3fdb ,0xbb77,0x3fd4 ,0xbb1b,0x3fcc ,
  0xbabf,0x3fc4 ,0xba64,0x3fbb ,0xba09,0x3fb1 ,
  0xb9af,0x3fa7 ,0xb956,0x3f9c ,0xb8fd,0x3f91 ,
  0xb8a6,0x3f85 ,0xb84f,0x3f78 ,0xb7f8,0x3f6b ,
  0xb7a2,0x3f5d ,0xb74d,0x3f4f ,0xb6f9,0x3f40 ,
  0xb6a5,0x3f30 ,0xb652,0x3f20 ,0xb600,0x3f0f ,
  0xb5af,0x3efd ,0xb55e,0x3eeb ,0xb50e,0x3ed8 ,
  0xb4be,0x3ec5 ,0xb470,0x3eb1 ,0xb422,0x3e9d ,
  0xb3d5,0x3e88 ,0xb388,0x3e72 ,0xb33d,0x3e5c ,
  0xb2f2,0x3e45 ,0xb2a7,0x3e2d ,0xb25e,0x3e15 ,
  0xb215,0x3dfc ,0xb1cd,0x3de3 ,0xb186,0x3dc9 ,
  0xb140,0x3daf ,0xb0fa,0x3d93 ,0xb0b5,0x3d78 ,
  0xb071,0x3d5b ,0xb02d,0x3d3f ,0xafeb,0x3d21 ,
  0xafa9,0x3d03 ,0xaf68,0x3ce4 ,0xaf28,0x3cc5 ,
  0xaee8,0x3ca5 ,0xaea9,0x3c85 ,0xae6b,0x3c64 ,
  0xae2e,0x3c42 ,0xadf2,0x3c20 ,0xadb6,0x3bfd ,
  0xad7b,0x3bda ,0xad41,0x3bb6 ,0xad08,0x3b92 ,
  0xacd0,0x3b6d ,0xac98,0x3b47 ,0xac61,0x3b21 ,
  0xac2b,0x3afa ,0xabf6,0x3ad3 ,0xabc2,0x3aab ,
  0xab8e,0x3a82 ,0xab5b,0x3a59 ,0xab29,0x3a30 ,
  0xaaf8,0x3a06 ,0xaac8,0x39db ,0xaa98,0x39b0 ,
  0xaa6a,0x3984 ,0xaa3c,0x3958 ,0xaa0f,0x392b ,
  0xa9e3,0x38fd ,0xa9b7,0x38cf ,0xa98d,0x38a1 ,
  0xa963,0x3871 ,0xa93a,0x3842 ,0xa912,0x3812 ,
  0xa8eb,0x37e1 ,0xa8c5,0x37b0 ,0xa89f,0x377e ,
  0xa87b,0x374b ,0xa857,0x3718 ,0xa834,0x36e5 ,
  0xa812,0x36b1 ,0xa7f1,0x367d ,0xa7d0,0x3648 ,
  0xa7b1,0x3612 ,0xa792,0x35dc ,0xa774,0x35a5 ,
  0xa757,0x356e ,0xa73b,0x3537 ,0xa71f,0x34ff ,
  0xa705,0x34c6 ,0xa6eb,0x348d ,0xa6d3,0x3453 ,
  0xa6bb,0x3419 ,0xa6a4,0x33df ,0xa68e,0x33a3 ,
  0xa678,0x3368 ,0xa664,0x332c ,0xa650,0x32ef ,
  0xa63e,0x32b2 ,0xa62c,0x3274 ,0xa61b,0x3236 ,
  0xa60b,0x31f8 ,0xa5fb,0x31b9 ,0xa5ed,0x3179 ,
  0xa5e0,0x3139 ,0xa5d3,0x30f9 ,0xa5c7,0x30b8 ,
  0xa5bc,0x3076 ,0xa5b2,0x3034 ,0xa5a9,0x2ff2 ,
  0xa5a1,0x2faf ,0xa599,0x2f6c ,0xa593,0x2f28 ,
  0xa58d,0x2ee4 ,0xa588,0x2e9f ,0xa585,0x2e5a ,
  0xa581,0x2e15 ,0xa57f,0x2dcf ,0xa57e,0x2d88 ,
  0xa57e,0x2d41 ,0xa57e,0x2cfa ,0xa57f,0x2cb2 ,
  0xa581,0x2c6a ,0xa585,0x2c21 ,0xa588,0x2bd8 ,
  0xa58d,0x2b8f ,0xa593,0x2b45 ,0xa599,0x2afb ,
  0xa5a1,0x2ab0 ,0xa5a9,0x2a65 ,0xa5b2,0x2a1a ,
  0xa5bc,0x29ce ,0xa5c7,0x2981 ,0xa5d3,0x2935 ,
  0xa5e0,0x28e7 ,0xa5ed,0x289a ,0xa5fb,0x284c ,
  0xa60b,0x27fe ,0xa61b,0x27af ,0xa62c,0x2760 ,
  0xa63e,0x2711 ,0xa650,0x26c1 ,0xa664,0x2671 ,
  0xa678,0x2620 ,0xa68e,0x25cf ,0xa6a4,0x257e ,
  0xa6bb,0x252c ,0xa6d3,0x24da ,0xa6eb,0x2488 ,
  0xa705,0x2435 ,0xa71f,0x23e2 ,0xa73b,0x238e ,
  0xa757,0x233b ,0xa774,0x22e7 ,0xa792,0x2292 ,
  0xa7b1,0x223d ,0xa7d0,0x21e8 ,0xa7f1,0x2193 ,
  0xa812,0x213d ,0xa834,0x20e7 ,0xa857,0x2091 ,
  0xa87b,0x203a ,0xa89f,0x1fe3 ,0xa8c5,0x1f8c ,
  0xa8eb,0x1f34 ,0xa912,0x1edc ,0xa93a,0x1e84 ,
  0xa963,0x1e2b ,0xa98d,0x1dd3 ,0xa9b7,0x1d79 ,
  0xa9e3,0x1d20 ,0xaa0f,0x1cc6 ,0xaa3c,0x1c6c ,
  0xaa6a,0x1c12 ,0xaa98,0x1bb8 ,0xaac8,0x1b5d ,
  0xaaf8,0x1b02 ,0xab29,0x1aa7 ,0xab5b,0x1a4b ,
  0xab8e,0x19ef ,0xabc2,0x1993 ,0xabf6,0x1937 ,
  0xac2b,0x18db ,0xac61,0x187e ,0xac98,0x1821 ,
  0xacd0,0x17c4 ,0xad08,0x1766 ,0xad41,0x1709 ,
  0xad7b,0x16ab ,0xadb6,0x164c ,0xadf2,0x15ee ,
  0xae2e,0x1590 ,0xae6b,0x1531 ,0xaea9,0x14d2 ,
  0xaee8,0x1473 ,0xaf28,0x1413 ,0xaf68,0x13b4 ,
  0xafa9,0x1354 ,0xafeb,0x12f4 ,0xb02d,0x1294 ,
  0xb071,0x1234 ,0xb0b5,0x11d3 ,0xb0fa,0x1173 ,
  0xb140,0x1112 ,0xb186,0x10b1 ,0xb1cd,0x1050 ,
  0xb215,0x0fee ,0xb25e,0x0f8d ,0xb2a7,0x0f2b ,
  0xb2f2,0x0eca ,0xb33d,0x0e68 ,0xb388,0x0e06 ,
  0xb3d5,0x0da4 ,0xb422,0x0d41 ,0xb470,0x0cdf ,
  0xb4be,0x0c7c ,0xb50e,0x0c1a ,0xb55e,0x0bb7 ,
  0xb5af,0x0b54 ,0xb600,0x0af1 ,0xb652,0x0a8e ,
  0xb6a5,0x0a2b ,0xb6f9,0x09c7 ,0xb74d,0x0964 ,
  0xb7a2,0x0901 ,0xb7f8,0x089d ,0xb84f,0x0839 ,
  0xb8a6,0x07d6 ,0xb8fd,0x0772 ,0xb956,0x070e ,
  0xb9af,0x06aa ,0xba09,0x0646 ,0xba64,0x05e2 ,
  0xbabf,0x057e ,0xbb1b,0x051a ,0xbb77,0x04b5 ,
  0xbbd4,0x0451 ,0xbc32,0x03ed ,0xbc91,0x0388 ,
  0xbcf0,0x0324 ,0xbd50,0x02c0 ,0xbdb0,0x025b ,
  0xbe11,0x01f7 ,0xbe73,0x0192 ,0xbed5,0x012e ,
  0xbf38,0x00c9 ,0xbf9c,0x0065 };


extern const int s_Q14R_8;
const int s_Q14R_8 = 1024;
extern const unsigned short t_Q14R_8[2032];
const unsigned short t_Q14R_8[2032] = {
  0x4000,0x0000 ,0x4000,0x0000 ,0x4000,0x0000 ,
  0x3b21,0x187e ,0x3ec5,0x0c7c ,0x3537,0x238e ,
  0x2d41,0x2d41 ,0x3b21,0x187e ,0x187e,0x3b21 ,
  0x187e,0x3b21 ,0x3537,0x238e ,0xf384,0x3ec5 ,
  0x0000,0x4000 ,0x2d41,0x2d41 ,0xd2bf,0x2d41 ,
  0xe782,0x3b21 ,0x238e,0x3537 ,0xc13b,0x0c7c ,
  0xd2bf,0x2d41 ,0x187e,0x3b21 ,0xc4df,0xe782 ,
  0xc4df,0x187e ,0x0c7c,0x3ec5 ,0xdc72,0xcac9 ,
  0x4000,0x0000 ,0x4000,0x0000 ,0x4000,0x0000 ,
  0x3fb1,0x0646 ,0x3fec,0x0324 ,0x3f4f,0x0964 ,
  0x3ec5,0x0c7c ,0x3fb1,0x0646 ,0x3d3f,0x1294 ,
  0x3d3f,0x1294 ,0x3f4f,0x0964 ,0x39db,0x1b5d ,
  0x3b21,0x187e ,0x3ec5,0x0c7c ,0x3537,0x238e ,
  0x3871,0x1e2b ,0x3e15,0x0f8d ,0x2f6c,0x2afb ,
  0x3537,0x238e ,0x3d3f,0x1294 ,0x289a,0x3179 ,
  0x3179,0x289a ,0x3c42,0x1590 ,0x20e7,0x36e5 ,
  0x2d41,0x2d41 ,0x3b21,0x187e ,0x187e,0x3b21 ,
  0x289a,0x3179 ,0x39db,0x1b5d ,0x0f8d,0x3e15 ,
  0x238e,0x3537 ,0x3871,0x1e2b ,0x0646,0x3fb1 ,
  0x1e2b,0x3871 ,0x36e5,0x20e7 ,0xfcdc,0x3fec ,
  0x187e,0x3b21 ,0x3537,0x238e ,0xf384,0x3ec5 ,
  0x1294,0x3d3f ,0x3368,0x2620 ,0xea70,0x3c42 ,
  0x0c7c,0x3ec5 ,0x3179,0x289a ,0xe1d5,0x3871 ,
  0x0646,0x3fb1 ,0x2f6c,0x2afb ,0xd9e0,0x3368 ,
  0x0000,0x4000 ,0x2d41,0x2d41 ,0xd2bf,0x2d41 ,
  0xf9ba,0x3fb1 ,0x2afb,0x2f6c ,0xcc98,0x2620 ,
  0xf384,0x3ec5 ,0x289a,0x3179 ,0xc78f,0x1e2b ,
  0xed6c,0x3d3f ,0x2620,0x3368 ,0xc3be,0x1590 ,
  0xe782,0x3b21 ,0x238e,0x3537 ,0xc13b,0x0c7c ,
  0xe1d5,0x3871 ,0x20e7,0x36e5 ,0xc014,0x0324 ,
  0xdc72,0x3537 ,0x1e2b,0x3871 ,0xc04f,0xf9ba ,
  0xd766,0x3179 ,0x1b5d,0x39db ,0xc1eb,0xf073 ,
  0xd2bf,0x2d41 ,0x187e,0x3b21 ,0xc4df,0xe782 ,
  0xce87,0x289a ,0x1590,0x3c42 ,0xc91b,0xdf19 ,
  0xcac9,0x238e ,0x1294,0x3d3f ,0xce87,0xd766 ,
  0xc78f,0x1e2b ,0x0f8d,0x3e15 ,0xd505,0xd094 ,
  0xc4df,0x187e ,0x0c7c,0x3ec5 ,0xdc72,0xcac9 ,
  0xc2c1,0x1294 ,0x0964,0x3f4f ,0xe4a3,0xc625 ,
  0xc13b,0x0c7c ,0x0646,0x3fb1 ,0xed6c,0xc2c1 ,
  0xc04f,0x0646 ,0x0324,0x3fec ,0xf69c,0xc0b1 ,
  0x4000,0x0000 ,0x4000,0x0000 ,0x4000,0x0000 ,
  0x3ffb,0x0192 ,0x3fff,0x00c9 ,0x3ff5,0x025b ,
  0x3fec,0x0324 ,0x3ffb,0x0192 ,0x3fd4,0x04b5 ,
  0x3fd4,0x04b5 ,0x3ff5,0x025b ,0x3f9c,0x070e ,
  0x3fb1,0x0646 ,0x3fec,0x0324 ,0x3f4f,0x0964 ,
  0x3f85,0x07d6 ,0x3fe1,0x03ed ,0x3eeb,0x0bb7 ,
  0x3f4f,0x0964 ,0x3fd4,0x04b5 ,0x3e72,0x0e06 ,
  0x3f0f,0x0af1 ,0x3fc4,0x057e ,0x3de3,0x1050 ,
  0x3ec5,0x0c7c ,0x3fb1,0x0646 ,0x3d3f,0x1294 ,
  0x3e72,0x0e06 ,0x3f9c,0x070e ,0x3c85,0x14d2 ,
  0x3e15,0x0f8d ,0x3f85,0x07d6 ,0x3bb6,0x1709 ,
  0x3daf,0x1112 ,0x3f6b,0x089d ,0x3ad3,0x1937 ,
  0x3d3f,0x1294 ,0x3f4f,0x0964 ,0x39db,0x1b5d ,
  0x3cc5,0x1413 ,0x3f30,0x0a2b ,0x38cf,0x1d79 ,
  0x3c42,0x1590 ,0x3f0f,0x0af1 ,0x37b0,0x1f8c ,
  0x3bb6,0x1709 ,0x3eeb,0x0bb7 ,0x367d,0x2193 ,
  0x3b21,0x187e ,0x3ec5,0x0c7c ,0x3537,0x238e ,
  0x3a82,0x19ef ,0x3e9d,0x0d41 ,0x33df,0x257e ,
  0x39db,0x1b5d ,0x3e72,0x0e06 ,0x3274,0x2760 ,
  0x392b,0x1cc6 ,0x3e45,0x0eca ,0x30f9,0x2935 ,
  0x3871,0x1e2b ,0x3e15,0x0f8d ,0x2f6c,0x2afb ,
  0x37b0,0x1f8c ,0x3de3,0x1050 ,0x2dcf,0x2cb2 ,
  0x36e5,0x20e7 ,0x3daf,0x1112 ,0x2c21,0x2e5a ,
  0x3612,0x223d ,0x3d78,0x11d3 ,0x2a65,0x2ff2 ,
  0x3537,0x238e ,0x3d3f,0x1294 ,0x289a,0x3179 ,
  0x3453,0x24da ,0x3d03,0x1354 ,0x26c1,0x32ef ,
  0x3368,0x2620 ,0x3cc5,0x1413 ,0x24da,0x3453 ,
  0x3274,0x2760 ,0x3c85,0x14d2 ,0x22e7,0x35a5 ,
  0x3179,0x289a ,0x3c42,0x1590 ,0x20e7,0x36e5 ,
  0x3076,0x29ce ,0x3bfd,0x164c ,0x1edc,0x3812 ,
  0x2f6c,0x2afb ,0x3bb6,0x1709 ,0x1cc6,0x392b ,
  0x2e5a,0x2c21 ,0x3b6d,0x17c4 ,0x1aa7,0x3a30 ,
  0x2d41,0x2d41 ,0x3b21,0x187e ,0x187e,0x3b21 ,
  0x2c21,0x2e5a ,0x3ad3,0x1937 ,0x164c,0x3bfd ,
  0x2afb,0x2f6c ,0x3a82,0x19ef ,0x1413,0x3cc5 ,
  0x29ce,0x3076 ,0x3a30,0x1aa7 ,0x11d3,0x3d78 ,
  0x289a,0x3179 ,0x39db,0x1b5d ,0x0f8d,0x3e15 ,
  0x2760,0x3274 ,0x3984,0x1c12 ,0x0d41,0x3e9d ,
  0x2620,0x3368 ,0x392b,0x1cc6 ,0x0af1,0x3f0f ,
  0x24da,0x3453 ,0x38cf,0x1d79 ,0x089d,0x3f6b ,
  0x238e,0x3537 ,0x3871,0x1e2b ,0x0646,0x3fb1 ,
  0x223d,0x3612 ,0x3812,0x1edc ,0x03ed,0x3fe1 ,
  0x20e7,0x36e5 ,0x37b0,0x1f8c ,0x0192,0x3ffb ,
  0x1f8c,0x37b0 ,0x374b,0x203a ,0xff37,0x3fff ,
  0x1e2b,0x3871 ,0x36e5,0x20e7 ,0xfcdc,0x3fec ,
  0x1cc6,0x392b ,0x367d,0x2193 ,0xfa82,0x3fc4 ,
  0x1b5d,0x39db ,0x3612,0x223d ,0xf82a,0x3f85 ,
  0x19ef,0x3a82 ,0x35a5,0x22e7 ,0xf5d5,0x3f30 ,
  0x187e,0x3b21 ,0x3537,0x238e ,0xf384,0x3ec5 ,
  0x1709,0x3bb6 ,0x34c6,0x2435 ,0xf136,0x3e45 ,
  0x1590,0x3c42 ,0x3453,0x24da ,0xeeee,0x3daf ,
  0x1413,0x3cc5 ,0x33df,0x257e ,0xecac,0x3d03 ,
  0x1294,0x3d3f ,0x3368,0x2620 ,0xea70,0x3c42 ,
  0x1112,0x3daf ,0x32ef,0x26c1 ,0xe83c,0x3b6d ,
  0x0f8d,0x3e15 ,0x3274,0x2760 ,0xe611,0x3a82 ,
  0x0e06,0x3e72 ,0x31f8,0x27fe ,0xe3ee,0x3984 ,
  0x0c7c,0x3ec5 ,0x3179,0x289a ,0xe1d5,0x3871 ,
  0x0af1,0x3f0f ,0x30f9,0x2935 ,0xdfc6,0x374b ,
  0x0964,0x3f4f ,0x3076,0x29ce ,0xddc3,0x3612 ,
  0x07d6,0x3f85 ,0x2ff2,0x2a65 ,0xdbcb,0x34c6 ,
  0x0646,0x3fb1 ,0x2f6c,0x2afb ,0xd9e0,0x3368 ,
  0x04b5,0x3fd4 ,0x2ee4,0x2b8f ,0xd802,0x31f8 ,
  0x0324,0x3fec ,0x2e5a,0x2c21 ,0xd632,0x3076 ,
  0x0192,0x3ffb ,0x2dcf,0x2cb2 ,0xd471,0x2ee4 ,
  0x0000,0x4000 ,0x2d41,0x2d41 ,0xd2bf,0x2d41 ,
  0xfe6e,0x3ffb ,0x2cb2,0x2dcf ,0xd11c,0x2b8f ,
  0xfcdc,0x3fec ,0x2c21,0x2e5a ,0xcf8a,0x29ce ,
  0xfb4b,0x3fd4 ,0x2b8f,0x2ee4 ,0xce08,0x27fe ,
  0xf9ba,0x3fb1 ,0x2afb,0x2f6c ,0xcc98,0x2620 ,
  0xf82a,0x3f85 ,0x2a65,0x2ff2 ,0xcb3a,0x2435 ,
  0xf69c,0x3f4f ,0x29ce,0x3076 ,0xc9ee,0x223d ,
  0xf50f,0x3f0f ,0x2935,0x30f9 ,0xc8b5,0x203a ,
  0xf384,0x3ec5 ,0x289a,0x3179 ,0xc78f,0x1e2b ,
  0xf1fa,0x3e72 ,0x27fe,0x31f8 ,0xc67c,0x1c12 ,
  0xf073,0x3e15 ,0x2760,0x3274 ,0xc57e,0x19ef ,
  0xeeee,0x3daf ,0x26c1,0x32ef ,0xc493,0x17c4 ,
  0xed6c,0x3d3f ,0x2620,0x3368 ,0xc3be,0x1590 ,
  0xebed,0x3cc5 ,0x257e,0x33df ,0xc2fd,0x1354 ,
  0xea70,0x3c42 ,0x24da,0x3453 ,0xc251,0x1112 ,
  0xe8f7,0x3bb6 ,0x2435,0x34c6 ,0xc1bb,0x0eca ,
  0xe782,0x3b21 ,0x238e,0x3537 ,0xc13b,0x0c7c ,
  0xe611,0x3a82 ,0x22e7,0x35a5 ,0xc0d0,0x0a2b ,
  0xe4a3,0x39db ,0x223d,0x3612 ,0xc07b,0x07d6 ,
  0xe33a,0x392b ,0x2193,0x367d ,0xc03c,0x057e ,
  0xe1d5,0x3871 ,0x20e7,0x36e5 ,0xc014,0x0324 ,
  0xe074,0x37b0 ,0x203a,0x374b ,0xc001,0x00c9 ,
  0xdf19,0x36e5 ,0x1f8c,0x37b0 ,0xc005,0xfe6e ,
  0xddc3,0x3612 ,0x1edc,0x3812 ,0xc01f,0xfc13 ,
  0xdc72,0x3537 ,0x1e2b,0x3871 ,0xc04f,0xf9ba ,
  0xdb26,0x3453 ,0x1d79,0x38cf ,0xc095,0xf763 ,
  0xd9e0,0x3368 ,0x1cc6,0x392b ,0xc0f1,0xf50f ,
  0xd8a0,0x3274 ,0x1c12,0x3984 ,0xc163,0xf2bf ,
  0xd766,0x3179 ,0x1b5d,0x39db ,0xc1eb,0xf073 ,
  0xd632,0x3076 ,0x1aa7,0x3a30 ,0xc288,0xee2d ,
  0xd505,0x2f6c ,0x19ef,0x3a82 ,0xc33b,0xebed ,
  0xd3df,0x2e5a ,0x1937,0x3ad3 ,0xc403,0xe9b4 ,
  0xd2bf,0x2d41 ,0x187e,0x3b21 ,0xc4df,0xe782 ,
  0xd1a6,0x2c21 ,0x17c4,0x3b6d ,0xc5d0,0xe559 ,
  0xd094,0x2afb ,0x1709,0x3bb6 ,0xc6d5,0xe33a ,
  0xcf8a,0x29ce ,0x164c,0x3bfd ,0xc7ee,0xe124 ,
  0xce87,0x289a ,0x1590,0x3c42 ,0xc91b,0xdf19 ,
  0xcd8c,0x2760 ,0x14d2,0x3c85 ,0xca5b,0xdd19 ,
  0xcc98,0x2620 ,0x1413,0x3cc5 ,0xcbad,0xdb26 ,
  0xcbad,0x24da ,0x1354,0x3d03 ,0xcd11,0xd93f ,
  0xcac9,0x238e ,0x1294,0x3d3f ,0xce87,0xd766 ,
  0xc9ee,0x223d ,0x11d3,0x3d78 ,0xd00e,0xd59b ,
  0xc91b,0x20e7 ,0x1112,0x3daf ,0xd1a6,0xd3df ,
  0xc850,0x1f8c ,0x1050,0x3de3 ,0xd34e,0xd231 ,
  0xc78f,0x1e2b ,0x0f8d,0x3e15 ,0xd505,0xd094 ,
  0xc6d5,0x1cc6 ,0x0eca,0x3e45 ,0xd6cb,0xcf07 ,
  0xc625,0x1b5d ,0x0e06,0x3e72 ,0xd8a0,0xcd8c ,
  0xc57e,0x19ef ,0x0d41,0x3e9d ,0xda82,0xcc21 ,
  0xc4df,0x187e ,0x0c7c,0x3ec5 ,0xdc72,0xcac9 ,
  0xc44a,0x1709 ,0x0bb7,0x3eeb ,0xde6d,0xc983 ,
  0xc3be,0x1590 ,0x0af1,0x3f0f ,0xe074,0xc850 ,
  0xc33b,0x1413 ,0x0a2b,0x3f30 ,0xe287,0xc731 ,
  0xc2c1,0x1294 ,0x0964,0x3f4f ,0xe4a3,0xc625 ,
  0xc251,0x1112 ,0x089d,0x3f6b ,0xe6c9,0xc52d ,
  0xc1eb,0x0f8d ,0x07d6,0x3f85 ,0xe8f7,0xc44a ,
  0xc18e,0x0e06 ,0x070e,0x3f9c ,0xeb2e,0xc37b ,
  0xc13b,0x0c7c ,0x0646,0x3fb1 ,0xed6c,0xc2c1 ,
  0xc0f1,0x0af1 ,0x057e,0x3fc4 ,0xefb0,0xc21d ,
  0xc0b1,0x0964 ,0x04b5,0x3fd4 ,0xf1fa,0xc18e ,
  0xc07b,0x07d6 ,0x03ed,0x3fe1 ,0xf449,0xc115 ,
  0xc04f,0x0646 ,0x0324,0x3fec ,0xf69c,0xc0b1 ,
  0xc02c,0x04b5 ,0x025b,0x3ff5 ,0xf8f2,0xc064 ,
  0xc014,0x0324 ,0x0192,0x3ffb ,0xfb4b,0xc02c ,
  0xc005,0x0192 ,0x00c9,0x3fff ,0xfda5,0xc00b ,
  0x4000,0x0000 ,0x4000,0x0065 ,0x3fff,0x00c9 ,
  0x3ffd,0x012e ,0x3ffb,0x0192 ,0x3ff8,0x01f7 ,
  0x3ff5,0x025b ,0x3ff1,0x02c0 ,0x3fec,0x0324 ,
  0x3fe7,0x0388 ,0x3fe1,0x03ed ,0x3fdb,0x0451 ,
  0x3fd4,0x04b5 ,0x3fcc,0x051a ,0x3fc4,0x057e ,
  0x3fbb,0x05e2 ,0x3fb1,0x0646 ,0x3fa7,0x06aa ,
  0x3f9c,0x070e ,0x3f91,0x0772 ,0x3f85,0x07d6 ,
  0x3f78,0x0839 ,0x3f6b,0x089d ,0x3f5d,0x0901 ,
  0x3f4f,0x0964 ,0x3f40,0x09c7 ,0x3f30,0x0a2b ,
  0x3f20,0x0a8e ,0x3f0f,0x0af1 ,0x3efd,0x0b54 ,
  0x3eeb,0x0bb7 ,0x3ed8,0x0c1a ,0x3ec5,0x0c7c ,
  0x3eb1,0x0cdf ,0x3e9d,0x0d41 ,0x3e88,0x0da4 ,
  0x3e72,0x0e06 ,0x3e5c,0x0e68 ,0x3e45,0x0eca ,
  0x3e2d,0x0f2b ,0x3e15,0x0f8d ,0x3dfc,0x0fee ,
  0x3de3,0x1050 ,0x3dc9,0x10b1 ,0x3daf,0x1112 ,
  0x3d93,0x1173 ,0x3d78,0x11d3 ,0x3d5b,0x1234 ,
  0x3d3f,0x1294 ,0x3d21,0x12f4 ,0x3d03,0x1354 ,
  0x3ce4,0x13b4 ,0x3cc5,0x1413 ,0x3ca5,0x1473 ,
  0x3c85,0x14d2 ,0x3c64,0x1531 ,0x3c42,0x1590 ,
  0x3c20,0x15ee ,0x3bfd,0x164c ,0x3bda,0x16ab ,
  0x3bb6,0x1709 ,0x3b92,0x1766 ,0x3b6d,0x17c4 ,
  0x3b47,0x1821 ,0x3b21,0x187e ,0x3afa,0x18db ,
  0x3ad3,0x1937 ,0x3aab,0x1993 ,0x3a82,0x19ef ,
  0x3a59,0x1a4b ,0x3a30,0x1aa7 ,0x3a06,0x1b02 ,
  0x39db,0x1b5d ,0x39b0,0x1bb8 ,0x3984,0x1c12 ,
  0x3958,0x1c6c ,0x392b,0x1cc6 ,0x38fd,0x1d20 ,
  0x38cf,0x1d79 ,0x38a1,0x1dd3 ,0x3871,0x1e2b ,
  0x3842,0x1e84 ,0x3812,0x1edc ,0x37e1,0x1f34 ,
  0x37b0,0x1f8c ,0x377e,0x1fe3 ,0x374b,0x203a ,
  0x3718,0x2091 ,0x36e5,0x20e7 ,0x36b1,0x213d ,
  0x367d,0x2193 ,0x3648,0x21e8 ,0x3612,0x223d ,
  0x35dc,0x2292 ,0x35a5,0x22e7 ,0x356e,0x233b ,
  0x3537,0x238e ,0x34ff,0x23e2 ,0x34c6,0x2435 ,
  0x348d,0x2488 ,0x3453,0x24da ,0x3419,0x252c ,
  0x33df,0x257e ,0x33a3,0x25cf ,0x3368,0x2620 ,
  0x332c,0x2671 ,0x32ef,0x26c1 ,0x32b2,0x2711 ,
  0x3274,0x2760 ,0x3236,0x27af ,0x31f8,0x27fe ,
  0x31b9,0x284c ,0x3179,0x289a ,0x3139,0x28e7 ,
  0x30f9,0x2935 ,0x30b8,0x2981 ,0x3076,0x29ce ,
  0x3034,0x2a1a ,0x2ff2,0x2a65 ,0x2faf,0x2ab0 ,
  0x2f6c,0x2afb ,0x2f28,0x2b45 ,0x2ee4,0x2b8f ,
  0x2e9f,0x2bd8 ,0x2e5a,0x2c21 ,0x2e15,0x2c6a ,
  0x2dcf,0x2cb2 ,0x2d88,0x2cfa ,0x2d41,0x2d41 ,
  0x2cfa,0x2d88 ,0x2cb2,0x2dcf ,0x2c6a,0x2e15 ,
  0x2c21,0x2e5a ,0x2bd8,0x2e9f ,0x2b8f,0x2ee4 ,
  0x2b45,0x2f28 ,0x2afb,0x2f6c ,0x2ab0,0x2faf ,
  0x2a65,0x2ff2 ,0x2a1a,0x3034 ,0x29ce,0x3076 ,
  0x2981,0x30b8 ,0x2935,0x30f9 ,0x28e7,0x3139 ,
  0x289a,0x3179 ,0x284c,0x31b9 ,0x27fe,0x31f8 ,
  0x27af,0x3236 ,0x2760,0x3274 ,0x2711,0x32b2 ,
  0x26c1,0x32ef ,0x2671,0x332c ,0x2620,0x3368 ,
  0x25cf,0x33a3 ,0x257e,0x33df ,0x252c,0x3419 ,
  0x24da,0x3453 ,0x2488,0x348d ,0x2435,0x34c6 ,
  0x23e2,0x34ff ,0x238e,0x3537 ,0x233b,0x356e ,
  0x22e7,0x35a5 ,0x2292,0x35dc ,0x223d,0x3612 ,
  0x21e8,0x3648 ,0x2193,0x367d ,0x213d,0x36b1 ,
  0x20e7,0x36e5 ,0x2091,0x3718 ,0x203a,0x374b ,
  0x1fe3,0x377e ,0x1f8c,0x37b0 ,0x1f34,0x37e1 ,
  0x1edc,0x3812 ,0x1e84,0x3842 ,0x1e2b,0x3871 ,
  0x1dd3,0x38a1 ,0x1d79,0x38cf ,0x1d20,0x38fd ,
  0x1cc6,0x392b ,0x1c6c,0x3958 ,0x1c12,0x3984 ,
  0x1bb8,0x39b0 ,0x1b5d,0x39db ,0x1b02,0x3a06 ,
  0x1aa7,0x3a30 ,0x1a4b,0x3a59 ,0x19ef,0x3a82 ,
  0x1993,0x3aab ,0x1937,0x3ad3 ,0x18db,0x3afa ,
  0x187e,0x3b21 ,0x1821,0x3b47 ,0x17c4,0x3b6d ,
  0x1766,0x3b92 ,0x1709,0x3bb6 ,0x16ab,0x3bda ,
  0x164c,0x3bfd ,0x15ee,0x3c20 ,0x1590,0x3c42 ,
  0x1531,0x3c64 ,0x14d2,0x3c85 ,0x1473,0x3ca5 ,
  0x1413,0x3cc5 ,0x13b4,0x3ce4 ,0x1354,0x3d03 ,
  0x12f4,0x3d21 ,0x1294,0x3d3f ,0x1234,0x3d5b ,
  0x11d3,0x3d78 ,0x1173,0x3d93 ,0x1112,0x3daf ,
  0x10b1,0x3dc9 ,0x1050,0x3de3 ,0x0fee,0x3dfc ,
  0x0f8d,0x3e15 ,0x0f2b,0x3e2d ,0x0eca,0x3e45 ,
  0x0e68,0x3e5c ,0x0e06,0x3e72 ,0x0da4,0x3e88 ,
  0x0d41,0x3e9d ,0x0cdf,0x3eb1 ,0x0c7c,0x3ec5 ,
  0x0c1a,0x3ed8 ,0x0bb7,0x3eeb ,0x0b54,0x3efd ,
  0x0af1,0x3f0f ,0x0a8e,0x3f20 ,0x0a2b,0x3f30 ,
  0x09c7,0x3f40 ,0x0964,0x3f4f ,0x0901,0x3f5d ,
  0x089d,0x3f6b ,0x0839,0x3f78 ,0x07d6,0x3f85 ,
  0x0772,0x3f91 ,0x070e,0x3f9c ,0x06aa,0x3fa7 ,
  0x0646,0x3fb1 ,0x05e2,0x3fbb ,0x057e,0x3fc4 ,
  0x051a,0x3fcc ,0x04b5,0x3fd4 ,0x0451,0x3fdb ,
  0x03ed,0x3fe1 ,0x0388,0x3fe7 ,0x0324,0x3fec ,
  0x02c0,0x3ff1 ,0x025b,0x3ff5 ,0x01f7,0x3ff8 ,
  0x0192,0x3ffb ,0x012e,0x3ffd ,0x00c9,0x3fff ,
  0x0065,0x4000 ,0x0000,0x4000 ,0xff9b,0x4000 ,
  0xff37,0x3fff ,0xfed2,0x3ffd ,0xfe6e,0x3ffb ,
  0xfe09,0x3ff8 ,0xfda5,0x3ff5 ,0xfd40,0x3ff1 ,
  0xfcdc,0x3fec ,0xfc78,0x3fe7 ,0xfc13,0x3fe1 ,
  0xfbaf,0x3fdb ,0xfb4b,0x3fd4 ,0xfae6,0x3fcc ,
  0xfa82,0x3fc4 ,0xfa1e,0x3fbb ,0xf9ba,0x3fb1 ,
  0xf956,0x3fa7 ,0xf8f2,0x3f9c ,0xf88e,0x3f91 ,
  0xf82a,0x3f85 ,0xf7c7,0x3f78 ,0xf763,0x3f6b ,
  0xf6ff,0x3f5d ,0xf69c,0x3f4f ,0xf639,0x3f40 ,
  0xf5d5,0x3f30 ,0xf572,0x3f20 ,0xf50f,0x3f0f ,
  0xf4ac,0x3efd ,0xf449,0x3eeb ,0xf3e6,0x3ed8 ,
  0xf384,0x3ec5 ,0xf321,0x3eb1 ,0xf2bf,0x3e9d ,
  0xf25c,0x3e88 ,0xf1fa,0x3e72 ,0xf198,0x3e5c ,
  0xf136,0x3e45 ,0xf0d5,0x3e2d ,0xf073,0x3e15 ,
  0xf012,0x3dfc ,0xefb0,0x3de3 ,0xef4f,0x3dc9 ,
  0xeeee,0x3daf ,0xee8d,0x3d93 ,0xee2d,0x3d78 ,
  0xedcc,0x3d5b ,0xed6c,0x3d3f ,0xed0c,0x3d21 ,
  0xecac,0x3d03 ,0xec4c,0x3ce4 ,0xebed,0x3cc5 ,
  0xeb8d,0x3ca5 ,0xeb2e,0x3c85 ,0xeacf,0x3c64 ,
  0xea70,0x3c42 ,0xea12,0x3c20 ,0xe9b4,0x3bfd ,
  0xe955,0x3bda ,0xe8f7,0x3bb6 ,0xe89a,0x3b92 ,
  0xe83c,0x3b6d ,0xe7df,0x3b47 ,0xe782,0x3b21 ,
  0xe725,0x3afa ,0xe6c9,0x3ad3 ,0xe66d,0x3aab ,
  0xe611,0x3a82 ,0xe5b5,0x3a59 ,0xe559,0x3a30 ,
  0xe4fe,0x3a06 ,0xe4a3,0x39db ,0xe448,0x39b0 ,
  0xe3ee,0x3984 ,0xe394,0x3958 ,0xe33a,0x392b ,
  0xe2e0,0x38fd ,0xe287,0x38cf ,0xe22d,0x38a1 ,
  0xe1d5,0x3871 ,0xe17c,0x3842 ,0xe124,0x3812 ,
  0xe0cc,0x37e1 ,0xe074,0x37b0 ,0xe01d,0x377e ,
  0xdfc6,0x374b ,0xdf6f,0x3718 ,0xdf19,0x36e5 ,
  0xdec3,0x36b1 ,0xde6d,0x367d ,0xde18,0x3648 ,
  0xddc3,0x3612 ,0xdd6e,0x35dc ,0xdd19,0x35a5 ,
  0xdcc5,0x356e ,0xdc72,0x3537 ,0xdc1e,0x34ff ,
  0xdbcb,0x34c6 ,0xdb78,0x348d ,0xdb26,0x3453 ,
  0xdad4,0x3419 ,0xda82,0x33df ,0xda31,0x33a3 ,
  0xd9e0,0x3368 ,0xd98f,0x332c ,0xd93f,0x32ef ,
  0xd8ef,0x32b2 ,0xd8a0,0x3274 ,0xd851,0x3236 ,
  0xd802,0x31f8 ,0xd7b4,0x31b9 ,0xd766,0x3179 ,
  0xd719,0x3139 ,0xd6cb,0x30f9 ,0xd67f,0x30b8 ,
  0xd632,0x3076 ,0xd5e6,0x3034 ,0xd59b,0x2ff2 ,
  0xd550,0x2faf ,0xd505,0x2f6c ,0xd4bb,0x2f28 ,
  0xd471,0x2ee4 ,0xd428,0x2e9f ,0xd3df,0x2e5a ,
  0xd396,0x2e15 ,0xd34e,0x2dcf ,0xd306,0x2d88 ,
  0xd2bf,0x2d41 ,0xd278,0x2cfa ,0xd231,0x2cb2 ,
  0xd1eb,0x2c6a ,0xd1a6,0x2c21 ,0xd161,0x2bd8 ,
  0xd11c,0x2b8f ,0xd0d8,0x2b45 ,0xd094,0x2afb ,
  0xd051,0x2ab0 ,0xd00e,0x2a65 ,0xcfcc,0x2a1a ,
  0xcf8a,0x29ce ,0xcf48,0x2981 ,0xcf07,0x2935 ,
  0xcec7,0x28e7 ,0xce87,0x289a ,0xce47,0x284c ,
  0xce08,0x27fe ,0xcdca,0x27af ,0xcd8c,0x2760 ,
  0xcd4e,0x2711 ,0xcd11,0x26c1 ,0xccd4,0x2671 ,
  0xcc98,0x2620 ,0xcc5d,0x25cf ,0xcc21,0x257e ,
  0xcbe7,0x252c ,0xcbad,0x24da ,0xcb73,0x2488 ,
  0xcb3a,0x2435 ,0xcb01,0x23e2 ,0xcac9,0x238e ,
  0xca92,0x233b ,0xca5b,0x22e7 ,0xca24,0x2292 ,
  0xc9ee,0x223d ,0xc9b8,0x21e8 ,0xc983,0x2193 ,
  0xc94f,0x213d ,0xc91b,0x20e7 ,0xc8e8,0x2091 ,
  0xc8b5,0x203a ,0xc882,0x1fe3 ,0xc850,0x1f8c ,
  0xc81f,0x1f34 ,0xc7ee,0x1edc ,0xc7be,0x1e84 ,
  0xc78f,0x1e2b ,0xc75f,0x1dd3 ,0xc731,0x1d79 ,
  0xc703,0x1d20 ,0xc6d5,0x1cc6 ,0xc6a8,0x1c6c ,
  0xc67c,0x1c12 ,0xc650,0x1bb8 ,0xc625,0x1b5d ,
  0xc5fa,0x1b02 ,0xc5d0,0x1aa7 ,0xc5a7,0x1a4b ,
  0xc57e,0x19ef ,0xc555,0x1993 ,0xc52d,0x1937 ,
  0xc506,0x18db ,0xc4df,0x187e ,0xc4b9,0x1821 ,
  0xc493,0x17c4 ,0xc46e,0x1766 ,0xc44a,0x1709 ,
  0xc426,0x16ab ,0xc403,0x164c ,0xc3e0,0x15ee ,
  0xc3be,0x1590 ,0xc39c,0x1531 ,0xc37b,0x14d2 ,
  0xc35b,0x1473 ,0xc33b,0x1413 ,0xc31c,0x13b4 ,
  0xc2fd,0x1354 ,0xc2df,0x12f4 ,0xc2c1,0x1294 ,
  0xc2a5,0x1234 ,0xc288,0x11d3 ,0xc26d,0x1173 ,
  0xc251,0x1112 ,0xc237,0x10b1 ,0xc21d,0x1050 ,
  0xc204,0x0fee ,0xc1eb,0x0f8d ,0xc1d3,0x0f2b ,
  0xc1bb,0x0eca ,0xc1a4,0x0e68 ,0xc18e,0x0e06 ,
  0xc178,0x0da4 ,0xc163,0x0d41 ,0xc14f,0x0cdf ,
  0xc13b,0x0c7c ,0xc128,0x0c1a ,0xc115,0x0bb7 ,
  0xc103,0x0b54 ,0xc0f1,0x0af1 ,0xc0e0,0x0a8e ,
  0xc0d0,0x0a2b ,0xc0c0,0x09c7 ,0xc0b1,0x0964 ,
  0xc0a3,0x0901 ,0xc095,0x089d ,0xc088,0x0839 ,
  0xc07b,0x07d6 ,0xc06f,0x0772 ,0xc064,0x070e ,
  0xc059,0x06aa ,0xc04f,0x0646 ,0xc045,0x05e2 ,
  0xc03c,0x057e ,0xc034,0x051a ,0xc02c,0x04b5 ,
  0xc025,0x0451 ,0xc01f,0x03ed ,0xc019,0x0388 ,
  0xc014,0x0324 ,0xc00f,0x02c0 ,0xc00b,0x025b ,
  0xc008,0x01f7 ,0xc005,0x0192 ,0xc003,0x012e ,
  0xc001,0x00c9 ,0xc000,0x0065 };
