/*
    GNUbik -- A 3 dimensional magic cube game.
    Copyright (C) 1998,2003--2004  John Darrington

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
*/
static const char RCSID[]="$Id: main.c,v 1.11 2004/02/18 10:56:24 dale_mellor Exp $";


#include <time.h>
#include <getopt.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <locale.h>
#include "../config.h"
#include "cube.h"
#include "drwBlock.h"
#include "gnubik.h"
#include "version.h"
#include "menus.h"
#include "ui.h"
#include "glarea.h"
#include "widget-set.h"
#include "select.h"



#include <ctype.h>


void set_icon(t_widget shell_widget);



void app_opts(int *argc, char **argv);

/* this is the number of frames drawn when a slice of the cube rotates 
   90 degrees */ 
extern int frameQty;


int cube_dimension=3;
static short solved = 0;
int number_of_blocks;



t_widget glxarea;
t_widget main_application_window;




void
c_main(void *closure, int argc, char *argv[])
{
  t_widget form ;
  t_widget menubar;
  t_widget play_toolbar;
  t_widget statusbar;



  /* Internationalisation stuff */
  setlocale(LC_ALL,"");
  bind_textdomain_codeset(PACKAGE,"UTF-8");
  bindtextdomain(PACKAGE,LOCALEDIR);
  textdomain(PACKAGE);


  widget_set_init(&argc, &argv);


  /* Create the top level widget --- that is, the main window which everything 
     goes in */
  main_application_window = create_top_level_widget();


  /* process arguments specific to this program */
  app_opts(&argc, argv) ;




  /* Create a container widget.   A `thing' which will contain the menubar 
     and the gl area */
  form = create_container_widget(main_application_window);


  menubar = create_menubar(form,main_application_window);
  play_toolbar = create_play_toolbar (form, main_application_window);
  



  glxarea = create_gl_area(form,play_toolbar);


  statusbar  = create_statusbar(form);


  /* tidy up whent the program exits */
  atexit(cleanup);


  register_gl_callbacks(glxarea);


  /* create the cube */
  number_of_blocks = create_the_cube (cube_dimension);
  if ( 0 > number_of_blocks ) {
    print_cube_error (the_cube, "Error creating cube");
    exit(-1);
  }
	
  /* If a solved cube has not been requested, then do some random
     moves on it */
  if ( !solved ) {
    int i;
    srand(time(0));
    for( i = 0; i < 8*cube_dimension; i++ )
    {
        Slice_Blocks *const blocks
            = identify_blocks (the_cube,
                               rand () % number_of_blocks,
                               rand () % 3);
        
        rotate_slice (the_cube, rand()%2 +1, blocks);

        free_slice_blocks (blocks);
    }
  }

  /* initialise the selection mechanism */
  initSelection(50, 1,selection_func);


  show_widget(main_application_window);


  setCubeColours(argv[0]);


  start_main_loop();

}



#ifdef HAVE_GUILE

#include <libguile.h>

    int
    main (int argc, char **argv)
    {
        scm_boot_guile (argc, argv, c_main, 0);
        return 0;
    }

#else

    int
    main (int argc, char **argv)
    {
        c_main (0, argc, argv);
        return 0;
    }

#endif



/* process the options we're interested in.  X resource overrides should
have already been extracted */
void 
app_opts(int *argc, char **argv)
{

#ifdef HAVE_GETOPT_LONG
#define GETOPT(A,B,C,D,E) getopt_long(A,B,C,D,E)
#else
#define GETOPT(A,B,C,D,E) getopt(A,B,C)
#endif

  int c;
  const char shortopts[]="vhsz:a:";

#ifdef HAVE_GETOPT_LONG
  int longind;
  const struct option longopts[] = {
    { "animation", 1, 0, 'a' },
    { "help", 0, 0, 'h' },
    { "version", 0,0,'v' },
    { "solved", 0,0,'s' },
    { "size",1,0,'z' },
    { 0,0,0,0 }
  } ;
#endif

  while ( ( c = GETOPT(*argc, argv, shortopts, longopts, &longind ) )!= -1 )  {
    switch (c) {
    case 'a':
      sscanf(optarg,"%d",&frameQty);
      break;
    case 's':
      solved = 1;
      break;
    case 'z':
      sscanf(optarg,"%d",&cube_dimension);
      break;
    case 'h':
      printf("%s",help_string);
      exit(0);
      break;
    case 'v':
      printf("%s\n",get_version_string());
      printf("%s",copyleft_notice);
      exit(0);
      break;
    default:
      break;
    }
		
  }

}




const char help_string[] = 
"-h\n--help\tShow this help message\n\n"
"-v\n--version\tShow version number\n\n"
"-s\n--solved\tStart with the cube already solved\n\n"
"-z n\n--size=n\tShow a   n x n x n   sized cube \n\n"
"-a n\n--animation=n\tNumber of intermediate positions to be shown in animations\n\n"
"\n\nBug reports to " PACKAGE_BUGREPORT "\n"
;
