/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.mac;

import gnu.crypto.mac.BaseMac;
import gnu.crypto.prng.IRandom;
import gnu.crypto.prng.LimitReachedException;
import java.security.InvalidKeyException;
import java.util.Map;

public class TMMH16
extends BaseMac {
    public static final String TAG_LENGTH = "gnu.crypto.mac.tmmh.tag.length";
    public static final String KEYSTREAM = "gnu.crypto.mac.tmmh.keystream";
    public static final String PREFIX = "gnu.crypto.mac.tmmh.prefix";
    private static final int P = 65537;
    private static Boolean valid;
    private int tagWords;
    private IRandom keystream;
    private byte[] prefix;
    private long keyWords;
    private long msgLength;
    private long msgWords;
    private int[] context;
    private int[] K0;
    private int[] Ki;
    private int Mi;

    private /* synthetic */ void finit$() {
        this.tagWords = 0;
        this.keystream = null;
    }

    public TMMH16() {
        super("tmmh16");
        this.finit$();
    }

    private TMMH16(TMMH16 that) {
        this();
        this.tagWords = that.tagWords;
        this.keystream = (IRandom)that.keystream.clone();
        this.keyWords = that.keyWords;
        this.msgLength = that.msgLength;
        this.msgWords = that.msgWords;
        this.context = (int[])that.context.clone();
        this.prefix = (byte[])that.prefix.clone();
        this.K0 = (int[])that.K0.clone();
        this.Ki = (int[])that.Ki.clone();
        this.Mi = that.Mi;
    }

    public Object clone() {
        return new TMMH16(this);
    }

    public int macSize() {
        return this.tagWords * 2;
    }

    public void init(Map attributes) throws InvalidKeyException, IllegalStateException {
        int wantTagLength = 0;
        Integer tagLength = (Integer)attributes.get(TAG_LENGTH);
        if (tagLength == null) {
            if (this.tagWords == 0) {
                throw new IllegalArgumentException(TAG_LENGTH);
            }
        } else {
            wantTagLength = tagLength;
            if (wantTagLength < 2 || wantTagLength % 2 != 0) {
                throw new IllegalArgumentException(TAG_LENGTH);
            }
            if (wantTagLength > 64) {
                throw new IllegalArgumentException(TAG_LENGTH);
            }
            this.tagWords = wantTagLength / 2;
            this.K0 = new int[this.tagWords];
            this.Ki = new int[this.tagWords];
            this.context = new int[this.tagWords];
        }
        this.prefix = (byte[])attributes.get(PREFIX);
        if (this.prefix == null) {
            this.prefix = new byte[this.tagWords * 2];
        } else if (this.prefix.length != this.tagWords * 2) {
            throw new IllegalArgumentException(PREFIX);
        }
        IRandom prng = (IRandom)attributes.get(KEYSTREAM);
        if (prng == null) {
            if (this.keystream == null) {
                throw new IllegalArgumentException(KEYSTREAM);
            }
        } else {
            this.keystream = prng;
        }
        this.reset();
        for (int i = 0; i < this.tagWords; ++i) {
            this.Ki[i] = this.K0[i] = this.getNextKeyWord(this.keystream);
        }
    }

    public void update(byte b) {
        this.update(b, this.keystream);
    }

    public void update(byte[] b, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            this.update(b[offset + i], this.keystream);
        }
    }

    public byte[] digest() {
        return this.digest(this.keystream);
    }

    public void reset() {
        this.keyWords = 0L;
        this.msgWords = 0L;
        this.msgLength = 0L;
        this.Mi = 0;
        for (int i = 0; i < this.tagWords; ++i) {
            this.context[i] = 0;
        }
    }

    public boolean selfTest() {
        if (valid == null) {
            valid = Boolean.TRUE;
        }
        return valid;
    }

    public void update(byte b, IRandom prng) {
        this.Mi <<= 8;
        this.Mi |= b & 0xFF;
        ++this.msgLength;
        if (this.msgLength % (long)2 == 0L) {
            ++this.msgWords;
            System.arraycopy(this.Ki, 1, this.Ki, 0, this.tagWords - 1);
            this.Ki[this.tagWords - 1] = this.getNextKeyWord(prng);
            for (int i = 0; i < this.tagWords; ++i) {
                long t = (long)this.context[i] & 0xFFFFFFFFL;
                this.context[i] = (int)(t += (long)(this.Ki[i] * this.Mi));
            }
            this.Mi = 0;
        }
    }

    public void update(byte[] b, int offset, int len, IRandom prng) {
        for (int i = 0; i < len; ++i) {
            this.update(b[offset + i], prng);
        }
    }

    public byte[] digest(IRandom prng) {
        this.doFinalRound(prng);
        byte[] result = new byte[this.tagWords * 2];
        int j = 0;
        for (int i = 0; i < this.tagWords; ++i) {
            result[j] = (byte)(this.context[i] >>> 8) ^ this.prefix[j];
            result[++j] = (byte)this.context[i] ^ this.prefix[j];
            ++j;
        }
        this.reset();
        return result;
    }

    private int getNextKeyWord(IRandom prng) {
        int result = 0;
        try {
            result = (prng.nextByte() & 0xFF) << 8 | prng.nextByte() & 0xFF;
        }
        catch (LimitReachedException x) {
            throw new RuntimeException(String.valueOf(x));
        }
        ++this.keyWords;
        return result;
    }

    private void doFinalRound(IRandom prng) {
        long limit = this.msgLength;
        while (this.msgLength % (long)2 != 0L) {
            this.update((byte)0, prng);
        }
        for (int i = 0; i < this.tagWords; ++i) {
            long t = (long)this.context[i] & 0xFFFFFFFFL;
            t += (long)this.K0[i] * limit;
            this.context[i] = (int)(t %= 65537L);
        }
    }

    static {
        TAG_LENGTH = TAG_LENGTH;
        KEYSTREAM = KEYSTREAM;
        PREFIX = PREFIX;
    }
}

