/*  http.c -  routines used to interactive with http proxy or http server
    Copyright (C) 2005-2006  Jia Wang (skyroam@gmail.com) 
    
    This file is part of Proxyknife.

    Proxyknife is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Proxyknife is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Foobar; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include <proxyknife.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
/* function defined in http.c */
int CONVIAHTTP (int sockfd, struct timeval *start,
		struct timeval *end, struct thread_mem *thread_mem);
int GET (int sockfd, struct timeval *req, struct thread_mem *thread_mem);
int PGET (int sockfd, struct timeval *send, struct thread_mem *thread_mem);
int
PCONGET (int sockfd, struct timeval *start, struct timeval *end,
	 struct timeval *req, struct thread_mem *thread_mem);
void http_build_auth (void);

/************** global , outside thread ***************************/
/* Build BASIC header and store it into my.header.auth.
 * 
 * Global Var: my.user,my.pass,my.userpass,my.header.auth
 * In: my.myuser,my.mypass
 * Out:my.header_auth
 * 
 * */
void
http_build_auth ()
{

  int blen, dlen, slen, elen;
  blen = strlen (BASIC);
  /*
     if ((blen = strlen (BASIC)) >= sizeof (header_auth))
     {
     fprintf (stderr, "lame code:BASIC longer than header_auth\n");
     exit (EXIT_FAILURE);
     } */
  slen = strlen (my.myuser) + strlen (my.mypass) + 1;
  my.myuserpass = xmalloc (slen + 1);
  snprintf (my.myuserpass, slen + 1, "%s:%s", my.myuser, my.mypass);

  elen = slen / 3 * 4 + ((slen % 3) ? 4 : 0);
  my.header_auth = xmalloc (blen + elen + 1);

  memmove (my.header_auth, BASIC, blen);
  dlen = base64en (my.header_auth + blen, elen,
		   (unsigned char *) my.myuserpass, slen);
  xfree ((void *) &(my.myuserpass));
  xfree ((void *) &(my.myuser));
  xfree ((void *) &(my.mypass));
  if (dlen == -1)
    {
      fprintf (stderr, "%s: http_build_auth:Error in base64encode\n",
	       progname);
      xexit (EXIT_FAILURE);
    }
  if (dlen != elen)
    {
      fprintf (stderr,
	       "%s: http_build_auth:base64en:This error is impossible,good news!\n",
	       progname);
      abort ();
      /* xexit (EXIT_FAILURE); */
    }
  my.header_auth[blen + dlen] = '\0';
  /* debug */
  /* printf ("%s\n", header_auth); */
}

/* Connect to req via a HTTP proxy.
 * The HTTP proxy should support CONNECT.
 * 
 * The format of req is "host:port". 
 * Return value:
 * 0: success!
 * -1: failure.
 * */
int
CONVIAHTTP_MAIN (int sockfd, char *host, char *port)
{
  int ret, len, offset;
  char *p;

  /* connect to myhost:myport */
  ret =
    connect (sockfd, (struct sockaddr *) &(my.myaddr),
	     sizeof (struct sockaddr));
  if (ret == -1)
    {
      perror ("CONVIAHTTP:connect:Connect to myaddr");
      return -1;
    }

  /* build request */
  if (my.mytype == HTTP_CONNECT_AUTH)
    {
      len =
	strlen ("CONNECT  HTTP/1.0") + strlen (host) + strlen (":") +
	strlen (port) + 2 + strlen (user_agent) + 2 + strlen (NOCACHE) + 2 +
	strlen ((const char *) my.header_auth) + 2 + 2;

      /* my.buffer = NULL before this call */
      my.buffer = xmalloc (len + 1);
      if (my.buffer == NULL)
	{
	  xexit (EXIT_FAILURE);
	}
      snprintf (my.buffer, len + 1,
		"CONNECT %s:%s HTTP/1.0\r\n"
		"%s\r\n"
		"%s\r\n"
		"%s\r\n" "\r\n", host, port, user_agent,
		NOCACHE, my.header_auth);

    }
  else
    {
      len =
	strlen ("CONNECT  HTTP/1.0") + strlen (host) + strlen (":") +
	strlen (port) + 2 + strlen (user_agent) + 2 + strlen (NOCACHE) + 2 +
	2;
      my.buffer = xmalloc (len + 1);
      if (my.buffer == NULL)
	{
	  xexit (EXIT_FAILURE);
	}

      snprintf (my.buffer, len + 1,
		"CONNECT %s:%s HTTP/1.0\r\n"
		"%s\r\n" "%s\r\n" "\r\n", host, port, user_agent, NOCACHE);
    }

  *(my.buffer + len) = '\0';

  /* send */
  ret = write (sockfd, my.buffer, strlen (my.buffer));

  if (ret != strlen (my.buffer))
    {
      fprintf (stderr, "%s: CONVIAHTTP:Fail to write completely\n", progname);
      if (ret == -1)
	perror ("CONVIAHTTP:write:Write to myaddr");
      xfree ((void **) &(my.buffer));
      return -1;
    }
  else
    xfree ((void **) &(my.buffer));

  /* read estab string */
  my.buffer = xmalloc (my.myconreplysize);
  if (my.buffer == NULL)
    {
      xexit (EXIT_FAILURE);
    }
  memset (my.buffer, 0, my.myconreplysize);
  p = my.buffer;

  offset = 0;

  while (1)
    {

      ret = read (sockfd, p, my.myconreplysize - offset - 1);
      if (ret <= 0)
	{
	  break;
	}
      /* if(ret < strlen(CONNECT_SUCCESS))return -1; */
      if ((strstr (my.buffer, CONNECT_SUCCESS0) != NULL)
	  || (strstr (my.buffer, CONNECT_SUCCESS1) != NULL))
	{
	  pxfree ((void **) &(my.buffer));
	  return 0;
	}
      p += ret;
      offset = p - my.buffer;
      if ((offset) >= (my.myconreplysize - 1));
      break;			/* too long */
    }
  /* too long or read return 0/-1 */
  if (debug)
    fprintf (stderr, "%s: CONVIAHTTP:Reply to CONVIAHTTP is wrong:%s\n",
	     progname, my.buffer);
  pxfree ((void **) &(my.buffer));
  return -1;
}

/* ***************** inside  thread *********************************/
/* Connect to testproxy via a HTTP proxy.
 * The HTTP proxy should support CONNECT.
 * 
 * The time sending CONNECT request is stored in *start.
 * The time receiving SUCCESS reply is stored in *end.
 *
 * Return value:
 * 0: success!
 * -1: failure.
 * */
int
CONVIAHTTP (int sockfd, struct timeval *start,
	    struct timeval *end, struct thread_mem *thread_mem)
{
  int ret, len, offset;
  char *p;

  /* if mytype == direct 
     parse(testproxy);(strtok)
     gettimeofday
     ret = connect(testhost,testport)
     gettimeofday
     if( ret == 0) return 0;
     else return -1;
   */
  ret =
    connect (sockfd, (struct sockaddr *) &(my.myaddr),
	     sizeof (struct sockaddr));
  if (ret == -1)
    {
      perror ("CONVIAHTTP:connect:Connect to myaddr");
      return -1;
    }

  /* build request */
  if (my.mytype == HTTP_CONNECT_AUTH)
    {
      len =
	strlen ("CONNECT  HTTP/1.0") + strlen (thread_mem->queue.testproxy) +
	2 + strlen (user_agent) + 2 + strlen (NOCACHE) + 2 +
	strlen ((const char *) my.header_auth) + 2 + 2;

      thread_mem->request = pxmalloc ((len + 1), thread_mem);
      if (thread_mem->request == NULL)
	{
	  ret = EXIT_FAILURE;
	  x_pthread_exit ((void *) &ret, thread_mem);
	}
      snprintf (thread_mem->request, len + 1,
		"CONNECT %s HTTP/1.0\r\n"
		"%s\r\n"
		"%s\r\n"
		"%s\r\n" "\r\n", thread_mem->queue.testproxy, user_agent,
		NOCACHE, my.header_auth);

    }
  else
    {
      len =
	strlen ("CONNECT  HTTP/1.0") + strlen (thread_mem->queue.testproxy) +
	2 + strlen (user_agent) + 2 + strlen (NOCACHE) + 2 + 2;
      thread_mem->request = pxmalloc ((len + 1), thread_mem);
      if (thread_mem->request == NULL)
	{
	  ret = EXIT_FAILURE;
	  x_pthread_exit ((void *) &ret, thread_mem);
	}

      snprintf (thread_mem->request, len + 1,
		"CONNECT %s HTTP/1.0\r\n"
		"%s\r\n" "%s\r\n" "\r\n", thread_mem->queue.testproxy,
		user_agent, NOCACHE);
    }

  *((thread_mem->request) + len) = '\0';

  /* send */
  gettimeofday (start, NULL);
  ret = write (sockfd, thread_mem->request, strlen (thread_mem->request));

  if (ret != strlen (thread_mem->request))
    {
      fprintf (stderr, "%s: CONVIAHTTP:Fail to write completely\n", progname);
      if (ret == -1)
	perror ("CONVIAHTTP:write:Write to myaddr");
      pxfree ((void **) &(thread_mem->request));
      return -1;
    }
  else
    pxfree ((void **) &(thread_mem->request));

  /* read estab string */
  thread_mem->reply = pxmalloc (my.myconreplysize, thread_mem);
  if (thread_mem->reply == NULL)
    {
      ret = EXIT_FAILURE;
      x_pthread_exit ((void *) &ret, thread_mem);
    }
  memset (thread_mem->reply, 0, my.myconreplysize);
  p = thread_mem->reply;

  while (1)
    {

      offset = p - thread_mem->reply;
      ret = read (sockfd, p, my.myconreplysize - offset - 1);
      if (ret <= 0)
	{
	  break;
	}
      /* repaired */
      gettimeofday (end, NULL);
      /* if(ret < strlen(CONNECT_SUCCESS))return -1; */
      if ((strstr (thread_mem->reply, CONNECT_SUCCESS0) != NULL)
	  || (strstr (thread_mem->reply, CONNECT_SUCCESS1) != NULL))
	{
	  pxfree ((void **) &(thread_mem->reply));
	  return 0;
	}
      p += ret;
      if ((p - thread_mem->reply) >= (my.myconreplysize - 1))	/* == is ok,ret <= readsize */
	break;			/* too long */
    }
  /* too long or read return 0/-1 */
  if (debug)
    fprintf (stderr, "%s: CONVIAHTTP:Reply to CONVIAHTTP is wrong:%s\n",
	     progname, thread_mem->reply);
  pxfree ((void **) &(thread_mem->reply));
  return -1;
}

/* Send HTTP PROXY GET request to HTTP proxy:
 *   GET http://somesite HTTP/1.0\r\nHost...
 * 
 * The time sending GET request is stored in *send.
 *
 * Return value:
 * -1: failure.
 *  NUMBYTES(>0): number of chars sent.
 * 
 * Verify is expected to be done immediately after this for correct delay.
 *
 * */
int
PGET (int sockfd, struct timeval *send, struct thread_mem *thread_mem)
{
  int numbytes, len;
  int ret;
  ret = EXIT_FAILURE;

  /* build request string */
  len = strlen ("GET  HTTP/1.0") + strlen (target.target) + 2 +
    strlen ("Host: ") + strlen (target.targethost) + 2 +
    strlen (user_agent) + 2 + strlen (NOCACHE) + 2 + 2;

  thread_mem->request = pxmalloc (len + 1, thread_mem);
  if (thread_mem->request == NULL)
    x_pthread_exit ((void *) &ret, thread_mem);

  snprintf (thread_mem->request, len + 1, "GET %s HTTP/1.0\r\n" "Host: %s\r\n" "%s\r\n%s\r\n" "\r\n", target.target, target.targethost, user_agent, NOCACHE);	/* remove header_auth! */

  thread_mem->request[len] = '\0';

  /* send */
  gettimeofday (send, NULL);
  numbytes =
    write (sockfd, thread_mem->request, strlen (thread_mem->request));

  pxfree ((void **) &(thread_mem->request));

  if (numbytes != len)
    {
      fprintf (stderr, "%s: PGET:Fail to write completely:\n", progname);
      if (numbytes < 0)
	perror ("PGET:write:Write to myaddr");
      return -1;		/* ... */
    }

  return numbytes;
}

/* Send HTTP/1.0 GET request to http server:
 *   GET /path HTTP/1.0\r\nHost:targethost ...
 *
 * The time sending GET request is stored in *req.
 * 
 * Return value:
 * -1: failure.
 * NUMBYTES(>0): success!. Return the number of chars sent.
 *
 * Verify is expected to be done imediately after this for correct delay. 
 * */
int
GET (int sockfd, struct timeval *req, struct thread_mem *thread_mem)
{
  int len, numbytes;
  int ret;
  ret = EXIT_FAILURE;
/* send req */
  len = strlen ("GET  HTTP/1.0") + strlen (target.targetpath) + 2 +
    strlen ("Host: ") + strlen (target.targethost) + 2 +
    strlen (user_agent) + 2 + strlen (NOCACHE) + 2 + 2;
  thread_mem->request = pxmalloc (len + 1, thread_mem);
  if (thread_mem->request == NULL)
    x_pthread_exit ((void *) &ret, thread_mem);

  snprintf (thread_mem->request, len + 1,
	    "GET %s HTTP/1.0\r\n"
	    "Host: %s\r\n"
	    "%s\r\n%s\r\n"
	    "\r\n", target.targetpath, target.targethost, user_agent,
	    NOCACHE);
  gettimeofday (req, NULL);
  numbytes =
    write (sockfd, thread_mem->request, strlen (thread_mem->request));
  pxfree ((void **) &(thread_mem->request));
  if (numbytes != len)
    {
      fprintf (stderr, "%s: GET:Fail to write completely!\n", progname);
      if (numbytes < 0)
	perror ("GET:write:Write to myaddr");
      return -1;		/* ... */
    }
  return numbytes;
}

/* Send HTTP PROXY CONNECT request to testproxy(build connection to target), 
 * then send HTTP/1.0 GET request to target with GET function.
 * HTTP PROXY CONNECT:
 *   CONNECT host:port HTTP/1.0\r\nHost:...
 * HTTP/1.0 GET:
 *   GET /path HTTP/1.0\r\nHost:targethost... 
 *
 * The time sending HTTP PROXY CONNECT request is stored in *start.
 * The time receiving Connection Established reply is stored in *end.
 *
 * Return value:
 * -1: failure.
 *  >0: success!
 * 
 * Verify is expected to be done immediately after this for correct delay. 
 * */
int
PCONGET (int sockfd, struct timeval *start, struct timeval *end,
	 struct timeval *req, struct thread_mem *thread_mem)
{
  int numbytes, len;
  char *p;
  int ret;
  ret = EXIT_FAILURE;
  /* build request string */
  len = strlen ("CONNECT : HTTP/1.0") + strlen (target.targethost) +
    strlen (target.targetport) + 2 +
    strlen ("Host: ") + strlen (target.targethost) + 2 +
    strlen (user_agent) + 2 + strlen (NOCACHE) + 2 + 2;
  thread_mem->request = pxmalloc (len + 1, thread_mem);
  if (thread_mem == NULL)
    x_pthread_exit ((void *) &ret, thread_mem);
  snprintf (thread_mem->request, len + 1, "CONNECT %s:%s HTTP/1.0\r\n" "Host: %s\r\n" "%s\r\n%s\r\n" "\r\n", target.targethost, target.targetport, target.targethost, user_agent, NOCACHE);	/* remove header_auth! */

  thread_mem->request[len] = '\0';
  /* send */
  gettimeofday (start, NULL);
  numbytes =
    write (sockfd, thread_mem->request, strlen (thread_mem->request));
  pxfree ((void **) &(thread_mem->request));
  if (numbytes != len)
    {
      fprintf (stderr, "%s: PCONGET:write:Fail to write completely!\n",
	       progname);
      if (numbytes < 0)
	perror ("PCONGET:write:Write to myaddr");
      return -1;		/* ... */
    }

  /* read estab string */
  thread_mem->reply = pxmalloc (test.testconreplysize, thread_mem);
  if (thread_mem->reply == NULL)
    x_pthread_exit ((void *) &ret, thread_mem);
  memset (thread_mem->reply, 0, test.testconreplysize);
  p = thread_mem->reply;
  while (1)
    {
      numbytes =
	read (sockfd, p, test.testconreplysize - (p - thread_mem->reply) - 1);

      /* need repaired */
      gettimeofday (end, NULL);

      if (numbytes <= 0)
	{
	  if (debug)
	    fprintf (stderr, "%s: PCONGET:Reply to concon is wrong:%s\n",
		     progname, thread_mem->reply);
	  pxfree ((void **) &(thread_mem->reply));
	  return -1;
	}
      /* if(numbytes < strlen(CONNECT_SUCCESS))return -1; */
      if ((strstr (thread_mem->reply, CONNECT_SUCCESS0) != NULL)
	  || (strstr (thread_mem->reply, CONNECT_SUCCESS1) != NULL))
	break;
      p += numbytes;
      if ((p - thread_mem->reply) == test.testconreplysize - 1)
	{
	  thread_mem->reply[test.testconreplysize] = '\0';	/* no need ! */
	  if (debug)
	    fprintf (stderr, "%s: PCONGET:Reply to concon is wrong:%s\n",
		     progname, thread_mem->reply);
	  pxfree ((void **) &(thread_mem->reply));
	  return -1;
	}
    }

  pxfree ((void **) &(thread_mem->reply));

  return GET (sockfd, req, thread_mem);
}
