/* C code produced by gperf version 2.7.2 */
/* Command-line: /usr/local/bin/gperf -k'1,2,6,7,11,13,$' -t /home/gray/radius-0.96-series/radiusd/./config.kw  */
/* This file is part of GNU RADIUS.
   Copyright (C) 2000,2001, Sergey Poznyakoff
  
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif
#include <syslog.h>
#include <radiusd.h>
#include <log.h>
#include <config_tok.h>
#define _Y(x) (int)(x)

struct conf_tok {
	char *name;
	int token;
	YYSTYPE lval;
};

#define TOTAL_KEYWORDS 90
#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 23
#define MIN_HASH_VALUE 2
#define MAX_HASH_VALUE 324
/* maximum key range = 323, duplicates = 0 */

#ifdef __GNUC__
__inline
#else
#ifdef __cplusplus
inline
#endif
#endif
static unsigned int
hash (str, len)
     register const char *str;
     register unsigned int len;
{
  static unsigned short asso_values[] =
    {
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325,   0, 325, 325,   5,  10,
       15,  25,  30,  35,  50,  45, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325,   5, 325,  72,
       20,   0,  10,  15, 100,   0, 325,   0,  35,  60,
      100,   0,  40,   0,   0,   0,  12,  75,   0,   5,
       55,  40, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325, 325, 325, 325, 325,
      325, 325, 325, 325, 325, 325
    };
  register int hval = len;

  switch (hval)
    {
      default:
      case 13:
        hval += asso_values[(unsigned char)str[12]];
      case 12:
      case 11:
        hval += asso_values[(unsigned char)str[10]];
      case 10:
      case 9:
      case 8:
      case 7:
        hval += asso_values[(unsigned char)str[6]];
      case 6:
        hval += asso_values[(unsigned char)str[5]];
      case 5:
      case 4:
      case 3:
      case 2:
        hval += asso_values[(unsigned char)str[1]];
      case 1:
        hval += asso_values[(unsigned char)str[0]];
        break;
    }
  return hval + asso_values[(unsigned char)str[len - 1]];
}

#ifdef __GNUC__
__inline
#endif
struct conf_tok *
in_word_set (str, len)
     register const char *str;
     register unsigned int len;
{
  static struct conf_tok wordlist[] =
    {
      {""}, {""},
      {"ro", T_SNMP_ACCESS, _Y(SNMP_RO)},
      {"err", T_SEVERITY, _Y(L_ERR)},
      {""},
      {"error", T_SEVERITY, _Y(L_ERR)},
      {""}, {""}, {""}, {""}, {""}, {""},
      {"rw", T_SNMP_ACCESS, _Y(SNMP_RW)},
      {""},
      {"file", T_FILE,},
      {"read_write", T_SNMP_ACCESS, _Y(SNMP_RW)},
      {""}, {""}, {""}, {""}, {""},
      {"realm-quota", T_MESGDEF, _Y(MSG_REALM_QUOTA)},
      {""},
      {"off", T_BOOL, _Y(0)},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"time-to-live", T_TTL},
      {"ident", T_IDENT},
      {""}, {""},
      {"debug", T_SEVERITY, _Y(L_DEBUG)},
      {""},
      {"log-dir", T_LOG_DIR},
      {"yes", T_BOOL, _Y(1)},
      {""},
      {"retry", T_RETRY},
      {""}, {""}, {""},
      {"source-ip", T_SOURCE_IP},
      {"allow", T_ALLOW,},
      {"local0", T_FACILITY, _Y(LOG_LOCAL0)},
      {""},
      {"log", T_LOGGING},
      {""}, {""},
      {"port", T_PORT},
      {"alert", T_SEVERITY, _Y(L_ALERT)},
      {""},
      {"load", T_LOAD,},
      {""},
      {"local1", T_FACILITY, _Y(LOG_LOCAL1)},
      {""}, {""},
      {"deny", T_DENY,},
      {"delay", T_DELAY },
      {""},
      {"print-failed-pass", T_LOGLEVEL, _Y(RLOG_FAILED_PASS)},
      {""}, {""}, {""},
      {"local2", T_FACILITY, _Y(LOG_LOCAL2)},
      {""}, {""}, {""},
      {"level", T_LEVEL,},
      {"syslog", T_SYSLOG},
      {""}, {""},
      {"user", T_FACILITY, _Y(LOG_USER)},
      {"emerg", T_SEVERITY, _Y(L_EMERG),},
      {""},
      {"message", T_MESSAGE},
      {""}, {""},
      {"proxy", T_PROXY},
      {""}, {""},
      {"crit", T_SEVERITY, _Y(L_CRIT)},
      {"max-requests", T_MAX_REQUESTS},
      {"print-pass", T_LOGLEVEL, _Y(RLOG_AUTH_PASS)},
      {"local3", T_FACILITY, _Y(LOG_LOCAL3)},
      {""},
      {"acct", T_ACCT},
      {""},
      {"guile", T_GUILE,},
      {"detail", T_DETAIL},
      {""}, {""}, {""}, {""},
      {"local4", T_FACILITY, _Y(LOG_LOCAL4)},
      {"no", T_BOOL, _Y(0),},
      {""},
      {"info", T_SEVERITY, _Y(L_INFO),},
      {"acct-dir", T_ACCT_DIR},
      {"notice", T_SEVERITY, _Y(L_NOTICE)},
      {"network", T_NETWORK,},
      {""},
      {"print-pid", T_LOGOPT, _Y(LO_PID)},
      {""},
      {"local5", T_FACILITY, _Y(LOG_LOCAL5)},
      {""}, {""}, {""},
      {"acl", T_ACL},
      {"host", T_HOST},
      {"exec-program-user", T_EXEC_PROGRAM_USER},
      {""}, {""}, {""},
      {"compare-attribute-flag", T_COMPARE_ATTRIBUTE_FLAG},
      {"print-cons", T_LOGOPT, _Y(LO_CONS)},
      {"strip-names", T_STRIP_NAMES},
      {""},
      {"category", T_CATEGORY,},
      {""}, {""}, {""}, {""},
      {"access-denied", T_MESGDEF, _Y(MSG_ACCESS_DENIED)},
      {"local7", T_FACILITY, _Y(LOG_LOCAL7)},
      {"second-login", T_MESGDEF, _Y(MSG_SECOND_LOGIN)},
      {""}, {""}, {""},
      {"password-expired", T_MESGDEF, _Y(MSG_PASSWORD_EXPIRED)},
      {""},
      {"password-expire-warning", T_EXPWARNING},
      {""}, {""},
      {"local6", T_FACILITY, _Y(LOG_LOCAL6)},
      {""}, {""},
      {"snmp", T_SNMP},
      {"spawn", T_SPAWN},
      {"print-priority", T_LOGOPT, _Y(LO_PRI)},
      {"warning", T_SEVERITY, _Y(L_WARN)},
      {""},
      {"read_only", T_SNMP_ACCESS, _Y(SNMP_RO)},
      {""}, {""}, {""}, {""}, {""},
      {"print-auth", T_LOGLEVEL, _Y(RLOG_AUTH)},
      {"print-level", T_LOGOPT, _Y(LO_PRI),},
      {""},
      {"exec-program-group", T_EXEC_PROGRAM_GROUP},
      {"usr2delay", T_USR2DELAY},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"aceclientip", T_ACECLIENTIP},
      {"main", T_MAIN,},
      {""}, {""},
      {"logging", T_LOGGING, },
      {"request-cleanup-delay", T_REQUEST_CLEANUP_DELAY},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"print-category", T_LOGOPT, _Y(LO_CAT)},
      {""}, {""},
      {"auth", T_AUTH,},
      {""},
      {"notify", T_NOTIFY},
      {""}, {""},
      {"load-path", T_LOAD_PATH,},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"usedbm", T_USEDBM},
      {"on", T_BOOL, _Y(1)},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"timespan-violation", T_MESGDEF, _Y(MSG_TIMESPAN_VIOLATION)},
      {"cntl", T_CNTL},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"community", T_COMMUNITY},
      {""},
      {"account-closed", T_MESGDEF, _Y(MSG_ACCOUNT_CLOSED)},
      {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"daemon", T_FACILITY, _Y(LOG_DAEMON),},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {"listen", T_LISTEN,},
      {""}, {""}, {""}, {""},
      {"option", T_OPTION},
      {""}, {""},
      {"channel", T_CHANNEL},
      {""}, {""}, {""}, {""},
      {"username-chars", T_USERNAME_CHARS},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""},
      {"checkrad-assume-logged", T_CHECKRAD_ASSUME_LOGGED},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""}, {""},
      {""}, {""},
      {"multiple-login", T_MESGDEF, _Y(MSG_MULTIPLE_LOGIN)}
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= 0)
        {
          register const char *s = wordlist[key].name;

          if (*str == *s && !strcmp (str + 1, s + 1))
            return &wordlist[key];
        }
    }
  return 0;
}

int
keyword()
{
	struct conf_tok *p = in_word_set(cclval.string,
					 strlen(cclval.string));
	if (p) {
		cclval = p->lval;
		return p->token;
	}
	return T_STRING;
}
