/* -*- Mode: Java; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*- 
 * $Id: Field.java,v 1.1 2000/02/11 22:08:18 metlov Exp $
 *
 * This file is part of the Java Expressions Library (JEL).
 *   For more information about JEL visit :
 *    http://galaxy.fzu.cz/JEL/
 *
 * (c) 1998 -- 2000 by Konstantin Metlov(metlov@fzu.cz);
 *
 * JEL is Distributed under the terms of GNU General Public License.
 *    This code comes with ABSOLUTELY NO WARRANTY.
 *  For license details see COPYING file in this directory.
 */

package gnu.jel.reflect;

import gnu.jel.debug.Debug;

/**
 * Represents a field of already compiled class.
 */
public class Field extends LocalField {
    java.lang.reflect.Field f;
    
  /**
   * Constructs a new field object.
   * @param f is corresponding <TT>java.lang.reflect.Field</TT> object.
   */
  public Field(java.lang.reflect.Field f) {
    super(f.getModifiers(),f.getType(),f.getName(),null);
    this.f=f;
  };

  public Class getDeclaringClass() {
	return f.getDeclaringClass();
  };

  public Object eval(Object obj,Object[] params) throws Exception {
	return f.get(obj);
  };

};
