
/*
 *  Tokenize a string, like "sh".  Viz., quoted strings are
 *  taken as a single token.
 *
 *  $Id: tokenize.h,v 2.2 1999/10/05 17:15:43 bkorb Exp $
 *
 *  NB:  Backslashes are *always* stripped out of quoted text,
 *       even in single quote strings.  If they represent an
 *       escape sequence, then that character is substituted.
 *
 *  ALSO:  in unquoted text, backslashes are *never* stripped out.
 *
 *  EXAMPLE:
 *      ABC" def '"GHI"' jkl '" as\dt "\t\n\x"
 *
 *  RESULT:
 *      token 1:  ABC def 'GHI' jkl '
 *      token 2:  as\dt
 *      token 3:  \t\nx
 *
 *  NOTE:  token 1 the single quotes to not participate in the quoting
 *         token 2 includes the backslash character
 *         token 3 consists of three characters:  tab, newline and 'x'.
 */

/*
 *  Type Pointer to Zero-terminated string
 */
typedef char*  tpz;

/*
 *  Type Array of Pointers to Zero-terminated strings
 */
typedef tpz    tapz[1];

/*
 *  Type Pointer to Array of Pointers to Zero-...
 */
typedef tpz*   tpapz;

#undef u_int
#define u_int unsigned int

/*
 *  tokenize
 *
 *  This routine will convert the input string (pzStr) into
 *  tokens.  Quoted strings will have the quotes stripped.
 */
    int
tokenize( char* pzStr, int tokCt, tpapz papzTokens );

/*
 *  doEscapeChar
 *
 *  Figures out what character to insert into the output buffer
 *  and how much to increment the scan pointer.  Usually, it is one,
 *  but the hex and octal conversions often require three characters.
 */
    u_int
doEscapeChar( char* pzIn, char* pRes );
/* end of tokenize.h */
