{(   -*- nroff -*-
autogen template man=%s.1
)}
{(
## ---------------------------------------------------------------------
## agman1.tpl -- Template for command line man pages
## 
##  AutoOpts copyright 1992-1999 Bruce Korb
## 
## Author:          Jim Van Zandt <jrv@vanzandt.mv.com>
## Maintainer:      Bruce Korb <bkorb@gnu.org>
## Created:         Mon Jun 28 15:35:12 1999
## Last Modified:     Tue Aug  3 15:43:56 1999				      
##            by:     Bruce Korb <bkorb@gnu.org>			      
## ---------------------------------------------------------------------
## $Id: agman1.tpl,v 2.5 1999/08/03 22:44:27 bkorb Exp $
## ---------------------------------------------------------------------

1999-06-26 original version, Jim Van Zandt <jrv@vanzandt.mv.com>
1999-06-28 modified to be template  Bruce Korb <bkorb@gnu.org>
1999-07-04 nroff tweaks, Jim Van Zandt <jrv@vanzandt.mv.com>

## Code:
)}.TH {(prog_name _up)} 1 {(
  _EVAL "date +%Y-%m-%d" _shell)} "" "Programmer's Manual"
{(

_EVAL '.\"  ' _DNE

)}
.\"
.SH NAME
{(prog_name _down)} \- {(prog_title)}
.SH SYNOPSIS{(

      # * * * * * * * * * * * * * * * * * * * * * * * * *
      #
      #  Display the command line prototype,
      #  based only on the argument processing type.
      #
      )}
.B {(
  _IF prog_file_name _exist )}{(prog_file_name)}{(
  _ELSE)}{(prog_name _down)}{(
  _ENDIF)}{(

  _IF flag.value _exist )}{(
    _IF long_opts _exist )}{(

      # * * * * *
      #
      )}
.\" Mixture of short (flag) options and long options
.RB [ -\fIflag\fP " [\fIvalue\fP]]... [" --\fIopt-name\fP " [[=| ]\fIvalue\fP]]..."{(

    _ELSE )}{(

      # * * * * *
      #
      )}
.\" Short (flag) options only
.RB [ -\fIflag\fP " [\fIvalue\fP]]..."{(
    _ENDIF )}{(

  _ELIF long_opts _exist )}{(

      # * * * * *
      #
      )}
.\" Long options only
.RB [ --\fIopt-name\fP [ = "| ] \fIvalue\fP]]..."{(

  _ELIF argument _exist ! )}{(

      # * * * * *
      #
      )}
.\" All arguments are named options.
.RI [ opt-name "[\fB=\fP" value ]]...
.PP
All arguments are named options.{(

  _ELSE )}{(
    _ERROR "Named option programs cannot have arguments" )}{(
  _ENDIF )}{(

  _IF argument _exist )}
.br
.in +8
{(argument)}{(
  _ELIF long_opts _exist flag.value _exist | )}
.PP
All arguments must be options.{(
  _ENDIF )}{(

      # * * * * * * * * * * * * * * * * * * * * * * * * *
      #
      #  Describe the command.  Use 'prog_man_desrip' if it exists,
      #  otherwise use the 'detail' help option.  If not that,
      #  then the thing is undocumented.
      #
      )}
.SH "DESCRIPTION"
This manual page documents, briefly, the \fB{(prog_name _down)}\fP command.
{(
_IF prog_man_descrip _exist
    )}{(prog_man_descrip)}{(
_ELIF detail _exist
    )}{(detail)}{(
_ELSE
    )}Its description is not documented.{(
_ENDIF)}
.SH OPTIONS{(

# * * * * * * * * * * * * * * * * * * * * * * * * *
#
   Describe each option

)}{(

_FOR flag

)}{(
  #  Skip the documentation options!
  #
  )}{(
  _IF documentation _exist ! )}
.TP{(
      _IF value _exist )}{(
        _IF long_opts _exist )}{(

          # * * * * * * * * * * * * * * * * * * * *
          *
          *  The option has a flag value (character) AND
          *  the program uses long options
          *
          )}
.BR -{(value)}{(
          _IF arg_name _exist ! )} ", " --{(
          _ELSE )} " \fI{(arg_name)}\fP, " --{(
          _ENDIF )}{(name #_^ #-- _tr _down)}{(
          _IF arg_name _exist)}{(
            _IF flag_arg _len 0 = )} [ ={(
            _ELSE )} "=" {(
            _ENDIF )}\fI{(arg_name)}\fP{(
            _IF flag_arg _len 0 = )} ]{(
            _ENDIF )}{(
          _ENDIF)}{(


        _ELSE   )}{(

          # * * * * * * * * * * * * * * * * * * * *
          *
          *  The option has a flag value (character) BUT
          *  the program does _NOT_ use long options
          *
          )}
.BR -{(value)}{(
          _IF arg_name _exist)}{(
            _IF flag_arg _len 0 = )}[{(
            _ENDIF )} "\fI{(arg_name)}\fP{(
            _IF flag_arg _len 0 = )}"]"{(
            _ENDIF )}{(
          _ENDIF)}{(
        _ENDIF  )}{(


      _ELSE  value does not exist -- named option only  )}{(

        _IF long_opts _exist ! )}{(

          # * * * * * * * * * * * * * * * * * * * *
          *
          *  The option does not have a flag value (character).
          *  The program does _NOT_ use long options either.
          *  Special magic:  All arguments are named options.
          *
          )}
.BR {(name #_^ #-- _tr _down)}{(
        _IF arg_name _exist)} {(
          _IF flag_arg _len 0 = )} [ ={(
          _ELSE )} "=" {(
          _ENDIF )}\fI{(arg_name)}\fP{(
          _IF flag_arg _len 0 = )}]{(
          _ENDIF )}{(
        _ENDIF)}{(


        _ELSE   )}{(

          # * * * * * * * * * * * * * * * * * * * *
          *
          *  The option does not have a flag value (character).
          *  The program, instead, only accepts long options.
          *
          )}
.BR --{(name #_^ #-- _tr _down)}{(
          _IF arg_name _exist)} "{(
            _IF flag_arg _len 0 = )}[{(
            _ENDIF )}=\fI{(arg_name)}\fP{(
            _IF flag_arg _len 0 = )}]{(
            _ENDIF )}"{(
          _ENDIF)}{(
        _ENDIF  )}{(
      _ENDIF )}
{(descrip)}{(
      _IF min           _exist
          max           _exist |
          enabled       _exist |
          no_preset     _exist |
          setable       _exist |
          equivalence   _exist |
          flags_must    _exist |
          flags_cant    _exist | )}.
Special attributes apply to this option.
See the invocation section in the info document.{(
      _ENDIF)}
.sp
{( # SED
   -e convert @code into \fB...\fP phrases
   -e convert @file into \fI...\fP phrases
   -e convert @var into \fB...\fP phrases
   -e Remove the '@' prefix from curly braces
   -e Indent example regions
   -e Delete example command
   -e Replade "end example" command with ".br"
   -e Replace "@*" command with ".br"

   NB:  backslashes are interpreted three times: by AutoGen, sed and nroff.
        Thus, for nroff to see one backslash, use four (4)!!

   ))}{(
doc "sed \
 -e 's;@code{\\([^}]*\\)\};\\\\fB\\1\\\\fP;g' \
 -e 's;@file{\\([^}]*\\)\};\\\\fI\\1\\\\fP;g' \
 -e 's;@var{\\([^}]*\\)\};\\\\fB\\1\\\\fP;g' \
 -e 's/@\\([{}]\\)/\\1/' \
 -e '/@ *example/,/@ *end *example/s/^/    /' \
 -e '/^ *@ *example/d' \
 -e 's/^ *@ *end *example/.br/' \
 -e 's/^@\\*/.br/' <<'_EOF_'\n%s\n_EOF_"
    _printf _shell )}{(

  _ENDIF documentation _exist ! )}{(

/flag


)}
.TP
.BR {(_IF flag.value _exist)}\-? , " --{(
      _ELIF long_opt _exist)}--{(_ENDIF)}help
Display usage information and exit.
.TP
.BR {(_IF flag.value _exist)}-! , " --{(
      _ELIF long_opt _exist)}--{(_ENDIF)}more-help
Extended usage information passed thru pager.{(


_IF homerc _exist )}
.TP
.BR {(_IF flag.value _exist)}-> " \fIrcfile\fP, --" {(
      _ELIF long_opt _exist)}--{(_ENDIF)}save-opts "[=\fIrcfile\fP] 
Save the option state to \fIrcfile\fP.
.TP
.BR {(_IF flag.value _exist)}-< " \fIrcfile\fP, --" {(
      _ELIF long_opt _exist)}--{(_ENDIF)}load-opts "=\fIrcfile\fP"
Load options from \fIrcfile\fP.
.TP
.BR  --no-load-opts
Disable loading options from an rc file.{(
_ENDIF)}{(


_IF version _exist )}
.TP
.BR {(_IF flag.value _exist)}\-v " \fI[v|c|n]\fP, " --{(
      _ELIF long_opt _exist)}--{(_ENDIF)}version "\fI[=v|c|n]\fP"
Output version of program and exit.  The default mode is `v', a simple
version.  The `c' mode will print copyright information and `n' will
print the full copyright notice.{(
_ENDIF


)}{(
_IF explain _exist )}
.PP
{(explain)}{(
_ENDIF)}{(
_IF man_doc _exist )}
{(man_doc)}{(
_ENDIF)}
.SH AUTHOR
{(owner)}{(eaddr "# <%s>" _printf)}
.PP
This manual page was \fIAutoGen\fP-erated from the \fB{(prog_name)}\fP
option definitions.{(

agman.tpl ends here  )}
