"=====================================================================
|
|   PosgreSQL DBI driver - PGColumnInfo class
|
|
 ======================================================================"

"======================================================================
|
| Copyright 2006 Mike Anderson
| Written by Mike Anderson
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
|
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
|
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LIB.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02110-1301, USA.
|
 ======================================================================
"



ColumnInfo subclass: PGColumnInfo [
    | resultSet index cname ctype csize |
    
    <comment: nil>
    <category: 'DBI-Framework'>

    TypeNames := nil.
    TypeConversions := nil.

    PGColumnInfo class >> in: aResultSet at: aIndex [
	<category: 'instance creation'>
	^self new in: aResultSet at: aIndex
    ]

    PGColumnInfo class >> convertBool: aRaw [
	<category: 'type conversions'>
	^#(true false) at: ('tf' indexOf: (aRaw at: 1) ifAbsent: [^nil])
    ]

    PGColumnInfo class >> convertNumber: aRaw [
	<category: 'type conversions'>
	^Number readFrom: (ReadStream on: aRaw)
    ]

    PGColumnInfo class >> convertPoint: aRaw [
	<category: 'type conversions'>
	^aRaw	"FIXME"
    ]

    PGColumnInfo class >> convertDate: aRaw [
	<category: 'type conversions'>
	^Date readFrom: (ReadStream on: aRaw)
    ]

    PGColumnInfo class >> convertTime: aRaw [
	<category: 'type conversions'>
	^Time readFrom: (ReadStream on: aRaw)
    ]

    PGColumnInfo class >> convertDateTime: aRaw [
	<category: 'type conversions'>
	^DateTime readFrom: (ReadStream on: aRaw)
    ]

    PGColumnInfo class >> convertTimeInterval: aRaw [
	<category: 'type conversions'>
	^aRaw	"FIXME"
    ]

    PGColumnInfo class >> initTypes [
	"Generated by extract_types.st; conversion routines added manually."

	<category: 'type conversions'>
	TypeNames := LookupTable new.
	TypeConversions := LookupTable new.
	#(#(#bool 16 #convertBool:)
		"boolean, 'true'/'false'"
	  #(#bytea 17)
		"variable-length string, binary values escaped"
	  #(#char 18)
		"single character"
	  #(#name 19)
		"63-character type for storing system identifiers"
	  #(#int8 20 #convertNumber:)
		"~18 digit integer, 8-byte storage"
	  #(#int2 21 #convertNumber:)
		"-32 thousand to 32 thousand, 2-byte storage"
	  #(#int2vector 22 #convertNumber:)
		"array of INDEX_MAX_KEYS int2 integers, used in system tables"
	  #(#int4 23 #convertNumber:)
		"-2 billion to 2 billion integer, 4-byte storage"
	  #(#regproc 24)
		"registered procedure"
	  #(#text 25)
		"variable-length string, no limit specified"
	  #(#oid 26 #convertNumber:)
		"object identifier(oid), maximum 4 billion"
	  #(#tid 27)
		"(Block, offset), physical location of tuple"
	  #(#xid 28 #convertNumber:)
		"transaction id"
	  #(#cid 29)
		"command identifier type, sequence in transaction id"
	  #(#oidvector 30)
		"array of INDEX_MAX_KEYS oids, used in system tables"
	  #(#smgr 210)
		"storage manager"
	  #(#point 600 #convertPoint:)
		"geometric point '(x, y)'"
	  #(#lseg 601)
		"geometric line segment '(pt1,pt2)'"
	  #(#path 602)
		"geometric path '(pt1,...)'"
	  #(#box 603)
		"geometric box '(lower left,upper right)'"
	  #(#polygon 604)
		"geometric polygon '(pt1,...)'"
	  #(#line 628)
		"geometric line (not implemented)'"
	  #(#float4 700 #convertNumber:)
		"single-precision floating point number, 4-byte storage"
	  #(#float8 701 #convertNumber:)
		"double-precision floating point number, 8-byte storage"
	  #(#abstime 702)
		"absolute, limited-range date and time (Unix system time)"
	  #(#reltime 703)
		"relative, limited-range time interval (Unix delta time)"
	  #(#tinterval 704)
		"(abstime,abstime), time interval"
	  #(#unknown 705)
		"geometric circle '(center,radius)'"
	  #(#circle 718)
		"monetary amounts, $d,ddd.cc"
	  #(#money 790 #convertNumber:)
		"XX:XX:XX:XX:XX:XX, MAC address"
	  #(#macaddr 829)
		"IP address/netmask, host address, netmask optional"
	  #(#inet 869)
		"network IP address/netmask, network address"
	  #(#cidr 650)

	  #(#aclitem 1033)
		"access control list"
	  #(#bpchar 1042)
		"char(length), blank-padded string, fixed storage length"
	  #(#varchar 1043)
		"varchar(length), non-blank-padded string, variable storage length"
	  #(#date 1082 #convertDate:)
		"ANSI SQL date"
	  #(#time 1083 #convertTime:)
		"hh:mm:ss, ANSI SQL time"
	  #(#timestamp 1114 #convertDateTime:)
		"date and time"
	  #(#timestamptz 1184 #convertDateTime:)
		"date and time with time zone"
	  #(#interval 1186 #convertTimeInterval:)
		"@ <number> <units>, time interval"
	  #(#timetz 1266 #convertTime:)
		"hh:mm:ss, ANSI SQL time"
	  #(#bit 1560)
		"fixed-length bit string"
	  #(#varbit 1562)
		"variable-length bit string"
	  #(#numeric 1700 #convertNumber:)
		"numeric(precision, decimal), arbitrary precision number"
	  #(#refcursor 1790)
		"reference cursor (portal name)"
	  #(#regprocedure 2202)
		"registered procedure (with args)"
	  #(#regoper 2203)
		"registered operator"
	  #(#regoperator 2204)
		"registered operator (with args)"
	  #(#regclass 2205)
		"registered class"
	  #(#regtype 2206)) 
		"registered type"
	    do: 
		[:a | 
		TypeNames at: a second put: a first.
		a size > 2 ifTrue: [TypeConversions at: a first put: a third]]
    ]

    PGColumnInfo class >> printTypeNames [
	<category: 'type conversions'>
	TypeNames keysAndValuesDo: 
		[:k :v | 
		(Transcript << v << ' ')
		    << k;
		    nl]
    ]

    PGColumnInfo class >> typeFromOid: aOid [
	<category: 'type conversions'>
	^TypeNames at: aOid ifAbsent: ['#' , aOid printString]
    ]

    PGColumnInfo class >> convert: aRaw type: aType [
	<category: 'type conversions'>
	TypeConversions at: aType ifPresent: [:sel | ^self perform: sel with: aRaw].
	^aRaw
    ]

    in: aResultSet at: aIndex [
	<category: 'initialization'>
	resultSet := aResultSet.
	index := aIndex
    ]

    name [
	<category: 'accessing'>
	cname isNil ifTrue: [cname := resultSet columnAt: index].
	^cname
    ]

    index [
	<category: 'accessing'>
	^index
    ]

    type [
	<category: 'accessing'>
	ctype isNil ifTrue: [ctype := resultSet columnTypeAt: index].
	^ctype
    ]

    size [
	<category: 'accessing'>
	csize isNil ifTrue: [csize := resultSet columnSizeAt: index].
	^csize
    ]
]



Eval [
    PGColumnInfo initTypes
]
