"======================================================================
|
|   Smalltalk Gtk+ bindings (ordering header files).
|
 ======================================================================"


"======================================================================
|
| Copyright 2004 Free Software Foundation, Inc.
| Written by Mike Anderson and Paolo Bonzini.
|
| This file is part of the GNU Smalltalk class library.
|
| The GNU Smalltalk class library is free software; you can redistribute it
| and/or modify it under the terms of the GNU Lesser General Public License
| as published by the Free Software Foundation; either version 2.1, or (at
| your option) any later version.
| 
| The GNU Smalltalk class library is distributed in the hope that it will be
| useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser
| General Public License for more details.
| 
| You should have received a copy of the GNU Lesser General Public License
| along with the GNU Smalltalk class library; see the file COPYING.LESSER.
| If not, write to the Free Software Foundation, 59 Temple Place - Suite
| 330, Boston, MA 02111-1307, USA.  
|
 ======================================================================"

Object subclass: #IncludesScanner 
       instanceVariableNames: 'paths ordered processed'
       classVariableNames: ''
       poolDictionaries: ''
       category: 'Gtk-Building bindings'
!

!CharacterArray methodsFor: 'testing'!

isGName
    ^(#('g' 'atk' 'pango') anySatisfy: [ :each | self startsWith: each ])
! !

!SystemDictionary methodsFor: 'utility'!

readOutput: aCommand
    ^(FileDescriptor popen: aCommand dir: FileStream read) contents.
!

getenvNoFail: aName
    | r |
    r := Smalltalk getenv: aName.
    r notNil ifTrue: [ ^r ].
    self error: 'env var ', aName printString, ' is not set'.
! !

!IncludesScanner class methodsFor: 'instance creation'!

new
    ^super new initialize
! !

!IncludesScanner methodsFor: 'making'!

initialize
    ordered := OrderedCollection new.
    paths := OrderedCollection with: '.'.
    processed := Set new. "Same as order, but a set for faster lookup"
!

process: args
    args do: [ :arg |
	[ self processArgument: arg ]
	    ifCurtailed: [ ('while processing ', arg) displayNl ]
    ]!

processArgument: arg
    (arg startsWith: '-L') 
	ifTrue: [ ^self processLib: (arg copyFrom: 3) ].

    (arg startsWith: '-I')
	ifTrue: [ ^self processPath: (arg copyFrom: 3) ].

    self processFile: arg
!

processPath: aPath
    (paths includes: aPath) 
	ifFalse: [ paths add: aPath ].
!

processLib: aLib
    | cflags |
    "('""Adding paths from library: ', aLib, '""') displayNl."
    cflags := Smalltalk readOutput: ((Smalltalk getenvNoFail: 'PKG_CONFIG'),
				     ' --cflags ', aLib).
    cflags subStrings do: [ :each | 
	(each startsWith: '-I') 
	    ifTrue: [ | path | self processPath: (each copyFrom: 3) ].
    ].
!

processFile: aFileName
    | incs file |
    (processed includes: aFileName) ifTrue: [ ^self ].
    processed add: aFileName.
    file := self findFile: aFileName.
    incs := self scanForIncludes: file.
    incs do: [ :each | each isGName ifTrue: [ self processFile: each ] ].
    ordered add: file fullName.
!

findFile: aFile
    paths do: [ :each | | f |
	f := File name: (each, '/', aFile).
	f isReadable ifTrue: [ ^f ].
    ].
    paths do: [ :each | ('looked in ', each) displayNl ].
    self error: 'Can''t find: ', aFile printString.
!

scanForIncludes: aFile
    | fs r |
    fs := aFile readStream.
    r := Set new.
    [ fs atEnd ] 
	whileFalse: [ | line |
            line := fs nextLine trimSeparators.
	    (line startsWith: '#include') 
		ifTrue: [
		    line := (line copyFrom: 9) trimSeparators.
		    (line startsWith: '<') 
			ifTrue: [ r add: (line copyFrom: 2 to: (line indexOf: $>) - 1) ].
		].
	].
    ^r
!

printOrdered
    ordered do: [ :each | each displayNl ].
! !

[
    IncludesScanner new
	process: Smalltalk arguments;
	printOrdered ] ifCurtailed: [ ObjectMemory quit: 1 ]!
