/*
  File autogenerated by gengetopt version 2.12rc
  generated with the following command:
  gengetopt --no-handle-help --no-handle-error --input shishid.ggo --file-name shishid_cmd 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "shishid_cmd.h"

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  Network daemon for issuing Kerberos 5 tickets.\n"
  "\n"
  "Usage: %s [OPTIONS]...\n", CMDLINE_PARSER_PACKAGE);
  printf("\n");
  printf("  -h, --help                                  Print help and exit\n");
  printf("  -V, --version                               Print version and exit\n");
  printf("  -c, --configuration-file=FILE               Use specified configuration \n                                                file.\n");
  printf("  -l, --listen=[FAMILY:]ADDRESS:SERVICE/TYPE  Sockets to listen for queries \n                                                on.  Family is `IPv4' or \n                                                `IPv6', if absent the family \n                                                is decided by \n                                                gethostbyname(ADDRESS). An \n                                                address of `*' indicates all \n                                                addresses on the local host. \n                                                The default is \n                                                `IPv4:*:kerberos/udp, \n                                                IPv4:*:kerberos/tcp, \n                                                IPv6:*:kerberos/udp, \n                                                IPv6:*:kerberos/tcp'.\n");
  printf("  -u, --setuid=NAME                           After binding socket, set user \n                                                identity.\n");
  printf("  -v, --verbose                               Produce verbose output.\n                                                  (default=off)\n");
  printf("  -q, --quiet                                 Don't produce any diagnostic output.\n                                                  (default=off)\n");
}


static char *gengetopt_strdup (const char *s);

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int missing_required_options = 0;

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->configuration_file_given = 0 ;
  args_info->listen_given = 0 ;
  args_info->setuid_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->quiet_given = 0 ;
#define clear_args() { \
  args_info->configuration_file_arg = NULL; \
  args_info->listen_arg = NULL; \
  args_info->setuid_arg = NULL; \
  args_info->verbose_flag = 0;\
  args_info->quiet_flag = 0;\
}

  clear_args();

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "configuration-file",	1, NULL, 'c' },
        { "listen",	1, NULL, 'l' },
        { "setuid",	1, NULL, 'u' },
        { "verbose",	0, NULL, 'v' },
        { "quiet",	0, NULL, 'q' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVc:l:u:vq", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          if (args_info->help_given)
            {
              fprintf (stderr, "%s: `--help' (`-h') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->help_given = 1;
          return 0;

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'c':	/* Use specified configuration file..  */
          if (args_info->configuration_file_given)
            {
              fprintf (stderr, "%s: `--configuration-file' (`-c') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->configuration_file_given = 1;
          args_info->configuration_file_arg = gengetopt_strdup (optarg);
          break;

        case 'l':	/* Sockets to listen for queries on.  Family is `IPv4' or `IPv6', if absent the family is decided by gethostbyname(ADDRESS). An address of `*' indicates all addresses on the local host. The default is `IPv4:*:kerberos/udp, IPv4:*:kerberos/tcp, IPv6:*:kerberos/udp, IPv6:*:kerberos/tcp'..  */
          if (args_info->listen_given)
            {
              fprintf (stderr, "%s: `--listen' (`-l') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->listen_given = 1;
          args_info->listen_arg = gengetopt_strdup (optarg);
          break;

        case 'u':	/* After binding socket, set user identity..  */
          if (args_info->setuid_given)
            {
              fprintf (stderr, "%s: `--setuid' (`-u') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->setuid_given = 1;
          args_info->setuid_arg = gengetopt_strdup (optarg);
          break;

        case 'v':	/* Produce verbose output.\n.  */
          if (args_info->verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-v') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->verbose_given = 1;
          args_info->verbose_flag = !(args_info->verbose_flag);
          break;

        case 'q':	/* Don't produce any diagnostic output.\n.  */
          if (args_info->quiet_given)
            {
              fprintf (stderr, "%s: `--quiet' (`-q') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              return (EXIT_FAILURE);
            }
          args_info->quiet_given = 1;
          args_info->quiet_flag = !(args_info->quiet_flag);
          break;


        case 0:	/* Long option with no short option */

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          return (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */


  if ( missing_required_options )
    return (EXIT_FAILURE);

  return 0;
}
