/* PSPP - Comments for C files generated by REGRESSION's EXPORT subcommand.
   Copyright (C) 2005 Free Software Foundation, Inc.
   Written by Jason H Stover <jason@sakla.net>.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
   02110-1301, USA. */

/*
  Exported C code for a regression model. The EXPORT subcommand causes PSPP
  to save a model as a small C program. This file contains some of the code
  of that saved program.
 */
#ifndef REG_EXPORT_COMMENTS_H
#define REG_EXPORT_COMMENTS_H
const char reg_header[] = "#ifndef REG_EXPORT_COMMENTS_H\n#define REG_EXPORT_COMMENTS_H\n"
"double pspp_reg_estimate (const double *, const char *[]);\n\n"
"double pspp_reg_variance (const double *var_vals, const char *[]);\n\n"
"double pspp_reg_confidence_interval_U "
"(const double *var_vals, const char *var_names[], double p);\n\n"
"double pspp_reg_confidence_interval_L "
"(const double *var_vals, const char *var_names[], double p);\n\n"
"double pspp_reg_prediction_interval_U "
"(const double *var_vals, const char *var_names[], double p);\n\n"
"double pspp_reg_prediction_interval_L "
"(const double *var_vals, const char *var_names[], double p);\n"
"#endif\n";

const char reg_preamble[] =  "/*\n   This program contains functions which return estimates\n"
"   and confidence intervals for a linear model. The EXPORT subcommand\n"
"   of the REGRESSION procedure of GNU PSPP generated this program.\n*/\n\n"
"#include <string.h>\n#include <math.h>\n#define PSPP_REG_MAXLEN 1024\n\n";

const char reg_mean_cmt[] =  "/*\n   Estimate the mean of Y, the dependent variable for\n"
"   the linear model of the form \n\n"
"      Y = b0 + b1 * X1 + b2 * X2 + ... + bk * Xk + error\n\n"
"   where X1, ..., Xk are the independent variables\n"
"   whose values are stored in var_vals and whose names, \n"
"   as known by PSPP, are stored in var_names. The estimated \n"
"   regression coefficients (i.e., the estimates of b0,...,bk) \n"
"   are stored in model_coeffs.\n*/\n";

const char reg_getvar[] = "{\n\t\tj = pspp_reg_getvar (var_names[i]);\n"
"\t\testimate += var_vals[j] * model_coeffs[j];\n"
"\t}\n\t\n\treturn estimate;\n}\n\n"
"/*\n    Variance of an estimated mean of this form:\n\t"
"Y = b0 + b1 * X1 + ... + bk * Xk\n    where X1,...Xk are the dependent variables,"
" stored in\n    var_vals and b0,...,bk are the estimated regression coefficients.\n*/\n"
"double\npspp_reg_variance (const double *var_vals, "
"const char *var_names[])\n{\n\t";

const char reg_export_t_quantiles_1[] = "/*\n    Quantiles for the T distribution.\n*/\n"
"static int\npspp_reg_t_quantile "
"(double prob)\n{\n\n\tint i;\n\tdouble quantiles[] = {\n\t\t";

const char reg_export_t_quantiles_2[] = "i = (int) 100.0 * prob;\n\treturn quantiles[i];\n}\n";

const char reg_variance[] = "double result = 0.0;\n\n\tfor(i = 0; i < n_vars; i++)\n\t"
"{\n\t\tj = pspp_reg_getvar (var_names[i]);\n\t\t"
"unshuffled_vals[j] = var_vals[i];\n\t}\n\t"
"for (i = 0; i < n_vars; i++)\n\t"
"{\n\t\tresult += cov[i][i] * unshuffled_vals[i] * unshuffled_vals[i];\n\t\t"
"for (j = i + 1; j < n_vars; j++)\n\t\t{\n\t\t\t"
"result += 2.0 * cov[i][j] * unshuffled_vals[i] * unshuffled_vals[j];"
"\n\t\t}\n\t}\n\treturn result;\n}\n";

const char reg_export_confidence_interval[] = "/*\n    Upper confidence limit for an "
"estimated mean b0 + b1 * X1 + ... + bk * Xk.\n    The confidence interval is a "
"100 * p percent confidence interval.\n*/\n"
"double pspp_reg_confidence_interval_U "
"(const double *var_vals, const char *var_names[], double p)\n{\n\t"
"double result;\n\t"
"result = sqrt (pspp_reg_variance (var_vals, var_names));\n\t"
"result *= pspp_reg_t_quantile ((1.0 + p) / 2.0);\n\t"
"result += pspp_reg_estimate (var_vals, var_names);\n\treturn result;\n}\n"
"/*\n    Lower confidence limit for an "
"estimated mean b0 + b1 * X1 + ... + bk * Xk.\n    The confidence interval is a "
"100 * p percent confidence interval.\n*/\n"
"double pspp_reg_confidence_interval_L "
"(const double *var_vals, const char *var_names[], double p)\n{\n\t"
"double result;\n\t"
"result = -sqrt (pspp_reg_variance (var_vals, var_names));\n\t"
"result *= pspp_reg_t_quantile ((1.0 + p) / 2.0);\n\t"
"result += pspp_reg_estimate (var_vals, var_names);\n\treturn result;\n}\n";

const char reg_export_prediction_interval_1[] = "/*\n    Upper prediction limit for a "
"predicted value b0 + b1 * X1 + ... + bk * Xk.\n    The prediction interval is a "
"100 * p percent prediction interval.\n*/\n"
"double pspp_reg_prediction_interval_U "
"(const double *var_vals, const char *var_names[], double p)\n{\n\t"
"double result;\n\tresult = sqrt (";

const char reg_export_prediction_interval_2[] = " + pspp_reg_variance (var_vals, var_names));\n"
"\tresult *= pspp_reg_t_quantile ((1.0 + p) / 2.0);\n\t"
"result += pspp_reg_estimate (var_vals, var_names);\n\treturn result;\n}\n"
"/*\n    Lower prediction limit for a "
"predicted value b0 + b1 * X1 + ... + bk * Xk.\n    The prediction interval is a "
"100 * p percent prediction interval.\n*/\n"
"double pspp_reg_prediction_interval_L "
"(const double *var_vals, const char *var_names[], double p)\n{\n\t"
"double result;\n\t"
"result = -sqrt (";

const char reg_export_prediction_interval_3[] = " + pspp_reg_variance (var_vals, var_names));"
"\n\tresult *= pspp_reg_t_quantile ((1.0 + p) / 2.0);\n\t"
"result += pspp_reg_estimate (var_vals, var_names);\n\treturn result;\n}\n";

/*
  Change categorical values to binary vectors. The routine will use
  an encoding in which a categorical variable with n values is mapped
  to a vector with n-1 entries. Value 0 is mapped to the zero vector,
  value 1 is mapped to a vector whose first entry is 1 and all others are
  0, etc. For example, if a variable can have 'a', 'b' or 'c' as values,
  then the value 'a' will be encoded as (0,0), 'b' as (1,0) and 'c' as
  (0,1). If the design matrix used to create the model used a different
  encoding, then the function pspp_reg_categorical_encode () will return
  a vector which does not match its categorical value in the model.
 */
const char reg_export_categorical_encode_1[] = "struct pspp_reg_categorical_variable\n"
"{\n\tchar * name;\n\tsize_t n_vals;\n\tchar *values[1024];\n};\n\n"
"/*\n   This function returns the binary vector which corresponds to the value\n"
"   of the categorical variable stored in 'value'. The name of the variable is\n"
"   stored in the 'var' argument. Notice the values stored in the\n"
"   pspp_categorical_variable structures all end with a space character.\n"
"   That means the values of the categorical variables you pass to any function\n"
"   in this program should also end with a space character.\n*/\n"
"static\ndouble * pspp_reg_get_value_vector (char *var, char *value)\n{\n\tdouble *result;\n\t"
"int i;\n\t";

const char reg_export_categorical_encode_2[] = "int v_index = 0;\n\t"
"while (v_index < n_vars && strncmp (var, varlist[i]->name, PSPP_REG_MAXLEN) != 0)\n\t{\n\t\t"
"v_index++;\n\t}\n\tresult = (double *) malloc (varlist[v_index]->n_vals * sizeof (*result));\n\t"
"for (i = 0; i < varlist[v_index]->n_vals; i++)\n\t{\n\t\t"
"if (strncmp ( (varlist[v_index]->values)[i], value, PSPP_REG_MAXLEN) == 0)\n\t\t{\n\t\t\t"
"result[i] = 1.0;\n\t\t}\n\t\telse result[i] = 0.0;\n\t}\n\n\t"
"return result;\n}\n\n";
#endif
