/* gsasl_cmd.h */

/* File autogenerated by gengetopt version 2.18  */

#ifndef GSASL_CMD_H
#define GSASL_CMD_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
#define CMDLINE_PARSER_PACKAGE PACKAGE
#endif

#ifndef CMDLINE_PARSER_VERSION
#define CMDLINE_PARSER_VERSION VERSION
#endif

struct gengetopt_args_info
{
  const char *help_help; /* Print help and exit help description.  */
  const char *version_help; /* Print version and exit help description.  */
  int client_flag;	/* Act as client. (default=on).  */
  const char *client_help; /* Act as client. help description.  */
  int server_flag;	/* Act as server. (default=off).  */
  const char *server_help; /* Act as server. help description.  */
  int client_mechanisms_flag;	/* Write name of supported client mechanisms separated by space to stdout. (default=off).  */
  const char *client_mechanisms_help; /* Write name of supported client mechanisms separated by space to stdout. help description.  */
  int server_mechanisms_flag;	/* Write name of supported server mechanisms separated by space to stdout. (default=off).  */
  const char *server_mechanisms_help; /* Write name of supported server mechanisms separated by space to stdout. help description.  */
  char * connect_arg;	/* Connect to TCP server and negotiate on stream instead of stdin/stdout. PORT is the protocol service, or an integer denoting the port, and defaults to 143 (imap) if not specified. Also sets the --hostname default..  */
  char * connect_orig;	/* Connect to TCP server and negotiate on stream instead of stdin/stdout. PORT is the protocol service, or an integer denoting the port, and defaults to 143 (imap) if not specified. Also sets the --hostname default. original value given at command line.  */
  const char *connect_help; /* Connect to TCP server and negotiate on stream instead of stdin/stdout. PORT is the protocol service, or an integer denoting the port, and defaults to 143 (imap) if not specified. Also sets the --hostname default. help description.  */
  int application_data_flag;	/* After authentication, read data from stdin and run it through the mechanism's security layer and print it base64 encoded to stdout. The default is to terminate after authentication. (default=on).  */
  const char *application_data_help; /* After authentication, read data from stdin and run it through the mechanism's security layer and print it base64 encoded to stdout. The default is to terminate after authentication. help description.  */
  int imap_flag;	/* Use a IMAP-like logon procedure (client only). Also sets the --service default to 'imap'. (default=off).  */
  const char *imap_help; /* Use a IMAP-like logon procedure (client only). Also sets the --service default to 'imap'. help description.  */
  int smtp_flag;	/* Use a SMTP-like logon procedure (client only). Also sets the --service default to 'smtp'. (default=off).  */
  const char *smtp_help; /* Use a SMTP-like logon procedure (client only). Also sets the --service default to 'smtp'. help description.  */
  char * mechanism_arg;	/* Mechanism to use..  */
  char * mechanism_orig;	/* Mechanism to use. original value given at command line.  */
  const char *mechanism_help; /* Mechanism to use. help description.  */
  int no_client_first_flag;	/* Disallow client to send data first (client only). (default=off).  */
  const char *no_client_first_help; /* Disallow client to send data first (client only). help description.  */
  char * anonymous_token_arg;	/* Token for anonymous authentication, usually mail address (ANONYMOUS only)..  */
  char * anonymous_token_orig;	/* Token for anonymous authentication, usually mail address (ANONYMOUS only). original value given at command line.  */
  const char *anonymous_token_help; /* Token for anonymous authentication, usually mail address (ANONYMOUS only). help description.  */
  char * authentication_id_arg;	/* Identity of credential owner..  */
  char * authentication_id_orig;	/* Identity of credential owner. original value given at command line.  */
  const char *authentication_id_help; /* Identity of credential owner. help description.  */
  char * authorization_id_arg;	/* Identity to request service for..  */
  char * authorization_id_orig;	/* Identity to request service for. original value given at command line.  */
  const char *authorization_id_help; /* Identity to request service for. help description.  */
  char * password_arg;	/* Password for authentication (insecure for non-testing purposes)..  */
  char * password_orig;	/* Password for authentication (insecure for non-testing purposes). original value given at command line.  */
  const char *password_help; /* Password for authentication (insecure for non-testing purposes). help description.  */
  char * realm_arg;	/* Realm. Defaults to hostname..  */
  char * realm_orig;	/* Realm. Defaults to hostname. original value given at command line.  */
  const char *realm_help; /* Realm. Defaults to hostname. help description.  */
  int maxbuf_arg;	/* Indicate maximum buffer size (DIGEST-MD5 only)..  */
  char * maxbuf_orig;	/* Indicate maximum buffer size (DIGEST-MD5 only). original value given at command line.  */
  const char *maxbuf_help; /* Indicate maximum buffer size (DIGEST-MD5 only). help description.  */
  char * passcode_arg;	/* Passcode for authentication (SECURID only)..  */
  char * passcode_orig;	/* Passcode for authentication (SECURID only). original value given at command line.  */
  const char *passcode_help; /* Passcode for authentication (SECURID only). help description.  */
  char * service_arg;	/* Set the requested service name (should be a registered GSSAPI host based service name)..  */
  char * service_orig;	/* Set the requested service name (should be a registered GSSAPI host based service name). original value given at command line.  */
  const char *service_help; /* Set the requested service name (should be a registered GSSAPI host based service name). help description.  */
  char * hostname_arg;	/* Set the name of the server with the requested service..  */
  char * hostname_orig;	/* Set the name of the server with the requested service. original value given at command line.  */
  const char *hostname_help; /* Set the name of the server with the requested service. help description.  */
  char * service_name_arg;	/* Set the generic server name in case of a replicated server (DIGEST-MD5 only)..  */
  char * service_name_orig;	/* Set the generic server name in case of a replicated server (DIGEST-MD5 only). original value given at command line.  */
  const char *service_name_help; /* Set the generic server name in case of a replicated server (DIGEST-MD5 only). help description.  */
  int enable_cram_md5_validate_flag;	/* Validate CRAM-MD5 challenge and response interactively. (default=off).  */
  const char *enable_cram_md5_validate_help; /* Validate CRAM-MD5 challenge and response interactively. help description.  */
  int disable_cleartext_validate_flag;	/* Disable cleartext validate hook, forcing server to prompt for password. (default=off).  */
  const char *disable_cleartext_validate_help; /* Disable cleartext validate hook, forcing server to prompt for password. help description.  */
  char * quality_of_protection_arg;	/* How application payload will be protected. 'auth' means no protection, 'auth-int' means integrity protection, 'auth-conf' means integrity and confidentialiy protection.  Currently only used by DIGEST-MD5, where the default is 'auth-conf'..  */
  char * quality_of_protection_orig;	/* How application payload will be protected. 'auth' means no protection, 'auth-int' means integrity protection, 'auth-conf' means integrity and confidentialiy protection.  Currently only used by DIGEST-MD5, where the default is 'auth-conf'. original value given at command line.  */
  const char *quality_of_protection_help; /* How application payload will be protected. 'auth' means no protection, 'auth-int' means integrity protection, 'auth-conf' means integrity and confidentialiy protection.  Currently only used by DIGEST-MD5, where the default is 'auth-conf'. help description.  */
  int starttls_flag;	/* Force use of STARTTLS.  The default is to use STARTTLS when available. (default=off).  */
  const char *starttls_help; /* Force use of STARTTLS.  The default is to use STARTTLS when available. help description.  */
  int no_starttls_flag;	/* Unconditionally disable STARTTLS. (default=off).  */
  const char *no_starttls_help; /* Unconditionally disable STARTTLS. help description.  */
  char * x509_ca_file_arg;	/* File containing one or more X.509 Certificate Authorities certificates in PEM format, used to verify the certificate received from the server.  If not specified, no verification of the remote server certificate will be done..  */
  char * x509_ca_file_orig;	/* File containing one or more X.509 Certificate Authorities certificates in PEM format, used to verify the certificate received from the server.  If not specified, no verification of the remote server certificate will be done. original value given at command line.  */
  const char *x509_ca_file_help; /* File containing one or more X.509 Certificate Authorities certificates in PEM format, used to verify the certificate received from the server.  If not specified, no verification of the remote server certificate will be done. help description.  */
  char * x509_cert_file_arg;	/* File containing client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair..  */
  char * x509_cert_file_orig;	/* File containing client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair. original value given at command line.  */
  const char *x509_cert_file_help; /* File containing client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair. help description.  */
  char * x509_key_file_arg;	/* Private key for the client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair..  */
  char * x509_key_file_orig;	/* Private key for the client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair. original value given at command line.  */
  const char *x509_key_file_help; /* Private key for the client X.509 certificate in PEM format.  Used together with --x509-key-file to specify the certificate/key pair. help description.  */
  int verbose_flag;	/* Produce verbose output. (default=off).  */
  const char *verbose_help; /* Produce verbose output. help description.  */
  int quiet_flag;	/* Don't produce any diagnostic output. (default=off).  */
  const char *quiet_help; /* Don't produce any diagnostic output. help description.  */
  
  int help_given ;	/* Whether help was given.  */
  int version_given ;	/* Whether version was given.  */
  int client_given ;	/* Whether client was given.  */
  int server_given ;	/* Whether server was given.  */
  int client_mechanisms_given ;	/* Whether client-mechanisms was given.  */
  int server_mechanisms_given ;	/* Whether server-mechanisms was given.  */
  int connect_given ;	/* Whether connect was given.  */
  int application_data_given ;	/* Whether application-data was given.  */
  int imap_given ;	/* Whether imap was given.  */
  int smtp_given ;	/* Whether smtp was given.  */
  int mechanism_given ;	/* Whether mechanism was given.  */
  int no_client_first_given ;	/* Whether no-client-first was given.  */
  int anonymous_token_given ;	/* Whether anonymous-token was given.  */
  int authentication_id_given ;	/* Whether authentication-id was given.  */
  int authorization_id_given ;	/* Whether authorization-id was given.  */
  int password_given ;	/* Whether password was given.  */
  int realm_given ;	/* Whether realm was given.  */
  int maxbuf_given ;	/* Whether maxbuf was given.  */
  int passcode_given ;	/* Whether passcode was given.  */
  int service_given ;	/* Whether service was given.  */
  int hostname_given ;	/* Whether hostname was given.  */
  int service_name_given ;	/* Whether service-name was given.  */
  int enable_cram_md5_validate_given ;	/* Whether enable-cram-md5-validate was given.  */
  int disable_cleartext_validate_given ;	/* Whether disable-cleartext-validate was given.  */
  int quality_of_protection_given ;	/* Whether quality-of-protection was given.  */
  int starttls_given ;	/* Whether starttls was given.  */
  int no_starttls_given ;	/* Whether no-starttls was given.  */
  int x509_ca_file_given ;	/* Whether x509-ca-file was given.  */
  int x509_cert_file_given ;	/* Whether x509-cert-file was given.  */
  int x509_key_file_given ;	/* Whether x509-key-file was given.  */
  int verbose_given ;	/* Whether verbose was given.  */
  int quiet_given ;	/* Whether quiet was given.  */

  char **inputs ; /* unamed options */
  unsigned inputs_num ; /* unamed options number */
} ;

extern const char *gengetopt_args_info_purpose;
extern const char *gengetopt_args_info_usage;
extern const char *gengetopt_args_info_help[];

int cmdline_parser (int argc, char * const *argv,
  struct gengetopt_args_info *args_info);
int cmdline_parser2 (int argc, char * const *argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

void cmdline_parser_print_help(void);
void cmdline_parser_print_version(void);

void cmdline_parser_init (struct gengetopt_args_info *args_info);
void cmdline_parser_free (struct gengetopt_args_info *args_info);

int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* GSASL_CMD_H */
