/* -*- c++ -*- */
/*
 * Copyright 2004 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

class gr_buffer;
typedef boost::shared_ptr<gr_buffer> gr_buffer_sptr;
%template(gr_buffer_sptr) boost::shared_ptr<gr_buffer>;

class gr_buffer_reader;
typedef boost::shared_ptr<gr_buffer_reader> gr_buffer_reader_sptr;
%template(gr_buffer_reader_sptr) boost::shared_ptr<gr_buffer_reader>;

%rename(buffer) gr_make_buffer;
gr_buffer_sptr gr_make_buffer (int nitems, size_t sizeof_item);

%rename(buffer_add_reader) gr_buffer_add_reader;
gr_buffer_reader_sptr gr_buffer_add_reader (gr_buffer_sptr buf);

%rename(buffer_ncurrently_allocated) gr_buffer_ncurrently_allocated;
long gr_buffer_ncurrently_allocated ();


%ignore gr_buffer;
class gr_buffer {
 public:
  ~gr_buffer ();

 private:
  friend class gr_buffer_reader;
  friend gr_buffer_sptr gr_make_buffer (int nitems, size_t sizeof_item);

  gr_buffer (int nitems, size_t sizeof_item);
};
  

%rename(buffer_reader_ncurrently_allocated) gr_buffer_reader_ncurrently_allocated;
long gr_buffer_reader_ncurrently_allocated ();

%ignore gr_buffer_reader;
class gr_buffer_reader {
 public:
  ~gr_buffer_reader ();

 private:
  friend class gr_buffer;
  gr_buffer_reader (gr_buffer_sptr buffer, unsigned int read_index);
};

