/* ------------------------------------------------------------------------- */
/* Raw2SS.c -- convert raw samples to ulaw (SparcStation Sound Format)       */
/* usage : Raw2SS <file-name> [<input-freq>]                                 */
/* Authors: Jean-Francois Giorgi & Thierry Leconte                           */
/*          giorgi@irisa.fr        leconte@irisa.fr                          */
/* routine cvt by :                                                          */
/*      Rich Gopstein and Harris Corporation                                 */
/* ------------------------------------------------------------------------- */

#include "types.h"
#include "gio.h"
#include "math.h"
#include "stdio.h"
#define OUT_FREQ 8192

BYTE *buf,*malloc(); 
int szBuf; 
ULONG fi = OUT_FREQ;

/* ------------------------------------------------------------------------- */
/* for routine 'cvt'
/************************************************************************/
/*      Copyright 1989 by Rich Gopstein and Harris Corporation          */
/************************************************************************/
unsigned int cvt(ch)
int ch;
{

  int mask;

  if (ch < 0) {
    ch = -ch;
    mask = 0x7f;
  } else {
    mask = 0xff;
  }

  if (ch < 32) {
    ch = 0xF0 | 15 - (ch / 2);
  } else if (ch < 96) {
    ch = 0xE0 | 15 - (ch - 32) / 4;
  } else if (ch < 224) {
    ch = 0xD0 | 15 - (ch - 96) / 8;
  } else if (ch < 480) {
    ch = 0xC0 | 15 - (ch - 224) / 16;
  } else if (ch < 992) {
    ch = 0xB0 | 15 - (ch - 480) / 32;
  } else if (ch < 2016) {
    ch = 0xA0 | 15 - (ch - 992) / 64;
  } else if (ch < 4064) {
    ch = 0x90 | 15 - (ch - 2016) / 128;
  } else if (ch < 8160) {
    ch = 0x80 | 15 - (ch - 4064) /  256;
  } else {
    ch = 0x80;
  }
return (mask & ch);
}
/* ------------------------------------------------------------------------- */
readin(fn)
char *fn;
{
  FILE *fin;
  int i;
 
  fin = fopen(fn,"r");
  if (fin == NULL) {
    fprintf(stderr,"couldn't access file %s\n",fn);
    exit();
  }
  fseek(fin,0,OFFSET_END);
  szBuf = ftell(fin);
  fseek(fin,0,OFFSET_BEGINNING);
  buf = malloc(szBuf);
  for(i=0;i<szBuf;i++) buf[i] = (BYTE) fgetc(fin);
  fclose(fin);
}


/* ------------------------------------------------------------------------- */
main(argc,argv)
int argc;
char **argv;
{

  double t,t1,t2,out;
  int n0,n1;
  ULONG f0 = OUT_FREQ;
  UBYTE ulaw;

  if ((argc != 2) && (argc != 3)) {
    fprintf(stderr,"Usage : %s <filename> [<samples-per-sec>]\n",argv[0]);
    exit();
  }

  readin(argv[1]);

  if (argc==3) fi = atoi(argv[2]);

  szBuf = (int)((double)szBuf * (double)f0 / (double)fi); 
  fprintf(stderr,"input freq   = %ld\n",fi);
  fprintf(stderr,"output freq  = %ld\n",f0);
  fprintf(stderr,"ouput lenght = %d\n",szBuf);

  for(n0=0;n0<szBuf;n0++) {

    t = (double)n0 / f0;
    n1 = (int)floor(t*fi);
    out = (double)(buf[n1+1]-buf[n1])*(double)fi*(t-((double)n1)/fi)+(double)buf[n1];

    ulaw=(UBYTE) cvt((int)(out*16));
    fputc(ulaw,stdout);
  }

}
/* ------------------------------------------------------------------------- */
