/* ------------------------------------------------------------------------- */
/* convert.c -- convertion routines                                          */
/* Authors: Jean-Francois Giorgi & Thierry Leconte                           */
/*          giorgi@irisa.fr        leconte@irisa.fr                          */
/* routine cvt by :                                                          */
/*      Rich Gopstein and Harris Corporation                                 */
/* ------------------------------------------------------------------------- */

#include "types.h"
#include "gio.h"
#include "math.h"
#define OUT_FREQ 8192
#define AMP_FACTOR 16

/* ------------------------------------------------------------------------- */
extern BYTE *buf; 
extern int szBuf; 
extern ULONG fi;

/* ------------------------------------------------------------------------- */
tomono()
{
  int i;
  printf("STEREO to MONO conversion\n");
  for(i=0;i<szBuf;i += 2) {
    buf[i] = (BYTE)(((int)buf[i] + (int)buf[i+1])/2); 
  }
  szBuf /= 2;
}

/* ------------------------------------------------------------------------- */
/* for 'cvt' only */
/************************************************************************/
/*      Copyright 1989 by Rich Gopstein and Harris Corporation          */
/*                                                                      */
/*      Permission to use, copy, modify, and distribute this software   */
/*      and its documentation for any purpose and without fee is        */
/*      hereby granted, provided that the above copyright notice        */
/*      appears in all copies and that both that copyright notice and   */
/*      this permission notice appear in supporting documentation, and  */
/*      that the name of Rich Gopstein and Harris Corporation not be    */
/*      used in advertising or publicity pertaining to distribution     */
/*      of the software without specific, written prior permission.     */
/*      Rich Gopstein and Harris Corporation make no representations    */
/*      about the suitability of this software for any purpose.  It     */
/*      provided "as is" without express or implied warranty.           */
/************************************************************************/
unsigned int cvt(ch)
int ch;
{

  int mask;

  if (ch < 0) {
    ch = -ch;
    mask = 0x7f;
  } else {
    mask = 0xff;
  }

  if (ch < 32) {
    ch = 0xF0 | 15 - (ch / 2);
  } else if (ch < 96) {
    ch = 0xE0 | 15 - (ch - 32) / 4;
  } else if (ch < 224) {
    ch = 0xD0 | 15 - (ch - 96) / 8;
  } else if (ch < 480) {
    ch = 0xC0 | 15 - (ch - 224) / 16;
  } else if (ch < 992) {
    ch = 0xB0 | 15 - (ch - 480) / 32;
  } else if (ch < 2016) {
    ch = 0xA0 | 15 - (ch - 992) / 64;
  } else if (ch < 4064) {
    ch = 0x90 | 15 - (ch - 2016) / 128;
  } else if (ch < 8160) {
    ch = 0x80 | 15 - (ch - 4064) /  256;
  } else {
    ch = 0x80;
  }
return (mask & ch);
}
      
/* ------------------------------------------------------------------------- */
convert(fout)
LONG fout;
{

  double t,t1,t2,out;
  int n0,n1;
  ULONG f0 = OUT_FREQ;

  UBYTE ulaw;

  szBuf = (int)((double)szBuf * (double)f0 / (double)fi); 
  /* printf("SZBUF = %d\n",szBuf);
  printf("FI    = %ld\n",fi); */
  for(n0=0;n0<szBuf;n0++) {

    t = (double)n0 / f0;
    n1 = (int)floor(t*fi);
    out = (double)(buf[n1+1]-buf[n1])*(double)fi*(t-((double)n1)/fi)+(double)buf[n1];

    ulaw=(UBYTE) cvt((int)(out*AMP_FACTOR));
    fputc(ulaw,fout);
  }

}
/* ------------------------------------------------------------------------- */
