#
#	Copyright'92, Alain Brossard, brossard@sic.epfl.ch
#
#	Copies a file into another one, prints out the error message if the
# third argument is true.
#	If the first argument is '-p' then the access time of the original
# file is kept
#	Returns the error string (true) if it fails
#	Returns false otherwise
#
sub cp {
    local( $keep_time, $time_a, $time_m, $mode );
    if( $_[0] eq '-p' ) { $keep_time = 1; shift; }
    local( $in, $out, $print ) = @_;
    if( ! open( IN, $in ) ) {
	if( $print ) { &print( "Couldn't open $in for reading.\n",
			"Incapable d'ouvrir $in pour la lecture.\n"); }
	return ("Couldn't open $in for reading.\n",
			"Incapable d'ouvrir $in pour la lecture.\n")[$lang];
    }
    if( $keep_time ) { ($mode, $time_a, $time_m) = ( stat IN )[2,8,9]; }
    if( ! open( OUT, ">$out" ) ) {
	close IN;
	if( $print ) { &print( "Couldn't open $out for writing.\n", 
			"Incapable d'ouvrir $out pour l'criture.\n"); }
	return ("Couldn't open $out for writing.\n",
			"Incapable d'ouvrir $out pour l'criture.\n")[$lang];
    }
    while( <IN> ) { print OUT; }
    close IN; close OUT;
    utime $time_a, $time_m, $out if $keep_time;
    chmod $mode, $out if $keep_time;
    '';
}
1;
