#ifndef _NETKEY_OSDEP_LINUX_H
#define _NETKEY_OSDEP_LINUX_H

#ifdef __KERNEL__
#include <linux/types.h>
#include <linux/param.h>

#include <linux/malloc.h>
#include <linux/string.h>
#include <linux/in.h>
#include <linux/socket.h>

#define KERNEL 1
#define printf printk
#else /* __KERNEL__ */

#endif /* __KERNEL__ */

struct sockaddr_bsd44 {   
  __u8 sa_len;
  __u8 sa_family;
  __u8 sa_data[14];
};
#define SOCKADDR struct sockaddr_bsd44

#define u_int8	__u8
#define u_int16	__u16
#define u_int32	__u32

#define KMALLOC(p, t, n) (p = (t)kmalloc(n, GFP_KERNEL))
#define KFREE(p) kfree(p)

#define bcopy(s, d, n) memcpy(d, s, n)
#define bzero(d, n) memset(d, 0, n)

/* We *really* need to use semaphores or locks instead */
#define CRITICAL_DCL
#define CRITICAL_START cli()
#define CRITICAL_END sti()
#define TIME_SECONDS time_seconds()
#define CURRENT_PID current->pid

#ifndef __P
#define __P(x) x
#endif /* __P */

#define DEFARGS(arglist, args) (args)
#define AND ,

long random __P((void));
long time_seconds __P((void));

#endif /* _NETKEY_OSDEP_LINUX_H */
