/*
  sshfc_conn.h

  Author: Sami Lehtinen <sjl@ssh.fi>

  Copyright (C) 1999 SSH Communications Security Oy, Espoo, Finland
  All rights reserved.

  Connection handling for SshFileCopy.
 */

#ifndef SSHFC_CONN_H
#define SSHFC_CONN_H

#include "sshincludes.h"
#include "sshfsm.h"
#include "sshfilecopy.h"

/* Flag values. */
#define SSH_FCC_OK                (SshUInt8)0
#define SSH_FCC_DOWN              (SshUInt8)1
#define SSH_FCC_CONNECTION_FAILED (SshUInt8)2
#define SSH_FCC_ERROR             (SshUInt8)4
#define SSH_FCC_ABORTED           (SshUInt8)5

/* Messages. */
#define SSH_FCC_CONN_DOWN  (SshUInt32)0
#define SSH_FCC_CONN_ABORT (SshUInt32)1
#define SSH_FCC_CONN_CLOSE (SshUInt32)2

SshFSMThread
ssh_file_copy_connection_thread_spawn(SshFSM fsm,
                                      SshFSMCondition waiting,
                                      SshFSMCondition finished,
                                      SshFileCopyConnection conn,
                                      SshUInt8 *conn_flags);

#define SSH_FSM_PROTOTYPES
#include "sshfc_conn_states.h"

#endif /* SSHFC_CONN_H */
