/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/cdb_gdbm/RCS/build_res_apdu.c,v $
 *
 *
 *  MODULE NAME:    build_res_apdu.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include "cdc.h"
#include "cdc_db.h"

static char certifbuffer1[3*CERTIF_SZ + 32];
static char certifbuffer2[3*CERTIF_SZ + 32];

extern int ps_len_strategy;

int build_error_res_apdu(rpkt, status, debugflag)
KTEXT rpkt;
int   status;
{
  int    i = 0;

  bzero(certifbuffer2, 4  /* since max size of error message is 3  */ );

  certifbuffer2[i++] = 0x81;
  certifbuffer2[i++] = 0x01;
  certifbuffer2[i++] = status;

  rpkt->length = i;
  bcopy(certifbuffer2, rpkt->dat, i);
  rpkt->mbz = 0;
  return(ASUCCESS);
}

int build_login_res_apdu(rpkt, status, logininfo, len, debugflag)
KTEXT rpkt;
int   status;
char  *logininfo;
int   len, debugflag;
{
  int    i, sizeofa3;

  bzero(certifbuffer2, len+32 /* since max size of response < len+32 */ );

  certifbuffer2[0] = 0xa3;
  sizeofa3 = len + 2 + NumEncodeLengthOctets(len+1) + 3;
  EncodeLength(&certifbuffer2[1], sizeofa3);
  i = 1+NumEncodeLengthOctets(sizeofa3);
  certifbuffer2[i++] = 0x80;
  certifbuffer2[i++] = 0x01;
  certifbuffer2[i++] = status;
  certifbuffer2[i++] = 0x03;
  EncodeLength(&certifbuffer2[i], len+1);
  i = i + NumEncodeLengthOctets(len+1);
  certifbuffer2[i++] = 0x00;
  bcopy(logininfo,&certifbuffer2[i],len);

  rpkt->length = i + len;
  bcopy(certifbuffer2, rpkt->dat, rpkt->length);
  rpkt->mbz = 0;
  return(ASUCCESS);
}

int build_certif_res_apdu(rpkt, status, certiflist, debugflag)
KTEXT rpkt;
int   status;
CertificateList  *certiflist;
int   debugflag;
{
  int    j, offset = 0;
  int    i, sizeofa5;

  bzero(certifbuffer1, sizeof(certifbuffer1));
  bzero(certifbuffer2, sizeof(certifbuffer2));

  if (certiflist->num > 0) {
    offset = 0;
    for (j=0; j < certiflist->num ; j++) {
      bcopy(certiflist->data[j], &certifbuffer1[offset], certiflist->sz[j]);
      offset = offset + certiflist->sz[j];
    }
  } else offset = 0;

  certifbuffer2[0] = 0xa5;
  sizeofa5 = offset + 1 + NumEncodeLengthOctets(offset)+3;
  EncodeLength(&certifbuffer2[1], sizeofa5);
  i = 1+NumEncodeLengthOctets(sizeofa5);
  certifbuffer2[i++] = 0x80;
  certifbuffer2[i++] = 0x01;
  certifbuffer2[i++] = status;
  certifbuffer2[i++] = 0xa3;
  EncodeLength(&certifbuffer2[i], offset);
  bcopy(certifbuffer1,&certifbuffer2[i+NumEncodeLengthOctets(offset)],offset);

  rpkt->length = i + NumEncodeLengthOctets(offset) + offset;
  bcopy(certifbuffer2, rpkt->dat, rpkt->length);
  rpkt->mbz = 0;
  return(ASUCCESS);
}

int build_tacertif_res_apdu(rpkt, status, certiflist, index, debugflag)
KTEXT rpkt;
int   status;
CertificateList  *certiflist;
int   index, debugflag;
{
  int    j, offset = 0;
  int    i, sizeofa7;

  bzero(certifbuffer1, sizeof(certifbuffer1));
  bzero(certifbuffer2, sizeof(certifbuffer2));

  if (certiflist->num > 0) {
    offset = 0;
    for (j=0; j < certiflist->num ; j++) {
      bcopy(certiflist->data[j], &certifbuffer1[offset], certiflist->sz[j]);
      offset = offset + certiflist->sz[j];
    }
  } else offset = 0;

  certifbuffer2[0] = 0xa7;
  sizeofa7 = offset + 1 + NumEncodeLengthOctets(offset)+ 5 + 3;
  EncodeLength(&certifbuffer2[1], sizeofa7);
  i = 1+NumEncodeLengthOctets(sizeofa7);
  certifbuffer2[i++] = 0x80;
  certifbuffer2[i++] = 0x01;
  certifbuffer2[i++] = status;
  certifbuffer2[i++] = 0xa1;
  certifbuffer2[i++] = 0x03;
  certifbuffer2[i++] = 0x02;
  certifbuffer2[i++] = 0x01;
  certifbuffer2[i++] = index;
  certifbuffer2[i++] = 0xa2;
  EncodeLength(&certifbuffer2[i], offset);
  bcopy(certifbuffer1,&certifbuffer2[i+NumEncodeLengthOctets(offset)],offset);

  rpkt->length = i + NumEncodeLengthOctets(offset) + offset;
  bcopy(certifbuffer2, rpkt->dat, rpkt->length);
  rpkt->mbz = 0;
  return(ASUCCESS);
}
