/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/str_manip.c,v $
 *
 *
 *  MODULE NAME:    str_manip.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *      J. Tardo
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>

#include "cdc.h"
#ifdef sun
#define strncasecmp      strncmp_support
#define strcasecmp       strcmp_support
#endif

extern char *rindex();

/*
 *  if n1 is not related to n2, return -1
 *  if n1 = n2 , return 0
 *  if n1 is immediate ancestor to n2 , return 1
 *  if n1 is ancestor to n2, return 2
 */

int str_cmp(n1,n2)
char *n1, *n2;
{
  char sub_n2[FULLNAME_SZ], *cp;

  if ((*n1 == '\0') || (*n2 == '\0'))  return(-1);

  if (strcasecmp(n1, n2) == 0) return(0);

  strcpy(sub_n2, n2);

  if ((cp = rindex(sub_n2, '/')) != 0)  *cp = '\0';
  else return(-1);

  if (strcasecmp(sub_n2, n1)==0) return(1);

/*
  if (strncasecmp(n1, sub_n2, strlen(sub_n2)) == 0) {
    if (strcasecmp(sub_n2, n1)==0) return(1);
  }
*/

  while (strlen(n1) < strlen(sub_n2)) {

    if ((cp = rindex(sub_n2, '/')) != 0) *cp = '\0';
    else return(-1);

    if (strcasecmp(sub_n2, n1)==0) return(2);
/*
    if (strncasecmp(n1, sub_n2, strlen(sub_n2)) == 0) {
      if (strcasecmp(sub_n2, n1)==0) return(2);
    }
*/
  }
  return(-1);
}
