/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/ber_encode.c,v $
 *
 *
 *  MODULE NAME:    ber_encode.c
 *
 *
 *  AUTHORS:
 *
 *      J. Tardo
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


#include <stdio.h>
#include <ctype.h>
#include "SPHINX-types.h"
#include "sign_aux.h"

#include "bigrsacode.h"
#include "bigsignverify.h"
#include "BigRSA.h"
#include "objid.h"

#ifdef DEBUG
#undef DEBUG
#endif

extern int ps_len_strategy;
typedef int (*IFX)();

/*
 * Converts pe to BER string form.
 */
int ber_encode(data,encode_fn,definite,out,len)
IFX encode_fn;
char **out;
PE data;
int definite, *len;
{
    int old_strategy = ps_len_strategy, status=NOTOK;
    PE new_x;

    ps_len_strategy = definite;

    status = (*encode_fn)(&new_x, 1, NULL, NULLCP, data);
    if (status == NOTOK) {
#ifdef DEBUG
printf("%s: Error encoding pe.\n", __FILE__);
printf(" %s\n", pe_error(new_x->pe_errno));
fflush(stdout);
#endif
    }
    else { 
        if ((status=pe2ssdu(new_x, out, len))== NOTOK) {
#ifdef DEBUG
printf("%s: Error converting to string. \n", __FILE__);
printf(" %s\n", pe_error(new_x->pe_errno));
fflush(stdout);
#endif
        }
        pe_free(new_x);
    }
    
    ps_len_strategy = old_strategy;
    return(status);
}
