# Macedonian (mk) locale

## `format` and `parse`

| Title                           | Token string | Date                     | `format` result                            | `parse` result           |
| ------------------------------- | ------------ | ------------------------ | ------------------------------------------ | ------------------------ |
| Calendar year                   | yo           | 1987-02-11T12:13:14.015Z | 1987-ми                                    | 1987-01-01T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 5-ти                                       | 0005-01-01T00:00:00.000Z |
| Local week-numbering year       | Yo           | 1987-02-11T12:13:14.015Z | 1987-ми                                    | 1986-12-29T00:00:00.000Z |
|                                 |              | 0005-01-01T12:13:14.015Z | 4-ти                                       | 0003-12-29T00:00:00.000Z |
| Quarter (formatting)            | Qo           | 2019-01-01T12:13:14.015Z | 1-ви                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ри                                       | 2019-04-01T00:00:00.000Z |
|                                 | QQQ          | 2019-01-01T12:13:14.015Z | 1-ви кв.                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ри кв.                                   | 2019-04-01T00:00:00.000Z |
|                                 | QQQQ         | 2019-01-01T12:13:14.015Z | 1-ви квартал                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ри квартал                               | 2019-04-01T00:00:00.000Z |
|                                 | QQQQQ        | 2019-01-01T12:13:14.015Z | 1                                          | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2                                          | 2019-04-01T00:00:00.000Z |
| Quarter (stand-alone)           | qo           | 2019-01-01T12:13:14.015Z | 1-ви                                       | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ри                                       | 2019-04-01T00:00:00.000Z |
|                                 | qqq          | 2019-01-01T12:13:14.015Z | 1-ви кв.                                   | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ри кв.                                   | 2019-04-01T00:00:00.000Z |
|                                 | qqqq         | 2019-01-01T12:13:14.015Z | 1-ви квартал                               | 2019-01-01T00:00:00.000Z |
|                                 |              | 2019-04-01T12:13:14.015Z | 2-ри квартал                               | 2019-04-01T00:00:00.000Z |
| Month (formatting)              | Mo           | 2019-02-11T12:13:14.015Z | 2-ри                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-ми                                       | 2019-07-01T00:00:00.000Z |
|                                 | MMM          | 2019-02-11T12:13:14.015Z | фев                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | јул                                        | 2019-07-01T00:00:00.000Z |
|                                 | MMMM         | 2019-02-11T12:13:14.015Z | февруари                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | јули                                       | 2019-07-01T00:00:00.000Z |
|                                 | MMMMM        | 2019-02-11T12:13:14.015Z | февруари                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | јули                                       | 2019-07-01T00:00:00.000Z |
| Month (stand-alone)             | Lo           | 2019-02-11T12:13:14.015Z | 2-ри                                       | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | 7-ми                                       | 2019-07-01T00:00:00.000Z |
|                                 | LLL          | 2019-02-11T12:13:14.015Z | фев                                        | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | јул                                        | 2019-07-01T00:00:00.000Z |
|                                 | LLLL         | 2019-02-11T12:13:14.015Z | февруари                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | јули                                       | 2019-07-01T00:00:00.000Z |
|                                 | LLLLL        | 2019-02-11T12:13:14.015Z | февруари                                   | 2019-02-01T00:00:00.000Z |
|                                 |              | 2019-07-10T12:13:14.015Z | јули                                       | 2019-07-01T00:00:00.000Z |
| Local week of year              | wo           | 2019-01-01T12:13:14.015Z | 1-ви                                       | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-ми                                      | 2019-11-25T00:00:00.000Z |
| ISO week of year                | Io           | 2019-01-01T12:13:14.015Z | 1-ви                                       | 2018-12-31T00:00:00.000Z |
|                                 |              | 2019-12-01T12:13:14.015Z | 48-ми                                      | 2019-11-25T00:00:00.000Z |
| Day of month                    | do           | 2019-02-11T12:13:14.015Z | 11-ти                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-28T12:13:14.015Z | 28-ми                                      | 2019-02-28T00:00:00.000Z |
| Day of year                     | Do           | 2019-02-11T12:13:14.015Z | 42-ри                                      | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-12-31T12:13:14.015Z | 365-ти                                     | 2019-12-31T00:00:00.000Z |
| Day of week (formatting)        | E            | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | EE           | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | EEE          | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | EEEE         | 2019-02-11T12:13:14.015Z | понеделник                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | петок                                      | 2019-02-15T00:00:00.000Z |
|                                 | EEEEE        | 2019-02-11T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 | EEEEEE       | 2019-02-11T12:13:14.015Z | по                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пе                                         | 2019-02-15T00:00:00.000Z |
| ISO day of week (formatting)    | io           | 2019-02-11T12:13:14.015Z | 1-ви                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ти                                       | 2019-02-15T00:00:00.000Z |
|                                 | iii          | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | iiii         | 2019-02-11T12:13:14.015Z | понеделник                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | петок                                      | 2019-02-15T00:00:00.000Z |
|                                 | iiiii        | 2019-02-11T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 | iiiiii       | 2019-02-11T12:13:14.015Z | по                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пе                                         | 2019-02-15T00:00:00.000Z |
| Local day of week (formatting)  | eo           | 2019-02-11T12:13:14.015Z | 1-ви                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ти                                       | 2019-02-15T00:00:00.000Z |
|                                 | eee          | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | eeee         | 2019-02-11T12:13:14.015Z | понеделник                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | петок                                      | 2019-02-15T00:00:00.000Z |
|                                 | eeeee        | 2019-02-11T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 | eeeeee       | 2019-02-11T12:13:14.015Z | по                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пе                                         | 2019-02-15T00:00:00.000Z |
| Local day of week (stand-alone) | co           | 2019-02-11T12:13:14.015Z | 1-ви                                       | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | 5-ти                                       | 2019-02-15T00:00:00.000Z |
|                                 | ccc          | 2019-02-11T12:13:14.015Z | пон                                        | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пет                                        | 2019-02-15T00:00:00.000Z |
|                                 | cccc         | 2019-02-11T12:13:14.015Z | понеделник                                 | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | петок                                      | 2019-02-15T00:00:00.000Z |
|                                 | ccccc        | 2019-02-11T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | П                                          | 2019-02-11T00:00:00.000Z |
|                                 | cccccc       | 2019-02-11T12:13:14.015Z | по                                         | 2019-02-11T00:00:00.000Z |
|                                 |              | 2019-02-15T12:13:14.015Z | пе                                         | 2019-02-15T00:00:00.000Z |
| AM, PM                          | a            | 2019-02-11T11:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 | aa           | 2019-02-11T11:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 | aaa          | 2019-02-11T11:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 | aaaa         | 2019-02-11T11:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 | aaaaa        | 2019-02-11T11:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | претпладне                                 | Invalid Date             |
| AM, PM, noon, midnight          | b            | 2019-02-11T11:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 | bb           | 2019-02-11T11:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 | bbb          | 2019-02-11T11:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 | bbbb         | 2019-02-11T11:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 | bbbbb        | 2019-02-11T11:13:14.015Z | претпладне                                 | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | претпладне                                 | Invalid Date             |
| Flexible day period             | B            | 2019-02-11T11:13:14.015Z | наутро                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | навечер                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ноќе                                       | Invalid Date             |
|                                 | BB           | 2019-02-11T11:13:14.015Z | наутро                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | навечер                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ноќе                                       | Invalid Date             |
|                                 | BBB          | 2019-02-11T11:13:14.015Z | наутро                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | навечер                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ноќе                                       | Invalid Date             |
|                                 | BBBB         | 2019-02-11T11:13:14.015Z | наутро                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | навечер                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ноќе                                       | Invalid Date             |
|                                 | BBBBB        | 2019-02-11T11:13:14.015Z | наутро                                     | Invalid Date             |
|                                 |              | 2019-02-11T14:13:14.015Z | попладне                                   | Invalid Date             |
|                                 |              | 2019-02-11T19:13:14.015Z | навечер                                    | Invalid Date             |
|                                 |              | 2019-02-11T02:13:14.015Z | ноќе                                       | Invalid Date             |
| Hour [1-12]                     | ho           | 2019-02-11T11:13:14.015Z | 11-ти                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-ти                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-23]                     | Ho           | 2019-02-11T11:13:14.015Z | 11-ти                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-ти                                      | 2019-02-11T23:00:00.000Z |
| Hour [0-11]                     | Ko           | 2019-02-11T11:13:14.015Z | 11-ти                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 11-ти                                      | 2019-02-11T23:00:00.000Z |
| Hour [1-24]                     | ko           | 2019-02-11T11:13:14.015Z | 11-ти                                      | 2019-02-11T11:00:00.000Z |
|                                 |              | 2019-02-11T23:13:14.015Z | 23-ти                                      | 2019-02-11T23:00:00.000Z |
| Minute                          | mo           | 2019-01-01T12:01:14.015Z | 1-ви                                       | 2019-01-01T12:01:00.000Z |
|                                 |              | 2019-04-01T12:55:14.015Z | 55-ти                                      | 2019-04-01T12:55:00.000Z |
| Second                          | so           | 2019-01-01T12:13:01.015Z | 1-ви                                       | 2019-01-01T12:13:01.000Z |
|                                 |              | 2019-04-01T12:13:55.015Z | 55-ти                                      | 2019-04-01T12:13:55.000Z |
| Long localized date             | P            | 1987-02-11T12:13:14.015Z | 11/02/1987                                 | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453                                 | 1453-05-29T00:00:00.000Z |
|                                 | PP           | 1987-02-11T12:13:14.015Z | 11 фев 1987                                | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мај 1453                                | 1453-05-29T00:00:00.000Z |
|                                 | PPP          | 1987-02-11T12:13:14.015Z | 11 февруари 1987                           | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мај 1453                                | 1453-05-29T00:00:00.000Z |
|                                 | PPPP         | 1987-02-11T12:13:14.015Z | среда, 11 февруари 1987                    | 1987-02-11T00:00:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | недела, 29 мај 1453                        | 1453-05-29T00:00:00.000Z |
| Long localized time             | p            | 1987-02-11T12:13:14.015Z | 12:13                                      | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59                                      | 1453-05-29T23:59:00.000Z |
|                                 | pp           | 1987-02-11T12:13:14.015Z | 12:13:14                                   | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59                                   | 1453-05-29T23:59:59.000Z |
|                                 | ppp          | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+0                             | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+0                             | Errored                  |
|                                 | pppp         | 1987-02-11T12:13:14.015Z | 12:13:14 GMT+00:00                         | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 23:59:59 GMT+00:00                         | Errored                  |
| Combination of date and time    | Pp           | 1987-02-11T12:13:14.015Z | 11/02/1987 12:13                           | 1987-02-11T12:13:00.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29/05/1453 23:59                           | 1453-05-29T23:59:00.000Z |
|                                 | PPpp         | 1987-02-11T12:13:14.015Z | 11 фев 1987 12:13:14                       | 1987-02-11T12:13:14.000Z |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мај 1453 23:59:59                       | 1453-05-29T23:59:59.000Z |
|                                 | PPPppp       | 1987-02-11T12:13:14.015Z | 11 февруари 1987 12:13:14 GMT+0            | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | 29 мај 1453 23:59:59 GMT+0                 | Errored                  |
|                                 | PPPPpppp     | 1987-02-11T12:13:14.015Z | среда, 11 февруари 1987 12:13:14 GMT+00:00 | Errored                  |
|                                 |              | 1453-05-29T23:59:59.999Z | недела, 29 мај 1453 23:59:59 GMT+00:00     | Errored                  |

## `formatDistance`

If now is January 1st, 2000, 00:00.

| Date                     | Result             | `includeSeconds: true` | `addSuffix: true`       |
| ------------------------ | ------------------ | ---------------------- | ----------------------- |
| 2006-01-01T00:00:00.000Z | околу 6 години     | околу 6 години         | за околу 6 години       |
| 2005-01-01T00:00:00.000Z | околу 5 години     | околу 5 години         | за околу 5 години       |
| 2004-01-01T00:00:00.000Z | околу 4 години     | околу 4 години         | за околу 4 години       |
| 2003-01-01T00:00:00.000Z | околу 3 години     | околу 3 години         | за околу 3 години       |
| 2002-01-01T00:00:00.000Z | околу 2 години     | околу 2 години         | за околу 2 години       |
| 2001-06-01T00:00:00.000Z | повеќе од 1 година | повеќе од 1 година     | за повеќе од 1 година   |
| 2001-02-01T00:00:00.000Z | околу 1 година     | околу 1 година         | за околу 1 година       |
| 2001-01-01T00:00:00.000Z | околу 1 година     | околу 1 година         | за околу 1 година       |
| 2000-06-01T00:00:00.000Z | 5 месеци           | 5 месеци               | за 5 месеци             |
| 2000-03-01T00:00:00.000Z | 2 месеци           | 2 месеци               | за 2 месеци             |
| 2000-02-01T00:00:00.000Z | околу 1 месец      | околу 1 месец          | за околу 1 месец        |
| 2000-01-15T00:00:00.000Z | 14 дена            | 14 дена                | за 14 дена              |
| 2000-01-02T00:00:00.000Z | 1 ден              | 1 ден                  | за 1 ден                |
| 2000-01-01T06:00:00.000Z | околу 6 часа       | околу 6 часа           | за околу 6 часа         |
| 2000-01-01T01:00:00.000Z | околу 1 час        | околу 1 час            | за околу 1 час          |
| 2000-01-01T00:45:00.000Z | околу 1 час        | околу 1 час            | за околу 1 час          |
| 2000-01-01T00:30:00.000Z | 30 минути          | 30 минути              | за 30 минути            |
| 2000-01-01T00:15:00.000Z | 15 минути          | 15 минути              | за 15 минути            |
| 2000-01-01T00:01:00.000Z | 1 минута           | 1 минута               | за 1 минута             |
| 2000-01-01T00:00:25.000Z | помалку од минута  | половина минута        | за помалку од минута    |
| 2000-01-01T00:00:15.000Z | помалку од минута  | помалку од 20 секунди  | за помалку од минута    |
| 2000-01-01T00:00:05.000Z | помалку од минута  | помалку од 10 секунди  | за помалку од минута    |
| 2000-01-01T00:00:00.000Z | помалку од минута  | помалку од 5 секунди   | пред помалку од минута  |
| 1999-12-31T23:59:55.000Z | помалку од минута  | помалку од 10 секунди  | пред помалку од минута  |
| 1999-12-31T23:59:45.000Z | помалку од минута  | помалку од 20 секунди  | пред помалку од минута  |
| 1999-12-31T23:59:35.000Z | помалку од минута  | половина минута        | пред помалку од минута  |
| 1999-12-31T23:59:00.000Z | 1 минута           | 1 минута               | пред 1 минута           |
| 1999-12-31T23:45:00.000Z | 15 минути          | 15 минути              | пред 15 минути          |
| 1999-12-31T23:30:00.000Z | 30 минути          | 30 минути              | пред 30 минути          |
| 1999-12-31T23:15:00.000Z | околу 1 час        | околу 1 час            | пред околу 1 час        |
| 1999-12-31T23:00:00.000Z | околу 1 час        | околу 1 час            | пред околу 1 час        |
| 1999-12-31T18:00:00.000Z | околу 6 часа       | околу 6 часа           | пред околу 6 часа       |
| 1999-12-30T00:00:00.000Z | 2 дена             | 2 дена                 | пред 2 дена             |
| 1999-12-15T00:00:00.000Z | 17 дена            | 17 дена                | пред 17 дена            |
| 1999-12-01T00:00:00.000Z | околу 1 месец      | околу 1 месец          | пред околу 1 месец      |
| 1999-11-01T00:00:00.000Z | 2 месеци           | 2 месеци               | пред 2 месеци           |
| 1999-06-01T00:00:00.000Z | 7 месеци           | 7 месеци               | пред 7 месеци           |
| 1999-01-01T00:00:00.000Z | околу 1 година     | околу 1 година         | пред околу 1 година     |
| 1998-12-01T00:00:00.000Z | околу 1 година     | околу 1 година         | пред околу 1 година     |
| 1998-06-01T00:00:00.000Z | повеќе од 1 година | повеќе од 1 година     | пред повеќе од 1 година |
| 1998-01-01T00:00:00.000Z | околу 2 години     | околу 2 години         | пред околу 2 години     |
| 1997-01-01T00:00:00.000Z | околу 3 години     | околу 3 години         | пред околу 3 години     |
| 1996-01-01T00:00:00.000Z | околу 4 години     | околу 4 години         | пред околу 4 години     |
| 1995-01-01T00:00:00.000Z | околу 5 години     | околу 5 години         | пред околу 5 години     |
| 1994-01-01T00:00:00.000Z | околу 6 години     | околу 6 години         | пред околу 6 години     |

## `formatDistanceStrict`

If now is January 1st, 2000, 00:00.

| Date                     | Result     | `addSuffix: true` | With forced unit (i.e. `hour`) |
| ------------------------ | ---------- | ----------------- | ------------------------------ |
| 2006-01-01T00:00:00.000Z | 6 години   | за 6 години       | 52608 часа                     |
| 2005-01-01T00:00:00.000Z | 5 години   | за 5 години       | 43848 часа                     |
| 2004-01-01T00:00:00.000Z | 4 години   | за 4 години       | 35064 часа                     |
| 2003-01-01T00:00:00.000Z | 3 години   | за 3 години       | 26304 часа                     |
| 2002-01-01T00:00:00.000Z | 2 години   | за 2 години       | 17544 часа                     |
| 2001-06-01T00:00:00.000Z | 1 година   | за 1 година       | 12408 часа                     |
| 2001-02-01T00:00:00.000Z | 1 година   | за 1 година       | 9528 часа                      |
| 2001-01-01T00:00:00.000Z | 1 година   | за 1 година       | 8784 часа                      |
| 2000-06-01T00:00:00.000Z | 5 месеци   | за 5 месеци       | 3648 часа                      |
| 2000-03-01T00:00:00.000Z | 2 месеци   | за 2 месеци       | 1440 часа                      |
| 2000-02-01T00:00:00.000Z | 1 месец    | за 1 месец        | 744 часа                       |
| 2000-01-15T00:00:00.000Z | 14 дена    | за 14 дена        | 336 часа                       |
| 2000-01-02T00:00:00.000Z | 1 ден      | за 1 ден          | 24 часа                        |
| 2000-01-01T06:00:00.000Z | 6 часа     | за 6 часа         | 6 часа                         |
| 2000-01-01T01:00:00.000Z | 1 час      | за 1 час          | 1 час                          |
| 2000-01-01T00:45:00.000Z | 45 минути  | за 45 минути      | 1 час                          |
| 2000-01-01T00:30:00.000Z | 30 минути  | за 30 минути      | 1 час                          |
| 2000-01-01T00:15:00.000Z | 15 минути  | за 15 минути      | 0 часа                         |
| 2000-01-01T00:01:00.000Z | 1 минута   | за 1 минута       | 0 часа                         |
| 2000-01-01T00:00:25.000Z | 25 секунди | за 25 секунди     | 0 часа                         |
| 2000-01-01T00:00:15.000Z | 15 секунди | за 15 секунди     | 0 часа                         |
| 2000-01-01T00:00:05.000Z | 5 секунди  | за 5 секунди      | 0 часа                         |
| 2000-01-01T00:00:00.000Z | 0 секунди  | пред 0 секунди    | 0 часа                         |
| 1999-12-31T23:59:55.000Z | 5 секунди  | пред 5 секунди    | 0 часа                         |
| 1999-12-31T23:59:45.000Z | 15 секунди | пред 15 секунди   | 0 часа                         |
| 1999-12-31T23:59:35.000Z | 25 секунди | пред 25 секунди   | 0 часа                         |
| 1999-12-31T23:59:00.000Z | 1 минута   | пред 1 минута     | 0 часа                         |
| 1999-12-31T23:45:00.000Z | 15 минути  | пред 15 минути    | 0 часа                         |
| 1999-12-31T23:30:00.000Z | 30 минути  | пред 30 минути    | 1 час                          |
| 1999-12-31T23:15:00.000Z | 45 минути  | пред 45 минути    | 1 час                          |
| 1999-12-31T23:00:00.000Z | 1 час      | пред 1 час        | 1 час                          |
| 1999-12-31T18:00:00.000Z | 6 часа     | пред 6 часа       | 6 часа                         |
| 1999-12-30T00:00:00.000Z | 2 дена     | пред 2 дена       | 48 часа                        |
| 1999-12-15T00:00:00.000Z | 17 дена    | пред 17 дена      | 408 часа                       |
| 1999-12-01T00:00:00.000Z | 1 месец    | пред 1 месец      | 744 часа                       |
| 1999-11-01T00:00:00.000Z | 2 месеци   | пред 2 месеци     | 1464 часа                      |
| 1999-06-01T00:00:00.000Z | 7 месеци   | пред 7 месеци     | 5136 часа                      |
| 1999-01-01T00:00:00.000Z | 1 година   | пред 1 година     | 8760 часа                      |
| 1998-12-01T00:00:00.000Z | 1 година   | пред 1 година     | 9504 часа                      |
| 1998-06-01T00:00:00.000Z | 2 години   | пред 2 години     | 13896 часа                     |
| 1998-01-01T00:00:00.000Z | 2 години   | пред 2 години     | 17520 часа                     |
| 1997-01-01T00:00:00.000Z | 3 години   | пред 3 години     | 26280 часа                     |
| 1996-01-01T00:00:00.000Z | 4 години   | пред 4 години     | 35064 часа                     |
| 1995-01-01T00:00:00.000Z | 5 години   | пред 5 години     | 43824 часа                     |
| 1994-01-01T00:00:00.000Z | 6 години   | пред 6 години     | 52584 часа                     |

## `formatRelative`

If now is January 1st, 2000, 00:00.

| Date                     | Result                  |
| ------------------------ | ----------------------- |
| 2000-01-10T00:00:00.000Z | 10/01/2000              |
| 2000-01-05T00:00:00.000Z | следната среда вo 0:00  |
| 2000-01-02T00:00:00.000Z | утре во 0:00            |
| 2000-01-01T00:00:00.000Z | денес во 0:00           |
| 1999-12-31T00:00:00.000Z | вчера во 0:00           |
| 1999-12-27T00:00:00.000Z | овој понеделник вo 0:00 |
| 1999-12-21T00:00:00.000Z | 21/12/1999              |
