/*
 This file is part of GNU Taler
 (C) 2021-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { MerchantAccountKycStatus, PaytoString } from "@gnu-taler/taler-util";
import * as tests from "@gnu-taler/web-util/testing";
import { ListPage as TestedComponent } from "./ListPage.js";

export default {
  title: "Pages/KYC/List",
  component: TestedComponent,
  argTypes: {
    onUpdate: { action: "onUpdate" },
    onBack: { action: "onBack" },
  },
};

export const Example = tests.createExample(TestedComponent, {
  status: {
    // timeout_kycs: [],
    kyc_data: [
      {
        exchange_url: "http://exchange.taler",
        status: MerchantAccountKycStatus.AWAITING_AML_REVIEW,
        h_wire: "",
        payto_uri: "payto://iban/de123123123" as PaytoString,
        // kyc_url: "http://exchange.taler/kyc",
        exchange_http_status: 0,
        auth_conflict: false,
        no_keys: false,
      },
      {
        exchange_http_status: 1,
        status: MerchantAccountKycStatus.AWAITING_AML_REVIEW,
        h_wire: "",
        exchange_url: "http://exchange.taler",
        payto_uri: "payto://iban/de123123123" as PaytoString,
        auth_conflict: false,
        no_keys: false,
      },
      {
        exchange_http_status: 2,
        status: MerchantAccountKycStatus.AWAITING_AML_REVIEW,
        h_wire: "",
        exchange_url: "http://exchange.taler",
        payto_uri: "payto://iban/de123123123" as PaytoString,
        auth_conflict: false,
        no_keys: false,
      },
    ],
  },
});
