/* challenge.c: The opiechallenge() library function.

Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net Copyright Notice and License Agreement applies to
these portions of the software.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

        History:

	Modified by cmetz for OPIE 2.2. Use FUNCTION declaration et al.
        Created at NRL for OPIE 2.2 from opiesubr2.c
*/
#include "opie_cfg.h"
#include <stdio.h>
#include <string.h>
#include "opie.h"

/* Return an OTP challenge string for user 'name'. 

   The return values are:

   0  = All good
   -1 = Low-level error (file, memory, I/O, etc.)
   1  = High-level error (user not found or locked)

   This function MUST eventually be followed by an opieverify() to release
   the user lock and file handles.

   This function will give you a blanked-out state block if it returns a
   nonzero status. Even though it returns a non-zero status and a blank
   state block, you still MUST call opieverify() to clear the lock and
   any internal state (the latter condition is not actually used yet).
*/
int opiechallenge FUNCTION((mp, name, ss), struct opie *mp AND char *name AND char *ss)
{
  int rval = -1;

  memset(mp, 0, sizeof(*mp));

  rval = opielookup(mp, name);

  if (!rval)
    rval = opielock(name);

  if (rval) {
    opierandomchallenge(ss);
    memset(mp, 0, sizeof(*mp));
  } else
    sprintf(ss, "otp-md%d %d %s", MDX, mp->n - 1, mp->seed);

  return rval;
}
