#! /bin/sh
# This is a shell archive.  Remove anything before this line, then unpack
# it by saving it into a file and typing "sh file".  To overwrite existing
# files, type "sh file -c".  You can also feed this as standard input via
# unshar, or by typing "sh <file", e.g..  If this archive is complete, you
# will see the following message at the end:
#		"End of shell archive."
# Contents:  README.MJR deskeyc.c makefile.patch skey.c.patch
# Wrapped by mjr@otter on Thu Mar 10 10:23:38 1994
PATH=/bin:/usr/bin:/usr/ucb ; export PATH
if test -f 'README.MJR' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'README.MJR'\"
else
echo shar: Extracting \"'README.MJR'\" \(3892 characters\)
sed "s/^X//" >'README.MJR' <<'END_OF_FILE'
X
X
X	The way S/key's algorithm works is to take a secret seed
Xthat you know (which can be any size, practically) and a second seed,
Xwhich it hashes with MD4 'N' times to generate the Nth response, which
Xis used to authenticate. The server knows the N+1th response and performs
Xone more round of hashing to verify that the response you gave is the
Xcorrect one. Very clever!
X
X	Well, the problem is that if you're like most of us, your
Xsecret seed is going to be short -- 8 characters or so, and may or
Xmay not be in the dictionary. If I intercept your communications,
XI obtain:
X	The sequence number (it's in the challenge)
X	The public seed (ot18722 or whatever it is)
X	Your response
X
X	I can then perform a dictionary attack to see if your secret
Xseed is in my dictionary, by performing a lot of hashing. This is one
Xplace where MD4/5 is a loser: it's a lot faster than DES. So my
Xdictionary attack may be quite a bit faster.
X
X	I have a version of the S/key client program "key" that I
Xhave modified (mostly for fun) to work a wee bit differently. Instead
Xof using the value I give it as a "private seed" it uses it as a
XDES key to unlock an encrypted block of random data. The block can
Xbe any size. One kb is more than enough. That block is used as my
Xprivate seed and everything else proceeds normally. Note that with
Xthe Ranum "key" program, everything is still completely interoperable
Xwith the existing S/key code -- you just use skey.init -s to set
Xthe response value and it all just works from there. The disadvantage
Xof my approach is that I can only generate keys on a machine where
XI have a copy of my DES-encrypted seed block. That's OK because you
Xonly *WANT* to generate keys on a machine you trust. You can forget
Xa dictionary attack because you need to know the hash value of
Xmy block of random noise, which, presumably, you haven't got, and
Xeven if you had it, you haven't got the ability to decrypt it. (It
Xis assumed that knowing when you have correctly decrypted a block
Xof white noise is *hard*)
X
X	This version adds a new option to "skey.c" to implement a
X"-d" flag, telling it to use a DES seed block. If the DES seed
Xblock is in use, it calls deskeycrunch() "deskeyc.c" to generate
Xthe hash seed, instead of the usual keycrunch(). deskeycrunch()
Xchecks for an environment variable "SKEYPADFILE" and uses that
Xas the file name for the DES-encrypted seed block. It simply
Xdecrypts it and hashes it. If you gave the wrong DES password,
Xyou get an incorrect value -- there's no warning. Generating
Xthe DES-encrypted seed block is fairly simple. I did something
Xlike:
X
X	setenv SKEYPADFILE ~/.skeypad
X	cat /etc/termcap | compress | dd bs=1024 count=1 > /tmp/xx
X	des -e < /tmp/xx > $SKEYPADFILE
X
X	The password I give to encrypt the pad file need not be
Xthe same one I use to decrypt it, as long as I always use the same
Xone to decrypt it, my protocol is secure. In fact, whenever I want
Xto change keys there's really no need to replace my pad file --
Xit'll be decrypted completely differently if I alter the key the
Xslightest.
X
X	Let's say I want to use S/key. I can simply initialize
Xmyself using my version, as follows:
X
Xotter-> skey.init -s
XUpdating mjr:
XOld key: ot5720000
XReminder you need the 6 english words from the skey command.
XEnter sequence count from 1 to 10000: 999
XEnter new key [default ot5720001]: 
Xs/key 999 ot5720001
Xs/key access password: ^Z[1] + Stopped                  skey.init -s
Xotter-> SKEYPADFILE=/etc/termcap
Xotter-> export SKEYPADFILE
Xotter-> ./key -d 999 ot5720001
XReminder - Do not use key while logged in via telnet or dial-in.
XEnter secret password: 
XGUST BIRD WEAK EGG FUNK SHOE
Xotter-> fg
Xskey.init -s
XGUST BIRD WEAK EGG FUNK SHOE
X
XID mjr s/key is 999 ot5720001
XGUST BIRD WEAK EGG FUNK SHOE
Xotter-> 
X
X	I will give a shiny new quarter to anyone who can dictionary
Xattack *that*.
X
XMarcus J. Ranum
XSenior Scientist
XTrusted Information Systems, Inc.
END_OF_FILE
if test 3892 -ne `wc -c <'README.MJR'`; then
    echo shar: \"'README.MJR'\" unpacked with wrong size!
fi
# end of 'README.MJR'
fi
if test -f 'deskeyc.c' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'deskeyc.c'\"
else
echo shar: Extracting \"'deskeyc.c'\" \(2172 characters\)
sed "s/^X//" >'deskeyc.c' <<'END_OF_FILE'
X#include <stdio.h>
X#ifdef HASSTDLIB
X#include <stdlib.h>
X#else
X#include <sys/types.h>
X#endif
X#include <string.h>
X#ifdef	__MSDOS__
X#include <dos.h>
X#else	/* Assume BSD unix */
X#include <fcntl.h>
X#include <sgtty.h>
X#endif
X#include "md4.h"
X#include "des.h"
X#include "skey.h"
X
X#if (defined(__MSDOS__) || defined(MPU8086) || defined(MPU8080) \
X || defined(vax) || defined (MIPSEL))
X#define	LITTLE_ENDIAN	/* Low order bytes are first in memory */
X#endif			/* Almost all other machines are big-endian */
X
Xextern	char	*getenv();
X
X/* Crunch a key:
X * DES decrypt the user's pad file and then crank it through MD4 and
X * collapse to 64 bits. This is defined as the user's starting key.
X * mjr@tis.com
X */
Xint
Xdeskeycrunch(result,seed,passwd)
Xchar *result;	/* 8-byte result */
Xchar *seed;	/* Seed, any length */
Xchar *passwd;	/* Password, any length */
X{
X	MDstruct md;
X	char *padfile;
X	char desobuf[BUFSIZ];
X	char desibuf[BUFSIZ];
X	des_key_schedule ks;
X	des_cblock kk;
X	char iv[8];
X	FILE *desfd;
X	int i;
X
X	if((padfile = getenv("SKEYPADFILE")) == (char *)0) {
X		fprintf(stderr,"No SKEYPADFILE in environment\n");
X		return(-1);
X	}
X
X	if((desfd = fopen(padfile,"r")) == (FILE *)0) {
X		perror(padfile);
X		return(-1);
X	}
X
X	des_string_to_key(passwd,kk);
X	des_set_key(kk,ks);
X	bzero(passwd,strlen(passwd));
X	bzero(kk,sizeof(kk));
X	bzero(iv,sizeof(iv));
X
X	/* decrypt our pad file and MD5 it */
X	MDbegin(&md);
X	while((i = fread(desibuf,1,64,desfd)) >= 8) {
X		if(i % 8 != 0)
X			i = i - (i % 8);
X		des_cbc_encrypt(desibuf,desobuf,i,ks,iv,DES_DECRYPT);
X		MDupdate(&md,(unsigned char *)desobuf,8 * i);
X	}
X	fclose(desfd);
X	if(i < 0) {
X		perror("read");
X		return(-1);
X	}
X
X	/* Fold result from 128 to 64 bits */
X	md.buffer[0] ^= md.buffer[2];
X	md.buffer[1] ^= md.buffer[3];
X
X#ifdef	LITTLE_ENDIAN
X	/* Only works on byte-addressed little-endian machines!! */
X	memcpy(result,(char *)md.buffer,8);
X#else
X	/* Default (but slow) code that will convert to
X	 * little-endian byte ordering on any machine
X	 */
X	for(i=0;i<2;i++){
X		register long tmp;
X		tmp = md.buffer[i];
X		*result++ = tmp;
X		tmp >>= 8;
X		*result++ = tmp;
X		tmp >>= 8;
X		*result++ = tmp;
X		tmp >>= 8;
X		*result++ = tmp;
X	}
X#endif
X	return 0;
X}
END_OF_FILE
if test 2172 -ne `wc -c <'deskeyc.c'`; then
    echo shar: \"'deskeyc.c'\" unpacked with wrong size!
fi
# end of 'deskeyc.c'
fi
if test -f 'makefile.patch' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'makefile.patch'\"
else
echo shar: Extracting \"'makefile.patch'\" \(1757 characters\)
sed "s/^X//" >'makefile.patch' <<'END_OF_FILE'
X*** /tmp/skey/Makefile	Tue Jul 27 17:06:02 1993
X--- Makefile	Sun Mar  6 22:52:41 1994
X***************
X*** 1,5 ****
X  LBIN=/usr/local/bin
X! CDEBUGFLAGS = 
X  #CDEBUGFLAGS = -O do NOT <----> use causes different output
X  
X  # if this machine uses shared libraries, (such as Suns), uncomment the first
X--- 1,5 ----
X  LBIN=/usr/local/bin
X! CDEBUGFLAGS =  -g
X  #CDEBUGFLAGS = -O do NOT <----> use causes different output
X  
X  # if this machine uses shared libraries, (such as Suns), uncomment the first
X***************
X*** 7,12 ****
X--- 7,17 ----
X  LDFLAGS = -Bstatic
X  #LDFLAGS =
X  
X+ 
X+ DESINCLUDE=	../libdes
X+ DESLIB=		$(DESINCLUDE)/libdes.a
X+ DESFLAGS=	-I$(DESINCLUDE)
X+ 
X  # if this machine has /usr/include/stdlib.h, uncomment the first line,
X  # otherwise, uncomment the second
X  HASSTDLIB = -DHASSTDLIB
X***************
X*** 13,21 ****
X  #HASSTDLIB =
X  
X  LIB=	libskey.a
X! LIBOBJS = skeylogin.o skeysubr.o md4.o put.o skey.o
X  
X! CFLAGS = $(CDEBUGFLAGS) $(HASSTDLIB)
X  
X  all: key keylogin skey.init keysu $(LIB)
X  
X--- 18,26 ----
X  #HASSTDLIB =
X  
X  LIB=	libskey.a
X! LIBOBJS = skeylogin.o skeysubr.o md4.o put.o skey.o deskeyc.o
X  
X! CFLAGS = $(CDEBUGFLAGS) $(HASSTDLIB) $(DESFLAGS)
X  
X  all: key keylogin skey.init keysu $(LIB)
X  
X***************
X*** 49,55 ****
X  	chmod 4755 keylogin skey.init keysu
X  
X  key: skey.o $(LIB)
X! 	$(CC) $(CFLAGS) $(LDFLAGS) -o key skey.o $(LIB)
X  
X  keylogin: login.o skeylogin.o skeysubr.o md4.o put.o setenv.o getenv.o
X  	$(CC) $(CFLAGS) $(LDFLAGS) -o keylogin \
X--- 54,60 ----
X  	chmod 4755 keylogin skey.init keysu
X  
X  key: skey.o $(LIB)
X! 	$(CC) $(CFLAGS) $(LDFLAGS) -o key skey.o $(LIB) $(DESLIB)
X  
X  keylogin: login.o skeylogin.o skeysubr.o md4.o put.o setenv.o getenv.o
X  	$(CC) $(CFLAGS) $(LDFLAGS) -o keylogin \
END_OF_FILE
if test 1757 -ne `wc -c <'makefile.patch'`; then
    echo shar: \"'makefile.patch'\" unpacked with wrong size!
fi
# end of 'makefile.patch'
fi
if test -f 'skey.c.patch' -a "${1}" != "-c" ; then 
  echo shar: Will not clobber existing file \"'skey.c.patch'\"
else
echo shar: Extracting \"'skey.c.patch'\" \(1070 characters\)
sed "s/^X//" >'skey.c.patch' <<'END_OF_FILE'
X*** /tmp/skey/skey.c	Tue Jul 27 16:57:12 1993
X--- skey.c	Sun Mar  6 22:00:30 1994
X***************
X*** 37,42 ****
X--- 37,43 ----
X  char *argv[];
X  {
X  	int n,cnt,i;
X+ 	int desmode = 0;
X  	char passwd[256],passwd2[256];
X  	char key[8];
X  	char *seed;
X***************
X*** 44,51 ****
X  	char *slash;
X  
X  	cnt = 1;
X! 	while((i = getopt(argc,argv,"n:")) != EOF){
X  		switch(i){
X  		case 'n':
X  			cnt = atoi(optarg);
X  			break;
X--- 45,55 ----
X  	char *slash;
X  
X  	cnt = 1;
X! 	while((i = getopt(argc,argv,"n:d")) != EOF){
X  		switch(i){
X+ 		case 'd':
X+ 			desmode++;
X+ 			break;
X  		case 'n':
X  			cnt = atoi(optarg);
X  			break;
X***************
X*** 99,105 ****
X  	}
X  
X  	/* Crunch seed and password into starting key */
X! 	if(keycrunch(key,seed,passwd) != 0){
X  		fprintf(stderr,"%s: key crunch failed\n",argv[0]);
X  		return 1;
X  	}
X--- 103,110 ----
X  	}
X  
X  	/* Crunch seed and password into starting key */
X! 	if(desmode ? deskeycrunch(key,seed,passwd) :
X! 		keycrunch(key,seed,passwd) != 0) {
X  		fprintf(stderr,"%s: key crunch failed\n",argv[0]);
X  		return 1;
X  	}
END_OF_FILE
if test 1070 -ne `wc -c <'skey.c.patch'`; then
    echo shar: \"'skey.c.patch'\" unpacked with wrong size!
fi
# end of 'skey.c.patch'
fi
echo shar: End of shell archive.
exit 0
