/* opie_conf.h.source: Various configuration-type pieces of information for
	OPIE. This version is designed to work with the older configuration
	system.

	This file makes a lot of naive assumptions.

Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net Copyright Notice and License Agreement applies to
these portions of the software.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

	History:

	Modified by cmetz for OPIE 2.22. Pull BSD mail directory from
		paths.h.
        Modified by cmetz for OPIE 2.2. Fairly major overhaul --
                updated to handle the new symbols. BSD4_3 is gone-
                IS_A_BSD implies this.
        Modified at NRL for OPIE 2.11. Added HAVE_SYS_TIME_H to
		IS_A_BSD. Removed version defines.
	Modified at NRL for OPIE 2.1. Fixed sigprocmask declaration.
		Gutted for autoconf. Split up for autoconf. Lots of
		changes for autoconf-style symbols. Removed trailing
		slashes from MAIL_DIR.
	Written at NRL for OPIE 2.0.
*/

#if defined(__GNUC__)
#if __GNUC__ >= 2
#ifndef ANSI_COMPILER
#define ANSI_COMPILER 1
#endif /* ANSI_COMPILER */
#endif /* __GNUC__ >= 2 */
#endif /* defined(__GNUC__) */

#ifdef SOLARIS
#ifndef SVR4
#define SVR4 1
#endif	/* SVR4 */
#ifndef NEED_SETENV
#define NEED_SETENV 1
#endif	/* NEED_SETENV */
#ifndef DOUTMPX
#define DOUTMPX 1
#endif	/* DOUTMPX */
#ifndef HAVE_CRYPT_H
#define HAVE_CRYPT_H 1
#endif /* HAVE_CRYPT_H */
#ifndef HAVE_SHADOW_H
#define HAVE_SHADOW_H 1
#endif /* HAVE_SHADOW_H */
#ifndef HAVE_SIGPROCMASK
#define HAVE_SIGPROCMASK 1
#endif /* HAVE_SIGPROCMASK */
#ifndef HAVE_SIGEMPTYSET
#define HAVE_SIGEMPTYSET 1
#endif /* HAVE_SIGEMPTYSET */
#ifndef HAVE_SIGADDSET
#define HAVE_SIGADDSET 1
#endif /* HAVE_SIGADDSET */
#ifndef HAVE_SHADOW
#define HAVE_SHADOW 1
#endif /* HAVE_SHADOW */
#ifndef DOTTYPROMPT
#define DOTTYPROMPT 1
#endif /* DOTTYPROMPT */
#ifndef HAVE_ETC_LOGINDEVPERM
#define HAVE_ETC_LOGINDEVPERM 1
#endif /* HAVE_ETC_LOGINDEVPERM */
#ifndef HAVE_MOTD_IN_PROFILE
#define HAVE_MOTD_IN_PROFILE 1
#endif /* HAVE_MOTD_IN_PROFILE */
#ifndef HAVE_MAILCHECK_IN_PROFILE
#define HAVE_MAILCHECK_IN_PROFILE 1
#endif /* HAVE_MAILCHECK_IN_PROFILE */
#endif	/* SOLARIS */

#ifdef linux
#ifndef IS_A_SYSV
#define IS_A_SYSV 1
#endif	/* IS_A_SYSV */
#ifndef HAVE_ETC_SECURETTY
#define HAVE_ETC_SECURETTY 1
#endif /* HAVE_ETC_SECURETTY */
#endif /* linux */

#ifdef hpux
#ifndef IS_A_SYSV
#define IS_A_SYSV 1
#endif	/* IS_A_SYSV */
#ifndef NEED_SETENV
#define NEED_SETENV 1
#endif	/* NEED_SETENV */
#define seteuid(x) setresuid(-1, x, -1)
#define setegid(x) setresgid(-1, x, -1)
#ifndef _PATH_WTMP
#define _PATH_WTMP "/etc/wtmp"
#endif	/* _PATH_WTMP */
#ifndef DOSECURETTY
#define DOSECURETTY 1
#endif	/* DOSECURETTY */
#ifndef HAVE_SIGPROCMASK
#define HAVE_SIGPROCMASK 1
#endif /* HAVE_SIGPROCMASK */
#ifndef HAVE_SIGEMPTYSET
#define HAVE_SIGEMPTYSET 1
#endif /* HAVE_SIGEMPTYSET */
#ifndef HAVE_SIGADDSET
#define HAVE_SIGADDSET 1
#endif /* HAVE_SIGADDSET */
#ifndef HAVE_GETENV
#define HAVE_GETENV 1
#endif /* HAVE_GETENV */
#ifndef HAVE_SYS_PARAM_H
#define HAVE_SYS_PARAM_H 1
#endif /* HAVE_SYS_PARAM_H */
#endif /* hpux */

#ifdef SUNOS
#ifndef IS_A_BSD
#define IS_A_BSD
#endif	/* IS_A_BSD */
#ifndef NEED_SETENV
#define NEED_SETENV 1
#endif	/* NEED_SETENV */
#ifndef NEED_STRERROR
#define NEED_STRERROR 1
#endif	/* NEED_STRERROR */
#ifndef atexit
#define atexit on_exit
#endif /* atexit */
#ifndef HAVE_LASTLOG_H
#define HAVE_LASTLOG_H 1
#endif /* HAVE_LASTLOG_H */
#ifndef HAVE_TIME_H
#define HAVE_TIME_H 1
#endif /* HAVE_TIME_H */
#ifndef HAVE_ETC_FBTAB
#define HAVE_ETC_FBTAB 1
#endif /* HAVE_ETC_FBTAB */
#ifndef HAVE_SETENV
#define HAVE_SETENV 0
#endif /* HAVE_SETENV */
#ifndef ANSI_LIBRARY
#define ANSI_LIBRARY 0
#endif /* ANSI_LIBRARY */
#endif	/* SUNOS */

#ifndef ANSI_LIBRARY
#define ANSI_LIBRARY 1
#endif /* ANSI_LIBRARY */
#ifndef POSIX_LIBRARY
#define POSIX_LIBRARY 1
#endif /* POSIX_LIBRARY */

/* SVR4 -> IS_A_SYSV */
#ifdef SVR4
#ifndef IS_A_SYSV
#define IS_A_SYSV 1
#endif	/* IS_A_SYSV */
#ifndef HAVE_ETC_DEFAULT_LOGIN 
#define HAVE_ETC_DEFAULT_LOGIN 1
#endif /* HAVE_ETC_DEFAULT_LOGIN */
#endif	/* SVR4 */

#if !defined(SYSV) && !defined(IS_A_SYSV) && defined(BSD)
#ifndef IS_A_BSD
#define IS_A_BSD 1
#endif	/* IS_A_BSD */
#endif	/* !defined(SYSV) && !defined(IS_A_SYSV) && defined(BSD) */

#if !defined(BSD) && !defined(IS_A_BSD) && defined(SYSV)
#ifndef IS_A_SYSV
#define IS_A_SYSV 1
#endif	/* IS_A_SYSV */
#endif	/* !defined(BSD) && !defined(IS_A_BSD) && defined(SYSV) */

#if defined(IS_A_BSD) && defined(IS_A_SYSV)
You cannot be both IS_A_BSD and IS_A_SYSV at the same time.
#endif	/* defined(IS_A_BSD) && defined(IS_A_SYSV) */

#if !defined(IS_A_BSD) && !defined(IS_A_SYSV)
   You must specify the kind of system you are on(See the Makefile).
#endif	/* !defined(IS_A_BSD) && !defined(IS_A_SYSV) */

/* If the user didn't specify, figure out what file to use for perm setting */
#ifndef PERMSFILE
#if defined(SOLARIS) || defined(linux)
#define PERMSFILE "/etc/logindevperm"
#endif	/* SOLARIS */
#ifdef SUNOS
#define PERMSFILE "/etc/fbtab"
#endif	/* SUNOS */
/* Otherwise, leave out PERMSFILE support */
#endif	/* PERMSFILE */

#ifdef IS_A_BSD
#ifndef HAVE_BCOPY
#define HAVE_BCOPY 1
#endif /* HAVE_BCOPY */
#ifndef HAVE_BZERO
#define HAVE_BZERO 1
#endif /* HAVE_BZERO */
#ifndef HAVE_SETPRIORITY
#define HAVE_SETPRIORITY 1
#endif /* HAVE_SETPRIORITY */
#ifndef HAVE_SYS_RESOURCE_H
#define HAVE_SYS_RESOURCE_H 1
#endif /* HAVE_SYS_RESOURCE_H */
#ifndef HAVE_SYS_TIME_H
#define HAVE_SYS_TIME_H 1
#endif /* HAVE_SYS_TIME_H */
#ifndef HAVE_FCNTL_H
#define HAVE_FCNTL_H 1
#endif /* HAVE_FCNTL_H */
#ifndef pid_t
#define pid_t int
#endif /* pid_t */
#ifdef NEED_STRING
#ifndef strchr
#define strchr(s,c)    index((s),(c))
#endif
#ifndef strrchr
#define strrchr(s,c)   rindex((s),(c))
#endif
#endif /* NEED_STRING */

#ifndef SUNOS /* These really shouldn't need to be defined for any system
                 that is reasonably POSIX... */
#ifndef getcwd
#define getcwd(buf,t)  getwd((buf))
#endif
#endif /* !SUNOS */

#include <paths.h>
#ifndef PATH_MAIL
#ifdef _PATH_MAILDIR
#define PATH_MAIL _PATH_MAILDIR
#else /* _PATH_MAILDIR */
#define PATH_MAIL "/usr/spool/mail"
#endif /* _PATH_MAILDIR */
#endif /* PATH_MAIL */

#ifndef HAVE_ETC_SECURETTY
#define HAVE_ETC_SECURETTY 1
#endif /* HAVE_ETC_SECURETTY */
#ifndef HAVE_GETENV
#define HAVE_GETENV 1
#endif /* HAVE_GETENV */
#ifndef HAVE_SETENV
#define HAVE_SETENV 1
#endif /* HAVE_SETENV */
#ifndef HAVE_UNSETENV
#define HAVE_UNSETENV 1
#endif /* HAVE_UNSETENV */
#ifndef HAVE_SIGMASK_MACRO
#define HAVE_SIGMASK_MACRO 1
#endif /* HAVE_SIGMASK_MACRO */

#ifndef sysconf
 /* sysconf first appeared in POSIX */
#define sysconf(_SC_OPEN_MAX)        getdtablesize()
#endif

 /* BSDs sometimes don't print the group w/o -g */
#ifndef LS_COMMAND
#define LS_COMMAND "/bin/ls -lgA"
#endif	/* LS_COMAND */
#endif /* IS_A_BSD */

#ifdef IS_A_SYSV
/* All modern SYSV systems have the dirent directory entry structure */
#ifndef HAVE_DIRENT
#define HAVE_DIRENT 1
#endif	/* HAVE_DIRENT */
#ifndef sigmask
/* sigmask() is a handy BSD macro that is not POSIX or SYSV */
#define sigmask(m)   (1 << ((m)-1))
#endif

 /* SysVs sometimes don't print the owner w/ -g */
#ifndef LS_COMMAND
#define LS_COMMAND "/bin/ls -lA"
#endif	/* LS_COMAND */

#ifndef PATH_MAIL
#define PATH_MAIL "/usr/mail"
#endif /* PATH_MAIL */
#endif

#ifndef HAVETTYSLOT
#ifdef IS_A_BSD
#define HAVETTYSLOT 1	/* BSD man pages say it appeared in V7 */
#endif	/* IS_A_BSD */
#ifdef IS_A_SYSV
#define HAVETTYSLOT 0	/* But some System Vs appear to have "fixed" it */
#endif	/* IS_A_SYSV */
#endif	/* HAVETTYSLOT */

#if !HAVE_DIRENT
#define dirent direct
#endif /* !HAVE_DIRENT */

#if !defined(HAVE_GETTTYNAM) && defined(IS_A_BSD)
#define HAVE_GETTTYNAM 1
#endif /* HAVE_GETTTYNAM */

#ifndef HAVE_ST_BLKSIZE
#define HAVE_ST_BLKSIZE 1
#endif /* HAVE_ST_BLKSIZE */

#ifndef HAVE_SIGNAL_H
#define HAVE_SIGNAL_H 1
#endif /* HAVE_SIGNAL_H */

#ifndef HAVE_MAILCHECK_IN_PROFILE
#define HAVE_MAILCHECK_IN_PROFILE 0
#endif /* HAVE_MAILCHECK_IN_PROFILE */

#ifndef HAVE_MOTD_IN_PROFILE
#define HAVE_MOTD_IN_PROFILE 0
#endif /* HAVE_MOTD_IN_PROFILE */

#ifdef ACCESS_FILE
#define PATH_ACCESS_FILE ACCESS_FILE
#endif /* ACCESS_FILE */

#ifndef ANSI_COMPILER
#ifdef __STDC__
#define ANSI_COMPILER 1
#else /* __STDC__ */
#define ANSI_COMPILER 1
#endif /* __STDC__ */
#endif /* ANSI_COMPILER */

#ifndef ANSI_LIBRARY
#define ANSI_LIBRARY 0
#endif /* ANSI_LIBRARY */

#ifndef POSIX_LIBRARY
#define POSIX_LIBRARY 0
#endif /* POSIX_LIBRARY */

#ifndef HAVE_VOIDPTR
#define HAVE_VOIDPTR ANSI_COMPILER
#endif /* HAVE_VOIDPTR */

#ifndef HAVE_VOIDRET
#define HAVE_VOIDRET ANSI_COMPILER
#endif /* HAVE_VOIDRET */

#ifndef HAVE_VOIDARG
#define HAVE_VOIDARG ANSI_COMPILER
#endif /* HAVE_VOIDARG */

#ifndef HAVE_ANSIDECL
#define HAVE_ANSIDECL ANSI_COMPILER
#endif /* HAVE_ANSIDECL */

#ifndef HAVE_ANSIPROTO
#define HAVE_ANSIPROTO ANSI_COMPILER
#endif /* HAVE_ANSIPROTO */

#ifndef HAVE_ANSISTDARG
#define HAVE_ANSISTDARG ANSI_COMPILER
#endif /* HAVE_ANSISTDARG */

#ifndef HAVE_STDLIB_H
#define HAVE_STDLIB_H ANSI_LIBRARY
#endif /* HAVE_STDLIB_H */

#ifndef HAVE_UNISTD_H
#define HAVE_UNISTD_H POSIX_LIBRARY
#endif /* HAVE_UNISTD_H */

#ifndef HAVE_GETCWD
#define HAVE_GETCWD POSIX_LIBRARY
#endif /* HAVE_GETCWD */

#ifndef HAVE_GETWD
#define HAVE_GETWD POSIX_LIBRARY
#endif /* HAVE_GETWD */

#ifndef TM_IN_SYS_TIME
#define TM_IN_SYS_TIME 1
#endif /* TM_IN_SYS_TIME */

#ifndef TIME_WITH_SYS_TIME
#define TIME_WITH_SYS_TIME 1
#endif /* TIME_WITH_SYS_TIME */

#ifndef HAVE_UNAME
#define HAVE_UNAME (IS_A_SYSV || POSIX_LIBRARY)
#endif /* HAVE_UNAME */

#ifndef HAVE_SYS_UTSNAME_H
#define HAVE_SYS_UTSNAME_H (IS_A_SYSV || POSIX_LIBRARY)
#endif /* HAVE_SYS_UTSNAME_H */

#ifndef HAVE_SYS_TIME_H
#define HAVE_SYS_TIME_H 1
#endif /* HAVE_SYS_TIME_H */

#ifndef HAVE_SYS_PARAM_H
#define HAVE_SYS_PARAM_H IS_A_BSD
#endif /* HAVE_SYS_PARAM_H */

#ifndef HAVE_SIGNAL_H
#define HAVE_SIGNAL_H 1
#endif /* HAVE_SIGNAL_H */

#ifndef HAVE_STRING_H
#define HAVE_STRING_H ANSI_LIBRARY
#endif /* HAVE_STRING_H */

#ifndef HAVE_STRERROR
#define HAVE_STRERROR 1
#endif /* HAVE_STRERROR */

#ifndef HAVE_PWD_H
#define HAVE_PWD_H 1
#endif /* HAVE_PWD_H 1 */
