/* lookup.c: The opielookup() library function.

Portions of this software are Copyright 1996 by Craig Metz, All Rights
Reserved. The Inner Net Copyright Notice and License Agreement applies to
these portions of the software.

Portions of this software are Copyright 1995 by Randall Atkinson and Dan
McDonald, All Rights Reserved. All Rights under this copyright are assigned
to the U.S. Naval Research Laboratory (NRL). The NRL Copyright Notice and
License Agreement applies to this software.

        History:

	Modified by cmetz for OPIE 2.2. Use FUNCTION declaration et al.
               Inlined and obseleted opiestripcrlf. Use symbolic fseek()
               whence value.
        Created at NRL for OPIE 2.2 from opiesubr2.c. Changed opiestrip_crlf
               to opiestripcrlf.
*/
#include "opie_cfg.h"
#include <stdio.h>
#include <sys/stat.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include "opie.h"

/* Find an entry in the One-time Password database.
 * Return codes:
 * -1: error in opening database
 *  0: entry found, file R/W pointer positioned at beginning of record
 *  1: entry not found, file CLOSED
 *  2: entry found, file R/O pointer positioned at beginning of record
       (i.e., could not get write access)
 */
int opielookup FUNCTION((mp, name), struct opie *mp AND char *name)
{
  int found;
  int len;
  long recstart;
  char *cp;
  struct stat statbuf;
  int rval = 0;

  /* See if the KEY_FILE exists, and create it if not */
  if (stat(KEY_FILE, &statbuf) == -1 && errno == ENOENT) {
    mp->keyfile = fopen(KEY_FILE, "w+");
  } else {
    /* Otherwise open normally for update, if we can */
    if (!(mp->keyfile = fopen(KEY_FILE, "r+")) && (errno == EACCES)) {
	mp->keyfile = fopen(KEY_FILE, "r");
	rval = 2;
    }
  }

  if (!mp->keyfile)
    return -1;

  /* Look up user name in database */
  len = strlen(name);
  if (len > OPIE_PRINCIPAL_MAX)
    len = OPIE_PRINCIPAL_MAX;	/* Added 8/2/91  -  nmh */
  found = 0;

  while (!feof((FILE *)mp->keyfile)) {
    recstart = ftell((FILE *)mp->keyfile);
    mp->recstart = recstart;
    if (fgets(mp->buf, sizeof(mp->buf), (FILE *)mp->keyfile) != mp->buf)
      break;

    {
    char *cp;

    if (cp = strchr(mp->buf, '\n')) {
      if (*(cp - 1) == '\r')
        cp--;
      *cp = 0;
    }
    } 

    if (mp->buf[0] == '#')
      continue;	/* Must be comment line */
    if ((mp->logname = strtok(mp->buf, " \t")) == NULL)
      continue;
    if ((cp = strtok(NULL, " \t")) == NULL)
      continue;
    mp->n = atoi(cp);
    if ((mp->seed = strtok(NULL, " \t")) == NULL)
      continue;
    if ((mp->val = strtok(NULL, " \t")) == NULL)
      continue;
    if (strlen(mp->logname) == len &&
	strncmp(mp->logname, name, len) == 0) {
      found = 1;
      break;
    }
  }
  if (found) {
    fseek((FILE *)mp->keyfile, recstart, SEEK_SET);
    return rval;
  } else {
    fclose((FILE *)mp->keyfile);
    mp->keyfile = NULL;
    return 1;
  };
}
