# Copyright (C) 2008, The Perl Foundation.
# $Id: crypto.pm 26359 2008-03-14 09:58:52Z fperrad $

=head1 NAME

config/auto/crypto.pm - Test for crypto library (libssl)

=head1 DESCRIPTION

See L<http://www.openssl.org>

=cut

package auto::crypto;

use strict;
use warnings;

use base qw(Parrot::Configure::Step);

use Parrot::Configure::Utils ':auto';


sub _init {
    my $self = shift;
    my %data;
    $data{description} = q{Determining if your platform supports crypto};
    $data{result}      = q{};
    return \%data;
}

sub runstep {
    my ( $self, $conf ) = @_;

    my ( $verbose, $without ) = $conf->options->get(
        qw|
            verbose
            without-crypto
        |
    );

    if ($without) {
        $conf->data->set( has_crypto => 0 );
        $self->set_result('no');
        return 1;
    }

    my $cc        = $conf->data->get('cc');
    my $libs      = $conf->data->get('libs');
    my $linkflags = $conf->data->get('linkflags');
    my $ccflags   = $conf->data->get('ccflags');

    my $osname = $conf->data->get_p5('OSNAME');

    _handle_mswin32($conf, $osname, $cc);

    $conf->cc_gen('config/auto/crypto/crypto.in');
    eval { $conf->cc_build(); };
    my $has_crypto = 0;
    if ( !$@ ) {
        my $test = $conf->cc_run();
        $has_crypto = $self->_evaluate_cc_run($test, $has_crypto, $verbose);
    }
    unless ($has_crypto) {
        # The Parrot::Configure settings might have changed while class ran
        $self->_recheck_settings($conf, $libs, $ccflags, $linkflags, $verbose);
    }
    $conf->data->set( has_crypto => $has_crypto );    # for dynpmc.in & digest.t

    return 1;
}

sub _handle_mswin32 {
    my ($conf, $osname, $cc) = @_;
    if ( $osname =~ /mswin32/i ) {
        if ( $cc =~ /^gcc/i ) {
            $conf->data->add( ' ', libs => '-lcrypto' );
        }
        else {
            $conf->data->add( ' ', libs => 'libcrypto.lib' );
        }
    }
    else {
        $conf->data->add( ' ', libs => '-lcrypto' );
    }
    return 1;
}

sub _evaluate_cc_run {
    my $self = shift;
    my ($test, $has_crypto, $verbose) = @_;
    if ( $test =~ m/^OpenSSL (\d\.\d\.\d\w)/ ) {
        $has_crypto = 1;
        print " (yes) " if $verbose;
        $self->set_result("yes, $1");
    }
    return $has_crypto;
}

1;

# Local Variables:
#   mode: cperl
#   cperl-indent-level: 4
#   fill-column: 100
# End:
# vim: expandtab shiftwidth=4:
