use utf8;
use Test::More;

use Document::OOXML::ContentTypes;

my $xml = <<'EOT';
<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
<Types 
    xmlns="http://schemas.openxmlformats.org/package/2006/content-types">
    <Default Extension="rels" ContentType="application/vnd.openxmlformats-package.relationships+xml"/>
    <Default Extension="xml" ContentType="application/xml"/>
    <Override PartName="/word/document.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml"/>
    <Override PartName="/word/styles.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.styles+xml"/>
    <Override PartName="/word/settings.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.settings+xml"/>
    <Override PartName="/word/webSettings.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.webSettings+xml"/>
    <Override PartName="/word/fontTable.xml" ContentType="application/vnd.openxmlformats-officedocument.wordprocessingml.fontTable+xml"/>
    <Override PartName="/word/theme/theme1.xml" ContentType="application/vnd.openxmlformats-officedocument.theme+xml"/>
    <Override PartName="/docProps/core.xml" ContentType="application/vnd.openxmlformats-package.core-properties+xml"/>
    <Override PartName="/docProps/app.xml" ContentType="application/vnd.openxmlformats-officedocument.extended-properties+xml"/>
</Types>
EOT

my $ct = Document::OOXML::ContentTypes->new_from_xml($xml);

is(
    $ct->get_content_type_for_part('word/document.xml'),
    'application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml',
    'Specific (overridden) filename gets correct content type'
);

is(
    $ct->get_content_type_for_part('word/_rels/.rels'),
    'application/vnd.openxmlformats-package.relationships+xml',
    'Generic (non-overridden) filename gets correct content type'
);

done_testing();
