# Gregory D. Troxel <gtroxel@bbn.com>

# add to path to find gzip, etc. if necessary
#$ENV{'PATH'} =~ s|$|:/usr/site/bin| ;

$montab{'Jan'} = 1; $montab{'Feb'} = 2; $montab{'Mar'} = 3; $montab{'Apr'} = 4;
$montab{'May'} = 5; $montab{'Jun'} = 6; $montab{'Jul'} = 7; $montab{'Aug'} = 8;
$montab{'Sep'} = 9; $montab{'Oct'} = 10; $montab{'Nov'} = 11; $montab{'Dec'} = 12;

$HOME = $ENV{'HOME'};
$procdir = "$HOME/time-surveying";

@hostname = split(/\./, `hostname`);
$hostname = $hostname[0];

if ( ! -d "$procdir" ) {
    die "Directory $procdir does not exist.";
}

if ( ! -d "$procdir/m" ) {
    die "Making directory $procdir/m\n";
    system "mkdir $procdir/m";
}

sub cdtop {
  chdir $procdir || warn "can't chdir to $procdir";
}

sub cdhost {
  local($host) = @_;
  if ( ! -d "$procdir/m/$host" ) {
      print "Making directory $procdir/m/$host.\n";
      system "mkdir $procdir/m/$host";
  }
  chdir "$procdir/m/$host" || warn "can't chdir to $procdir/m/$host";
}

# check for tickets
sub krb_tk_check {
  system("klist", "-t")
   ? warn "No kerberos tickets"
   : print "Have kerberos tickets.\n";
}

sub gethosts {
  if (@ARGV == 0)
    {
      # read hosts directory for list
      split(' ', `ls m`);
    }
  else
    {
      @ARGV;
    }
}

## default actions

# change to top-level directory
&cdtop;

# get list of hosts to process
@HOSTS = &gethosts;

# return true
1;
