/* 
This software is being provided to you, the LICENSEE, by the
Massachusetts Institute of Technology (M.I.T.) under the following
license.  By obtaining, using and/or copying this software, you agree
that you have read, understood, and will comply with these terms and
conditions:

Permission to use, copy, modify and distribute, including the right to
grant others the right to distribute at any tier, this software and
its documentation for any purpose and without fee or royalty is hereby
granted, provided that you agree to comply with the following
copyright notice and statements, including the disclaimer, and that
the same appear on ALL copies of the software and documentation,
including modifications that you make for internal use or for
distribution:

Copyright 1992,1993,1994 by the Massachusetts Institute of Technology.
                    All rights reserved.

THIS SOFTWARE IS PROVIDED "AS IS", AND M.I.T. MAKES NO REPRESENTATIONS
OR WARRANTIES, EXPRESS OR IMPLIED.  By way of example, but not
limitation, M.I.T. MAKES NO REPRESENTATIONS OR WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE
OF THE LICENSED SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD
PARTY PATENTS, COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS.

The name of the Massachusetts Institute of Technology or M.I.T. may
NOT be used in advertising or publicity pertaining to distribution of
the software.  Title to copyright in this software and any associated
documentation shall at all times remain with M.I.T., and USER agrees
to preserve same.
*/
/*
 * Gregory D. Troxel
 * DATAPOINT and DATASET types
 */

/* DATAPOINT - represents a single NTP observation */

#define RSADJ_NULL -1
#define RSADJ_PQF 0			/* piecewise individual fits */
#define RSADJ_INT 1			/* integrated fit */
#define RSADJ_OVERALL 2			/* overall fit */
#define NRSADJP 3

typedef struct datapoint_s
{
  ntp_t time;
  real_t delay;			/* observed delay */
  /* overloaded onto delay*/	/* current freq error estimate */
  real_t rsadj;			/* actual rsadj */
  real_t aoffset;		/* actual offset */
  real_t uoffset;		/* uncorrected offset */
  real_t simrsadj;		/* simluated rsadj */
  real_t simaoffset;		/* simulated actual offset */
  real_t rsadjr[NRSADJP];	/* rsadj residuals */
  real_t poffset[NRSADJP];	/* predicted offsets */
  real_t simrsadjr[NRSADJP];	/* residuals from simulated rsadj */
  int pid;			/* XXX delete? */
  int clock;
  int tau;
  short run;			/* which run of program? */
  short valid : 8;		/* 1 if it has not been trimmed */
  short type : 3;		/* 1 if SLEW, 2 if OPEN */
  short observation : 2;	/* 1 if raw observation */
  short sim : 1;		/* 1 if predicted */
} datapoint_t;

#define VALID_OK	0	/* white */
#define VALID_DELAY	1	/* green */
#define VALID_BUNCH	2	/* red */
#define VALID_SELFS	3	/* blue */
#define VALID_SELFL	4	/* yellow */
#define VALID_COVER	5
#define VALID_SHORT	5
#define VALID_NTP	5	
#define VALID_TRIM	5
#define VALID_NOT	8

/* DATASET - contain many datapoints, plus info about them */
typedef struct dataset_s
{
  datapoint_t *dptr;
  int n;			/* first useable point */
  int lim;			/* number of points allocated */
  int extent_begin;		/* first point in region of interest */
  int extent_end;		/* last point in region of interest */
  real_t weight;		/* XXX move to clock_state */
} dataset_t;

void ds_init(dataset_t *ds);
void ds_free(dataset_t *ds);
void ds_grow(dataset_t *ds, int n);

/* return pointer to new point */
#ifdef __GNUC__
inline static
#endif
datapoint_t *
dp_new(dataset_t *ds)
#if defined(PD_UTIL) || defined(__GNUC__)
{
  datapoint_t *dp;

  /* make sure there is one point */
  if ( ds->n + 1 > ds->lim )
    ds_grow(ds, ds->n + 1);

  dp = & ds->dptr[ds->n];
  ds->n++;
  bzero(dp, sizeof(datapoint_t)); /* clear it */
  return dp;
}
#else
;
#endif

/* this is expected to be abstraction-violationed */
#ifdef __GNUC__
inline static
#endif
datapoint_t *
ds_addrdp(dataset_t *ds, int n)
#if defined(PD_UTIL) || defined(__GNUC__)
{
#ifdef DIAGNOSTIC
  if ( n < 0 || n >= ds->n )
    panic("read of nonexistent datapoint");
#endif
  return &ds->dptr[n];
}
#else
;
#endif


void ds_reinit(dataset_t *ds);
